/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.list.exception.ObjectNotFoundException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeCollection;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeInfo;
import com.kingdee.eas.ncm.std.basedata.app.AbstractSTDCostEstimateSchemeControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;
import org.apache.log4j.Logger;

public class STDCostEstimateSchemeControllerBean
extends AbstractSTDCostEstimateSchemeControllerBean {
    private static final long serialVersionUID = 3873200896870623278L;
    private static Logger logger = Logger.getLogger((String)STDCostEstimateSchemeControllerBean.class.getName());

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        STDCostEstimateSchemeInfo info = (STDCostEstimateSchemeInfo)model;
        this.processInfo(ctx, info);
        this.checkBlank(info);
        this.checkNumberDup(ctx, info);
        super._update(ctx, pk, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        STDCostEstimateSchemeInfo info = (STDCostEstimateSchemeInfo)model;
        this.checkNumber(ctx, info, info.getCompany().getId().toString());
        this.processInfo(ctx, info);
        this.checkBlank(info);
        IObjectPK pk = super._addnew(ctx, model);
        CoreBaseInfo cbInfo = this.getValue(ctx, pk);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"addnew", (BOSObjectType)this.getBOSType(), (IObjectPK)pk, (String)cbInfo.getLogInfo(), (String)"std_STDCostEstimateScheme_addnew");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return pk;
    }

    private void processInfo(Context ctx, STDCostEstimateSchemeInfo info) throws BOSException, EASBizException {
        String beginDateStr = String.valueOf(info.getYear()) + "-" + String.valueOf(info.getBeginPeriod()) + "-01 00:00:00";
        String endDateStr = String.valueOf(info.getYear()) + "-" + String.valueOf(info.getEndPeriod()) + "-01 00:00:00";
        try {
            info.setBeginDate(NCMUtils.getMinMonthDate((String)beginDateStr));
            info.setEndDate(NCMUtils.getMaxMonthDate((String)endDateStr));
        }
        catch (ParseException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void checkBlank(STDCostEstimateSchemeInfo info) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        if (StringUtils.isEmpty((String)info.getName())) {
            throw new EASBizException(EASBizException.CHECKNAMEBLANK);
        }
    }

    private void checkNumberDup(Context ctx, STDCostEstimateSchemeInfo info) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString(), CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{info.getNumber()});
        }
    }

    @Override
    protected void _check(Context ctx, BOSUuid schemeID) throws BOSException, EASBizException {
        if (schemeID == null || StringUtils.isEmpty((String)schemeID.toString())) {
            return;
        }
        NCMDbUtil.execute((Context)ctx, (String)" update T_NCM_SCEstimateScheme set FState = 2 where FID = ? ", (Object[])new Object[]{schemeID.toString()});
    }

    @Override
    protected void _unCheck(Context ctx, BOSUuid schemeID) throws BOSException, EASBizException {
        if (schemeID == null || StringUtils.isEmpty((String)schemeID.toString())) {
            return;
        }
        NCMDbUtil.execute((Context)ctx, (String)" update T_NCM_SCEstimateScheme set FState = 1 where FID = ? ", (Object[])new Object[]{schemeID.toString()});
    }

    @Override
    protected boolean _existsCombination(Context ctx, BOSUuid schemeID) throws BOSException, EASBizException {
        if (schemeID == null || StringUtils.isEmpty((String)schemeID.toString())) {
            return false;
        }
        IRowSet rst = NCMDbUtil.executeQuery((Context)ctx, (String)" select count(fid) as fidCount from T_NCM_SCEstimateSchemeComb where FEstimateSchemeID = ? ", (Object[])new Object[]{schemeID.toString()});
        try {
            if (rst.next() && rst.getInt("fidCount") > 0) {
                return true;
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        return false;
    }

    @Override
    protected void _checkRefered(Context ctx, List ids) throws BOSException, EASBizException, ObjectReferedException {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        IRowSet rst = null;
        try {
            int size = ids.size();
            for (int i = 0; i < size; ++i) {
                String id = ids.get(i).toString();
                rst = NCMDbUtil.executeQuery((Context)ctx, (String)" select fid from T_NCM_SCEstimateSchemeComb where FEstimateSchemeID <> ?  and (FMaterialPriceSchemeID = ?       or FResStdQtySchemeID = ?       or FResStdPriceSchemeID = ?       or FStdBOMScheme = ? )", (Object[])new String[]{id, id, id, id, id});
                if (!rst.next()) continue;
                throw new ObjectReferedException((Object)"");
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] arrayPK = new IObjectPK[]{pk};
        this.checkCanDelete(ctx, arrayPK);
        this.recycleBatchNumbers(ctx, arrayPK);
        super._delete(ctx, pk);
        NCMDbUtil.execute((Context)ctx, (String)"delete from T_NCM_SCEstimateSchemeComb where FEstimateSchemeID  = ?", (Object[])new Object[]{pk.toString()});
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        this.checkCanDelete(ctx, arrayPK);
        this.recycleBatchNumbers(ctx, arrayPK);
        super._delete(ctx, arrayPK);
        Object[] pks = new Object[arrayPK.length];
        for (int i = 0; i < arrayPK.length; ++i) {
            pks[i] = arrayPK[i].toString();
        }
        NCMDbUtil.execute((Context)ctx, (String)("delete from T_NCM_SCEstimateSchemeComb where FEstimateSchemeID in (" + BDCMUtils.splitPK((Object[])pks) + ")"));
    }

    private void checkCanDelete(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        if (pks == null || pks.length == 0) {
            return;
        }
        IRowSet rst = null;
        try {
            for (int i = 0; i < pks.length; ++i) {
                int state;
                String id = pks[i].toString();
                rst = NCMDbUtil.executeQuery((Context)ctx, (String)" select FState from T_NCM_SCEstimateScheme where FID = ? ", (Object[])new Object[]{id});
                if (!rst.next() || (state = rst.getInt("FState")) != 2) continue;
                throw new CMBillException(CMBillException.CHECKAUDITEDOK);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    private void recycleBatchNumbers(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        if (pks == null || pks.length == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)NCMUtils.arrayPK2Set((IObjectPK[])pks), CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("company.id");
        view.setSelector(sic);
        STDCostEstimateSchemeCollection bills = null;
        try {
            bills = this.getSTDCostEstimateSchemeCollection(ctx, view);
        }
        catch (ObjectNotFoundException exc) {
            throw new BOSException((Throwable)exc);
        }
        if (bills == null) {
            return;
        }
        STDCostEstimateSchemeInfo bill = bills.get(0);
        String companyId = bill.getCompany().getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean isExistCodingRule = iCodingRuleManager.isExist((IObjectValue)bill, companyId);
        if (isExistCodingRule) {
            String[] numbers = new String[bills.size()];
            int size = bills.size();
            for (int i = 0; i < size; ++i) {
                numbers[i] = bills.get(i).getNumber();
            }
            iCodingRuleManager.recycleBatchNumber((IObjectValue)bill, companyId, numbers);
        }
    }

    protected synchronized void checkNumber(Context ctx, DataBaseInfo info, String orgId) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager;
        RuleStatus ruleStatus;
        if (orgId == null || orgId.trim().length() == 0) {
            orgId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        if ((ruleStatus = (iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx)).getRuleStatus((IObjectValue)info, orgId)).isExist()) {
            boolean isAddNew = true;
            if (info.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
                isAddNew = false;
            }
            if (isAddNew && ruleStatus.isAddNoBreak() || StringUtils.isEmpty((String)info.getNumber()) || this.isNumberUsed(ctx, null, info)) {
                this.setNewNumber(ctx, info, orgId, null);
            }
        } else {
            if (StringUtils.isEmpty((String)info.getNumber())) {
                throw new EASBizException(EASBizException.CHECKNUMBLANK);
            }
            if (this.isNumberUsed(ctx, null, info)) {
                throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{info.getNumber()});
            }
        }
    }

    protected boolean isNumberUsed(Context ctx, IObjectPK pk, DataBaseInfo info) throws EASBizException, BOSException {
        FilterInfo filter = this.getCheckFilter(ctx, pk, info);
        boolean exist = super._exists(ctx, filter);
        return exist;
    }

    protected FilterInfo getCheckFilter(Context ctx, IObjectPK pk, DataBaseInfo info) {
        STDCostEstimateSchemeInfo sInfo = (STDCostEstimateSchemeInfo)info;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)sInfo.getNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)sInfo.getCompany().getId().toString(), CompareType.EQUALS));
        if (sInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        return filter;
    }

    protected void setNewNumber(Context ctx, DataBaseInfo info, String org, String customString) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = iCodingRuleManager.getNumber((IObjectValue)info, org, customString);
        info.setNumber(number);
        ObjectUuidPK pk = null;
        if (info.getId() != null) {
            pk = new ObjectUuidPK(info.getId());
        }
        if (this.isNumberUsed(ctx, (IObjectPK)pk, info)) {
            this.setNewNumber(ctx, info, org, customString);
        }
    }

    protected boolean _checkStatusValid(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        STDCostEstimateSchemeInfo info = (STDCostEstimateSchemeInfo)model;
        String companyId = info.getCompany().getId().toString();
        String schemeId = info.getId().toString();
        try {
            String T_NCM_STDCostDataMatDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_STDCostDataMatDetail");
            IRowSet rst = NCMDbUtil.executeQuery((Context)ctx, (String)(" select top 1 1 from " + T_NCM_STDCostDataMatDetail + "  where FEstimateSchemeID = ? "), (Object[])new String[]{schemeId});
            if (rst.next()) {
                return true;
            }
            String T_NCM_STDCostDataResDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_STDCostDataResDetail");
            rst = NCMDbUtil.executeQuery((Context)ctx, (String)(" select top 1 1 from " + T_NCM_STDCostDataResDetail + "  where FEstimateSchemeID = ? "), (Object[])new String[]{schemeId});
            if (rst.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }
}

