/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.std.bill.ISTDCostEstimateType;
import com.kingdee.eas.ncm.std.bill.STDCostDataSourceTypeEnum;
import com.kingdee.eas.ncm.std.bill.STDCostEstimateTypeCollection;
import com.kingdee.eas.ncm.std.bill.STDCostEstimateTypeFactory;
import com.kingdee.eas.ncm.std.bill.STDCostEstimateTypeInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;

public class STDCostEstimateTypeImport
extends AbstractNCMDataImport {
    CompanyOrgUnitInfo company = null;
    PeriodInfo period = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return STDCostEstimateTypeFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        STDCostEstimateTypeInfo info = null;
        try {
            this.initOrgUnit(ctx);
            info = this.parse(ctx, hsData);
            this.verify(ctx, info, this.isSltImportUpdate());
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    private void initOrgUnit(Context ctx) throws BOSException {
        if (this.company == null) {
            this.company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        if (this.period == null) {
            try {
                this.period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)this.company.getId().toString());
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private STDCostEstimateTypeInfo parse(Context ctx, Hashtable hsData) throws BOSException, EASBizException {
        STDCostEstimateTypeInfo info = new STDCostEstimateTypeInfo();
        Object data = null;
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        data = this.getData(hsData, "storageOrg.number");
        if (data != null && data.toString().trim().length() > 0) {
            info.setStorageOrgUnit(NCMDataImportUtil.getStorageOrgByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"50_STDCostEstimateTypeImport", (Locale)ctx.getLocale()), (String)data.toString()));
        }
        if ((data = this.getData(hsData, "material.number")) != null && data.toString().trim().length() > 0) {
            MaterialInfo material = NCMDataImportUtil.getMaterialByNumber((Context)ctx, (String)this.getResource("MATERIAL_NUMBER", ctx), (String)data.toString());
            info.setMaterial(material);
        }
        if ((data = this.getData(hsData, "type")) != null && data.toString().trim().length() > 0) {
            if (data.toString().equals(STDCostDataSourceTypeEnum.manual.getAlias())) {
                info.setEstimateType(STDCostDataSourceTypeEnum.manual);
            } else if (data.toString().equals(STDCostDataSourceTypeEnum.BOMRollUp.getAlias())) {
                info.setEstimateType(STDCostDataSourceTypeEnum.BOMRollUp);
            }
        }
        return info;
    }

    public void verify(Context ctx, STDCostEstimateTypeInfo info, boolean isSltImportUpdate) throws BOSException, EASBizException {
        if (info.getStorageOrgUnit() == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"51_STDCostEstimateTypeImport", (Locale)ctx.getLocale()));
        }
        if (info.getMaterial() == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"11_STDCostDataImportVerify", (Locale)ctx.getLocale()));
        }
        if (info.getEstimateType() == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"12_STDCostDataImportVerify", (Locale)ctx.getLocale()));
        }
        this.checkStorageOrg(ctx, info);
        this.checkMaterial(ctx, info);
    }

    private void checkStorageOrg(Context ctx, STDCostEstimateTypeInfo info) throws BOSException, EASBizException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection ccColl = iOUR.getFromUnit(this.company.getId().toString(), 1, 4);
        int ccSize = ccColl.size();
        if (ccSize == 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"52_STDCostEstimateTypeImport", (Locale)ctx.getLocale()));
        }
        HashSet<String> ccIDSet = new HashSet<String>(ccSize);
        for (int i = 0; i < ccSize; ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ccIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getStorageOrgUnit().getId().toString()));
        boolean exist = StorageOrgUnitFactory.getLocalInstance((Context)ctx).exists(filter);
        if (!exist) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"53_STDCostEstimateTypeImport", (Locale)ctx.getLocale()) + info.getStorageOrgUnit().getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"54_STDCostEstimateTypeImport", (Locale)ctx.getLocale()));
        }
    }

    private void checkMaterial(Context ctx, STDCostEstimateTypeInfo info) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CompanyOrgUnit.id", (Object)this.company.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)info.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("MaterialCompanyInfo.status", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("MaterialInventory.status", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getMaterial().getId().toString(), CompareType.EQUALS));
        String queryInfo = "com.kingdee.eas.basedata.ncm.app.MaterialFiStorageCostQuery";
        MetaDataPK metaDataPK = new MetaDataPK(queryInfo);
        IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metaDataPK);
        queryExecutor.option().isAutoTranslateEnum = true;
        queryExecutor.option().isAutoTranslateBoolean = true;
        queryExecutor.option().isAutoIgnoreZero = true;
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExecutor.setObjectView(evi);
        IRowSet rowSet = queryExecutor.executeQuery();
        Object s = null;
        if (rowSet.size() <= 0) {
            throw new BOSException("\u7269\u6599" + info.getMaterial().getNumber() + "\u57fa\u7840\u8d44\u6599\u7684\u8d22\u52a1\u9875\u7b7e\u6216\u5e93\u5b58\u9875\u7b7e\u672a\u7ef4\u62a4\u6216\u672a\u6838\u51c6");
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        STDCostEstimateTypeInfo estimateTypeInfo = (STDCostEstimateTypeInfo)coreBaseInfo;
        ArrayList<STDCostEstimateTypeInfo> addObjList = new ArrayList<STDCostEstimateTypeInfo>();
        HashMap<String, STDCostDataSourceTypeEnum> updateObjects = new HashMap<String, STDCostDataSourceTypeEnum>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)estimateTypeInfo.getStorageOrgUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)estimateTypeInfo.getMaterial().getId().toString()));
        EntityViewInfo eviData = new EntityViewInfo();
        eviData.setFilter(filter);
        try {
            ISTDCostEstimateType i = STDCostEstimateTypeFactory.getLocalInstance(ctx);
            STDCostEstimateTypeCollection collection = i.getSTDCostEstimateTypeCollection(eviData);
            if (collection.size() != 0 && this.isSltImportUpdate()) {
                STDCostEstimateTypeInfo info = collection.get(0);
                updateObjects.put(info.getId().toString(), estimateTypeInfo.getEstimateType());
            } else {
                if (collection.size() != 0 && !this.isSltImportUpdate()) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"62_STDCostEstimateTypeImport", (Locale)ctx.getLocale()) + estimateTypeInfo.getStorageOrgUnit().getNumber() + " " + estimateTypeInfo.getStorageOrgUnit().getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"63_STDCostEstimateTypeImport", (Locale)ctx.getLocale()) + estimateTypeInfo.getMaterial().getNumber() + " " + estimateTypeInfo.getMaterial().getName());
                }
                if (collection.size() == 0) {
                    addObjList.add(estimateTypeInfo);
                }
            }
            i.updateData(updateObjects, new ArrayList(), addObjList);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            result.put("storageOrg.number", rs.getString("storageOrgUnit.number"));
            result.put("storageOrg.name", rs.getString("storageOrgUnit.name"));
            result.put("material.number", rs.getString("material.number"));
            result.put("material.name", rs.getString("material.name"));
            result.put("type", (Object)STDCostDataSourceTypeEnum.getEnum(rs.getInt("estimateType")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

