/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.std.basedata.STCostBOMQueueInfo;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeInfo;
import com.kingdee.eas.ncm.std.bill.ISTDCostMaterialBOM;
import com.kingdee.eas.ncm.std.bill.STDCostMaterialBOMCollection;
import com.kingdee.eas.ncm.std.bill.STDCostMaterialBOMFactory;
import com.kingdee.eas.ncm.std.bill.STDCostMaterialBOMInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;

public class STDCostMaterialBOMImport
extends AbstractNCMDataImport {
    CompanyOrgUnitInfo company = null;
    PeriodInfo period = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return STDCostMaterialBOMFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        STDCostMaterialBOMInfo info = null;
        try {
            this.initOrgUnit(ctx);
            info = this.parse(ctx, hsData);
            this.verify(ctx, info, this.isSltImportUpdate());
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    private void initOrgUnit(Context ctx) throws BOSException {
        if (this.company == null) {
            this.company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        if (this.period == null) {
            try {
                this.period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)this.company.getId().toString());
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private STDCostMaterialBOMInfo parse(Context ctx, Hashtable hsData) throws BOSException, EASBizException {
        STDCostMaterialBOMInfo info = new STDCostMaterialBOMInfo();
        Object data = null;
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        data = this.getData(hsData, "estimateScheme.number");
        if (data != null && data.toString().trim().length() > 0) {
            info.setEstimateScheme(NCMDataImportUtil.getEstimateSchemeByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"56_STDCostMaterialBOMImport", (Locale)ctx.getLocale()), (String)data.toString()));
        }
        if ((data = this.getData(hsData, "material.number")) != null && data.toString().trim().length() > 0) {
            MaterialInfo material = NCMDataImportUtil.getMaterialByNumber((Context)ctx, (String)this.getResource("MATERIAL_NUMBER", ctx), (String)data.toString());
            info.setParentMaterial(material);
        }
        if ((data = this.getData(hsData, "BOMQueue")) != null && data.toString().trim().length() > 0) {
            STCostBOMQueueInfo bomQueue = NCMDataImportUtil.getBOMQueueByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"57_STDCostMaterialBOMImport", (Locale)ctx.getLocale()), (String)data.toString());
            info.setBOMQueue(bomQueue);
        }
        if (info.getBOMQueue() == null) {
            data = this.getData(hsData, "BOM");
            if (data != null && data.toString().trim().length() > 0) {
                BomInfo bom = NCMDataImportUtil.getBomByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"58_STDCostMaterialBOMImport", (Locale)ctx.getLocale()), (String)data.toString(), (String)this.company.getId().toString());
                info.setBOM(bom);
            }
        } else {
            info.setBOM(null);
        }
        if ((data = this.getData(hsData, "validateDate")) != null && data.toString().trim().length() > 0) {
            try {
                info.setValidateDate(new SimpleDateFormat("yyyy-MM-dd").parse(data.toString()));
            }
            catch (ParseException e) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"59_STDCostMaterialBOMImport", (Locale)ctx.getLocale()));
            }
        }
        data = this.getData(hsData, "description");
        info.setDescription(data.toString());
        return info;
    }

    public void verify(Context ctx, STDCostMaterialBOMInfo info, boolean isSltImportUpdate) throws BOSException, EASBizException {
        if (info.getEstimateScheme() == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"60_STDCostMaterialBOMImport", (Locale)ctx.getLocale()));
        }
        if (info.getParentMaterial() == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"11_STDCostDataImportVerify", (Locale)ctx.getLocale()));
        }
        this.checkEstimateScheme(ctx, info);
        this.checkMaterial(ctx, info);
    }

    private void checkEstimateScheme(Context ctx, STDCostMaterialBOMInfo info) throws BOSException, EASBizException {
        STDCostEstimateSchemeInfo estimateSchemeInfo = info.getEstimateScheme();
        String estimateSchemeCompanyId = estimateSchemeInfo.getCompany().getId().toString();
        if (!estimateSchemeCompanyId.equals(this.company.getId().toString())) {
            throw new BOSException(estimateSchemeInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"61_STDCostMaterialBOMImport", (Locale)ctx.getLocale()));
        }
    }

    private void checkMaterial(Context ctx, STDCostMaterialBOMInfo info) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CompanyOrgUnit.id", (Object)this.company.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("MaterialCompanyInfo.status", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("MaterialInventory.status", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getParentMaterial().getId().toString(), CompareType.EQUALS));
        String queryInfo = "com.kingdee.eas.basedata.ncm.app.MaterialFiStorageCostQuery";
        MetaDataPK metaDataPK = new MetaDataPK(queryInfo);
        IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metaDataPK);
        queryExecutor.option().isAutoTranslateEnum = true;
        queryExecutor.option().isAutoTranslateBoolean = true;
        queryExecutor.option().isAutoIgnoreZero = true;
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExecutor.setObjectView(evi);
        IRowSet rowSet = queryExecutor.executeQuery();
        if (rowSet.size() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"53_STDCostEstimateTypeImport", (Locale)ctx.getLocale()) + info.getParentMaterial().getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"55_STDCostEstimateTypeImport", (Locale)ctx.getLocale()));
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        STDCostMaterialBOMInfo bomInfo = (STDCostMaterialBOMInfo)coreBaseInfo;
        HashMap updateObjects = new HashMap();
        ArrayList<STDCostMaterialBOMInfo> addObjList = new ArrayList<STDCostMaterialBOMInfo>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("estimateScheme.id", (Object)bomInfo.getEstimateScheme().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("parentMaterial.id", (Object)bomInfo.getParentMaterial().getId().toString()));
        EntityViewInfo eviData = new EntityViewInfo();
        eviData.setFilter(filter);
        try {
            ISTDCostMaterialBOM i = STDCostMaterialBOMFactory.getLocalInstance(ctx);
            STDCostMaterialBOMCollection collection = i.getSTDCostMaterialBOMCollection(eviData);
            if (collection.size() != 0 && this.isSltImportUpdate()) {
                STDCostMaterialBOMInfo info = collection.get(0);
                ArrayList<Object> dataList = new ArrayList<Object>();
                dataList.add(bomInfo.getBOMQueue());
                dataList.add(bomInfo.getBOM());
                dataList.add(bomInfo.getValidateDate());
                dataList.add(bomInfo.getDescription());
                updateObjects.put(info.getId().toString(), dataList);
            } else {
                if (collection.size() != 0 && !this.isSltImportUpdate()) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"18_STDCostResourceTypePriceImportVerify", (Locale)ctx.getLocale()) + bomInfo.getEstimateScheme().getNumber() + " " + bomInfo.getEstimateScheme().getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"63_STDCostEstimateTypeImport", (Locale)ctx.getLocale()) + bomInfo.getParentMaterial().getNumber() + " " + bomInfo.getParentMaterial().getName());
                }
                if (collection.size() == 0) {
                    addObjList.add(bomInfo);
                }
            }
            i.updateData(updateObjects, new ArrayList(), addObjList);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("estimateScheme.number", this.getNotBlankString(rs.getString("scheme.number")));
            result.put("estimateScheme.name", this.getNotBlankString(rs.getString("scheme.name")));
            result.put("material.number", this.getNotBlankString(rs.getString("parentMaterial.number")));
            result.put("material.name", this.getNotBlankString(rs.getString("parentMaterial.name")));
            result.put("BOMQueue", this.getNotBlankString(rs.getString("BOMQueue.number")));
            result.put("BOM", this.getNotBlankString(rs.getString("BOM.number")));
            result.put("validateDate", this.getNotBlankString(rs.getString("validateDate")));
            result.put("description", this.getNotBlankString(rs.getString("description")));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

