/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.list.exception.ObjectNotFoundException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.std.basedata.ISTDCostEstimateScheme;
import com.kingdee.eas.ncm.std.basedata.ISTDResourceType;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeCollection;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeFactory;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeInfo;
import com.kingdee.eas.ncm.std.basedata.STDResourceTypeCollection;
import com.kingdee.eas.ncm.std.basedata.STDResourceTypeFactory;
import com.kingdee.eas.ncm.std.basedata.STDResourceTypeInfo;
import com.kingdee.eas.ncm.std.bill.STDCostResourceTypePriceFactory;
import com.kingdee.eas.ncm.std.bill.STDCostResourceTypePriceInfo;
import com.kingdee.eas.ncm.std.bill.app.STDCostResourceTypePriceImportVerify;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class STDCostResourceTypePriceImport
extends AbstractNCMDataImport {
    private static Logger logger = Logger.getLogger((String)STDCostResourceTypePriceImport.class.getName());
    private STDCostResourceTypePriceImportVerify verify = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return STDCostResourceTypePriceFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        STDCostResourceTypePriceInfo info = null;
        try {
            info = this.parse(ctx, hsData);
            this.getVerify().verify(ctx, info, this.isSltImportUpdate());
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("estimateScheme.number", this.getNotBlankString(rs.getString("estimateScheme.number")));
            result.put("estimateScheme.name", this.getNotBlankString(rs.getString("estimateScheme.name")));
            result.put("resourceType.number", this.getNotBlankString(rs.getString("resourceType.number")));
            result.put("resourceType.name", this.getNotBlankString(rs.getString("resourceType.name")));
            BigDecimal stdPrice = rs.getBigDecimal("stdPrice");
            if (stdPrice != null) {
                result.put("stdPrice", stdPrice.setScale(4, 4).toString());
            } else {
                result.put("stdPrice", "");
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private STDCostResourceTypePriceInfo parse(Context ctx, Hashtable hsData) throws BOSException, EASBizException {
        STDCostResourceTypePriceInfo info = new STDCostResourceTypePriceInfo();
        Object data = null;
        CompanyOrgUnitInfo currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        PeriodInfo currentPeriod = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(1001, currCompany.getId().toString());
        info.setCompanyOrg(currCompany);
        info.setCalculatePeriod(currentPeriod);
        data = this.getData(hsData, "estimateScheme.number");
        if (data != null && data.toString().trim().length() > 0) {
            info.setEstimateScheme(this.getEstimateSchemeByNumber(ctx, data.toString(), currCompany.getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"5_STDCostDataImport", (Locale)ctx.getLocale())));
        }
        if ((data = this.getData(hsData, "resourceType.number")) != null && data.toString().trim().length() > 0) {
            info.setResourceType(this.getResourceTypeByNumber(ctx, data.toString(), currCompany.getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"16_STDCostResourceTypePriceImport", (Locale)ctx.getLocale())));
        }
        if ((data = this.getData(hsData, "stdPrice")) instanceof BigDecimal) {
            info.setStdPrice((BigDecimal)data);
        } else if (data instanceof String) {
            try {
                info.setStdPrice(new BigDecimal(data.toString()));
            }
            catch (Exception ex) {
                info.setStdPrice(null);
            }
        }
        info.setBillStatus(BillBaseStatusEnum.ADD);
        info.setNumber(String.valueOf(SysUtil.getAppServerTime((Context)ctx).getTime()));
        return info;
    }

    private STDCostResourceTypePriceImportVerify getVerify() {
        if (this.verify == null) {
            this.verify = new STDCostResourceTypePriceImportVerify();
        }
        return this.verify;
    }

    private STDCostEstimateSchemeInfo getEstimateSchemeByNumber(Context ctx, String number, String companyID, String fieldName) throws BOSException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID, CompareType.EQUALS));
        view.setFilter(filter);
        ISTDCostEstimateScheme iScheme = STDCostEstimateSchemeFactory.getLocalInstance(ctx);
        STDCostEstimateSchemeCollection col = null;
        try {
            col = iScheme.getSTDCostEstimateSchemeCollection(view);
        }
        catch (ObjectNotFoundException exc) {
            logger.error((Object)"", (Throwable)exc);
        }
        if (col != null && col.size() > 0) {
            return col.get(0);
        }
        throw new BOSException(STDCostResourceTypePriceImport.getExceptionMessage(fieldName, ctx));
    }

    private STDResourceTypeInfo getResourceTypeByNumber(Context ctx, String number, String companyID, String fieldName) throws BOSException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID, CompareType.EQUALS));
        view.setFilter(filter);
        ISTDResourceType iResType = STDResourceTypeFactory.getLocalInstance(ctx);
        STDResourceTypeCollection col = null;
        try {
            col = iResType.getSTDResourceTypeCollection(view);
        }
        catch (ObjectNotFoundException exc) {
            logger.error((Object)"", (Throwable)exc);
        }
        if (col != null && col.size() > 0) {
            return col.get(0);
        }
        throw new BOSException(STDCostResourceTypePriceImport.getExceptionMessage(fieldName, ctx));
    }

    private static String getExceptionMessage(String fieldName, Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"7_STDCostDataImport", (Locale)ctx.getLocale()) + fieldName + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"8_STDCostDataImport", (Locale)ctx.getLocale()) + fieldName + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"9_STDCostDataImport", (Locale)ctx.getLocale());
    }
}

