/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.list.exception.ObjectNotFoundException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.std.basedata.ISTDCostEstimateScheme;
import com.kingdee.eas.ncm.std.basedata.ISTDResourceType;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeCollection;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeFactory;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeInfo;
import com.kingdee.eas.ncm.std.basedata.STDResourceTypeCollection;
import com.kingdee.eas.ncm.std.basedata.STDResourceTypeFactory;
import com.kingdee.eas.ncm.std.basedata.STDResourceTypeInfo;
import com.kingdee.eas.ncm.std.bill.STDCostResourceTypeQtyFactory;
import com.kingdee.eas.ncm.std.bill.STDCostResourceTypeQtyInfo;
import com.kingdee.eas.ncm.std.bill.app.STDCostResourceTypeQtyImportVerify;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class STDCostResourceTypeQtyImport
extends AbstractNCMDataImport {
    private static Logger logger = Logger.getLogger((String)STDCostResourceTypeQtyImport.class.getName());
    private STDCostResourceTypeQtyImportVerify verify = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return STDCostResourceTypeQtyFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        STDCostResourceTypeQtyInfo info = null;
        try {
            info = this.parse(ctx, hsData);
            this.getVerify().verify(ctx, info, this.isSltImportUpdate());
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("material.number", rs.getString("material.number"));
            result.put("material.name", rs.getString("material.name"));
            result.put("estimateScheme.number", rs.getString("estimateScheme.number"));
            result.put("estimateScheme.name", rs.getString("estimateScheme.name"));
            result.put("resourceType.number", rs.getString("resourceType.number"));
            result.put("resourceType.name", rs.getString("resourceType.name"));
            result.put("stdQty", rs.getString("stdQty"));
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    private STDCostResourceTypeQtyInfo parse(Context ctx, Hashtable hsData) throws BOSException, EASBizException {
        STDCostResourceTypeQtyInfo info = new STDCostResourceTypeQtyInfo();
        Object data = null;
        CompanyOrgUnitInfo currCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        PeriodInfo currentPeriod = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(1001, currCompany.getId().toString());
        info.setCompanyOrg(currCompany);
        info.setCalculatePeriod(currentPeriod);
        data = this.getData(hsData, "estimateScheme.number");
        if (data != null && data.toString().trim().length() > 0) {
            info.setEstimateScheme(this.getEstimateSchemeByNumber(ctx, data.toString(), currCompany.getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"5_STDCostDataImport", (Locale)ctx.getLocale())));
        }
        if ((data = this.getData(hsData, "material.number")) != null && data.toString().trim().length() > 0) {
            info.setMaterial(this.getMaterialByNumber(ctx, data.toString(), ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"6_STDCostDataImport", (Locale)ctx.getLocale())));
        }
        if ((data = this.getData(hsData, "resourceType.number")) != null && data.toString().trim().length() > 0) {
            info.setResourceType(this.getResourceTypeByNumber(ctx, data.toString(), currCompany.getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"16_STDCostResourceTypePriceImport", (Locale)ctx.getLocale())));
        }
        if ((data = this.getData(hsData, "stdQty")) instanceof BigDecimal) {
            info.setStdQty((BigDecimal)data);
        } else if (data instanceof String) {
            try {
                info.setStdQty(new BigDecimal(data.toString()));
            }
            catch (Exception ex) {
                info.setStdQty(null);
            }
        }
        info.setBillStatus(BillBaseStatusEnum.ADD);
        info.setNumber(String.valueOf(SysUtil.getAppServerTime((Context)ctx).getTime()));
        return info;
    }

    private STDCostResourceTypeQtyImportVerify getVerify() {
        if (this.verify == null) {
            this.verify = new STDCostResourceTypeQtyImportVerify();
        }
        return this.verify;
    }

    private STDCostEstimateSchemeInfo getEstimateSchemeByNumber(Context ctx, String number, String companyID, String fieldName) throws BOSException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID, CompareType.EQUALS));
        view.setFilter(filter);
        ISTDCostEstimateScheme iScheme = STDCostEstimateSchemeFactory.getLocalInstance(ctx);
        STDCostEstimateSchemeCollection col = null;
        try {
            col = iScheme.getSTDCostEstimateSchemeCollection(view);
        }
        catch (ObjectNotFoundException exc) {
            logger.error((Object)"", (Throwable)exc);
        }
        if (col != null && col.size() > 0) {
            return col.get(0);
        }
        throw new BOSException(STDCostResourceTypeQtyImport.getExceptionMessage(fieldName, ctx));
    }

    private MaterialInfo getMaterialByNumber(Context ctx, String number, String fieldName) throws BOSException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialCollection col = null;
        try {
            col = iMaterial.getMaterialCollection(view);
        }
        catch (ObjectNotFoundException exc) {
            logger.error((Object)"", (Throwable)exc);
        }
        if (col != null && col.size() > 0) {
            return col.get(0);
        }
        throw new BOSException(STDCostResourceTypeQtyImport.getExceptionMessage(fieldName, ctx));
    }

    private STDResourceTypeInfo getResourceTypeByNumber(Context ctx, String number, String companyID, String fieldName) throws BOSException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID, CompareType.EQUALS));
        view.setFilter(filter);
        ISTDResourceType iResType = STDResourceTypeFactory.getLocalInstance(ctx);
        STDResourceTypeCollection col = null;
        try {
            col = iResType.getSTDResourceTypeCollection(view);
        }
        catch (ObjectNotFoundException exc) {
            logger.error((Object)"", (Throwable)exc);
        }
        if (col != null && col.size() > 0) {
            return col.get(0);
        }
        throw new BOSException(STDCostResourceTypeQtyImport.getExceptionMessage(fieldName, ctx));
    }

    private static String getExceptionMessage(String fieldName, Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"7_STDCostDataImport", (Locale)ctx.getLocale()) + fieldName + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"8_STDCostDataImport", (Locale)ctx.getLocale()) + fieldName + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"9_STDCostDataImport", (Locale)ctx.getLocale());
    }
}

