/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.std.cal.STDCostCalcParam;
import com.kingdee.eas.ncm.std.cal.STDCostCalcResult;
import com.kingdee.eas.ncm.std.cal.STDCostCalcTaskEnum;
import com.kingdee.eas.ncm.std.cal.app.AbstractSTDCostCalcFacadeControllerBean;
import com.kingdee.eas.ncm.std.cal.task.BOMDataCache;
import com.kingdee.eas.ncm.std.cal.task.app.IServerCalcTask;
import com.kingdee.eas.ncm.std.cal.task.app.factory.CalcTaskFactory;
import com.kingdee.eas.scm.cal.IStandardCostAdjBill;
import com.kingdee.eas.scm.cal.StandardCostAdjBillEntryCollection;
import com.kingdee.eas.scm.cal.StandardCostAdjBillEntryInfo;
import com.kingdee.eas.scm.cal.StandardCostAdjBillFactory;
import com.kingdee.eas.scm.cal.StandardCostAdjBillInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Date;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class STDCostCalcFacadeControllerBean
extends AbstractSTDCostCalcFacadeControllerBean {
    private static final long serialVersionUID = 573320060875668937L;
    private static Logger logger = Logger.getLogger((String)STDCostCalcFacadeControllerBean.class.getName());

    @Override
    protected STDCostCalcResult _exeCalcTask(Context ctx, STDCostCalcParam calcParam) throws BOSException, EASBizException {
        Assert.that((calcParam != null ? 1 : 0) != 0);
        Assert.that((calcParam.getCompanyId() != null ? 1 : 0) != 0);
        Assert.that((calcParam.getEstimateSchemeId() != null ? 1 : 0) != 0);
        Assert.that((calcParam.getCalcTaskEnum() != null ? 1 : 0) != 0);
        STDCostCalcTaskEnum calcTaskEnum = calcParam.getCalcTaskEnum();
        IServerCalcTask calTasker = CalcTaskFactory.getCalcTask(ctx, calcTaskEnum);
        STDCostCalcResult calResult = new STDCostCalcResult();
        BOMDataCache dataCache = new BOMDataCache(ctx, calcParam);
        String bomTbl = dataCache.getBomDataTable();
        calcParam.setBomDataTbl(bomTbl);
        calcParam.getCheckParam().setBomDataTbl(bomTbl);
        calResult = calTasker.execute(calcParam, calResult);
        return calResult;
    }

    @Override
    protected List _sendSTDCost(Context ctx, String estimateSchemeId) throws BOSException, EASBizException {
        IRowSet rst;
        StringBuffer kSql;
        int periodNumber;
        int periodYear;
        Date bizDate;
        CompanyOrgUnitInfo company;
        String estimateSchemeName;
        String storageOrgUnitId;
        String companyId;
        ArrayList<String> bills;
        block18: {
            block17: {
                bills = new ArrayList<String>();
                if (StringUtils.isEmpty((String)estimateSchemeId)) {
                    return bills;
                }
                companyId = null;
                storageOrgUnitId = null;
                estimateSchemeName = null;
                company = null;
                bizDate = null;
                periodYear = -1;
                periodNumber = -1;
                kSql = new StringBuffer();
                rst = null;
                kSql.setLength(0);
                kSql.append("SELECT FName_" + ctx.getLocale() + " AS schemeName,FCompanyID,FStorageOrgUnitID FROM T_NCM_SCEstimateScheme WHERE FID = ?");
                rst = NCMDbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{estimateSchemeId});
                if (rst.next()) {
                    companyId = rst.getString("FCompanyID");
                    storageOrgUnitId = rst.getString("FStorageOrgUnitID");
                    estimateSchemeName = rst.getString("schemeName");
                    company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)companyId));
                    break block17;
                }
                ArrayList<String> arrayList = bills;
                SQLUtils.cleanup((ResultSet)rst);
                return arrayList;
            }
            SQLUtils.cleanup((ResultSet)rst);
            kSql.setLength(0);
            kSql.append(" SELECT period.FBeginDate    AS beginDate, \n");
            kSql.append("        period.FPeriodYear   AS FPeriodYear, \n");
            kSql.append("        period.FPeriodNumber AS FPeriodNumber \n");
            kSql.append(" FROM   T_BD_SystemStatusCtrol sysCtrl \n");
            kSql.append("        LEFT OUTER JOIN T_BD_SystemStatus stsSta \n");
            kSql.append("          ON sysCtrl.FSystemStatusID = stsSta.FID \n");
            kSql.append("        LEFT OUTER JOIN T_BD_Period period \n");
            kSql.append("          ON sysCtrl.FCurrentPeriodID = period.FID \n");
            kSql.append(" WHERE  sysCtrl.FCompanyID = ? \n");
            kSql.append("        AND stsSta.FName = 2 \n");
            rst = NCMDbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{companyId});
            if (rst.next()) {
                bizDate = rst.getDate(1);
                periodYear = rst.getInt("FPeriodYear");
                periodNumber = rst.getInt("FPeriodNumber");
                break block18;
            }
            ArrayList<String> arrayList = bills;
            SQLUtils.cleanup((ResultSet)rst);
            return arrayList;
        }
        try {
            SQLUtils.cleanup((ResultSet)rst);
            kSql.setLength(0);
            kSql.append(" SELECT adjBill.FMaterialID AS FMaterialID, \n");
            kSql.append("        adjBill.FNewUnitStdPrice AS FNewUnitStdPrice, \n");
            kSql.append("        adjBill.FOldUnitStdPrice AS FOldUnitStdPrice, \n");
            kSql.append("        ISNULL(invBal.FBaseQty,0) AS FBaseQty, \n");
            kSql.append("        (ISNULL(invBal.FBaseQty,0) * ISNULL(adjBill.FNewUnitStdPrice,0)) AS FNewStandardAmount, \n");
            kSql.append("        (ISNULL(invBal.FBaseQty,0) * ISNULL(adjBill.FOldUnitStdPrice,0)) AS FOldStandardAmount, \n");
            kSql.append("        (ISNULL(adjBill.FNewUnitStdPrice,0)- ISNULL(adjBill.FOldUnitStdPrice,0)) AS FDiffPrice, \n");
            kSql.append("        ((ISNULL(invBal.FBaseQty,0)* ISNULL(adjBill.FNewUnitStdPrice,0)) \n");
            kSql.append("           - \n");
            kSql.append("          (ISNULL(invBal.FBaseQty,0)* ISNULL(adjBill.FOldUnitStdPrice,0)) \n");
            kSql.append("         ) AS FDiffAmount \n");
            kSql.append(" FROM   T_NCM_STDCostAdjustBill adjBill \n");
            kSql.append("        INNER JOIN T_NCM_SCEstimateScheme scheme \n");
            kSql.append("          ON adjBill.FEstimateSchemeID = scheme.FID \n");
            kSql.append("        LEFT OUTER JOIN (SELECT   FMaterialID, \n");
            kSql.append("                                  FStorageOrgUnitID, \n");
            kSql.append("                                  FCompanyOrgUnitID, \n");
            kSql.append("                                  ISNULL(SUM(FPeriodBeginQty),0) AS FBaseQty \n");
            kSql.append("                         FROM     T_IM_InventoryBalance \n");
            kSql.append("                         WHERE    FCompanyOrgUnitID = ? \n");
            kSql.append("                                  AND FStorageOrgUnitID = ? \n");
            kSql.append("                                  AND FIsCalculate = 1 \n");
            kSql.append("                                  AND FPeriod = ? \n");
            kSql.append("                                  AND FYear = ? \n");
            kSql.append("                         GROUP BY FMaterialID,FStorageOrgUnitID,FCompanyOrgUnitID) invBal \n");
            kSql.append("          ON adjBill.FMaterialID = invBal.FMaterialID \n");
            kSql.append("             AND scheme.FStorageOrgUnitID = invBal.FStorageOrgUnitID \n");
            kSql.append("             AND adjBill.FCompanyID = invBal.FCompanyOrgUnitID \n");
            kSql.append("        INNER JOIN T_BD_MaterialCompanyInfo matCompany \n");
            kSql.append("          ON matCompany.FMaterialID = adjBill.FMaterialID \n");
            kSql.append("            AND matCompany.FCompanyID = ? \n");
            kSql.append("            AND matCompany.FAccountType = 2 \n");
            kSql.append(" WHERE  adjBill.FCompanyID = ? \n");
            kSql.append("        AND adjBill.FEstimateSchemeID = ? \n");
            rst = NCMDbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{companyId, storageOrgUnitId, periodNumber, periodYear, companyId, companyId, estimateSchemeId});
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            boolean isExistNumberRule = codingRuleManager.isExist((IObjectValue)new StandardCostAdjBillInfo(), companyId);
            IStandardCostAdjBill iAdjBill = StandardCostAdjBillFactory.getLocalInstance((Context)ctx);
            StandardCostAdjBillEntryCollection entryCol = new StandardCostAdjBillEntryCollection();
            int i = 0;
            while (rst.next()) {
                ++i;
                StandardCostAdjBillEntryInfo entryInfo = new StandardCostAdjBillEntryInfo();
                MaterialInfo matrial = new MaterialInfo();
                matrial.setId(BOSUuid.read((String)rst.getString("FMaterialID")));
                entryInfo.setMaterial(matrial);
                entryInfo.setBaseQty(rst.getBigDecimal("FBaseQty"));
                entryInfo.setNewStandardPrice(rst.getBigDecimal("FNewUnitStdPrice"));
                entryInfo.setOldStandardPrice(rst.getBigDecimal("FOldUnitStdPrice"));
                entryInfo.setNewStandardAmount(rst.getBigDecimal("FNewStandardAmount"));
                entryInfo.setOldStandardAmount(rst.getBigDecimal("FOldStandardAmount"));
                entryInfo.setDiffPrice(rst.getBigDecimal("FDiffPrice"));
                entryInfo.setDiffAmount(rst.getBigDecimal("FDiffAmount"));
                entryInfo.setRemark(estimateSchemeName);
                entryCol.add(entryInfo);
                if (i % 200 != 0) continue;
                StandardCostAdjBillInfo adjBillInfo = new StandardCostAdjBillInfo();
                adjBillInfo.setBizDate((java.util.Date)bizDate);
                adjBillInfo.setCompanyOrgUnit(company);
                adjBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                String number = null;
                if (isExistNumberRule) {
                    number = codingRuleManager.getNumber((IObjectValue)adjBillInfo, companyId);
                    if (StringUtils.isEmpty((String)number)) {
                        number = "STDCostAdj-" + SysUtil.getAppServerTime((Context)ctx).getTime();
                    }
                } else {
                    number = "STDCostAdj-" + SysUtil.getAppServerTime((Context)ctx).getTime();
                }
                adjBillInfo.setNumber(number);
                bills.add(number);
                adjBillInfo.getEntry().addCollection(entryCol);
                iAdjBill.addnew((CoreBaseInfo)adjBillInfo);
                entryCol.clear();
                i = 0;
            }
            if (i != 0) {
                StandardCostAdjBillInfo adjBillInfo = new StandardCostAdjBillInfo();
                adjBillInfo.setBizDate((java.util.Date)bizDate);
                adjBillInfo.setCompanyOrgUnit(company);
                adjBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                String number = null;
                if (isExistNumberRule) {
                    number = codingRuleManager.getNumber((IObjectValue)adjBillInfo, companyId);
                    if (StringUtils.isEmpty((String)number)) {
                        number = "STDCostAdj-" + SysUtil.getAppServerTime((Context)ctx).getTime();
                    }
                } else {
                    number = "STDCostAdj-" + SysUtil.getAppServerTime((Context)ctx).getTime();
                }
                adjBillInfo.setNumber(number);
                bills.add(number);
                adjBillInfo.getEntry().addCollection(entryCol);
                iAdjBill.addnew((CoreBaseInfo)adjBillInfo);
            }
        }
        catch (Exception exc) {
            try {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bills;
    }
}

