/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.CheckStatusEnum;
import com.kingdee.eas.ncm.common.utils.app.NCMDbBatchUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.std.cal.STDCostCheckParam;
import com.kingdee.eas.ncm.std.cal.STDCostCheckResultDetailCollection;
import com.kingdee.eas.ncm.std.cal.STDCostCheckResultDetailInfo;
import com.kingdee.eas.ncm.std.cal.STDCostCheckResultInfo;
import com.kingdee.eas.ncm.std.cal.app.ISTDCostChecker;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class STDCostManualMatPriceChecker
implements ISTDCostChecker {
    private static Logger logger = Logger.getLogger((String)STDCostManualMatPriceChecker.class.getName());

    @Override
    public STDCostCheckResultInfo calChecker(final Context ctx, STDCostCheckParam checkParam, STDCostCheckResultInfo costCheckResultInfo) throws BOSException, EASBizException {
        Assert.that((checkParam != null ? 1 : 0) != 0);
        Assert.that((checkParam.getMatPriceSchemeID() != null ? 1 : 0) != 0);
        Assert.that((checkParam.getStorageOrgUnitID() != null ? 1 : 0) != 0);
        Assert.that((checkParam.getCompanyID() != null ? 1 : 0) != 0);
        Assert.that((costCheckResultInfo != null ? 1 : 0) != 0);
        String companyID = checkParam.getCompanyID();
        final String storageOrgUnitID = checkParam.getStorageOrgUnitID();
        final String matPriceSchemeID = checkParam.getMatPriceSchemeID();
        String[] materialIds = checkParam.getMaterialIDs();
        final STDCostCheckResultInfo _costCheckResultInfo = (STDCostCheckResultInfo)costCheckResultInfo.clone();
        _costCheckResultInfo.setCheckStatus(CheckStatusEnum.succeed);
        _costCheckResultInfo.getDetail().addCollection(new STDCostCheckResultDetailCollection());
        StringBuffer kSql = new StringBuffer();
        kSql.append("select distinct top 100 \n");
        kSql.append("    mat.FNumber AS FMaterialNumber, mat.Fname_" + ctx.getLocale() + " AS FMaterialName \n");
        kSql.append("from T_NCM_STDCostEstimateType estimateType \n");
        kSql.append("left join T_NCM_STDCostData costData \n");
        kSql.append("    on costData.FMaterialID = estimateType.FMaterialID \n");
        kSql.append("    and costData.FEstimateSchemeID = ? \n");
        kSql.append("join T_BD_Material mat \n");
        kSql.append("    on mat.FID = estimateType.FMaterialID \n");
        kSql.append("where estimateType.FEstimateType = 1 \n");
        kSql.append("    and estimateType.FStorageOrgUnitID = ? \n");
        kSql.append("    and (costData.FID IS NULL or costData.FStdAmount is null or costData.FStdAmount = 0)  \n");
        if (materialIds == null || materialIds.length == 0) {
            IRowSet rst = NCMDbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{matPriceSchemeID, storageOrgUnitID});
            try {
                while (rst.next()) {
                    this.fillCheckResultDetail(_costCheckResultInfo, (ResultSet)rst, ctx);
                }
            }
            catch (SQLException exc) {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        String T_NCM_STDCostBomPath = null;
        try {
            T_NCM_STDCostBomPath = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_STDCostBomPath");
        }
        catch (SQLException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        kSql.append("  AND (");
        kSql.append("  \t\tmat.FID IN( \n");
        for (int i = 0; i < 200; ++i) {
            if (i == 199) {
                kSql.append(" ? ");
                continue;
            }
            kSql.append(" ?, ");
        }
        kSql.append("                  )\n");
        kSql.append("       OR \n");
        kSql.append("       mat.FID IN (SELECT FMaterialID FROM\u3000" + T_NCM_STDCostBomPath + ")");
        kSql.append("      )");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int i = 0; i < materialIds.length; ++i) {
            params.add(new Object[]{materialIds[i]});
        }
        NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), params, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

            public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                ps.setString(1, matPriceSchemeID);
                ps.setString(2, storageOrgUnitID);
                return 2;
            }

            public void processRow(ResultSet rs) throws SQLException {
                STDCostManualMatPriceChecker.this.fillCheckResultDetail(_costCheckResultInfo, rs, ctx);
            }
        });
        return _costCheckResultInfo;
    }

    private void fillCheckResultDetail(STDCostCheckResultInfo costCheckResultInfo, ResultSet rs, Context ctx) throws SQLException {
        STDCostCheckResultDetailInfo detail = new STDCostCheckResultDetailInfo();
        detail.setDescription(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.cal.CALAutoGenerateResource", (String)"0_STDCostManualMatPriceChecker", (Locale)ctx.getLocale()) + rs.getString("FMaterialNumber") + " " + rs.getString("FMaterialName") + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.cal.CALAutoGenerateResource", (String)"1_STDCostManualMatPriceChecker", (Locale)ctx.getLocale()));
        detail.setReason(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.cal.CALAutoGenerateResource", (String)"2_STDCostManualMatPriceChecker", (Locale)ctx.getLocale()));
        detail.setSuggestOperation(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.cal.CALAutoGenerateResource", (String)"3_STDCostManualMatPriceChecker", (Locale)ctx.getLocale()));
        costCheckResultInfo.setCheckStatus(CheckStatusEnum.lost);
        costCheckResultInfo.getDetail().add(detail);
    }
}

