/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.CheckStatusEnum;
import com.kingdee.eas.ncm.common.utils.app.NCMDbBatchUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.std.cal.STDCostCheckParam;
import com.kingdee.eas.ncm.std.cal.STDCostCheckResultDetailCollection;
import com.kingdee.eas.ncm.std.cal.STDCostCheckResultDetailInfo;
import com.kingdee.eas.ncm.std.cal.STDCostCheckResultInfo;
import com.kingdee.eas.ncm.std.cal.app.ISTDCostChecker;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class STDCostNestedBOMChecker
implements ISTDCostChecker {
    private static Logger logger = Logger.getLogger((String)STDCostNestedBOMChecker.class.getName());

    @Override
    public STDCostCheckResultInfo calChecker(Context ctx, STDCostCheckParam checkParam, STDCostCheckResultInfo costCheckResultInfo) throws BOSException, EASBizException {
        Assert.that((checkParam != null ? 1 : 0) != 0);
        Assert.that((checkParam.getCompanyID() != null ? 1 : 0) != 0);
        Assert.that((checkParam.getStorageOrgUnitID() != null ? 1 : 0) != 0);
        Assert.that((checkParam.getMatBOMSchemeID() != null ? 1 : 0) != 0);
        Assert.that((costCheckResultInfo != null ? 1 : 0) != 0);
        final String storageOrgUnitID = checkParam.getStorageOrgUnitID();
        final String matBOMSchemeID = checkParam.getMatBOMSchemeID();
        final String matPriceSchemeID = checkParam.getMatPriceSchemeID();
        boolean isOnlyForOnStdCost = checkParam.isOnlyForOnStdCost();
        String bomTbl = checkParam.getBomDataTbl();
        String companyID = checkParam.getCompanyID();
        String[] materialIds = checkParam.getMaterialIDs();
        costCheckResultInfo.setCheckStatus(CheckStatusEnum.succeed);
        costCheckResultInfo.getDetail().addCollection(new STDCostCheckResultDetailCollection());
        StringBuffer kSql = new StringBuffer();
        IRowSet rst = null;
        try {
            String T_NCM_STDCostBomPath = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_STDCostBomPath");
            NCMDbUtil.execute((Context)ctx, (String)(" truncate table " + T_NCM_STDCostBomPath));
            kSql.setLength(0);
            kSql.append(" INSERT INTO " + T_NCM_STDCostBomPath + " \n");
            kSql.append("            (FStorageOrgUnitID, \n");
            kSql.append("             FBomID, \n");
            kSql.append("             FParentMaterialID, \n");
            kSql.append("             FMaterialID, \n");
            kSql.append("             FBomPath, \n");
            kSql.append("             FBomEntryID, \n");
            kSql.append("             FLevelCode, \n");
            kSql.append("             FIsNest) \n");
            kSql.append(" SELECT '" + storageOrgUnitID + "' AS FStorageOrgUnitID, \n");
            kSql.append("        CASE  \n");
            kSql.append("          WHEN mat2bom.FBomID IS NOT NULL THEN mat2bom.FBomID \n");
            kSql.append("          ELSE mainBom.FBOmID \n");
            kSql.append("        END AS FBomID, \n");
            kSql.append("        mat2bom.FParentMaterialID AS FParentMaterialID, \n");
            kSql.append("        mat2bom.FParentMaterialID AS FMaterialID, \n");
            kSql.append("        pMat.FNumber AS FBomPath, \n");
            kSql.append("        NULL AS FBomEntryID, \n");
            kSql.append("        0 AS FLevelCode, \n");
            kSql.append("        0 AS FIsNest \n");
            kSql.append(" FROM   T_NCM_STDCostMaterialBOM mat2bom \n");
            kSql.append("        INNER JOIN T_NCM_STDCostEstimateType estimateType \n");
            kSql.append("          ON estimateType.FMaterialID = mat2bom.FParentMaterialID \n");
            kSql.append("            AND estimateType.FEstimateType = 2 \n");
            kSql.append("        INNER JOIN T_BD_Material pMat \n");
            kSql.append("          ON pMat.FID = mat2bom.FParentMaterialID \n");
            kSql.append("        Left Outer Join (select distinct FParentMaterialID,FStorageOrgUnitID,FBomID From ").append(bomTbl).append(") mainBom \n");
            kSql.append("            on mainBom.FParentMaterialID = mat2bom.FParentMaterialID and mainBom.FSTORAGEORGUNITID = estimateType.FStorageOrgUnitID \n");
            kSql.append(" WHERE  mat2bom.FEstimateSchemeID = ? \n");
            kSql.append("        AND estimateType.FStorageOrgUnitID = ? \n");
            kSql.append("        AND (mat2bom.FBomID IS NOT NULL OR mainBom.FBomID IS NOT NULL) \n \n");
            kSql.append("        AND (mat2bom.FBomID IS NOT NULL OR mat2bom.FBOMQueueID IS NOT NULL) \n \n");
            if (isOnlyForOnStdCost) {
                kSql.append("        AND EXISTS(SELECT 1 \n");
                kSql.append("                    FROM T_NCM_STDCostData costData \n");
                kSql.append("                   WHERE costData.FEstimateSchemeID = ? \n");
                kSql.append("                     AND costData.FMaterialID = estimateType.FMaterialID \n");
                kSql.append("                     AND costData.FStdAmount IS NULL \n");
                kSql.append("                    ) \n");
            }
            if (materialIds == null || materialIds.length == 0) {
                if (isOnlyForOnStdCost) {
                    NCMDbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{matBOMSchemeID, storageOrgUnitID, matPriceSchemeID});
                } else {
                    NCMDbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{matBOMSchemeID, storageOrgUnitID});
                }
            } else {
                kSql.append("    AND pMat.FID in( \n");
                for (int i = 0; i < 200; ++i) {
                    if (i == 199) {
                        kSql.append(" ? ");
                        continue;
                    }
                    kSql.append(" ?, ");
                }
                kSql.append(" )");
                ArrayList<Object[]> params = new ArrayList<Object[]>();
                for (int i = 0; i < materialIds.length; ++i) {
                    params.add(new Object[]{materialIds[i]});
                }
                if (isOnlyForOnStdCost) {
                    NCMDbBatchUtil.batchExecuteUpdate((Context)ctx, (String)kSql.toString(), params, (NCMDbBatchUtil.UpdateCallbackHandler)new NCMDbBatchUtil.UpdateCallbackHandler(){

                        public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                            ps.setString(1, matBOMSchemeID);
                            ps.setString(2, storageOrgUnitID);
                            ps.setString(3, matPriceSchemeID);
                            return 3;
                        }
                    });
                } else {
                    NCMDbBatchUtil.batchExecuteUpdate((Context)ctx, (String)kSql.toString(), params, (NCMDbBatchUtil.UpdateCallbackHandler)new NCMDbBatchUtil.UpdateCallbackHandler(){

                        public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                            ps.setString(1, matBOMSchemeID);
                            ps.setString(2, storageOrgUnitID);
                            return 2;
                        }
                    });
                }
            }
            kSql.setLength(0);
            kSql.append(" INSERT INTO " + T_NCM_STDCostBomPath + " \n");
            kSql.append("            (FStorageOrgUnitID, \n");
            kSql.append("             FBomID, \n");
            kSql.append("             FParentMaterialID, \n");
            kSql.append("             FMaterialID, \n");
            kSql.append("             FBomPath, \n");
            kSql.append("             FBomEntryID, \n");
            kSql.append("             FLevelCode, \n");
            kSql.append("             FIsNest) \n");
            kSql.append(" SELECT bomPath.FStorageOrgUnitID AS FStorageOrgUnitID, \n");
            kSql.append("        bomPath.FBOMID AS FBomID, \n");
            kSql.append("        bomPath.FParentMaterialID AS FParentMaterialID, \n");
            kSql.append("        bomEntry.FMaterialID AS FMaterialID, \n");
            kSql.append("        TO_CHAR(CONCAT(CONCAT(bomPath.FBomPath,','),cMat.Fnumber)) AS FBomPath, \n");
            kSql.append("        null AS FBomEntryID, \n");
            kSql.append("        1 AS FLevelCode, \n");
            kSql.append("        0 AS FIsNest \n");
            kSql.append(" FROM   " + T_NCM_STDCostBomPath + " bomPath \n");
            kSql.append("        INNER JOIN ").append(bomTbl).append(" bomEntry \n");
            kSql.append("          ON bomEntry.FParentMaterialID = bomPath.FParentMaterialID And bomEntry.FSTORAGEORGUNITID = bomPath.FStorageOrgUnitID And bomEntry.FEffectiveDate <= GetDate() and GetDate() < bomEntry.FDisableDate \n");
            kSql.append("        INNER JOIN T_BD_Material cMat \n");
            kSql.append("          ON cMat.Fid = bomEntry.FMaterialID \n");
            kSql.append(" WHERE  bomPath.FLevelCode = 0 \n");
            NCMDbUtil.execute((Context)ctx, (String)kSql.toString());
            int i = 1;
            rst = this.isExistsNextLevelMat(ctx, storageOrgUnitID, T_NCM_STDCostBomPath, i);
            while (rst.next() && rst.getInt(1) > 0) {
                kSql.setLength(0);
                kSql.append(" INSERT INTO " + T_NCM_STDCostBomPath + " \n");
                kSql.append("            (FStorageOrgUnitID, \n");
                kSql.append("             FBomID, \n");
                kSql.append("             FParentMaterialID, \n");
                kSql.append("             FMaterialID, \n");
                kSql.append("             FBomPath, \n");
                kSql.append("             FBomEntryID, \n");
                kSql.append("             FLevelCode, \n");
                kSql.append("             FIsNest) \n");
                kSql.append(" SELECT DISTINCT '" + storageOrgUnitID + "' AS FStorageOrgUnitID, \n");
                kSql.append("                 mainBomEntry.FBomID AS FBomID, \n");
                kSql.append("                 bomPath.FMaterialID AS FParentMaterialID, \n");
                kSql.append("                 mainBomEntry.FMaterialID AS FMaterialID, \n");
                kSql.append("                 CASE WHEN CHARINDEX(','||bomEntryMat.FNumber||',', ','||bomPath.FBOMPATH||',') <> 0  \n");
                kSql.append("                                 THEN TO_CHAR(CONCAT(CONCAT(RTRIM(SUBSTRING(bomPath.FBOMPATH, \n");
                kSql.append("                                                           CHARINDEX(','||bomEntryMat.Fnumber||',', ','||bomPath.FBOMPATH||','), \n");
                kSql.append("                                                           LEN(bomPath.FBOMPATH))),','),bomEntryMat.Fnumber)) \n");
                kSql.append("                              ELSE TO_CHAR(CONCAT(CONCAT(bomPath.FBOMPATH,','),bomEntryMat.Fnumber)) \n");
                kSql.append("                 END AS FBomPath, \n");
                kSql.append("                 null AS FBomEntryID, \n");
                kSql.append("                 " + (i + 1) + " AS FLevelCode, \n");
                kSql.append("                 CASE  \n");
                kSql.append("                           WHEN CHARINDEX(','||bomEntryMat.Fnumber||',', ','||bomPath.FBOMPATH||',') <> 0 THEN 1 \n");
                kSql.append("                           ELSE 0 \n");
                kSql.append("                 END AS FIsNest \n");
                kSql.append(" FROM   " + T_NCM_STDCostBomPath + " bomPath \n");
                kSql.append("        INNER JOIN T_NCM_STDCostMaterialBOM mat2bom \n");
                kSql.append("          ON bomPath.FMaterialID = mat2bom.FParentMaterialID \n");
                kSql.append("        INNER JOIN T_NCM_STDCostEstimateType estimateType \n");
                kSql.append("          ON estimateType.FMaterialID = mat2bom.FParentMaterialID \n");
                kSql.append("             AND estimateType.FEstimateType = 2 \n");
                kSql.append("             AND estimateType.FStorageOrgUnitID = ? \n");
                kSql.append("        Left Join ").append(bomTbl).append(" mainBomEntry \n");
                kSql.append("          ON mainBomEntry.FParentMaterialID = mat2bom.FParentMaterialID and mainBomEntry.FSTORAGEORGUNITID = estimateType.FStorageOrgUnitID \n");
                kSql.append("        LEFT OUTER JOIN T_BD_Material bomEntryMat \n");
                kSql.append("          ON mainBomEntry.FMaterialID = bomEntryMat.FID \n");
                kSql.append(" WHERE  mat2bom.FEstimateSchemeID = ? \n");
                kSql.append("        AND bomPath.FLevelCode = ? \n");
                kSql.append("        AND bomPath.FIsNest = 0 \n");
                kSql.append("        AND (mat2bom.FBomID IS NOT NULL OR mainBomEntry.FBomID IS NOT NULL) \n");
                kSql.append("        AND (mat2bom.FBomID IS NOT NULL OR mat2bom.FBOMQueueID IS NOT NULL) \n \n");
                kSql.append("        and (\n");
                kSql.append("            mat2bom.FBomID is not null \n");
                kSql.append("            and (\n");
                kSql.append("                mat2bom.FValidateDate is not null \n");
                kSql.append("                and mainBomEntry.FEffectiveDate <= mat2bom.FValidateDate and mat2bom.FValidateDate < mainBomEntry.FDisableDate \n");
                kSql.append("                or \n");
                kSql.append("                mat2bom.FValidateDate is null \n");
                kSql.append("                and mainBomEntry.FEffectiveDate <= GetDate() and GetDate() < mainBomEntry.FDisableDate \n");
                kSql.append("            ) \n");
                kSql.append("            or \n");
                kSql.append("            mat2bom.FBomID is null \n");
                kSql.append("            and (\n");
                kSql.append("                mat2bom.FValidateDate is not null \n");
                kSql.append("                and mainBomEntry.FEffectiveDate <= mat2bom.FValidateDate and mat2bom.FValidateDate < mainBomEntry.FDisableDate \n");
                kSql.append("                or \n");
                kSql.append("                mat2bom.FValidateDate is null \n");
                kSql.append("                and mainBomEntry.FEffectiveDate <= GetDate() and GetDate() < mainBomEntry.FDisableDate \n");
                kSql.append("            ) \n");
                kSql.append("        ) \n");
                NCMDbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{storageOrgUnitID, matBOMSchemeID, i});
                rst = this.isExistsNextLevelMat(ctx, storageOrgUnitID, T_NCM_STDCostBomPath, ++i);
            }
            kSql.setLength(0);
            kSql.append(" SELECT DISTINCT bom.FNumber AS FBomNumber, \n");
            kSql.append("                 bom.FName_" + ctx.getLocale() + " AS FBomName, \n");
            kSql.append("                 mat.FNumber AS FMatNumber, \n");
            kSql.append("                 mat.FName_" + ctx.getLocale() + " AS FMatName, \n");
            kSql.append("                 bomPath.FBomPath as FBomPath \n");
            kSql.append(" FROM   " + T_NCM_STDCostBomPath + " bomPath  \n");
            kSql.append("        INNER JOIN T_MM_Bom bom  \n");
            kSql.append("          ON bom.Fid = bomPath.FBomID  \n");
            kSql.append("        INNER JOIN T_BD_Material mat  \n");
            kSql.append("          ON mat.Fid = bomPath.FParentMaterialID  \n");
            kSql.append(" WHERE  bomPath.FIsNest = 1  \n");
            rst = NCMDbUtil.executeQuery((Context)ctx, (String)kSql.toString());
            while (rst.next()) {
                STDCostCheckResultDetailInfo detail = new STDCostCheckResultDetailInfo();
                detail.setDescription(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.cal.CALAutoGenerateResource", (String)"0_STDCostManualMatPriceChecker", (Locale)ctx.getLocale()) + rst.getString("FMatNumber") + " " + rst.getString("FMatName") + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.cal.CALAutoGenerateResource", (String)"4_STDCostNestedBOMChecker", (Locale)ctx.getLocale()) + rst.getString("FBomNumber") + " " + rst.getString("FBomName") + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.cal.CALAutoGenerateResource", (String)"5_STDCostNestedBOMChecker", (Locale)ctx.getLocale()) + rst.getString("FBomPath"));
                detail.setReason(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.cal.CALAutoGenerateResource", (String)"6_STDCostNestedBOMChecker", (Locale)ctx.getLocale()));
                detail.setSuggestOperation(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.cal.CALAutoGenerateResource", (String)"7_STDCostNestedBOMChecker", (Locale)ctx.getLocale()));
                costCheckResultInfo.setCheckStatus(CheckStatusEnum.lost);
                costCheckResultInfo.getDetail().add(detail);
            }
        }
        catch (Exception exc) {
            try {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return costCheckResultInfo;
    }

    private IRowSet isExistsNextLevelMat(Context ctx, String storageOrgUnitId, String T_NCM_STDCostBomPath, int level) throws BOSException {
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT COUNT(bomPath.FLevelCode) \n");
        kSql.append(" FROM   " + T_NCM_STDCostBomPath + " bomPath \n");
        kSql.append("        INNER JOIN T_MM_Bom bom \n");
        kSql.append("          ON bomPath.FMaterialID = bom.FMaterialID \n");
        kSql.append("             AND bomPath.FStorageOrgUnitID = bom.FStorageOrgUnitID \n");
        kSql.append(" WHERE  bomPath.FLevelCode = ? \n");
        kSql.append("        AND bom.FStorageOrgUnitID = ? \n");
        kSql.append("        AND bom.FBaseStatus = 4 \n");
        kSql.append("        AND bom.FBomType = 40 \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{level, storageOrgUnitId});
        return rs;
    }
}

