/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.cal.CheckStatusEnum;
import com.kingdee.eas.ncm.common.utils.app.NCMDbBatchUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.std.cal.STDCostCheckParam;
import com.kingdee.eas.ncm.std.cal.STDCostCheckResultDetailCollection;
import com.kingdee.eas.ncm.std.cal.STDCostCheckResultDetailInfo;
import com.kingdee.eas.ncm.std.cal.STDCostCheckResultInfo;
import com.kingdee.eas.ncm.std.cal.app.ISTDCostChecker;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class STDCostRollUpMatBOMChecker
implements ISTDCostChecker {
    private static Logger logger = Logger.getLogger((String)STDCostRollUpMatBOMChecker.class.getName());

    @Override
    public STDCostCheckResultInfo calChecker(final Context ctx, STDCostCheckParam checkParam, STDCostCheckResultInfo costCheckResultInfo) throws BOSException, EASBizException {
        Assert.that((checkParam != null ? 1 : 0) != 0);
        Assert.that((checkParam.getStorageOrgUnitID() != null ? 1 : 0) != 0);
        Assert.that((checkParam.getMatBOMSchemeID() != null ? 1 : 0) != 0);
        Assert.that((checkParam.getMatPriceSchemeID() != null ? 1 : 0) != 0);
        Assert.that((costCheckResultInfo != null ? 1 : 0) != 0);
        final String storageOrgUnitID = checkParam.getStorageOrgUnitID();
        final String matBOMSchemeID = checkParam.getMatBOMSchemeID();
        String[] materialIds = checkParam.getMaterialIDs();
        final STDCostCheckResultInfo _costCheckResultInfo = (STDCostCheckResultInfo)costCheckResultInfo.clone();
        String bomTbl = checkParam.getBomDataTbl();
        _costCheckResultInfo.setCheckStatus(CheckStatusEnum.succeed);
        _costCheckResultInfo.getDetail().addCollection(new STDCostCheckResultDetailCollection());
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT top 100 CASE  \n");
        kSql.append("          WHEN scMatBom.FBomID IS NOT NULL \n");
        kSql.append("          \t\tTHEN scMatBom.FBomID \n");
        kSql.append("          WHEN scMatBom.FBomID IS NULL AND scMatBom.FBOMQueueID IS NOT NULL \n");
        kSql.append("               THEN mainBom.FBomID \n");
        kSql.append("          ELSE NULL \n");
        kSql.append("        END AS FBomID, \n");
        kSql.append("        mat.FID AS FParentMaterialID, \n");
        kSql.append("        mat.FNumber AS FParentMaterialNumber, \n");
        kSql.append("        mat.Fname_L2 AS FParentMaterialName \n");
        kSql.append(" FROM   T_NCM_STDCostEstimateType estimateType \n");
        kSql.append("        LEFT OUTER JOIN T_NCM_STDCostMaterialBOM scMatBom \n");
        kSql.append("          ON estimateType.FMaterialID = scMatBom.FParentMaterialID \n");
        kSql.append("              AND scMatBom.FEstimateSchemeID = ? \n");
        kSql.append("        LEFT OUTER JOIN T_BD_Material mat \n");
        kSql.append("          ON mat.FID = estimateType.FMaterialID \n");
        kSql.append("        LEFT OUTER JOIN ").append(bomTbl).append(" mainBom \n");
        kSql.append("          ON mainBom.FParentMaterialID = scMatBom.FParentMaterialID \n");
        kSql.append("            AND mainBom.FStorageOrgUnitID = estimateType.FStorageOrgUnitID \n");
        kSql.append(" WHERE  estimateType.FEstimateType = 2 \n");
        kSql.append("        AND estimateType.FStorageOrgUnitID = ? \n");
        final HashMap dumpMat = new HashMap();
        if (materialIds == null || materialIds.length == 0) {
            IRowSet rst = NCMDbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{matBOMSchemeID, storageOrgUnitID});
            try {
                while (rst.next()) {
                    this.fillCheckResultDetail(_costCheckResultInfo, (ResultSet)rst, dumpMat, ctx);
                }
            }
            catch (SQLException exc) {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rst);
            }
        } else {
            kSql.append("  AND estimateType.FMaterialID IN( \n");
            for (int i = 0; i < 200; ++i) {
                if (i == 199) {
                    kSql.append(" ? ");
                    continue;
                }
                kSql.append(" ?, ");
            }
            kSql.append(" )");
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (int i = 0; i < materialIds.length; ++i) {
                params.add(new Object[]{materialIds[i]});
            }
            NCMDbBatchUtil.batchExecuteQuery((Context)ctx, (String)kSql.toString(), params, (NCMDbBatchUtil.QueryCallbackHandler)new NCMDbBatchUtil.QueryCallbackHandler(){

                public int beforeBatchBindParams(PreparedStatement ps) throws SQLException {
                    ps.setString(1, matBOMSchemeID);
                    ps.setString(2, storageOrgUnitID);
                    return 2;
                }

                public void processRow(ResultSet rs) throws SQLException {
                    STDCostRollUpMatBOMChecker.this.fillCheckResultDetail(_costCheckResultInfo, rs, dumpMat, ctx);
                }
            });
        }
        return _costCheckResultInfo;
    }

    private void fillCheckResultDetail(STDCostCheckResultInfo costCheckResultInfo, ResultSet rs, Map dumpMat, Context ctx) throws SQLException {
        if (rs.getString("FBomID") == null) {
            if (dumpMat.containsKey(rs.getString("FParentMaterialID"))) {
                return;
            }
            dumpMat.put(rs.getString("FParentMaterialID"), null);
            STDCostCheckResultDetailInfo detail = new STDCostCheckResultDetailInfo();
            detail.setDescription(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.cal.CALAutoGenerateResource", (String)"0_STDCostManualMatPriceChecker", (Locale)ctx.getLocale()) + rs.getString("FParentMaterialNumber") + " " + rs.getString("FParentMaterialName") + ResourceBase.getString((String)"com.kingdee.eas.ncm.std.cal.CALAutoGenerateResource", (String)"12_STDCostRollUpMatBOMChecker", (Locale)ctx.getLocale()));
            detail.setReason(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.cal.CALAutoGenerateResource", (String)"13_STDCostRollUpMatBOMChecker", (Locale)ctx.getLocale()));
            detail.setSuggestOperation(ResourceBase.getString((String)"com.kingdee.eas.ncm.std.cal.CALAutoGenerateResource", (String)"14_STDCostRollUpMatBOMChecker", (Locale)ctx.getLocale()));
            costCheckResultInfo.setCheckStatus(CheckStatusEnum.lost);
            costCheckResultInfo.getDetail().add(detail);
        }
    }
}

