/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.cal.task.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.std.cal.STDCostCalcParam;
import com.kingdee.eas.ncm.std.cal.STDCostCalcResult;
import com.kingdee.util.Assert;
import org.apache.log4j.Logger;

public class MatBOMRollUpCalculator {
    private static Logger logger = Logger.getLogger((String)MatBOMRollUpCalculator.class.getName());
    Context ctx = null;
    STDCostCalcParam calcParam = null;
    STDCostCalcResult calcResult = null;
    String T_NCM_STDCostBomPath = null;
    String T_NCM_STDCostRollUpMat = null;
    String T_NCM_STDCostRollUpRes = null;
    private String T_TMP_Material = null;
    private String bomTbl = null;

    private MatBOMRollUpCalculator() {
    }

    public MatBOMRollUpCalculator(Context ctx, STDCostCalcParam calcParam, STDCostCalcResult calcResult, String T_TMP_Material) throws Exception {
        this();
        Assert.that((calcParam != null ? 1 : 0) != 0);
        Assert.that((calcParam.getCompanyId() != null ? 1 : 0) != 0);
        Assert.that((calcParam.getStorageOrgUnitID() != null ? 1 : 0) != 0);
        Assert.that((calcParam.getEstimateSchemeId() != null ? 1 : 0) != 0);
        Assert.that((calcParam.getResStdQtySchemeID() != null ? 1 : 0) != 0);
        Assert.that((calcParam.getResStdPriceSchemeID() != null ? 1 : 0) != 0);
        Assert.that((calcResult != null ? 1 : 0) != 0);
        Assert.that((ctx != null ? 1 : 0) != 0);
        this.ctx = ctx;
        this.calcParam = calcParam;
        this.calcResult = calcResult;
        this.T_TMP_Material = T_TMP_Material;
        this.T_NCM_STDCostBomPath = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)calcParam.getCompanyId(), (String)"T_NCM_STDCostBomPath");
        this.T_NCM_STDCostRollUpMat = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)calcParam.getCompanyId(), (String)"T_NCM_STDCostRollUpMat");
        this.T_NCM_STDCostRollUpRes = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)calcParam.getCompanyId(), (String)"T_NCM_STDCostRollUpRes");
        this.bomTbl = calcParam.getBomDataTbl();
    }

    public STDCostCalcResult rollUp(int rank) throws BOSException, EASBizException {
        StringBuffer kSql = new StringBuffer();
        boolean isOnlyForOnStdCost = this.calcParam.isOnlyForOnStdCost();
        try {
            kSql.setLength(0);
            kSql.append("UPDATE " + this.T_NCM_STDCostRollUpMat + " \n");
            kSql.append("SET FChildQty = ( \n");
            kSql.append("    SELECT Sum(isnull(FConsumeFixQty,0)) AS FQty \n");
            kSql.append("    FROM  " + this.T_NCM_STDCostBomPath + " bomPath \n");
            kSql.append("        INNER JOIN ").append(this.bomTbl).append(" bomData \n");
            kSql.append("            ON bomData.FStorageOrgUnitID = bomPath.FStorageOrgUnitID and bomData.FParentMaterialID = bomPath.FParentMaterialID and bomPath.FMaterialID = bomData.FMaterialID \n");
            kSql.append("\t\t INNER JOIN T_BD_Material childMat \n");
            kSql.append("  \t\t\t ON bomPath.FMaterialID = childMat.FID \n");
            kSql.append("    WHERE  " + this.T_NCM_STDCostRollUpMat + ".FEstimateType = " + 2 + " \n");
            kSql.append("        AND " + this.T_NCM_STDCostRollUpMat + ".FLowLevelCode = " + rank + " \n");
            kSql.append("        and " + this.T_NCM_STDCostRollUpMat + ".FParentMaterialID = bomPath.FParentMaterialID \n");
            kSql.append("        AND " + this.T_NCM_STDCostRollUpMat + ".FMaterialID = bomPath.FMaterialID \n");
            kSql.append(" \t\t AND " + this.T_NCM_STDCostRollUpMat + ".FSpreadPath = bomPath.FBomPath \n");
            kSql.append(") \n");
            kSql.append("WHERE FEstimateType = 2 \n");
            kSql.append("    AND FLowLevelCode = " + rank + " \n");
            NCMDbUtil.execute((Context)this.ctx, (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" UPDATE " + this.T_NCM_STDCostRollUpMat + " \n");
            kSql.append(" SET    FChildQty = (SELECT CASE  \n");
            kSql.append("                              WHEN matBom.FValidateDate IS NOT NULL  \n");
            kSql.append("                                   AND bomEntry.FEffectiveDate IS NOT NULL \n");
            kSql.append("                                   AND bomEntry.FDisableDate IS NOT NULL \n");
            kSql.append("                                   AND (matBom.FValidateDate > bomEntry.FDisableDate \n");
            kSql.append("                                         OR matBom.FValidateDate < bomEntry.FEffectiveDate \n");
            kSql.append("                                        ) \n");
            kSql.append("                                 THEN 0 \n");
            kSql.append("                              ELSE rollMat.FChildQty \n");
            kSql.append("                            END AS FChildQty \n");
            kSql.append("                     FROM   " + this.T_NCM_STDCostRollUpMat + " rollMat \n");
            kSql.append("                            INNER JOIN " + this.T_NCM_STDCostBomPath + " bomPath \n");
            kSql.append("                              ON rollMat.FParentMaterialID = bomPath.FParentMaterialID \n");
            kSql.append("                                 AND rollMat.FMaterialID = bomPath.FMaterialID \n");
            kSql.append(" \t\t \t\t\t              AND rollMat.FSpreadPath = bomPath.FBomPath \n");
            kSql.append("                            INNER JOIN ").append(this.bomTbl).append(" bomEntry \n");
            kSql.append("                              ON bomEntry.FStorageOrgUnitID = rollMat.FStorageOrgUnitID \n");
            kSql.append("                                 AND bomEntry.FParentMaterialID = rollMat.FparentMaterialID \n");
            kSql.append("                                 AND bomEntry.FMaterialID = rollMat.FMaterialID \n");
            kSql.append("                            INNER JOIN T_NCM_STDCostMaterialBom matBom \n");
            kSql.append("                              ON matBom.FParentMaterialID = bomPath.FParentMaterialID \n");
            kSql.append("\t\t\t\t\t\t\t INNER JOIN T_BD_Material childMat \n");
            kSql.append("  \t\t\t\t\t  \t\t   ON rollMat.FMaterialID = childMat.FID \n");
            kSql.append("                     WHERE  rollMat.FEstimateType = 2 \n");
            kSql.append("                            AND rollMat.FLowLevelCode = " + rank + " \n");
            kSql.append("                            AND rollMat.fid = " + this.T_NCM_STDCostRollUpMat + ".fid \n");
            kSql.append("                            AND matBom.FEstimateSchemeID = '" + this.calcParam.getMatBOMSchemeID() + "' \n");
            kSql.append("                     ) \n");
            kSql.append(" WHERE  FEstimateType = 2 \n");
            kSql.append("        AND FLowLevelCode = " + rank + " \n");
            kSql.setLength(0);
            kSql.append("UPDATE " + this.T_NCM_STDCostRollUpMat + " \n");
            kSql.append("set (FChildAmount) = ( \n");
            kSql.append("    select  \n");
            kSql.append("         ROUND( \n");
            kSql.append("             ISNULL(FChildQty,0) * ISNULL(FChildStdPrice,0), isnull(m.FPricePrecision, 2) \n");
            kSql.append("         ) \n");
            kSql.append("    from T_BD_Material m \n");
            kSql.append("    where m.FID = " + this.T_NCM_STDCostRollUpMat + ".FMaterialID \n");
            kSql.append(") \n");
            kSql.append(" WHERE  FEstimateType = 2 \n");
            kSql.append(" AND FLowLevelCode = " + rank + " \n");
            NCMDbUtil.execute((Context)this.ctx, (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" UPDATE " + this.T_NCM_STDCostRollUpRes + " \n");
            kSql.append(" SET FStdPrice = (SELECT ISNULL(" + this.T_NCM_STDCostRollUpRes + ".FStdPrice,0) + ISNULL(rollMat.sumChildAmount,0) \n");
            kSql.append("                            FROM   (SELECT FParentMaterialID AS FParentMaterialID, \n");
            kSql.append("                                           SUM(ISNULL(FChildAmount,0)) AS sumChildAmount \n");
            kSql.append("                                    FROM   (SELECT  DISTINCT FParentMaterialID, \n");
            kSql.append("                                                             FMaterialID, \n");
            kSql.append("                                                             FChildAmount \n");
            kSql.append("                                              FROM " + this.T_NCM_STDCostRollUpMat + " \n");
            kSql.append("                                             WHERE FLowLevelCode = " + rank + ") rollMats\n");
            kSql.append("                                    GROUP BY rollMats.FParentMaterialID) rollMat \n");
            kSql.append("                       WHERE  rollMat.FParentMaterialID = " + this.T_NCM_STDCostRollUpRes + ".FParentMaterialID) \n");
            kSql.append(" WHERE  EXISTS (SELECT 1 \n");
            kSql.append("                FROM   " + this.T_NCM_STDCostRollUpMat + " \n");
            kSql.append("                WHERE  FParentMaterialID = " + this.T_NCM_STDCostRollUpRes + ".FParentMaterialID \n");
            kSql.append("                  AND  FLowLevelCode = " + rank + ") \n");
            NCMDbUtil.execute((Context)this.ctx, (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" UPDATE " + this.T_NCM_STDCostRollUpMat + " \n");
            kSql.append(" SET    FStdPrice = (SELECT ISNULL(FStdPrice,0) \n");
            kSql.append("                     FROM   (SELECT DISTINCT FStorageOrgUnitID,\n");
            kSql.append("                                             FEstimateSchemeID,\n");
            kSql.append("                                             FParentMaterialID,\n");
            kSql.append("                                             FStdPrice\n");
            kSql.append("                               FROM  " + this.T_NCM_STDCostRollUpRes + ") rollRes \n");
            kSql.append("                     WHERE  rollRes.FStorageOrgUnitID = " + this.T_NCM_STDCostRollUpMat + ".FStorageOrgUnitID \n");
            kSql.append("                            AND rollRes.FEstimateSchemeID = " + this.T_NCM_STDCostRollUpMat + ".FEstimateSchemeID \n");
            kSql.append("                            AND rollRes.FParentMaterialID = " + this.T_NCM_STDCostRollUpMat + ".FParentMaterialID) \n");
            kSql.append(" WHERE  FLowLevelCode = " + rank + " \n");
            kSql.append("        AND FEstimateType = 2 \n");
            kSql.append("        AND EXISTS (SELECT 1 \n");
            kSql.append("                    FROM   " + this.T_NCM_STDCostRollUpRes + " \n");
            kSql.append("                    WHERE  FStorageOrgUnitID = " + this.T_NCM_STDCostRollUpMat + ".FStorageOrgUnitID \n");
            kSql.append("                           AND FEstimateSchemeID = " + this.T_NCM_STDCostRollUpMat + ".FEstimateSchemeID \n");
            kSql.append("                           AND FParentMaterialID = " + this.T_NCM_STDCostRollUpMat + ".FParentMaterialID) \n");
            NCMDbUtil.execute((Context)this.ctx, (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" UPDATE " + this.T_NCM_STDCostRollUpMat + " \n");
            kSql.append(" SET    FStdPrice = (SELECT sumChildAmount \n");
            kSql.append("                     FROM   (SELECT   FParentMaterialID AS FParentMaterialID, \n");
            kSql.append("                                      SUM(ISNULL(FChildAmount,0)) AS sumChildAmount \n");
            kSql.append("                             FROM     (SELECT DISTINCT FParentMaterialID,\n");
            kSql.append("                                                       FMaterialID, \n");
            kSql.append("                                                       FChildAmount \n");
            kSql.append("                                         FROM " + this.T_NCM_STDCostRollUpMat + " \n");
            kSql.append("                                        WHERE FLowLevelCode = " + rank + " ) rollMats \n");
            kSql.append("                             GROUP BY rollMats.FParentMaterialID) rollMat \n");
            kSql.append("                     WHERE  rollMat.FParentMaterialID = " + this.T_NCM_STDCostRollUpMat + ".FParentMaterialID) \n");
            kSql.append(" WHERE  FLowLevelCode = " + rank + " \n");
            kSql.append("        AND FEstimateType = 2 \n");
            kSql.append("        AND NOT EXISTS (SELECT 1 \n");
            kSql.append("                    \t   FROM   " + this.T_NCM_STDCostRollUpRes + " res \n");
            kSql.append("                    \t  WHERE res.FStorageOrgUnitID = " + this.T_NCM_STDCostRollUpMat + ".FStorageOrgUnitID \n");
            kSql.append("                           AND res.FEstimateSchemeID = " + this.T_NCM_STDCostRollUpMat + ".FEstimateSchemeID \n");
            kSql.append("                           AND res.FParentMaterialID = " + this.T_NCM_STDCostRollUpMat + ".FParentMaterialID) \n");
            NCMDbUtil.execute((Context)this.ctx, (String)kSql.toString());
            if (isOnlyForOnStdCost) {
                kSql.setLength(0);
                kSql.append(" UPDATE " + this.T_NCM_STDCostRollUpMat + " \n");
                kSql.append(" SET    FStdPrice = (SELECT FStdAmount \n");
                kSql.append("                       FROM T_NCM_StdCostData costData \n");
                kSql.append("                      WHERE costData.FEstimateSchemeID = " + this.T_NCM_STDCostRollUpMat + ".FEstimateSchemeID \n");
                kSql.append("                        AND costData.FMaterialID = " + this.T_NCM_STDCostRollUpMat + ".FParentMaterialID) \n");
                kSql.append(" WHERE  FLowLevelCode = " + rank + " \n");
                kSql.append("        AND FEstimateType = 2 \n");
                kSql.append("        AND EXISTS (SELECT 1 \n");
                kSql.append("                    \t   FROM T_NCM_STDCostData costData \n");
                kSql.append("                         WHERE costData.FEstimateSchemeID = " + this.T_NCM_STDCostRollUpMat + ".FEstimateSchemeID \n");
                kSql.append("                           AND costData.FMaterialID = " + this.T_NCM_STDCostRollUpMat + ".FParentMaterialID \n");
                kSql.append("                           AND costData.FStdAmount IS NOT NULL) \n");
                NCMDbUtil.execute((Context)this.ctx, (String)kSql.toString());
            }
            kSql.setLength(0);
            kSql.append(" UPDATE " + this.T_NCM_STDCostRollUpMat + " \n");
            kSql.append(" SET    FChildStdPrice = (SELECT DISTINCT ISNULL(rollMat.FSTDPrice,0) \n");
            kSql.append("                          FROM   " + this.T_NCM_STDCostRollUpMat + " rollMat\n");
            kSql.append("                          WHERE  rollMat.FLowLevelCode = " + rank + " \n");
            kSql.append("                                 AND rollMat.FParentMaterialID = " + this.T_NCM_STDCostRollUpMat + ".FMaterialID) \n");
            kSql.append(" WHERE  FEstimateType = 2 \n");
            kSql.append("        AND EXISTS (SELECT 1 \n");
            kSql.append("                    FROM   " + this.T_NCM_STDCostRollUpMat + " rollMat\n");
            kSql.append("                    WHERE  rollMat.FParentMaterialID = " + this.T_NCM_STDCostRollUpMat + ".FMaterialID \n");
            kSql.append("                           AND rollMat.FLowLevelCode = " + rank + ") \n");
            NCMDbUtil.execute((Context)this.ctx, (String)kSql.toString());
        }
        catch (Exception exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        return this.calcResult;
    }
}

