/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.perflog;

import com.kingdee.eas.perflog.IMonitor;
import com.kingdee.eas.perflog.IMonitorListener;
import com.kingdee.eas.perflog.PerfExceptionLogger;
import java.util.HashMap;
import java.util.Map;

public class PerfMonitorFactory {
    private static Map<String, IMonitor> monitorMap = new HashMap<String, IMonitor>();

    public static IMonitor getMonitorInstance(String monitorClass) {
        IMonitor monitor = monitorMap.get(monitorClass);
        if (monitor == null) {
            try {
                Class<?> tmpClass = Class.forName(monitorClass);
                monitor = (IMonitor)tmpClass.newInstance();
                monitorMap.put(monitorClass, monitor);
            }
            catch (Exception ex) {
                PerfExceptionLogger.error(ex);
            }
        }
        return monitor;
    }

    public static void setMonitorInstance(String monitorClass, IMonitor monitor) {
        monitorMap.put(monitorClass, monitor);
    }

    public static void addListener(String monitorClass, IMonitorListener listener) {
        IMonitor monitor = PerfMonitorFactory.getMonitorInstance(monitorClass);
        if (monitor != null) {
            monitor.addListener(listener);
        }
    }

    public static void removeListener(String monitorClass, IMonitorListener listener) {
        IMonitor monitor = PerfMonitorFactory.getMonitorInstance(monitorClass);
        if (monitor != null) {
            monitor.removeListener(listener);
        }
    }
}

