/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.perflog.app.log.perfdump;

import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.perflog.AbstractPerfLog;
import com.kingdee.eas.perflog.IMonitorEvent;
import com.kingdee.eas.perflog.PerfBean;
import com.kingdee.eas.perflog.RpcEvent;
import com.kingdee.eas.perflog.app.log.PerfLogConfig;
import com.kingdee.eas.perflog.app.log.perfdump.PerfDumpLogMBean;
import com.kingdee.eas.perflog.app.monitor.http.HttpEvent;
import com.kingdee.eas.perflog.app.monitor.workflow.WorkflowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;

public class PerfDumpLog
extends AbstractPerfLog
implements PerfDumpLogMBean {
    private Map<Long, PerfBean> perfMap = new ConcurrentHashMap<Long, PerfBean>();
    private ArrayBlockingQueue<HashMap> perfQueue = new ArrayBlockingQueue(1000);
    private long[] rpcPerf = new long[]{0L, 0L, 0L, 0L};

    public PerfDumpLog() {
        this.setConfig(PerfLogConfig.getInstance());
        this.setMonitorSet("httpmonitor;rpcmonitor");
    }

    @Override
    public void setValid(boolean valid) {
        if (this.isValid() == valid) {
            return;
        }
        this.perfMap.clear();
        this.perfQueue.clear();
        Arrays.fill((long[])this.rpcPerf, (long)0L);
        super.setValid(valid);
    }

    @Override
    public void monitorEventStart(IMonitorEvent event) {
        if (event instanceof HttpEvent) {
            this.startHttp((HttpEvent)event);
        } else if (event instanceof RpcEvent) {
            this.startRpc((RpcEvent)event);
        } else if (event instanceof WorkflowEvent) {
            this.startWorkflow((WorkflowEvent)event);
        }
    }

    @Override
    public void monitorEventEnd(IMonitorEvent event) {
        if (event instanceof HttpEvent) {
            this.endHttp((HttpEvent)event);
        } else if (event instanceof RpcEvent) {
            this.endRpc((RpcEvent)event);
        } else if (event instanceof WorkflowEvent) {
            this.endWorkflow((WorkflowEvent)event);
        }
    }

    @Override
    public void monitorEventPerformed(IMonitorEvent event) {
    }

    @Override
    protected void startTransaction(PerfBean transact) {
        PerfBean head = transact;
        long id = Thread.currentThread().getId();
        this.perfMap.put(id, head);
        super.startTransaction(transact);
    }

    private void startHttp(HttpEvent event) {
        PerfBean head = new PerfBean();
        head.name = event.url;
        head.id = event.id;
        this.startTransaction(head);
    }

    private void startWorkflow(WorkflowEvent event) {
        PerfBean head = new PerfBean();
        head.name = event.operation;
        head.id = event.id;
        this.startTransaction(head);
    }

    private void startRpc(RpcEvent event) {
        PerfBean head = new PerfBean();
        head.name = event.remoteInterface + "." + event.method;
        head.id = event.id;
        this.startTransaction(head);
    }

    protected void endTransaction(PerfBean invoke) {
        super.endTransaction();
        if (invoke.isFilter) {
            return;
        }
        long actionTime = invoke.timespan;
        if (actionTime < 1000L) {
            this.rpcPerf[0] = this.rpcPerf[0] + 1L;
        } else if (actionTime >= 1000L && actionTime < 5000L) {
            this.rpcPerf[1] = this.rpcPerf[1] + 1L;
        } else if (actionTime >= 5000L && actionTime < 10000L) {
            this.rpcPerf[2] = this.rpcPerf[2] + 1L;
        } else {
            this.rpcPerf[3] = this.rpcPerf[3] + 1L;
        }
        if (this.isLog()) {
            this.perfQueue.offer(invoke.toMap());
        }
    }

    private void endHttp(HttpEvent event) {
        PerfBean invoke = (PerfBean)this.transaction.get();
        if (invoke == null) {
            return;
        }
        long id = Thread.currentThread().getId();
        this.perfMap.remove(id);
        invoke.reqBytes = event.reqBytes;
        invoke.resBytes = event.resBytes;
        invoke.dc = event.dc;
        invoke.easUser = event.user;
        invoke.ou = event.ou;
        this.endTransaction(invoke);
    }

    private void endRpc(RpcEvent event) {
        PerfBean invoke = (PerfBean)this.transaction.get();
        if (invoke == null) {
            return;
        }
        long id = Thread.currentThread().getId();
        this.perfMap.remove(id);
        invoke.name = event.remoteInterface + "." + event.method;
        invoke.reqBytes = event.requestBytes;
        invoke.resBytes = event.responseBytes;
        invoke.dc = event.dc;
        invoke.easUser = event.user;
        invoke.ou = event.ou;
        this.endTransaction(invoke);
    }

    private void endWorkflow(WorkflowEvent event) {
        PerfBean head = (PerfBean)this.transaction.get();
        if (head == null) {
            return;
        }
        long id = Thread.currentThread().getId();
        this.perfMap.remove(id);
        head.name = event.operation;
        head.instanceNumber = event.instanceNumber;
        head.procName = event.procName;
        super.endTransaction();
    }

    public synchronized List<PerfBean> getRunningTransactionList() {
        if (!this.isValid()) {
            return null;
        }
        ArrayList<PerfBean> list = new ArrayList<PerfBean>();
        for (Long key : this.perfMap.keySet()) {
            PerfBean head = this.perfMap.get(key);
            if (head == null) continue;
            PerfBean tmpHead = new PerfBean();
            tmpHead.timespan = System.currentTimeMillis() - head.startTime.getTime();
            tmpHead.id = head.id;
            tmpHead.name = head.name;
            tmpHead.startTime = head.startTime;
            tmpHead.thread = head.thread;
            list.add(tmpHead);
        }
        return list;
    }

    @Override
    public long[] getPerfGroup() {
        return this.rpcPerf;
    }

    @Override
    public Collection<HashMap> getPerfQueue() {
        ArrayList<HashMap> c = new ArrayList<HashMap>();
        this.perfQueue.drainTo(c);
        return c;
    }
}

