/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.perflog.app.monitor.http;

import com.kingdee.bos.Context;
import com.kingdee.bos.rpc.ThreadListenerManager;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.perflog.AbstractProbe;
import com.kingdee.eas.perflog.PerfExceptionLogger;
import com.kingdee.eas.perflog.app.monitor.http.HttpEvent;
import com.kingdee.eas.perflog.app.monitor.http.HttpMonitor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpFilter
extends AbstractProbe
implements Filter {
    @Override
    protected String getMonitorClass() {
        return HttpMonitor.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletrequest, ServletResponse servletresponse, FilterChain filterchain) throws IOException, ServletException {
        ThreadListenerManager.fireFinishedEvent((Thread)Thread.currentThread());
        if (!this.isValid()) {
            filterchain.doFilter(servletrequest, servletresponse);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)servletrequest;
        HttpServletResponse res = (HttpServletResponse)servletresponse;
        HttpEvent event = new HttpEvent();
        event.url = req.getRequestURL().toString();
        String urlEnd = event.url.substring(event.url.lastIndexOf("/"));
        HttpMonitor monitor = (HttpMonitor)this.getMonitor();
        Set<String> urlSet = monitor.getFilterURLSet();
        if (urlSet.contains(urlEnd)) {
            filterchain.doFilter(servletrequest, servletresponse);
            return;
        }
        HttpEvent httpEvent = event;
        httpEvent.reqBytes = httpEvent.reqBytes + (long)event.url.length();
        StringBuffer sb = new StringBuffer();
        Enumeration nameEnum = req.getParameterNames();
        while (nameEnum.hasMoreElements()) {
            String key = nameEnum.nextElement().toString();
            String value = req.getParameter(key);
            HttpEvent httpEvent2 = event;
            Long.valueOf(httpEvent2.reqBytes + (long)(key.length() + value.length() + 2));
            httpEvent2.reqBytes = httpEvent2.reqBytes;
            if ("javax.faces.ViewState".equals(key)) {
                value = value.length() + "bytes";
            }
            sb.append(key);
            sb.append("=");
            sb.append(value);
            sb.append(";");
        }
        String paramStr = sb.toString();
        if (paramStr != null && !paramStr.trim().equals("")) {
            event.param = paramStr;
        }
        try {
            this.eventStart(event);
            filterchain.doFilter(servletrequest, servletresponse);
        }
        finally {
            this.getBytes(event, req, res);
            Context context = WebContextUtil.getEasContext((HttpServletRequest)req);
            if (context != null) {
                event.dc = context.getAIS();
                event.user = context.getUserName();
                OrgUnitInfo orgUnit = (OrgUnitInfo)context.get((Object)"CurOU");
                if (orgUnit != null) {
                    event.ou = orgUnit.getNumber();
                }
            }
            this.eventEnd(event);
        }
    }

    private void getBytes(HttpEvent event, HttpServletRequest req, HttpServletResponse res) {
        if ("com.apusic.web.container.Request".equals(req.getClass().getName())) {
            Number bytesRead = (Number)this.getValueByFieldPath(req, "stream.bytesRead");
            HttpEvent httpEvent = event;
            httpEvent.reqBytes = httpEvent.reqBytes + (bytesRead == null ? 0L : bytesRead.longValue());
            Number bytesWritten = (Number)this.getValueByFieldPath(res, "out.bytesWritten");
            event.resBytes = bytesWritten == null ? 0L : bytesWritten.longValue();
        }
    }

    private Object getValueByFieldPath(Object object, String path) {
        Object re = null;
        Object tmpObject = object;
        Class<?> tmpClass = object.getClass();
        Field tmpField = null;
        StringTokenizer token = new StringTokenizer(path, ".");
        try {
            while (token.hasMoreTokens()) {
                String fieldName = token.nextToken();
                if ("super".equals(fieldName)) {
                    if ((tmpClass = tmpClass.getSuperclass()) != null) continue;
                } else {
                    tmpField = tmpClass.getDeclaredField(fieldName);
                    if (tmpField != null) {
                        tmpField.setAccessible(true);
                        tmpObject = tmpField.get(tmpObject);
                        if (tmpObject != null) {
                            tmpClass = tmpObject.getClass();
                            continue;
                        }
                    }
                }
                break;
            }
        }
        catch (Exception ex) {
            PerfExceptionLogger.error(ex);
        }
        re = tmpObject;
        return re;
    }

    public void init(FilterConfig filterconfig) throws ServletException {
    }

    public void destroy() {
    }
}

