/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.perflog.app.monitor.rpc;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.ISessionManager;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.rpc.performance.InvokeMonitor;
import com.kingdee.bos.rpc.performance.InvokeRecord;
import com.kingdee.bos.rpcwrapper.IServerSession;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.rpcwrapper.ServerSessionContainer;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.perflog.AbstractMonitor;
import com.kingdee.eas.perflog.PerfExceptionLogger;
import com.kingdee.eas.perflog.RpcEvent;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class RpcMonitor
extends AbstractMonitor {
    private InnerRpcMonitor rpcMonitor;
    private Set<String> filterNameSet = new HashSet<String>();
    private Map<String, int[]> paramValueMap = new HashMap<String, int[]>();
    ISessionManager sessionManager = SessionManager.getInstance();

    public RpcMonitor() {
        this.rpcMonitor = new InnerRpcMonitor();
        this.rpcMonitor.recordInvokeStart(true);
        RPCEngineFactory.addInvokeMonitor((InvokeMonitor)this.rpcMonitor);
        String tmpStr = "com.kingdee.eas.base.message.IMessageCenter.receiveTempMsg;com.kingdee.eas.base.message.IMessageCenter.getMessageCenterCounts;com.kingdee.eas.base.message.IMessageCenter.getRsBysql;com.kingdee.eas.base.message.IMessageCenter.getHighWarnIDList;com.kingdee.eas.base.message.IMessageCenter.getSameKindTaskMsg;com.kingdee.eas.base.usermonitor.IUserMonitor.update";
        StringTokenizer token = new StringTokenizer(tmpStr, ";");
        while (token.hasMoreTokens()) {
            this.filterNameSet.add(token.nextToken());
        }
        tmpStr = "com.kingdee.bos.dao.query.server.IVirtualModeDataAccess.doAllQueryTask,3;com.kingdee.bos.dao.query.server.IVirtualModeDataAccess.getRowSet,1;com.kingdee.bos.dao.query.server.IQueryDataAccess.getRowSet,0;com.kingdee.bos.dao.query.server.IQueryDataAccess.getQuerySql,0;com.kingdee.eas.scm.common.action.IBatchExecutor.execute,0;";
        token = new StringTokenizer(tmpStr, ";");
        while (token.hasMoreTokens()) {
            String[] strVec = token.nextToken().split(",");
            if (strVec.length < 2) continue;
            String invokeName = strVec[0];
            int[] paramIndexVec = new int[strVec.length - 1];
            for (int i = 0; i < paramIndexVec.length; ++i) {
                paramIndexVec[i] = Integer.parseInt(strVec[i + 1]);
            }
            this.paramValueMap.put(invokeName, paramIndexVec);
        }
    }

    public String getFilterNameSet() {
        StringBuffer sb = new StringBuffer();
        Iterator<String> iter = this.filterNameSet.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            sb.append(";");
        }
        return sb.toString();
    }

    public void setFilterNameSet(String tmpStr) {
        this.filterNameSet.clear();
        if (tmpStr != null && !tmpStr.trim().equals("")) {
            StringTokenizer token = new StringTokenizer(tmpStr, ";");
            while (token.hasMoreTokens()) {
                this.filterNameSet.add(token.nextToken());
            }
        }
    }

    public String getParamValueMap() {
        StringBuffer sb = new StringBuffer();
        for (String key : this.paramValueMap.keySet()) {
            sb.append(key);
            sb.append(",");
            int[] value = this.paramValueMap.get(key);
            for (int i = 0; i < value.length; ++i) {
                sb.append(value[i]);
                if (i >= value.length - 1) continue;
                sb.append(",");
            }
            sb.append(";");
        }
        return sb.toString();
    }

    public void setParamValueMap(String tmpStr) {
        this.paramValueMap.clear();
        if (tmpStr != null && !tmpStr.trim().equals("")) {
            StringTokenizer token = new StringTokenizer(tmpStr, ";");
            while (token.hasMoreTokens()) {
                String[] strVec = token.nextToken().split(",");
                if (strVec.length < 2) continue;
                String invokeName = strVec[0];
                int[] paramIndexVec = new int[strVec.length - 1];
                for (int i = 0; i < paramIndexVec.length; ++i) {
                    paramIndexVec[i] = Integer.parseInt(strVec[i + 1]);
                }
                this.paramValueMap.put(invokeName, paramIndexVec);
            }
        }
    }

    public class InnerRpcMonitor
    extends InvokeMonitor {
        public InnerRpcMonitor() {
            this(false, true);
        }

        protected InnerRpcMonitor(boolean client, boolean server) {
            super(client, server);
        }

        public void invokePerformed(InvokeRecord rec) {
            Context context;
            SessionInfo bosSession;
            String sessionID;
            if (!RpcMonitor.this.isValid() || rec == null || rec.command != 0 || rec.detail == null || !(rec.detail instanceof InvokeRecord.MethodInvoke)) {
                return;
            }
            InvokeRecord.MethodInvoke invokeInfo = (InvokeRecord.MethodInvoke)rec.detail;
            String methodName = "unknown";
            if (invokeInfo.model != null && invokeInfo.method != null) {
                methodName = invokeInfo.model.getName() + "." + invokeInfo.method.getName();
            } else if (invokeInfo.method != null) {
                methodName = invokeInfo.method.getDeclaringClass().getName() + "." + invokeInfo.method.getName();
            }
            if (RpcMonitor.this.filterNameSet.contains(methodName)) {
                return;
            }
            RpcEvent re = new RpcEvent();
            this.getMethodInfo(re, invokeInfo);
            re.invokeId = invokeInfo.invokeId;
            re.requestBytes = rec.requestAcutalBytes;
            re.responseBytes = rec.responseActualBytes;
            re.startTime = rec.finishRequestTime;
            re.timespan = rec.startResponseTime - rec.finishRequestTime;
            IServerSession rpcSession = ServerSessionContainer.getCurrentSession();
            if (rpcSession != null && (sessionID = (String)rpcSession.get((Object)"bos_sessionid")) != null && (bosSession = RpcMonitor.this.sessionManager.getSession(sessionID)) != null && (context = bosSession.getContext()) != null) {
                re.dc = context.getAIS();
                re.user = context.getUserName();
                OrgUnitInfo orgUnit = (OrgUnitInfo)context.get((Object)"CurOU");
                if (orgUnit != null) {
                    re.ou = orgUnit.getNumber();
                }
            }
            RpcMonitor.this.eventEnd(re);
        }

        public void invokeStart(String methodStr, InvokeRecord rec) {
            if (!RpcMonitor.this.isValid() || rec == null || rec.command != 0 || rec.detail == null || !(rec.detail instanceof InvokeRecord.MethodInvoke)) {
                return;
            }
            InvokeRecord.MethodInvoke invokeInfo = (InvokeRecord.MethodInvoke)rec.detail;
            String methodName = "unknown";
            if (invokeInfo.model != null && invokeInfo.method != null) {
                methodName = invokeInfo.model.getName() + "." + invokeInfo.method.getName();
            } else if (invokeInfo.method != null) {
                methodName = invokeInfo.method.getDeclaringClass().getName() + "." + invokeInfo.method.getName();
            }
            if (RpcMonitor.this.filterNameSet.contains(methodName)) {
                return;
            }
            RpcEvent re = new RpcEvent();
            this.getMethodInfo(re, invokeInfo);
            re.invokeId = invokeInfo.invokeId;
            RpcMonitor.this.eventStart(re);
        }

        private void getMethodInfo(RpcEvent re, InvokeRecord.MethodInvoke invokeInfo) {
            if (invokeInfo.model != null) {
                re.remoteInterface = invokeInfo.model.getName();
            } else if (invokeInfo.method != null) {
                re.remoteInterface = invokeInfo.method.getDeclaringClass().getName();
            }
            Method method = invokeInfo.method;
            if (method == null) {
                return;
            }
            String methodName = method.getName();
            StringBuffer sb = new StringBuffer(methodName);
            sb.append("(");
            if (RpcMonitor.this.paramValueMap.containsKey(re.remoteInterface + "." + methodName)) {
                int[] paramIndexVec = (int[])RpcMonitor.this.paramValueMap.get(re.remoteInterface + "." + methodName);
                if (paramIndexVec != null) {
                    for (int i = 0; i < paramIndexVec.length; ++i) {
                        int index = paramIndexVec[i];
                        sb.append(invokeInfo.args[index]);
                        if (index >= paramIndexVec.length - 1) continue;
                        sb.append(", ");
                    }
                }
            } else if ("com.kingdee.eas.framework.IServiceHandlerFacade".equals(re.remoteInterface) && "Execute".equals(methodName)) {
                if (invokeInfo.args != null && invokeInfo.args[0] != null) {
                    RequestContext request = (RequestContext)invokeInfo.args[0];
                    try {
                        Map reqMap = request.getParameter();
                        sb.append(reqMap.get("Fw_ClassName"));
                        sb.append(", ");
                        sb.append(reqMap.get("Fw_MethodName"));
                    }
                    catch (Exception ex) {
                        PerfExceptionLogger.error(ex);
                    }
                }
            } else if ("com.kingdee.eas.base.btp.IBTPManager".equals(re.remoteInterface) && "saveRelations".equals(methodName)) {
                if (invokeInfo.args != null && invokeInfo.args[0] != null) {
                    sb.append(invokeInfo.args[0].getClass().getName());
                }
            } else if ("com.kingdee.eas.base.btp.IBTPManager".equals(re.remoteInterface) && "submitRelations".equals(methodName)) {
                if (invokeInfo.args != null && invokeInfo.args[0] != null) {
                    sb.append(invokeInfo.args[0].getClass().getName());
                }
            } else {
                Class<?>[] params = method.getParameterTypes();
                for (int i = 0; i < params.length; ++i) {
                    sb.append(params[i].getSimpleName());
                    if (i >= params.length - 1) continue;
                    sb.append(", ");
                }
            }
            sb.append(") ");
            sb.append(method.getReturnType().getSimpleName());
            re.method = sb.toString();
        }
    }
}

