/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.org.QualityOrgUnitFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.QCGroupFactory;
import com.kingdee.eas.qm.basedata.QCInstrumentFactory;
import com.kingdee.eas.qm.basedata.QCInstrumentGroupFactory;
import com.kingdee.eas.qm.basedata.QCInstrumentInfo;
import com.kingdee.eas.qm.basedata.QCSamplingProgramFactory;
import com.kingdee.eas.qm.basedata.QCSamplingProgramInfo;
import com.kingdee.eas.qm.basedata.QCStandardExtValueTypeEnum;
import com.kingdee.eas.qm.basedata.QCStandardFactory;
import com.kingdee.eas.qm.basedata.QCStandardInfo;
import com.kingdee.eas.qm.basedata.app.AbstractQCStandardFacadeControllerBean;
import com.kingdee.eas.qm.common.QMTreeBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class QCStandardFacadeControllerBean
extends AbstractQCStandardFacadeControllerBean {
    private static final long serialVersionUID = -2268543628212135066L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.basedata.app.QCStandardFacadeControllerBean");

    @Override
    protected Object _getStandardEntryExtValue(Context ctx, IObjectPK id, IObjectPK entryID, IObjectPK orgID, QCStandardExtValueTypeEnum extValueType) throws BOSException, EASBizException {
        Map dataMap = this._getAllStandardEntryExtValue(ctx, id, entryID, orgID);
        return dataMap.get(extValueType.getValue());
    }

    @Override
    protected Map _getAllStandardEntryExtValue(Context ctx, IObjectPK id, IObjectPK entryID, IObjectPK orgID) throws BOSException, EASBizException {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T1.FDELEGORGUNITID AS DELEGORGID, \n");
        sql.append("T1.FQCGROUPID AS QCGROUPID, \n");
        sql.append("T1.FQCINSTRUMENTGROUPID AS QCINSTRUMENTGROUPID, \n");
        sql.append("T1.FQCINSTRUMENTID AS QCINSTRUMENTID, \n");
        sql.append("T1.FSAMPLEPROGRAMID AS SAMPLEPROGRAMID \n");
        sql.append("FROM T_QM_QCSTANDARDITEMENTRIES T \n");
        sql.append("INNER JOIN T_QM_QCSTANDARDITEMEXTENDATTR T1 \n");
        sql.append("ON T.FID = T1.Fqcstandardentryid \n");
        sql.append("WHERE T1.FQUALITYORGUNITID = '" + orgID.toString() + "' \n");
        sql.append("AND T.FPARENTID = '" + id.toString() + "' \n");
        sql.append("AND T.FID = '" + entryID + "'  \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                QMTreeBaseInfo groupInfo;
                String delegOrgID = rs.getString("DELEGORGID");
                String qcGroupID = rs.getString("QCGROUPID");
                String qcInstrumentGroupID = rs.getString("QCINSTRUMENTGROUPID");
                String qcInstrumentID = rs.getString("QCINSTRUMENTID");
                String sampleProgramID = rs.getString("SAMPLEPROGRAMID");
                if (!StringUtil.isEmptyString((String)delegOrgID)) {
                    QualityOrgUnitInfo delegOrgInfo = QualityOrgUnitFactory.getLocalInstance((Context)ctx).getQualityOrgUnitInfo((IObjectPK)new ObjectStringPK(delegOrgID));
                    dataMap.put("DelegOrgUnit", delegOrgInfo);
                }
                if (!StringUtil.isEmptyString((String)qcGroupID)) {
                    groupInfo = QCGroupFactory.getLocalInstance(ctx).getQCGroupInfo((IObjectPK)new ObjectStringPK(qcGroupID));
                    dataMap.put("QCGroup", groupInfo);
                }
                if (!StringUtil.isEmptyString((String)qcInstrumentGroupID)) {
                    groupInfo = QCInstrumentGroupFactory.getLocalInstance(ctx).getQCInstrumentGroupInfo((IObjectPK)new ObjectStringPK(qcInstrumentGroupID));
                    dataMap.put("QCInstrumentGroup", groupInfo);
                }
                if (!StringUtil.isEmptyString((String)qcInstrumentID)) {
                    QCInstrumentInfo info = QCInstrumentFactory.getLocalInstance(ctx).getQCInstrumentInfo((IObjectPK)new ObjectStringPK(qcInstrumentID));
                    dataMap.put("QCInstrument", info);
                }
                if (!StringUtil.isEmptyString((String)sampleProgramID)) {
                    QCSamplingProgramInfo sampleProgram = QCSamplingProgramFactory.getLocalInstance(ctx).getQCSamplingProgramInfo((IObjectPK)new ObjectUuidPK(sampleProgramID));
                    dataMap.put("SampleProgram", sampleProgram);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return dataMap;
    }

    @Override
    protected QCStandardInfo _getQCStandardToMM(Context ctx, String orgID, String materialID, String productLineID, String productLineWPID) throws BOSException, EASBizException {
        String sql = this.getQCStandardToMMSql(ctx, orgID, materialID, productLineID, productLineWPID);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        QCStandardInfo info = new QCStandardInfo();
        try {
            String id;
            if (rs.next() && !StringUtil.isEmptyString((String)(id = rs.getString("FID")))) {
                info = QCStandardFactory.getLocalInstance(ctx).getQCStandardInfo((IObjectPK)new ObjectStringPK(id));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return info;
    }

    protected String buildGetSqlToMM(Context ctx, String orgID, String filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T1.FID \n");
        sql.append("FROM T_QM_QCSTANDARD T1 \n");
        sql.append("INNER JOIN T_QM_QCBIZBILLTYPE T2  \n");
        sql.append("ON T1.FBILLTYPEID = T2.FID \n");
        sql.append("INNER JOIN T_QM_QCStandardExtendAttr EXT \n");
        sql.append("ON T1.FID = EXT.FParentID AND EXT.FQualityOrgUnitID = '" + orgID + "' \n");
        sql.append("WHERE T1.FID IN ( \n");
        sql.append("SELECT DD.FDATABASEDID \n");
        sql.append("FROM T_QM_DataBaseDAssign DD \n");
        sql.append("INNER JOIN T_QM_QCSTANDARDPLINEENTRY ENTRY \n");
        sql.append("ON DD.FDATABASEDID =ENTRY.FPARENTID \n");
        sql.append("WHERE DD.FBOSOBJECTTYPE = '" + new QCStandardInfo().getBOSType().toString() + "' \n");
        sql.append("AND DD.FASSIGNORGUNITID = '" + orgID + "' \n");
        sql.append("" + filter + " \n");
        sql.append(") \n");
        sql.append("AND EXT.FCHECKEDSTATUS = 2 \n");
        sql.append("AND T1.Fdeletedstatus = 1 \n");
        sql.append("AND T2.FQCBIZTYPE = 20 \n");
        sql.append(" \n");
        return sql.toString();
    }

    @Override
    protected QCStandardInfo _getQCStandardToMM(Context ctx, String orgID, String materialID, String productLineID, String productLineWPID, SelectorItemCollection sic) throws BOSException, EASBizException {
        String sql = this.getQCStandardToMMSql(ctx, orgID, materialID, productLineID, productLineWPID);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        QCStandardInfo info = new QCStandardInfo();
        try {
            String id;
            if (rs.next() && !StringUtil.isEmptyString((String)(id = rs.getString("FID")))) {
                info = QCStandardFactory.getLocalInstance(ctx).getQCStandardInfo((IObjectPK)new ObjectStringPK(id), sic);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return info;
    }

    protected String getQCStandardToMMSql(Context ctx, String orgID, String materialID, String productLineID, String productLineWPID) throws BOSException, EASBizException {
        StringBuffer filter = new StringBuffer();
        filter.append("AND ENTRY.FMATERIALID = '" + materialID + "' \n ");
        filter.append("AND ENTRY.FPRODUCTLINEID = '" + productLineID + "' \n ");
        filter.append("AND ENTRY.FPRODUCTLINEWPID = '" + productLineWPID + "' \n");
        StringBuffer sql = new StringBuffer();
        sql.append(this.buildGetSqlToMM(ctx, orgID, filter.toString()));
        sql.append("UNION ALL \n");
        filter = new StringBuffer();
        filter.append("AND ENTRY.FMATERIALID = '" + materialID + "' \n ");
        filter.append("AND ENTRY.FPRODUCTLINEID = '" + productLineID + "' \n ");
        sql.append(this.buildGetSqlToMM(ctx, orgID, filter.toString()));
        sql.append("UNION ALL \n");
        filter = new StringBuffer();
        filter.append("AND ENTRY.FMATERIALID = '" + materialID + "' \n ");
        sql.append(this.buildGetSqlToMM(ctx, orgID, filter.toString()));
        logger.debug((Object)sql.toString());
        return sql.toString();
    }
}

