/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.IQCStandard;
import com.kingdee.eas.qm.basedata.QCItemFactory;
import com.kingdee.eas.qm.basedata.QCStandardException;
import com.kingdee.eas.qm.basedata.QCStandardFactory;
import com.kingdee.eas.qm.basedata.QCStandardInfo;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.common.app.QMDataBaseDNewImpl;
import com.kingdee.eas.qm.common.util.QMSelectorUtils;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class QCStandardNewImpl
extends QMDataBaseDNewImpl {
    private final Logger logger = Logger.getLogger(QCStandardNewImpl.class);
    private static final String resourceDir = "com.kingdee.eas.qm.basedata.BASEDATAAutoGenerateResource";

    protected void beforeBatchAssign(Context ctx, String tempTblName, String orgUnitID) throws BOSException, EASBizException {
        this.checkBeforeQCItemCanAssign(ctx, orgUnitID, tempTblName, true);
        String sql = this.buildExtSql(true, tempTblName, orgUnitID);
        this.logger.debug((Object)("ext add sql >>" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        sql = this.buildEntryExtSql(true, tempTblName, orgUnitID);
        this.logger.debug((Object)("entry ext add sql >>" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        this.checkBeforeMaterialAssign(ctx, tempTblName, true, orgUnitID);
        sql = "Select ID from " + tempTblName + " ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        Connection conn = null;
        Statement st = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            while (rs.next()) {
                String tempID = rs.getString("ID");
                st.addBatch(this.buildAssignMaterialSql(ctx, tempID, orgUnitID));
            }
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    protected void beforeBatchAssign(Context ctx, String[] data, String assignedOrgUnits) throws BOSException, EASBizException {
        StringBuffer ids = new StringBuffer();
        ids.append("('X'");
        for (int i = 0; data != null && i < data.length; ++i) {
            ids.append(",'" + data[i] + "'");
        }
        ids.append(")");
        this.checkBeforeQCItemCanAssign(ctx, assignedOrgUnits, ids.toString(), false);
        String sql = this.buildExtSql(false, ids.toString(), assignedOrgUnits);
        this.logger.debug((Object)("ext add sql >>" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        sql = this.buildEntryExtSql(false, ids.toString(), assignedOrgUnits);
        this.logger.debug((Object)("entry ext add sql >>" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        this.checkBeforeMaterialAssign(ctx, ids.toString(), false, assignedOrgUnits);
        Connection conn = null;
        Statement st = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            for (int i = 0; data != null && i < data.length; ++i) {
                String tempID = data[i];
                st.addBatch(this.buildAssignMaterialSql(ctx, tempID, assignedOrgUnits));
            }
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    protected void checkBeforeQCItemCanAssign(Context ctx, String orgID, String filter, boolean isAllBatch) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct tt.fqcitemid as QCITEMID  ");
        sql.append("from t_qm_qcstandarditementries tt ");
        if (isAllBatch) {
            sql.append("where tt.fparentid in (select id from " + filter + ") ");
        } else {
            sql.append("where tt.fparentid in " + filter + " ");
        }
        sql.append("and tt.fqcitemid not in( ");
        sql.append("select bb.fdatabasedid ");
        sql.append("from t_qm_databasedassign bb ");
        sql.append("where bb.fassignorgunitid = '" + orgID + "' ");
        sql.append("and bb.fbosobjecttype ='A0346138' )");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String[] idDatas = new String[rs.size()];
        int index = 0;
        try {
            while (rs.next()) {
                String itemID;
                idDatas[index] = itemID = rs.getString("QCITEMID");
                ++index;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (idDatas.length > 0) {
            QCItemFactory.getLocalInstance(ctx).batchAssign(null, false, null, idDatas, new String[]{orgID});
        }
    }

    private void checkBeforeSampleProgramCanAssign(Context ctx, String orgID, String filter, boolean isAllBatch) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct tt.fqcitemid as QCITEMID  ");
        sql.append("from T_QM_QCStandardItemExtendAttr tt ");
        if (isAllBatch) {
            sql.append("where tt.fparentid in (select id from " + filter + ") ");
        } else {
            sql.append("where tt.fparentid in " + filter + " ");
        }
        sql.append("and tt.fqcitemid not in( ");
        sql.append("select bb.fdatabasedid ");
        sql.append("from t_qm_databasedassign bb ");
        sql.append("where bb.fassignorgunitid = '" + orgID + "' ");
        sql.append("and bb.fbosobjecttype ='A0346138' )");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String[] idDatas = new String[rs.size()];
        int index = 0;
        try {
            while (rs.next()) {
                String itemID;
                idDatas[index] = itemID = rs.getString("QCITEMID");
                ++index;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (idDatas.length > 0) {
            QCItemFactory.getLocalInstance(ctx).batchAssign(null, false, null, idDatas, new String[]{orgID});
        }
    }

    protected void checkBeforeMaterialAssign(Context ctx, String tempIds, boolean isTempTable, String orgID) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String[])new String[]{"id", "number", "name", "CU", "CU.id", "CU.number", "CU.name"});
        QualityOrgUnitInfo orgInfo = QualityOrgUnitFactory.getLocalInstance((Context)ctx).getQualityOrgUnitInfo((IObjectPK)new ObjectStringPK(orgID), sic);
        String cuid = orgInfo.getCU().getId().toString();
        StringBuffer checkSql = new StringBuffer();
        checkSql.append("select distinct  cc.fid,cc.fnumber,cc.fname_l2 as fname,bb.fdatabasedid  ");
        checkSql.append("from t_qm_qcstandardmaterialentries aa ");
        checkSql.append("left join t_bd_databasedassign bb ");
        checkSql.append("on aa.fmaterialid = bb.fdatabasedid  ");
        checkSql.append("and bb.fassigncuid = '" + cuid + "' ");
        checkSql.append("left join t_bd_material cc ");
        checkSql.append("on aa.fmaterialid = cc.fid ");
        if (isTempTable) {
            checkSql.append("where aa.fparentid in (SELECT ID FROM " + tempIds + ") ");
        } else {
            checkSql.append("where aa.fparentid in " + tempIds + " ");
        }
        checkSql.append("and aa.fmaterialid is not null ");
        checkSql.append("and bb.fdatabasedid is null ");
        checkSql.append("and cc.fcontrolunitid !='" + cuid + "' ");
        checkSql.append("and aa.fQualityOrgUnitid ='" + orgID + "' ");
        this.logger.debug((Object)checkSql.toString());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        boolean isok = false;
        StringBuffer errorMsg = new StringBuffer();
        String msg = ResourceBase.getString((String)resourceDir, (String)"1_QCStandardNewImpl", (Locale)ctx.getLocale());
        MessageFormat mf = new MessageFormat(msg);
        errorMsg.append(mf.format(new String[]{orgInfo.getName(), orgInfo.getCU().getName()}));
        try {
            while (rs.next()) {
                isok = true;
                String mnumber = rs.getString("fnumber");
                String mname = rs.getString("fname");
                msg = ResourceBase.getString((String)resourceDir, (String)"4_QCStandardNewImpl", (Locale)ctx.getLocale());
                mf = new MessageFormat(msg);
                errorMsg.append(mf.format(new String[]{mnumber, mname}));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (isok) {
            throw new QMException(QMException.BLANK, (Object[])new String[]{errorMsg.toString()});
        }
    }

    protected String buildAssignMaterialSql(Context ctx, String tempID, String orgID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into t_qm_qcstandardmaterialentries  ");
        sql.append("(fid,fseq,fmaterialgroupid,fmaterialid,fsourceallotid, ");
        sql.append("fparentid,fisfreeze,fisallot,fqualityorgunitid) ");
        sql.append("select newbosid('C36D0849'),abc.fseq, ");
        sql.append("abc.fmaterialgroupid,abc.fmaterialid,abc.fid, ");
        sql.append("abc.fparentid,abc.fisfreeze,1,'" + orgID + "' ");
        sql.append(" from t_qm_qcstandardmaterialentries abc ");
        sql.append(" where abc.fparentid = '" + tempID + "' ");
        sql.append(" and abc.fqualityorgunitid='" + this.getCurrentQualityOrgUnit(ctx).getId().toString() + "' ");
        return sql.toString();
    }

    protected String buildExtSql(boolean isAllBatch, String filter, String orgID) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append("T_QM_QCSTANDARDEXTENDATTR ");
        sql.append("(FID,FPARENTID,FSEQ,FCHECKEDSTATUS,FQUALITYORGUNITID,FQCSTRATEGY,FEachSampleQty,FEachSampleUnitID) ");
        sql.append("SELECT NEWBOSID('BC89242D'), T1.FID, 1, 1, '" + orgID + "',T2.FQCSTRATEGY,T2.FEachSampleQty,T2.FEachSampleUnitID ");
        sql.append("FROM T_QM_QCSTANDARD T1 ");
        sql.append(" left join t_qm_qcstandardextendattr T2 on T1.fid = T2.fparentid ");
        if (isAllBatch) {
            sql.append("WHERE T1.FID IN (SELECT ID FROM " + filter + ") ");
        } else {
            sql.append("WHERE T1.FID IN " + filter + " ");
        }
        sql.append("and T2.FQUALITYORGUNITID  = T1.FQUALITYORGUNITID ");
        sql.append("AND T1.FID NOT IN ( ");
        sql.append("SELECT ABC.FPARENTID FROM T_QM_QCSTANDARDEXTENDATTR ABC ");
        sql.append("WHERE ABC.FQUALITYORGUNITID = '" + orgID + "' ");
        if (isAllBatch) {
            sql.append("AND ABC.FPARENTID IN (SELECT ID FROM " + filter + ")  ");
        } else {
            sql.append(" AND ABC.FPARENTID  IN " + filter + " ");
        }
        sql.append(") ");
        return sql.toString();
    }

    protected String buildEntryExtSql(boolean isAllBatch, String filter, String orgID) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append("T_QM_QCSTANDARDITEMEXTENDATTR ");
        sql.append("(FID,FPARENTID,FQCSTANDARDENTRYID,FQUALITYORGUNITID,FSEQ,FQCGroupID,FDelegOrgUnitID,FSampleProgramID) ");
        sql.append(" SELECT newbosid('520A2EA0'),T1.FPARENTID,T1.FID,'" + orgID + "',1,T2.FQCGroupID,T2.FDelegOrgUnitID,T2.FSampleProgramID ");
        sql.append("FROM T_QM_QCSTANDARDITEMENTRIES T1 ");
        sql.append("left join t_qm_qcstandarditemextendattr T2 on T1.fid = T2.FQCSTANDARDENTRYID ");
        if (isAllBatch) {
            sql.append("WHERE T1.FPARENTID IN (SELECT ID FROM " + filter + ") ");
        } else {
            sql.append("WHERE T1.FPARENTID IN " + filter + " ");
        }
        sql.append("and T2.FQUALITYORGUNITID = T1.FQualityOrgUnitID ");
        sql.append("AND T1.FPARENTID NOT IN( ");
        sql.append("SELECT FPARENTID FROM t_qm_qcstandarditemextendattr TTT ");
        sql.append("WHERE TTT.FQUALITYORGUNITID = '" + orgID + "' ");
        if (isAllBatch) {
            sql.append("AND TTT.FPARENTID IN (SELECT ID FROM " + filter + ")  ");
        } else {
            sql.append("AND TTT.FPARENTID IN " + filter + "  ");
        }
        sql.append(") ");
        sql.append(" ");
        return sql.toString();
    }

    protected void _beforeUnBatchAssign(Context ctx, String tempTblName, String orgUnitID) throws BOSException, EASBizException {
        String sql = this.buildDelExtSql(true, tempTblName, orgUnitID);
        this.logger.debug((Object)("ext del sql >>" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        sql = this.buildDelEntryExtSql(true, tempTblName, orgUnitID);
        this.logger.debug((Object)("entry ext del sql >>" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from t_qm_qcstandardmaterialentries  where fparentid in (select id from " + tempTblName + ") and fqualityorgunitid = '" + orgUnitID + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from t_qm_qcstandardtechnicsentries  where fparentid in (select id from " + tempTblName + ") and fqualityorgunitid = '" + orgUnitID + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from t_qm_qcstandardplineentry  where fparentid in (select id from " + tempTblName + ") and fqualityorgunitid = '" + orgUnitID + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from t_qm_qcstandardboentry  where fparentid in (select id from " + tempTblName + ") and fqualityorgunitid = '" + orgUnitID + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        this.checkUnAssign(ctx, tempTblName, null, orgUnitID);
    }

    protected void _beforeUnBatchAssign(Context ctx, String[] data, String orgUnitID) throws BOSException, EASBizException {
        StringBuffer ids = new StringBuffer();
        ids.append("('X'");
        for (int i = 0; data != null && i < data.length; ++i) {
            ids.append(",'" + data[i] + "'");
        }
        ids.append(")");
        String sql = this.buildDelExtSql(false, ids.toString(), orgUnitID);
        this.logger.debug((Object)("ext del sql >>" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        sql = this.buildDelEntryExtSql(false, ids.toString(), orgUnitID);
        this.logger.debug((Object)("entry ext del sql >>" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from t_qm_qcstandardmaterialentries  where fparentid in " + ids.toString() + " and fqualityorgunitid = '" + orgUnitID + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from t_qm_qcstandardtechnicsentries\t where fparentid in " + ids.toString() + " and fqualityorgunitid = '" + orgUnitID + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from t_qm_qcstandardplineentry  where fparentid in " + ids.toString() + " and fqualityorgunitid = '" + orgUnitID + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from t_qm_qcstandardboentry  where fparentid in " + ids.toString() + " and fqualityorgunitid = '" + orgUnitID + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        this.checkUnAssign(ctx, null, data, orgUnitID);
    }

    protected void checkUnAssign(Context ctx, String tempTableName, String[] data, String unRefOrgID) throws BOSException, EASBizException {
        ArrayList<String> pkList = new ArrayList<String>();
        if (tempTableName != null) {
            String sql = "Select ID from " + tempTableName + " ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                while (rs.next()) {
                    String tempID = rs.getString("ID");
                    pkList.add(tempID);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        } else if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                pkList.add(data[i]);
            }
        }
        Iterator it = pkList.iterator();
        IQCStandard ibiz = QCStandardFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("qualityOrgUnit");
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        while (it.hasNext()) {
            String pk = (String)it.next();
            QCStandardInfo info = ibiz.getQCStandardInfo((IObjectPK)new ObjectStringPK(pk), sic);
            try {
                ibiz.isReferenced((IObjectPK)new ObjectStringPK(pk));
            }
            catch (ObjectReferedException refEx) {
                BizReference refObj = (BizReference)refEx.getReferingObject();
                QualityOrgUnitInfo createOrgInfo = info.getQualityOrgUnit();
                boolean isAss = true;
                if (createOrgInfo != null && createOrgInfo.getId().toString().equals(unRefOrgID)) {
                    isAss = false;
                }
                if (isAss) {
                    throw new QCStandardException(QCStandardException.CANNOT_REF_UNASS, new String[]{info.getNumber(), refObj.getRefEntityAlias_L2()});
                }
                throw new QCStandardException(QCStandardException.CANNOT_REF_DEL, new String[]{info.getNumber(), refObj.getRefEntityAlias_L2()});
            }
        }
    }

    protected String buildDelEntryExtSql(boolean isAllBatch, String filter, String orgID) {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM T_QM_QCSTANDARDEXTENDATTR ");
        if (isAllBatch) {
            sql.append("WHERE FPARENTID IN ( ");
            sql.append("SELECT ID FROM " + filter + " ");
            sql.append(") ");
            sql.append("AND FQUALITYORGUNITID = '" + orgID + "' ");
        } else {
            sql.append("WHERE FPARENTID IN " + filter + " ");
            sql.append("AND FQUALITYORGUNITID = '" + orgID + "' ");
        }
        return sql.toString();
    }

    protected String buildDelExtSql(boolean isAllBatch, String filter, String orgID) {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM T_QM_QCSTANDARDITEMEXTENDATTR ");
        if (isAllBatch) {
            sql.append("WHERE FPARENTID IN ( ");
            sql.append("SELECT ID FROM " + filter + " ");
            sql.append(") ");
            sql.append("AND FQUALITYORGUNITID = '" + orgID + "' ");
        } else {
            sql.append("WHERE FPARENTID IN " + filter + " ");
            sql.append("AND FQUALITYORGUNITID = '" + orgID + "' ");
        }
        return sql.toString();
    }

    protected QualityOrgUnitInfo getCurrentQualityOrgUnit(Context ctx) throws BOSException, EASBizException {
        QualityOrgUnitInfo qyOrg = ContextUtil.getCurrentQualityUnit((Context)ctx);
        if (qyOrg == null) {
            throw new QMException(QMException.BLANK, (Object[])new String[]{"Error QualityOrgUnit!!!"});
        }
        return qyOrg;
    }
}

