/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.app.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.qm.basedata.QCStandardInfo;
import com.kingdee.eas.qm.basedata.app.QCStandardControllerBean;
import com.kingdee.eas.qm.basedata.app.action.QCStandardServerBatchBaseAction;
import com.kingdee.eas.qm.common.QMCoreDataBaseInfo;
import com.kingdee.eas.qm.common.app.action.ISuportServerBatchAction;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;

public class QCStandardServerBatchDeleteAction
extends QCStandardServerBatchBaseAction {
    private QCStandardControllerBean bean;

    public QCStandardServerBatchDeleteAction(ISuportServerBatchAction bean, String beforeEventName, String afterEventName) {
        super(bean, beforeEventName, afterEventName);
        this.bean = (QCStandardControllerBean)bean;
    }

    protected CoreBaseCollection beforeDoIt(Context ctx, BatchExecuteResult result, CoreBaseCollection successedColl) throws BOSException {
        CoreBaseCollection tempCols = super.beforeDoIt(ctx, result, successedColl);
        ArrayList<ObjectUuidPK> pkList = new ArrayList<ObjectUuidPK>();
        for (Object objInfo : tempCols) {
            QCStandardInfo reportInfo;
            if (!(objInfo instanceof QCStandardInfo) || (reportInfo = (QCStandardInfo)objInfo).getId() == null) continue;
            ObjectUuidPK pk = new ObjectUuidPK(reportInfo.getId());
            pkList.add(pk);
        }
        IObjectPK[] pks = pkList.toArray(new IObjectPK[pkList.size()]);
        if (pks != null && pks.length > 0) {
            this.deleteRelation(ctx, pks);
        }
        return tempCols;
    }

    public CoreBaseCollection doIt(Context ctx, BatchExecuteResult result, CoreBaseCollection successedColl) throws BOSException, EASBizException {
        CoreBaseCollection tmpCol = (CoreBaseCollection)successedColl.clone();
        ArrayList successedids = QCStandardServerBatchDeleteAction.getIds((CoreBaseCollection)tmpCol);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(successedids), CompareType.INCLUDE));
        this.getBiz().delete(ctx, filter);
        return tmpCol;
    }

    protected IVerifyManager getVerifyManager(Context ctx, CoreBaseInfo info) {
        return this.bean.getDeleteVerifyManager(ctx, (QMCoreDataBaseInfo)info);
    }

    protected void deleteRelation(Context ctx, IObjectPK[] pks) throws BOSException {
        if (pks == null || pks.length == 0) {
            return;
        }
        StringBuffer whereSql = new StringBuffer();
        whereSql.append("''");
        for (int i = 0; i < pks.length; ++i) {
            whereSql.append(",'" + pks[i].toString() + "'");
        }
        Connection conn = null;
        Statement st = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            StringBuffer deleteSql = new StringBuffer();
            deleteSql.append("DELETE FROM t_qm_qcstandardextendattr WHERE fparentid in (" + whereSql.toString() + ")");
            st.addBatch(deleteSql.toString());
            deleteSql = new StringBuffer();
            deleteSql.append("DELETE FROM t_qm_qcstandarditementries WHERE fparentid in(" + whereSql.toString() + ")");
            st.addBatch(deleteSql.toString());
            deleteSql = new StringBuffer();
            deleteSql.append("DELETE FROM t_qm_qcstandarditemextendattr WHERE fparentid in(" + whereSql.toString() + ")");
            st.addBatch(deleteSql.toString());
            deleteSql = new StringBuffer();
            deleteSql.append("DELETE FROM t_qm_qcstandardmaterialentries WHERE fparentid in(" + whereSql.toString() + ")");
            st.addBatch(deleteSql.toString());
            deleteSql = new StringBuffer();
            deleteSql.append("DELETE FROM t_qm_qcstandardplineentry WHERE fparentid in(" + whereSql.toString() + ")");
            st.addBatch(deleteSql.toString());
            deleteSql = new StringBuffer();
            deleteSql.append("DELETE FROM t_qm_qcstandardtechnicsentries WHERE fparentid in(" + whereSql.toString() + ")");
            st.addBatch(deleteSql.toString());
            deleteSql = new StringBuffer();
            deleteSql.append("DELETE FROM t_qm_qcstandardboentry WHERE fparentid in (" + whereSql.toString() + ")");
            st.addBatch(deleteSql.toString());
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }
}

