/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.app.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.qm.basedata.app.action.QCStandardServerBatchBaseAction;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.common.app.action.ISuportServerBatchAction;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class QCStandardServerBatchUnAuditAction
extends QCStandardServerBatchBaseAction {
    public QCStandardServerBatchUnAuditAction(ISuportServerBatchAction bean, String beforeEventName, String afterEventName) {
        super(bean, beforeEventName, afterEventName);
    }

    protected CoreBaseCollection batchVerify(Context ctx, BatchExecuteResult result, CoreBaseCollection successedColl) throws BOSException {
        if (null == successedColl || successedColl.size() == 0) {
            result.setException(0, (Throwable)new QMException(QMException.RECORDNOTEXIST));
            return null;
        }
        QualityOrgUnitInfo qmOrgInfo = ContextUtil.getCurrentQualityUnit((Context)ctx);
        String currentQMOrgID = qmOrgInfo.getId().toString();
        CoreBaseCollection tmpCol = (CoreBaseCollection)successedColl.clone();
        String ids = this.getSuccessedIDS(ctx, tmpCol);
        this.checkHeadExtDataRight(ctx, result, tmpCol, ids, currentQMOrgID);
        ids = this.getSuccessedIDS(ctx, tmpCol);
        this.checkAuditStatusSql(ctx, result, tmpCol, currentQMOrgID, ids, false);
        return tmpCol;
    }

    public CoreBaseCollection doIt(Context ctx, BatchExecuteResult result, CoreBaseCollection successedColl) throws BOSException, EASBizException {
        QualityOrgUnitInfo qmOrgInfo = ContextUtil.getCurrentQualityUnit((Context)ctx);
        String currentQMOrgID = qmOrgInfo.getId().toString();
        CoreBaseCollection tmpCol = (CoreBaseCollection)successedColl.clone();
        String ids = this.getSuccessedIDS(ctx, tmpCol);
        if (ids == null) {
            return null;
        }
        Connection conn = null;
        Statement st = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            StringBuffer sql = this.doAudit1(currentQMOrgID, ids, false);
            st.addBatch(sql.toString());
            sql = this.doAudit2(currentQMOrgID, ids, false);
            st.addBatch(sql.toString());
            sql = this.doAduit3(currentQMOrgID, ids, false);
            st.addBatch(sql.toString());
            int[] rsarray = st.executeBatch();
        }
        catch (SQLException sqlEx) {
            try {
                throw new SQLDataException(sqlEx);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
        return tmpCol;
    }
}

