/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.QCGroupFactory;
import com.kingdee.eas.qm.basedata.QCGroupInfo;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCLowerLimitEnum;
import com.kingdee.eas.qm.basedata.QCStandardException;
import com.kingdee.eas.qm.basedata.QCStandardInfo;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryInfo;
import com.kingdee.eas.qm.basedata.QCStandardItemExtendAttrInfo;
import com.kingdee.eas.qm.basedata.QCUpperLimitEnum;
import com.kingdee.eas.qm.common.util.NumericUtils;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import java.math.BigDecimal;
import java.util.Iterator;

public class QCStandardSubmitVerifyItem
extends AbstractVerifyItem
implements IVerifyItem {
    private Context ctx;
    private QCStandardInfo info;

    public QCStandardSubmitVerifyItem(Context ctx, QCStandardInfo info) {
        this.ctx = ctx;
        this.info = info;
    }

    public boolean verify() throws EASBizException, BOSException {
        Iterator it = this.info.getItemEntries().iterator();
        int index = 0;
        while (it.hasNext()) {
            QCStandardItemEntryInfo entryInfo = (QCStandardItemEntryInfo)it.next();
            QCStandardItemExtendAttrInfo extInfo = entryInfo.getItemExtendAttr().get(0);
            QualityOrgUnitInfo orgInfo = extInfo.getDelegOrgUnit();
            QCGroupInfo groupInfo = extInfo.getQCGroup();
            if (orgInfo == null || groupInfo == null) continue;
            groupInfo = QCGroupFactory.getLocalInstance(this.ctx).getQCGroupInfo((IObjectPK)new ObjectUuidPK(groupInfo.getId()));
            if (!groupInfo.getQualityOrgUnit().getId().equals((Object)orgInfo.getId())) {
                throw new QCStandardException(QCStandardException.ERRORQCGROUP, new String[]{entryInfo.getQCItem().getName()});
            }
            this.verifyItemEntryLimit(entryInfo, ++index);
        }
        return true;
    }

    private void verifyItemEntryLimit(QCStandardItemEntryInfo itemEntry, int entrySeq) throws EASBizException {
        QCItemInfo qcItem = itemEntry.getQCItem();
        if (!(qcItem.getQCValueType().getValue() != 10 && qcItem.getQCValueType().getValue() != 40 || NumericUtils.equalsZero((BigDecimal)itemEntry.getLower()) || NumericUtils.equalsZero((BigDecimal)itemEntry.getUpper()))) {
            if (itemEntry.getLower().compareTo(itemEntry.getUpper()) > 0) {
                throw new QCStandardException(QCStandardException.LOWERCANNOTMOREUPPER, new Object[]{new Integer(entrySeq)});
            }
            if (itemEntry.getLower().compareTo(itemEntry.getUpper()) == 0 && (itemEntry.getLowerLimit().equals((Object)QCLowerLimitEnum.greater) || itemEntry.getUpperLimit().equals((Object)QCUpperLimitEnum.less))) {
                throw new QCStandardException(QCStandardException.LOWERLIMITEQUALSUPPERLIMITEXP, new Object[]{new Integer(entrySeq)});
            }
        }
    }
}

