/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.util;

import com.kingdee.eas.qm.basedata.QCModifyModeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;

public class QCModifyModeHelper {
    private static final long INFLATED = Long.MIN_VALUE;
    public static final int MAX_COMPACT_DIGITS = 18;

    public static BigDecimal modify(BigDecimal var, QCModifyModeInfo modifyInfo) {
        return QCModifyModeHelper.modify(var, modifyInfo, 8);
    }

    public static BigDecimal modify(BigDecimal var, QCModifyModeInfo modifyInfo, int validDigitals) {
        if (modifyInfo == null) {
            return var;
        }
        BigDecimal modifyVar = var;
        double offset = modifyInfo.getModifyOffset().doubleValue();
        int multiple = modifyInfo.getMultiple().getValue();
        modifyVar = QCModifyModeHelper.modify(var, offset, validDigitals, multiple);
        return modifyVar;
    }

    public static BigDecimal modify(BigDecimal toBeModified, double offset, int validDigitals, int multiple) {
        boolean transfer = false;
        BigDecimal modifyValue = toBeModified;
        if (toBeModified.signum() < 0) {
            modifyValue = toBeModified.abs();
            transfer = true;
        }
        modifyValue = QCModifyModeHelper.modifyCalStep2And3(modifyValue, offset, multiple, true);
        BigDecimal step3bd = modifyValue = QCModifyModeHelper.modifyCalStep2And3(modifyValue, offset, multiple, false);
        BigInteger intVal = QCModifyModeHelper.toIntValue(step3bd);
        int scale = step3bd.scale();
        String str = intVal.toString(10);
        int len = str.length();
        StringBuffer buf = new StringBuffer(str);
        BigDecimal result = new BigDecimal("0.0");
        if (validDigitals >= len) {
            for (int i = 0; i < validDigitals - len; ++i) {
                buf.append('0');
                ++scale;
            }
            result = new BigDecimal(QCModifyModeHelper.getValueString(1, buf.toString(), scale));
        } else {
            int newScale;
            char ch = buf.charAt(validDigitals);
            buf.delete(validDigitals, buf.length());
            if (ch >= '5') {
                long value = Long.parseLong(buf.toString());
                buf = new StringBuffer(String.valueOf(++value));
            }
            if ((newScale = scale - (len - validDigitals)) < 0) {
                int v = Math.abs(newScale);
                for (int i = 0; i < v; ++i) {
                    buf.append('0');
                }
                result = new BigDecimal(buf.toString());
            } else {
                result = new BigDecimal(QCModifyModeHelper.getValueString(1, buf.toString(), newScale));
            }
        }
        if (transfer) {
            result = result.multiply(new BigDecimal("-1"));
        }
        return result;
    }

    private static BigDecimal modifyCalStep2And3(BigDecimal toBeModified, double offset, int multiple, boolean needMultiple) {
        String answer;
        char charCheck;
        int i;
        BigDecimal tobeModifiedTemp = new BigDecimal("0.00");
        double offsetTemp = 0.0;
        if (needMultiple) {
            tobeModifiedTemp = toBeModified.multiply(new BigDecimal(multiple));
            offsetTemp = offset * (double)multiple;
        } else {
            tobeModifiedTemp = toBeModified.divide(new BigDecimal(multiple), 6, 5);
            offsetTemp = offset;
        }
        BigDecimal modifyValue = tobeModifiedTemp;
        String plainString = QCModifyModeHelper.toPlainString(new BigDecimal(String.valueOf(tobeModifiedTemp)));
        plainString = plainString.trim();
        StringBuffer checkStrBuf = new StringBuffer(plainString);
        checkStrBuf.setLength(plainString.length());
        int dotIndexOfCheck = checkStrBuf.indexOf(".");
        String offsetStr = QCModifyModeHelper.toPlainString(new BigDecimal(String.valueOf(offsetTemp)));
        offsetStr = offsetStr.trim();
        int dotIndexOfOffset = offsetStr.indexOf(".");
        int dex = 0;
        if (offsetTemp >= 1.0) {
            dex = -dotIndexOfOffset;
        } else {
            String sub = offsetStr.substring(dotIndexOfOffset + 1);
            char[] chs = sub.toCharArray();
            for (i = chs.length - 1; i >= 0; --i) {
                char ch = chs[i];
                if (ch == '0') continue;
                dex = i + 1;
                break;
            }
        }
        int checkIndex = dotIndexOfCheck + dex + 1;
        if (checkIndex < 0) {
            return toBeModified;
        }
        if (checkIndex >= checkStrBuf.length()) {
            int size = checkIndex - checkStrBuf.length() + 1;
            for (i = 0; i < size; ++i) {
                checkStrBuf.append('0');
            }
        }
        if ((charCheck = checkStrBuf.charAt(checkIndex)) == '.') {
            charCheck = checkStrBuf.charAt(++checkIndex);
        }
        if ((answer = checkStrBuf.substring(0, checkIndex)) != null && answer.trim().length() == 0) {
            answer = "0";
        }
        modifyValue = new BigDecimal(answer);
        if (charCheck < '5') {
            if (dex < 0) {
                modifyValue = modifyValue.multiply(new BigDecimal(Math.pow(10.0, Math.abs(dex) - 1)));
            }
        } else if (charCheck == '5') {
            String sub = checkStrBuf.substring(checkIndex + 1);
            char[] chs = sub.toCharArray();
            int tmepGetIndex = checkIndex - 1;
            int tempGetIndex1 = checkIndex - 2;
            if (chs == null || chs.length == 0) {
                int remain = checkStrBuf.charAt(tmepGetIndex);
                if (remain == 46) {
                    int n = remain = tempGetIndex1 < 0 ? 48 : (int)checkStrBuf.charAt(tempGetIndex1);
                }
                if (remain % 2 == 0) {
                    if (dex < 0) {
                        modifyValue = modifyValue.multiply(new BigDecimal(Math.pow(10.0, Math.abs(dex) - 1)));
                    }
                } else if (dex < 0) {
                    modifyValue = modifyValue.multiply(new BigDecimal(Math.pow(10.0, Math.abs(dex) - 1)));
                    modifyValue = modifyValue.add(new BigDecimal(Math.pow(10.0, Math.abs(dex) - 1)));
                } else if (dex > 0) {
                    modifyValue = modifyValue.add(new BigDecimal(Math.pow(0.1, Math.abs(dex))));
                }
            } else {
                boolean isAllZero = true;
                for (int i2 = 0; i2 < chs.length; ++i2) {
                    char ch = chs[i2];
                    if (ch == '.' || ch == '0') continue;
                    if (dex < 0) {
                        modifyValue = modifyValue.multiply(new BigDecimal(Math.pow(10.0, Math.abs(dex) - 1)));
                        modifyValue = modifyValue.add(new BigDecimal(Math.pow(10.0, Math.abs(dex) - 1)));
                    } else if (dex > 0) {
                        modifyValue = modifyValue.add(new BigDecimal(Math.pow(0.1, Math.abs(dex))));
                    }
                    isAllZero = false;
                    break;
                }
                if (isAllZero) {
                    int remain;
                    int n = remain = tmepGetIndex < 0 ? 48 : (int)checkStrBuf.charAt(tmepGetIndex);
                    if (remain == 46) {
                        remain = checkStrBuf.charAt(tempGetIndex1);
                    }
                    if (remain % 2 == 0) {
                        if (dex < 0) {
                            modifyValue = modifyValue.multiply(new BigDecimal(Math.pow(10.0, Math.abs(dex) - 1)));
                        }
                    } else if (dex < 0) {
                        modifyValue = modifyValue.multiply(new BigDecimal(Math.pow(10.0, Math.abs(dex) - 1)));
                        modifyValue = modifyValue.add(new BigDecimal(Math.pow(10.0, Math.abs(dex) - 1)));
                    } else if (dex > 0) {
                        modifyValue = modifyValue.add(new BigDecimal(Math.pow(0.1, Math.abs(dex))));
                    }
                }
            }
        } else if (dex < 0) {
            modifyValue = modifyValue.multiply(new BigDecimal(Math.pow(10.0, Math.abs(dex) - 1)));
            modifyValue = modifyValue.add(new BigDecimal(Math.pow(10.0, Math.abs(dex) - 1)));
        } else if (dex > 0) {
            modifyValue = modifyValue.add(new BigDecimal(Math.pow(0.1, Math.abs(dex))));
        }
        return modifyValue;
    }

    public static BigInteger toIntValue(BigDecimal bd) {
        if (bd == null) {
            return null;
        }
        String dbValue = bd.toString();
        if (dbValue == null) {
            return null;
        }
        char[] in = dbValue.toCharArray();
        int offset = 0;
        int len = dbValue.length();
        int precision = 0;
        long intCompact = Long.MIN_VALUE;
        BigInteger intVal = null;
        try {
            char[] quick;
            boolean isneg = false;
            if (in[offset] == '-') {
                isneg = true;
                ++offset;
                --len;
            } else if (in[offset] == '+') {
                ++offset;
                --len;
            }
            int dotoff = -1;
            long exp = 0L;
            if (len > in.length) {
                throw new NumberFormatException();
            }
            char[] coeff = new char[len];
            while (len > 0) {
                char c = in[offset];
                if (c >= '0' && c <= '9' || Character.isDigit(c)) {
                    coeff[precision] = c;
                    ++precision;
                } else if (c == '.') {
                    if (dotoff >= 0) {
                        throw new NumberFormatException();
                    }
                    dotoff = offset;
                } else {
                    if (c != 'e' && c != 'E') {
                        throw new NumberFormatException();
                    }
                    c = in[++offset];
                    --len;
                    boolean negexp = false;
                    if (c == '-' || c == '+') {
                        negexp = c == '-';
                        c = in[++offset];
                        --len;
                    }
                    if (len <= 0) {
                        throw new NumberFormatException();
                    }
                    while (len > 10 && Character.digit(c, 10) == 0) {
                        c = in[++offset];
                        --len;
                    }
                    if (len > 10) {
                        throw new NumberFormatException();
                    }
                    while (true) {
                        int v;
                        if (c >= '0' && c <= '9') {
                            v = c - 48;
                        } else {
                            v = Character.digit(c, 10);
                            if (v < 0) {
                                throw new NumberFormatException();
                            }
                        }
                        exp = exp * 10L + (long)v;
                        if (len == 1) break;
                        c = in[++offset];
                        --len;
                    }
                    if (negexp) {
                        exp = -exp;
                    }
                    if ((long)((int)exp) == exp) break;
                    throw new NumberFormatException();
                }
                ++offset;
                --len;
            }
            if (precision == 0) {
                throw new NumberFormatException();
            }
            int first = 0;
            while ((coeff[first] == '0' || Character.digit(coeff[first], 10) == 0) && precision > 1) {
                --precision;
                ++first;
            }
            if (!isneg) {
                quick = new char[precision];
                System.arraycopy(coeff, first, quick, 0, precision);
            } else {
                quick = new char[precision + 1];
                quick[0] = 45;
                System.arraycopy(coeff, first, quick, 1, precision);
            }
            if (precision <= 18) {
                intCompact = Long.parseLong(new String(quick));
            } else {
                intVal = new BigInteger(String.valueOf(quick), 10);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NumberFormatException();
        }
        catch (NegativeArraySizeException e) {
            throw new NumberFormatException();
        }
        if (intVal == null) {
            intVal = BigInteger.valueOf(intCompact);
        }
        return intVal;
    }

    private static String getValueString(int signum, String intString, int scale) {
        StringBuffer buf;
        int insertionPoint = intString.length() - scale;
        if (insertionPoint == 0) {
            return (signum < 0 ? "-0." : "0.") + intString;
        }
        if (insertionPoint > 0) {
            buf = new StringBuffer(intString);
            buf.insert(insertionPoint, '.');
            if (signum < 0) {
                buf.insert(0, '-');
            }
        } else {
            buf = new StringBuffer(3 - insertionPoint + intString.length());
            buf.append(signum < 0 ? "-0." : "0.");
            for (int i = 0; i < -insertionPoint; ++i) {
                buf.append('0');
            }
            buf.append(intString);
        }
        return buf.toString();
    }

    public static String toPlainString(BigDecimal bd) {
        int scale = bd.scale();
        BigInteger intVal = QCModifyModeHelper.toIntValue(bd);
        if (scale < 0) {
            StringBuffer buf = new StringBuffer(intVal.toString());
            int size = Math.abs(scale);
            for (int i = 0; i < size; ++i) {
                buf.append('0');
            }
            return buf.toString();
        }
        if (scale == 0) {
            StringBuffer buf = new StringBuffer(intVal.toString());
            buf.append(".0");
            return buf.toString();
        }
        return QCModifyModeHelper.getValueString(bd.signum(), intVal.abs().toString(), scale);
    }
}

