/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.IQCStandardItemEntry;
import com.kingdee.eas.qm.basedata.IQCStandardItemExtendAttr;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrCollection;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrFactory;
import com.kingdee.eas.qm.basedata.QCStandardExtendAttrInfo;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryCollection;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryFactory;
import com.kingdee.eas.qm.basedata.QCStandardItemEntryInfo;
import com.kingdee.eas.qm.basedata.QCStandardItemExtendAttrCollection;
import com.kingdee.eas.qm.basedata.QCStandardItemExtendAttrFactory;
import com.kingdee.eas.qm.basedata.QCStandardItemExtendAttrInfo;
import com.kingdee.eas.qm.common.util.QMSelectorUtils;
import java.util.Map;

public abstract class QCStandardUtils {
    public static QCStandardItemEntryInfo getQCStandardItemEntryInfo(Context ctx, String orgID, String qcStandardID, String qcItemID) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)selector, (String[])new String[]{"*"});
        QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)selector, (String[])new String[]{"unit", "qCFrequency", "qCMethod", "qCModifyMode"}, (String[])new String[]{"*"});
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("qCItem.id", (Object)qcItemID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)qcStandardID, CompareType.EQUALS));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        ev.setSelector(selector);
        IQCStandardItemEntry ibiz = ctx == null ? QCStandardItemEntryFactory.getRemoteInstance() : QCStandardItemEntryFactory.getLocalInstance(ctx);
        QCStandardItemEntryCollection colls = ibiz.getQCStandardItemEntryCollection(ev);
        if (colls != null && colls.size() > 0) {
            QCStandardItemEntryInfo entryInfo = colls.get(0);
            EntityViewInfo extEv = new EntityViewInfo();
            FilterInfo extFilter = new FilterInfo();
            extFilter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)orgID, CompareType.EQUALS));
            extFilter.getFilterItems().add(new FilterItemInfo("qCStandardEntry.id", (Object)entryInfo.getId().toString(), CompareType.EQUALS));
            extEv.setFilter(extFilter);
            SelectorItemCollection sic = new SelectorItemCollection();
            QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String[])new String[]{"*"});
            QMSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String[])new String[]{"delegOrgUnit", "qCGroup", "qCInstrument", "qCInstrumentGroup"}, (String[])new String[]{"*"});
            QMSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String[])new String[]{"sampleProgram"});
            sic.add(new SelectorItemInfo("sampleProgram.evaluationMode"));
            extEv.setSelector(sic);
            IQCStandardItemExtendAttr iExtBiz = ctx == null ? QCStandardItemExtendAttrFactory.getRemoteInstance() : QCStandardItemExtendAttrFactory.getLocalInstance(ctx);
            QCStandardItemExtendAttrCollection extCols = iExtBiz.getQCStandardItemExtendAttrCollection(extEv);
            if (extCols != null && extCols.size() > 0) {
                QCStandardItemExtendAttrInfo extInfo = extCols.get(0);
                entryInfo.put("delegOrgUnit", extInfo.getDelegOrgUnit());
                entryInfo.put("qCGroup", extInfo.getQCGroup());
                entryInfo.put("qCInstrumentGroup", extInfo.getQCInstrumentGroup());
                entryInfo.put("qCInstrument", extInfo.getQCInstrument());
                entryInfo.put("sampleProgram", extInfo.getSampleProgram());
            }
            return entryInfo;
        }
        return null;
    }

    public static void setQCItemEntryInfoOnTable(QCStandardItemEntryInfo info, IRow row, Map keyMapping) throws Exception {
        for (Map.Entry entry : keyMapping.entrySet()) {
            String rowKey = (String)entry.getValue();
            Object rowValue = info != null ? info.get((String)entry.getKey()) : null;
            row.getCell(rowKey).setValue(rowValue);
        }
    }

    public static int getMaterialUnitQtyPrecision(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo measureUnitInfo) throws Exception {
        int precision = 4;
        if (measureUnitInfo != null && materialInfo != null) {
            IMultiMeasureUnit imultiUnit = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            MultiMeasureUnitInfo multiUnitInfo = imultiUnit.getMultiUnit(materialInfo.getId().toString(), measureUnitInfo.getId().toString());
            if (multiUnitInfo != null) {
                precision = multiUnitInfo.getQtyPrecision();
            }
        } else if (measureUnitInfo != null && materialInfo == null) {
            precision = measureUnitInfo.getQtyPrecision();
        }
        return precision;
    }

    public static QCStandardExtendAttrInfo getQCStandardExtendAttr(String qCStandardId, String qualitityOrgUnitId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)qCStandardId));
        filter.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)qualitityOrgUnitId));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("eachSampleUnit.id"));
        sic.add(new SelectorItemInfo("eachSampleUnit.name"));
        sic.add(new SelectorItemInfo("eachSampleUnit.number"));
        view.setFilter(filter);
        view.setSelector(sic);
        QCStandardExtendAttrCollection coll = QCStandardExtendAttrFactory.getRemoteInstance().getQCStandardExtendAttrCollection(view);
        return coll.get(0);
    }
}

