/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.qm.common.app.AbstractQMCommonFacadeControllerBean;
import com.kingdee.eas.qm.common.app.util.QMServerUtils;
import com.kingdee.eas.qm.common.cache.QMBatchExecuteParam;
import com.kingdee.eas.qm.common.cache.QMBatchExecuteResult;
import java.util.List;

public class QMCommonFacadeControllerBean
extends AbstractQMCommonFacadeControllerBean {
    private static final long serialVersionUID = -4087703554503320494L;

    @Override
    protected OrgUnitInfo[] _getAuthorizedBizOrgUnits(Context ctx, OrgType orgType, String permissionItem) throws BOSException, EASBizException {
        OrgUnitCollection bizOrgs;
        OrgUnitCollection collection = null;
        if (permissionItem != null) {
            collection = QMServerUtils.getAuthOrgByPermItem(ctx, orgType, permissionItem);
        }
        if ((bizOrgs = QMServerUtils.getOrgUnitInfosByType(ctx, collection, orgType, true)) == null) {
            return null;
        }
        int size = bizOrgs.size();
        OrgUnitInfo[] results = new OrgUnitInfo[size];
        if (size > 0) {
            Object[] objects = bizOrgs.toArray();
            System.arraycopy(objects, 0, results, 0, size);
        }
        return results;
    }

    @Override
    protected OrgUnitInfo[] _getAuthorizedOrgUnits(Context ctx, OrgType orgType, String permissionItem) throws BOSException, EASBizException {
        OrgUnitCollection bizOrgs;
        OrgUnitCollection collection = null;
        if (permissionItem != null) {
            collection = QMServerUtils.getAuthOrgByPermItem(ctx, orgType, permissionItem);
        }
        if ((bizOrgs = QMServerUtils.getOrgUnitInfosByType(ctx, collection, orgType, false)) == null) {
            return null;
        }
        int size = bizOrgs.size();
        OrgUnitInfo[] results = new OrgUnitInfo[size];
        if (size > 0) {
            Object[] objects = bizOrgs.toArray();
            System.arraycopy(objects, 0, results, 0, size);
        }
        return results;
    }

    @Override
    protected QMBatchExecuteResult[] _batchExcute(Context ctx, QMBatchExecuteParam[] param) throws BOSException, EASBizException {
        QMBatchExecuteResult[] rst = new QMBatchExecuteResult[param.length];
        for (int i = 0; i < param.length; ++i) {
            try {
                QMBatchExecuteParam batchExecuteParam = param[i];
                if (!batchExecuteParam.isEnable()) continue;
                batchExecuteParam.invokeLocale(ctx);
                rst[i] = new QMBatchExecuteResult(batchExecuteParam.getResult(), null);
                continue;
            }
            catch (Exception e) {
                rst[i] = new QMBatchExecuteResult(null, e);
            }
        }
        return rst;
    }

    @Override
    protected void _writeTDPrintLog(Context ctx, List idList, BOSObjectType bosType, String pringTDLogName) throws BOSException, EASBizException {
        if (bosType == null || idList == null || idList.size() == 0) {
            return;
        }
        IBOSObject ibo = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        if (!(ibo instanceof ICoreBase)) {
            return;
        }
        ICoreBase ibiz = (ICoreBase)ibo;
        for (String id : idList) {
            if (StringUtil.isEmptyString((String)id)) continue;
            ObjectStringPK dataPk = new ObjectStringPK(id);
            CoreBaseInfo info = ibiz.getValue((IObjectPK)dataPk);
            String operationName = "";
            if (info != null && info.getString("number") != null) {
                operationName = info.getString("number");
            }
            IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"actionTDPrint", (BOSObjectType)bosType, (IObjectPK)dataPk, (String)operationName, (String)pringTDLogName);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        }
    }
}

