/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.Context2;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ReflectException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.util.VerifyUtil;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.app.service.FunctionPermissionService;
import com.kingdee.eas.basedata.framework.util.FMQuerySqlBuilder;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.qm.common.QMBillBaseStatusEnum;
import com.kingdee.eas.qm.common.QMCoreBillBaseCollection;
import com.kingdee.eas.qm.common.QMCoreBillBaseInfo;
import com.kingdee.eas.qm.common.app.AbstractQMCoreBillBaseControllerBean;
import com.kingdee.eas.qm.common.app.action.IServerActionManager;
import com.kingdee.eas.qm.common.app.action.IServerBatchAction;
import com.kingdee.eas.qm.common.app.action.ISuportServerBatchAction;
import com.kingdee.eas.qm.common.app.action.ServerActionManager;
import com.kingdee.eas.qm.common.app.action.ServerBatchAuditAction;
import com.kingdee.eas.qm.common.app.action.ServerBatchDeleteAction;
import com.kingdee.eas.qm.common.app.action.ServerBatchUnAuditAction;
import com.kingdee.eas.qm.common.app.action.ServerEvent;
import com.kingdee.eas.qm.common.app.util.QMServerUtils;
import com.kingdee.eas.qm.common.app.verify.QMBillAddnewCommonVerifyItem;
import com.kingdee.eas.qm.common.app.verify.QMBillAuditCommonVerifyItem;
import com.kingdee.eas.qm.common.app.verify.QMBillDeleteCommonVerifyItem;
import com.kingdee.eas.qm.common.app.verify.QMBillUnAuditCommonVerifyItem;
import com.kingdee.eas.qm.common.codingrule.ISuportCodingRule;
import com.kingdee.eas.qm.common.codingrule.ServerCodingRuleStrategy;
import com.kingdee.eas.qm.common.util.QMEqualsUtils;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.common.util.backup.QMCommonUtils;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.common.verify.VerifyManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.BaseException;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class QMCoreBillBaseControllerBean
extends AbstractQMCoreBillBaseControllerBean
implements ISuportCodingRule,
ISuportServerBatchAction {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.qm.common.app.QMCoreBillBaseControllerBean");

    protected void regesterServerAction(Context ctx, QMCoreBillBaseInfo model, IServerActionManager serverActionManager) throws BOSException {
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum billOperStateEnum, IObjectValue relationInfo) throws BOSException, EASBizException {
        this.fireServerAction(ctx, srcBillVO, "BEFORE_UPDATE", new Object[]{srcBillPK, srcBillVO, billOperStateEnum, relationInfo});
    }

    public IServerActionManager getServerActionManager(Context ctx, QMCoreBillBaseInfo model, String name) throws BOSException {
        ServerActionManager serverActionManager = new ServerActionManager(name);
        this.regesterServerAction(ctx, model, serverActionManager);
        return serverActionManager;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QMCoreBillBaseInfo info = (QMCoreBillBaseInfo)model;
        String tableName = this.getTableName(ctx);
        QMServerUtils.checkLastUpTime(ctx, (ObjectBaseInfo)info, tableName);
        IVerifyManager verifymanager = this.getSaveVerifyManager(ctx, info);
        verifymanager.verify();
        info.setBillStatus(QMBillBaseStatusEnum.SAVE);
        return super._save(ctx, (IObjectValue)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QMCoreBillBaseInfo info = (QMCoreBillBaseInfo)model;
        String tableName = this.getTableName(ctx);
        QMServerUtils.checkLastUpTime(ctx, (ObjectBaseInfo)info, tableName);
        this.getSubmitVerifyManager(ctx, info).verify();
        if (info.getBillStatus() == QMBillBaseStatusEnum.SAVE || info.getBillStatus() == QMBillBaseStatusEnum.AddNew || info.getBillStatus() == null) {
            info.setBillStatus(QMBillBaseStatusEnum.Submit);
        }
        IObjectPK pk = super._submit(ctx, model);
        if (this.isAuditBySubmit(ctx, info) && this.hasAuditPermission(ctx, info)) {
            super.audit(ctx, pk);
        }
        return pk;
    }

    protected boolean isAuditBySubmit(Context ctx, QMCoreBillBaseInfo info) throws BOSException, EASBizException {
        return false;
    }

    protected boolean hasAuditPermission(Context ctx, QMCoreBillBaseInfo info) throws EASBizException, BOSException {
        String auditPermItem = this.getAuditPerItem(ctx, info);
        if (QMStringUtils.isEmpty(auditPermItem)) {
            return false;
        }
        FunctionPermissionService service = new FunctionPermissionService(ctx);
        boolean hasAuditPerm = service.hasPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getMainOrgUnit().getId()), this.getAuditPerItem(ctx, info), true);
        return hasAuditPerm;
    }

    protected String getAuditPerItem(Context ctx, QMCoreBillBaseInfo info) throws EASBizException, BOSException {
        return null;
    }

    protected void _checkNumberBlank(Context ctx, QMCoreBillBaseInfo model) throws BOSException, EASBizException {
        String number = model.getNumber();
        if (number == null || number.trim().equals("")) {
            throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        QMCoreBillBaseInfo info = (QMCoreBillBaseInfo)model;
        this.getCodingRuleStrategy().initEditNumber(this, ctx, info);
        this._checkNumberBlank(ctx, info);
        this._checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
        IVerifyManager verifymanager = this.getUpdateVerifyManager(ctx, info);
        verifymanager.verify();
        this.fireServerAction(ctx, model, "BEFORE_UPDATE");
        super._update(ctx, pk, model);
        this.fireServerAction(ctx, model, "AFTER_UPDATE");
    }

    protected void _update1(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    @Override
    public void fireServerAction(Context ctx, IObjectValue model, String eventName) throws EASBizException, BOSException {
        ServerEvent event = new ServerEvent();
        event.setEventName(eventName);
        event.setSrcObject(model);
        this.getServerActionManager(ctx, (QMCoreBillBaseInfo)model, eventName).fireServerAction(ctx, event);
    }

    protected void fireServerAction(Context ctx, IObjectValue model, String eventName, Object[] args) throws EASBizException, BOSException {
        ServerEvent event = new ServerEvent();
        event.setEventName(eventName);
        event.setSrcObject(model);
        event.setParams(args);
        this.getServerActionManager(ctx, (QMCoreBillBaseInfo)model, eventName).fireServerAction(ctx, event);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        QMCoreBillBaseInfo info = this.getQMCoreBillBaseInfo(ctx, pk);
        IVerifyManager verifymanager = this.getDeleteVerifyManager(ctx, info);
        verifymanager.verify();
        this.fireServerAction(ctx, info, "BEFORE_DELETE");
        super._delete(ctx, pk);
        this.fireServerAction(ctx, info, "AFTER_DELETE");
        QMCommonUtils.recycleNumber(ctx, (CoreBaseInfo)info, info.getMainOrgUnit().getId().toString());
    }

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.delete(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    protected IVerifyManager getDeleteVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        QMBillDeleteCommonVerifyItem verifyItem = new QMBillDeleteCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected void isCanDelete(Context ctx, IObjectPK pk, CoreBillBaseInfo coreBillInfo) throws BOSException, EASBizException {
        super.isCanDelete(ctx, pk, coreBillInfo);
    }

    public IServerBatchAction getBatchDeleteAction() {
        BillBatchDeleteAction action = new BillBatchDeleteAction(this);
        return action;
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws EASBizException, BOSException {
        QMCoreBillBaseCollection collection = new QMCoreBillBaseCollection();
        collection.add((QMCoreBillBaseInfo)objectValue);
        this._handleAfterTransform(ctx, action, (IObjectCollection)collection);
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        for (int i = 0; i < collection.size(); ++i) {
            IObjectValue qcInfo = collection.getObject(i);
            this.fireServerAction(ctx, qcInfo, "AFTER_TRANS_FORM");
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Quality;
    }

    protected OrgUnitInfo getMainBizOrgUnit(Context ctx, CoreBillBaseInfo model) {
        if (model.get(model.getBizOrgPropertyName()) != null) {
            return (OrgUnitInfo)model.get(model.getBizOrgPropertyName());
        }
        return (OrgUnitInfo)ctx.get((Object)this.getMainBizOrgType());
    }

    public ServerCodingRuleStrategy getCodingRuleStrategy() {
        return new ServerCodingRuleStrategy();
    }

    public FilterInfo getFilterForCheckNumber(CoreBillBaseInfo model) {
        FilterInfo filter = new FilterInfo();
        QMCoreBillBaseInfo info = (QMCoreBillBaseInfo)model;
        filter.getFilterItems().add(new FilterItemInfo(info.getBizOrgPropertyName() + ".id", (Object)info.getMainOrgUnit().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QMCoreBillBaseInfo info = (QMCoreBillBaseInfo)model;
        VerifyUtil.checkBlank((Context)ctx, (IObjectValue)info, (String)info.getBizOrgPropertyName());
        this.getCodingRuleStrategy().initNumber(this, ctx, info);
        this.prepareLogContext(ctx, info);
        this._checkNumberBlank(ctx, null, info);
        this._checkNumberDup(ctx, null, info);
        IVerifyManager verifymanager = this.getAddnewVerifyManager(ctx, info);
        verifymanager.verify();
        this.fireServerAction(ctx, info, "BEFORE_ADDNEW");
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        this.fireServerAction(ctx, info, "AFTER_ADDNEW");
        return pk;
    }

    protected void prepareLogContext(Context ctx, QMCoreBillBaseInfo info) throws BOSException, EASBizException {
        LogControllManager.getInstance().enableLog();
        Context logCtx = null;
        if (QMEqualsUtils.equals(ctx.get((Object)"CurOU"), info.getMainOrgUnit())) {
            logCtx = ctx;
        } else {
            logCtx = new Context2(ContextUtils.getContextFromSession());
            logCtx.setClientHostIP(ctx.getClientHostIP());
            logCtx.setClientHostName(ctx.getClientHostName());
            OrgUnitInfo mainOrg = info.getMainOrgUnit();
            logCtx.put((Object)"CurOU", (Object)mainOrg);
            if (mainOrg instanceof QualityOrgUnitInfo) {
                ContextUtil.setCurrentQualityUnit((Context)logCtx, (QualityOrgUnitInfo)((QualityOrgUnitInfo)mainOrg));
            } else if (mainOrg instanceof StorageOrgUnitInfo) {
                ContextUtil.setCurrentStorageUnit((Context)logCtx, (StorageOrgUnitInfo)((StorageOrgUnitInfo)mainOrg));
            }
        }
        this.logAddnew(logCtx, info);
    }

    protected void updateBotpBillAddNewLastUpdateInfoNull(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    protected IVerifyManager getAddnewVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        QMBillAddnewCommonVerifyItem verifyItem = new QMBillAddnewCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected IVerifyManager getUpdateVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        return verifymanager;
    }

    protected IVerifyManager getSaveVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        return verifymanager;
    }

    protected IVerifyManager getSubmitVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        return verifymanager;
    }

    @Override
    public boolean isNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)coreBillBaseInfo.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (coreBillBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)coreBillBaseInfo.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
        }
        if (FilterUtility.hasFilterItem((FilterInfo)this.getFilterForCheckNumber(coreBillBaseInfo))) {
            filter.mergeFilter(this.getFilterForCheckNumber(coreBillBaseInfo), "AND");
        }
        return super._exists(ctx, filter);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        Class[] parameTypes = new Class[]{IObjectPK.class};
        BatchExecuteParamsEntry p = new BatchExecuteParamsEntry(parameTypes);
        p.add((Object)pk);
        BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[]{p};
        BatchExecuteResult result = this.batchAudit(ctx, paramEntries);
        this.throwException(result);
    }

    protected IVerifyManager getAuditVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        QMBillAuditCommonVerifyItem verifyItem = new QMBillAuditCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    public void lockData(Context ctx, String pk) throws BOSException {
        String tbl = this.getTableName(ctx);
        String dateStr = DateTimeUtils.format((Date)new Date());
        String sql = "update " + tbl + " set FLastUpdateTime= to_date('" + dateStr + "') where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{pk.toString()});
    }

    public void lockData(Context ctx, String[] pks) throws BOSException {
        String tbl = this.getTableName(ctx);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        String dateStr = DateTimeUtils.format((Date)new Date());
        sb.appendSql("update " + tbl + " set FLastUpdateTime= to_date('" + dateStr + "') where fid in (");
        sb.appendParam((Object[])pks);
        sb.appendSql(")");
        sb.execute(ctx);
    }

    public void lockData(Context ctx, IObjectPK[] pks) throws BOSException {
        Object[] aid = new String[pks.length];
        for (int i = 0; i < aid.length; ++i) {
            aid[i] = pks[i].toString();
        }
        String tbl = this.getTableName(ctx);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        String dateStr = DateTimeUtils.format((Date)new Date());
        sb.appendSql("update " + tbl + " set FLastUpdateTime= to_date('" + dateStr + "') where fid in (");
        sb.appendParam(aid);
        sb.appendSql(")");
        sb.execute(ctx);
    }

    public void lockData(Context ctx, List ids) throws BOSException {
        String tbl = this.getTableName(ctx);
        FMQuerySqlBuilder sql = new FMQuerySqlBuilder();
        String dateStr = DateTimeUtils.format((Date)new Date());
        sql.appendSql("update " + tbl + " set FLastUpdateTime= to_date('" + dateStr + "') ");
        sql.appendSql("where fid in (");
        sql.appendParam(ids.toArray());
        sql.appendSql(")");
        sql.execute(ctx);
    }

    @Override
    public void lockData(Context ctx, Set ids) throws BOSException {
        String tbl = this.getTableName(ctx);
        FMQuerySqlBuilder sql = new FMQuerySqlBuilder();
        String dateStr = DateTimeUtils.format((Date)new Date());
        sql.appendSql("update " + tbl + " set FLastUpdateTime=to_date('" + dateStr + "') ");
        sql.appendSql("where fid in (");
        sql.appendParam(ids.toArray());
        sql.appendSql(")");
        sql.execute(ctx);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        Class[] parameTypes = new Class[]{IObjectPK.class};
        BatchExecuteParamsEntry p = new BatchExecuteParamsEntry(parameTypes);
        p.add((Object)pk);
        BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[]{p};
        BatchExecuteResult result = this.batchUnAudit(ctx, paramEntries);
        this.throwException(result);
    }

    protected IVerifyManager getUnAuditVerifyManager(Context ctx, QMCoreBillBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        QMBillUnAuditCommonVerifyItem verifyItem = new QMBillUnAuditCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    public String getTableName(Context ctx) {
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(this.getBOSType());
        return entity.getTable().getName();
    }

    @Override
    public FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return super.getFilterForCheckNumber((CoreBillBaseInfo)model);
    }

    @Override
    public void audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            LogControllManager.getInstance().enableLog();
            super.audit(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    public BatchExecuteResult batchUnAudit(Context ctx, BatchExecuteParamsEntry[] paramEntries) throws BOSException, EASBizException {
        IServerBatchAction action = this.getBatchUnAuditAction(ctx);
        return this.doBatchExcuter(ctx, action, "batchUnAudit", paramEntries);
    }

    public BatchExecuteResult doBatchExcuter(Context ctx, IServerBatchAction action, String name, BatchExecuteParamsEntry[] paramEntries) throws EASBizException, BOSException {
        ServerEvent event = new ServerEvent();
        event.setEventName(name);
        event.setSrcObject(null);
        event.setParams(paramEntries);
        ServerActionManager serverActionManager = new ServerActionManager(name);
        serverActionManager.addServerAction(action);
        serverActionManager.fireServerAction(ctx, event);
        return (BatchExecuteResult)event.getResult();
    }

    public IServerBatchAction getBatchUnAuditAction(Context ctx) {
        BillBatchUnAuditAction action = new BillBatchUnAuditAction(this, this.getTableName(ctx));
        return action;
    }

    public BatchExecuteResult batchAudit(Context ctx, BatchExecuteParamsEntry[] paramEntries) throws BOSException, EASBizException {
        IServerBatchAction action = this.getBatchAuditAction(ctx);
        return this.doBatchExcuter(ctx, action, "batchAudit", paramEntries);
    }

    public IServerBatchAction getBatchAuditAction(Context ctx) {
        BillBatchAuditAction action = new BillBatchAuditAction(this, this.getTableName(ctx));
        return action;
    }

    @Override
    public void unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.unAudit(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    @Override
    public void mutexRequest(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean b = MutexServiceControlFactory.getLocalInstance((Context)ctx).requestObjIDForUpdate(pk.toString());
        if (!b) {
            throw new EASBizException(new NumericExceptionSubItem("100", ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request", (Locale)ctx.getLocale())));
        }
    }

    @Override
    protected void _logAddnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected SelectorItemCollection getPrepareDataSelector(SelectorItemCollection sic) {
        return sic;
    }

    public BatchExecuteResult batchingExecute(Context ctx, MetaDataPK methodPK, Method batchMethod, BatchExecuteParamsEntry[] paramEntries) throws BaseException {
        ServiceStateManager.getInstance().setServiceState(this.getServiceState());
        try {
            int i;
            BatchExecuteResult result = new BatchExecuteResult(paramEntries.length);
            ServiceContext[] arrSvcCtx = new ServiceContext[result.size()];
            for (int i2 = 0; i2 < arrSvcCtx.length; ++i2) {
                ServiceContext svcCtx = this.createServiceContext(methodPK, this.getParamValueArray(ctx, paramEntries[i2]));
                svcCtx.setExecutionMode(0);
                svcCtx.setBatchExctue(true);
                arrSvcCtx[i2] = svcCtx;
            }
            ServiceManagerFactory.getServiceManager().execute((IServiceContext[])arrSvcCtx);
            ArrayList<BatchExecuteParamsEntry> successedEntries = new ArrayList<BatchExecuteParamsEntry>();
            ArrayList<Integer> successedEntryIndex = new ArrayList<Integer>();
            for (int i3 = 0; i3 < arrSvcCtx.length; ++i3) {
                Throwable th = arrSvcCtx[i3].getServiceException();
                if (th == null) {
                    successedEntries.add(paramEntries[i3]);
                    successedEntryIndex.add(new Integer(i3));
                    continue;
                }
                result.setException(i3, th);
            }
            Object batchRtv = this.invoke(this, batchMethod, new Object[]{ctx, successedEntries.toArray(new BatchExecuteParamsEntry[0])});
            result.setBatchResult(batchRtv);
            if (batchRtv instanceof BatchExecuteResult) {
                for (int i4 = 0; i4 < successedEntryIndex.size(); ++i4) {
                    BatchExecuteResult batchRtv2 = (BatchExecuteResult)batchRtv;
                    int entryIndex = (Integer)successedEntryIndex.get(i4);
                    if (batchRtv2.exceptionOccured(i4)) {
                        arrSvcCtx[entryIndex] = null;
                    }
                    result.setException(entryIndex, batchRtv2.getException(i4));
                    result.setReturnValue(entryIndex, batchRtv2.getReturnValue(i4));
                }
            }
            for (i = 0; i < arrSvcCtx.length; ++i) {
                if (arrSvcCtx[i] == null) continue;
                if (arrSvcCtx[i].getServiceException() != null) {
                    arrSvcCtx[i] = null;
                    continue;
                }
                ServiceContext svcCtx = this.createServiceContext(methodPK, this.getParamValueArray(ctx, paramEntries[i]));
                svcCtx.setExecutionMode(1);
                svcCtx.setBatchExctue(true);
                arrSvcCtx[i] = svcCtx;
            }
            ServiceManagerFactory.getServiceManager().execute((IServiceContext[])arrSvcCtx);
            for (i = 0; i < arrSvcCtx.length; ++i) {
                Throwable th;
                if (arrSvcCtx[i] == null || (th = arrSvcCtx[i].getServiceException()) == null) continue;
                result.setException(i, th);
            }
            BatchExecuteResult batchExecuteResult = result;
            return batchExecuteResult;
        }
        catch (Throwable th) {
            this.setRollbackOnly();
            if (th instanceof BaseException) {
                throw (BaseException)th;
            }
            throw new BOSException(th);
        }
        finally {
            this.cleanUpServiceState();
        }
    }

    public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException iae) {
            throw new ReflectException((Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    public Object[] getParamValueArray(Context ctx, BatchExecuteParamsEntry entry) {
        Object[] params = new Object[entry.getParamTypes().length + 1];
        params[0] = ctx;
        Object[] entryItems = entry.toArray();
        System.arraycopy(entryItems, 0, params, 1, entryItems.length);
        return params;
    }

    protected void throwException(BatchExecuteResult result) throws BOSException, EASBizException {
        Throwable[] exceptions = result.getExceptions();
        if (null != exceptions && exceptions.length > 0) {
            Throwable th = exceptions[0];
            try {
                throw th;
            }
            catch (BOSException bosExp) {
                throw bosExp;
            }
            catch (EASBizException bizExp) {
                throw bizExp;
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    @Override
    protected void _close(Context ctx, List pks) throws BOSException, EASBizException {
        if (null == pks || pks.size() == 0) {
            return;
        }
        this.updateBillStatus(ctx, pks, QMBillBaseStatusEnum.CLOSED);
    }

    @Override
    protected void _unClose(Context ctx, List pks) throws BOSException, EASBizException {
        if (null == pks || pks.size() == 0) {
            return;
        }
        this.updateBillStatus(ctx, pks, QMBillBaseStatusEnum.Audit);
    }

    protected void updateBillStatus(Context ctx, List pks, QMBillBaseStatusEnum status) throws BOSException {
        if (null == pks || pks.size() == 0) {
            return;
        }
        StringBuffer strPks = new StringBuffer();
        for (int i = 0; i < pks.size(); ++i) {
            if (i > 0) {
                strPks.append("','");
            }
            strPks.append(pks.get(i).toString());
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update ");
        sql.append(this.getTableName(ctx));
        sql.append(" set FBillStatus=? ");
        sql.append(" where FID in ('").append(strPks).append("') ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(status.getValue())});
    }

    public class BillBatchAuditAction
    extends ServerBatchAuditAction {
        public BillBatchAuditAction(ISuportServerBatchAction bean, String tableName) {
            super(bean, tableName);
        }

        @Override
        protected IVerifyManager getVerifyManager(Context ctx, CoreBaseInfo info) {
            IVerifyManager verifymanager = super.getVerifyManager(ctx, info);
            QMCoreBillBaseInfo billInfo = (QMCoreBillBaseInfo)info;
            IVerifyManager manager = QMCoreBillBaseControllerBean.this.getAuditVerifyManager(ctx, billInfo);
            verifymanager.addChildrenManager(manager);
            return verifymanager;
        }

        @Override
        protected SelectorItemCollection getSelector() throws BOSException {
            SelectorItemCollection sic = super.getSelector();
            return QMCoreBillBaseControllerBean.this.getPrepareDataSelector(sic);
        }
    }

    public class BillBatchUnAuditAction
    extends ServerBatchUnAuditAction {
        public BillBatchUnAuditAction(ISuportServerBatchAction bean, String tableName) {
            super(bean, tableName);
        }

        @Override
        protected IVerifyManager getVerifyManager(Context ctx, CoreBaseInfo info) {
            IVerifyManager verifymanager = super.getVerifyManager(ctx, info);
            QMCoreBillBaseInfo billInfo = (QMCoreBillBaseInfo)info;
            QMBillUnAuditCommonVerifyItem verifyItem = new QMBillUnAuditCommonVerifyItem(billInfo);
            verifymanager.addVerifyItem(verifyItem);
            IVerifyManager manager = QMCoreBillBaseControllerBean.this.getUnAuditVerifyManager(ctx, billInfo);
            verifymanager.addChildrenManager(manager);
            return verifymanager;
        }

        @Override
        protected SelectorItemCollection getSelector() throws BOSException {
            SelectorItemCollection sic = super.getSelector();
            return QMCoreBillBaseControllerBean.this.getPrepareDataSelector(sic);
        }
    }

    public class BillBatchDeleteAction
    extends ServerBatchDeleteAction {
        public BillBatchDeleteAction(ISuportServerBatchAction bean) {
            super(bean);
        }

        @Override
        protected IVerifyManager getVerifyManager(Context ctx, CoreBaseInfo info) {
            IVerifyManager verifymanager = super.getVerifyManager(ctx, info);
            QMCoreBillBaseInfo billInfo = (QMCoreBillBaseInfo)info;
            IVerifyManager manager = QMCoreBillBaseControllerBean.this.getDeleteVerifyManager(ctx, billInfo);
            verifymanager.addChildrenManager(manager);
            return verifymanager;
        }
    }
}

