/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.app.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.common.app.action.IServerBatchAction;
import com.kingdee.eas.qm.common.app.action.ISuportServerBatchAction;
import com.kingdee.eas.qm.common.app.action.ServerEvent;
import com.kingdee.eas.qm.common.app.util.QMServerUtils;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.common.verify.IVerifyManager;
import com.kingdee.eas.qm.common.verify.VerifyManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class ServerBatchAction
implements IServerBatchAction {
    private ISuportServerBatchAction biz;
    private List dataSeq;
    String afterEventName = null;
    String beforeEventName = null;

    public ISuportServerBatchAction getBiz() {
        return this.biz;
    }

    public List getDataSeq() {
        return this.dataSeq;
    }

    public ServerBatchAction(ISuportServerBatchAction bean, String beforeEventName, String afterEventName) {
        this.biz = bean;
        this.beforeEventName = beforeEventName;
        this.afterEventName = afterEventName;
    }

    @Override
    public void handler(Context ctx, ServerEvent event) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] paramEntries = (BatchExecuteParamsEntry[])event.getParams();
        BatchExecuteResult result = new BatchExecuteResult(paramEntries.length);
        event.setResult(result);
        CoreBaseCollection successedColl = new CoreBaseCollection();
        if (null == paramEntries || paramEntries.length <= 0) {
            return;
        }
        this.dataSeq = ServerBatchAction.getIds(paramEntries);
        CoreBaseCollection tempCols = this.prepareData(ctx, paramEntries);
        successedColl.addCollection(tempCols);
        tempCols = this.beforeDoIt(ctx, result, tempCols);
        if (null == tempCols || tempCols.size() == 0) {
            return;
        }
        tempCols = this.doIt(ctx, result, tempCols);
        this.afterDoIt(ctx, result, tempCols);
        event.setResult(result);
    }

    public abstract CoreBaseCollection doIt(Context var1, BatchExecuteResult var2, CoreBaseCollection var3) throws BOSException, EASBizException;

    protected IVerifyManager getVerifyManager(Context ctx, CoreBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        return verifymanager;
    }

    protected CoreBaseCollection batchVerify(Context ctx, BatchExecuteResult result, CoreBaseCollection successedColl) throws BOSException {
        CoreBaseCollection rtnCol = new CoreBaseCollection();
        Object[] arr = null;
        if (null == successedColl || successedColl.size() == 0) {
            result.setException(0, (Throwable)((Object)new QMException(QMException.RECORDNOTEXIST)));
            return null;
        }
        arr = successedColl.toArray();
        for (int i = 0; i < arr.length; ++i) {
            CoreBaseInfo info = (CoreBaseInfo)arr[i];
            try {
                IVerifyManager verifymanager = this.getVerifyManager(ctx, info);
                verifymanager.verify();
            }
            catch (Exception e) {
                this.putException(result, info, e);
                continue;
            }
            rtnCol.add(info);
        }
        return rtnCol;
    }

    public void putException(BatchExecuteResult result, CoreBaseInfo info, Exception e) {
        int index = this.getDataIndex(info.getId().toString());
        if (index < 0) {
            return;
        }
        result.setException(index, (Throwable)e);
    }

    public void putException(BatchExecuteResult result, String id, Throwable e) {
        int index = this.getDataIndex(id);
        if (index < 0) {
            return;
        }
        result.setException(index, e);
    }

    public void putException(BatchExecuteResult result, CoreBaseCollection sucColl, CoreBaseInfo info, Exception e) {
        int index = this.getDataIndex(info.getId().toString());
        if (index < 0) {
            return;
        }
        result.setException(index, (Throwable)e);
        sucColl.remove(info);
    }

    public void putResult(BatchExecuteResult result, CoreBaseInfo info, Object rtnValue) {
        int index = this.getDataIndex(info.getId().toString());
        result.setReturnValue(index, rtnValue);
    }

    protected CoreBaseCollection beforeDoIt(Context ctx, BatchExecuteResult result, CoreBaseCollection successedColl) throws BOSException {
        CoreBaseCollection tempCols = this.batchVerify(ctx, result, successedColl);
        if (null != tempCols && tempCols.size() > 0) {
            for (int i = 0; i < tempCols.size(); ++i) {
                CoreBaseInfo info = tempCols.get(i);
                try {
                    this.biz.fireServerAction(ctx, (IObjectValue)info, this.beforeEventName);
                    continue;
                }
                catch (Exception e) {
                    this.putException(result, tempCols, info, e);
                }
            }
        }
        return tempCols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoreBaseCollection afterDoIt(Context ctx, BatchExecuteResult result, CoreBaseCollection successedColl) throws BOSException {
        CoreBaseCollection rtnCol = new CoreBaseCollection();
        for (int i = 0; i < successedColl.size(); ++i) {
            CoreBaseInfo info = successedColl.get(i);
            try {
                this.biz.fireServerAction(ctx, (IObjectValue)info, this.afterEventName);
            }
            catch (Exception ex) {
                this.putException(result, info, ex);
                continue;
            }
            finally {
                MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(info.getId().toString());
            }
            rtnCol.add(info);
        }
        return rtnCol;
    }

    protected CoreBaseCollection prepareData(Context ctx, BatchExecuteParamsEntry[] paramEntries) throws BOSException {
        ArrayList idList = ServerBatchAction.getIds(paramEntries);
        HashSet ids = new HashSet(idList);
        this.biz.lockData(ctx, ids);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelector());
        CoreBaseCollection coll = this.biz.getCollection(ctx, view);
        return QMServerUtils.sortCollection(coll, idList.toArray());
    }

    protected SelectorItemCollection getSelector() throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        return sic;
    }

    protected static ArrayList getIds(BatchExecuteParamsEntry[] paramEntries) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < paramEntries.length; ++i) {
            BatchExecuteParamsEntry entry = paramEntries[i];
            if (null == entry || null == entry.get(0)) continue;
            ids.add(paramEntries[i].get(0).toString());
        }
        return ids;
    }

    public static ArrayList getIds(CoreBaseCollection col) {
        ArrayList<String> ids = new ArrayList<String>();
        if (null == col || col.size() <= 0) {
            return null;
        }
        for (int i = 0; i < col.size(); ++i) {
            CoreBaseInfo info = col.get(i);
            ids.add(info.getId().toString());
        }
        return ids;
    }

    public int getDataIndex(String id) {
        int index = -1;
        if (QMStringUtils.isEmpty(id)) {
            return -1;
        }
        index = this.dataSeq.indexOf(id);
        return index;
    }

    protected void batchCheckMutex(Context ctx, BatchExecuteResult result, CoreBaseCollection successedColl) throws BOSException {
        if (successedColl == null || successedColl.size() == 0) {
            return;
        }
        Object[] arr = successedColl.toArray();
        for (int i = 0; i < arr.length; ++i) {
            CoreBaseInfo info = (CoreBaseInfo)arr[i];
            try {
                this.biz.mutexRequest(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
                continue;
            }
            catch (Exception ex) {
                String standardID = info.getId().toString();
                BOSUuid sduuid = BOSUuid.read((String)standardID);
                int index = successedColl.indexOf((Object)sduuid);
                if (index < 0) continue;
                successedColl.removeObject(index);
                this.putException(result, info, ex);
            }
        }
    }
}

