/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.codingrule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.qm.common.QMCoreBillBaseInfo;
import com.kingdee.eas.qm.common.codingrule.ISuportCodingRule;
import com.kingdee.eas.qm.common.codingrule.ISuportCodingRuleInfo;
import com.kingdee.eas.qm.common.codingrule.QMCodingRuleData;
import com.kingdee.eas.qm.common.util.QMEqualsUtils;
import com.kingdee.eas.qm.common.util.QMStringUtils;

public class ServerCodingRuleStrategy {
    /*
     * Enabled aggressive block sorting
     */
    public void initNumber(ISuportCodingRule bean, Context ctx, ISuportCodingRuleInfo info) throws BOSException, EASBizException {
        QMCodingRuleData codingRuleData = (QMCodingRuleData)info.get("codingRuleData");
        if (codingRuleData != null && codingRuleData.isExistRule()) {
            if (codingRuleData.isUseIntermitNumber()) {
                this.setNumber(bean, ctx, info);
                return;
            }
            if (codingRuleData.isAddView() && !codingRuleData.isModifable()) {
                if (!QMStringUtils.isEmpty(info.getNumber())) {
                    return;
                }
                this.setNumber(bean, ctx, info);
                return;
            }
            if (codingRuleData.isAddView() && codingRuleData.isModifable()) {
                String oldNumber = info.getString("oldNumber");
                if (QMEqualsUtils.equals(oldNumber, info.getNumber())) {
                    this.setNumber(bean, ctx, info);
                    return;
                }
                if (!QMStringUtils.isEmpty(info.getNumber())) {
                    return;
                }
                this.setNumber(bean, ctx, info);
                return;
            }
            if (codingRuleData.isAddView() && !codingRuleData.isUseIntermitNumber()) {
                this.setNumber(bean, ctx, info);
                return;
            }
            if (codingRuleData.isAddView()) return;
            this.setNumber(bean, ctx, info);
            return;
        }
        if (!QMStringUtils.isEmpty(info.getNumber())) {
            return;
        }
        this.setNumber(bean, ctx, info);
    }

    public void initEditNumber(ISuportCodingRule bean, Context ctx, ISuportCodingRuleInfo info) throws BOSException, EASBizException {
        QMCodingRuleData codingRuleData = (QMCodingRuleData)info.get("codingRuleData");
        if (codingRuleData != null && codingRuleData.isExistRule() && codingRuleData.isUseIntermitNumber() && codingRuleData.isModifable()) {
            String oldNumber = info.getString("oldNumber");
            if (QMEqualsUtils.equals(oldNumber, info.getNumber())) {
                return;
            }
            this.recycleNumber(ctx, (CoreBaseInfo)info, info.getMainOrgUnit().getId().toString());
            return;
        }
    }

    public void setNumber(ISuportCodingRule bean, Context ctx, ISuportCodingRuleInfo info) throws BOSException, CodingRuleException, EASBizException {
        if (info.getMainOrgUnit() == null) {
            return;
        }
        int i = 0;
        do {
            String numberSilent;
            if (QMStringUtils.isEmpty(numberSilent = this.getNumberSilent(ctx, info, info.getMainOrgUnit().getId().toString()))) {
                return;
            }
            info.setNumber(numberSilent);
        } while (bean.isNumberDup(ctx, null, info) && ++i < 10);
    }

    public String getNewNumberWhenBotpBill(Context ctx, QMCoreBillBaseInfo info) throws BOSException, EASBizException {
        String result = null;
        if (QMStringUtils.isEmpty(info.getNumber())) {
            result = info.getId() != null ? "AutoNumBTP_" + info.getId().toString() : "AutoNumBTP_" + BOSUuid.create((BOSObjectType)info.getBOSType());
        }
        return result;
    }

    public String getNumberSilent(Context ctx, ISuportCodingRuleInfo info, String companyId) throws BOSException, CodingRuleException, EASBizException {
        if (info == null || companyId == null || companyId.equals("")) {
            return null;
        }
        String result = null;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo codingRuleInfo = codingRuleManager.getCodingRule((IObjectValue)info, companyId);
        if (null != codingRuleInfo) {
            result = codingRuleManager.getNumber((IObjectValue)info, codingRuleInfo);
        } else if (info instanceof QMCoreBillBaseInfo && ((QMCoreBillBaseInfo)info).isBotpCallSave()) {
            result = this.getNewNumberWhenBotpBill(ctx, (QMCoreBillBaseInfo)info);
        }
        return result;
    }

    public void recycleNumber(Context ctx, CoreBaseInfo info, String companyId) {
        if (info == null || companyId == null || companyId.equals("")) {
            return;
        }
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (codingRuleManager.isExist((IObjectValue)info, companyId) && codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId)) {
                codingRuleManager.recycleNumber((IObjectValue)info, companyId, info.getString("number"));
            }
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }
}

