/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.ctx;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.fi.gl.GLUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.qm.common.ctx.IQMContextHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.HashMap;
import org.apache.log4j.Logger;

final class QMRemoteContextHelperWithCtx
implements IQMContextHelper {
    private static Logger logger = Logger.getLogger((String)QMRemoteContextHelperWithCtx.class.getName());
    public static final String resClassName = "com.kingdee.eas.fm.common.FMResource";
    private Context ctx;

    public QMRemoteContextHelperWithCtx(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public CompanyOrgUnitInfo getCurrentCompany() {
        CompanyOrgUnitInfo companyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)this.ctx);
        if (companyOrgUnitInfo == null) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"currenctCompanyNotEmpty"));
            SysUtil.abort();
        }
        if (companyOrgUnitInfo.getAccountTable() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"currenctCompanyAcctTableNull"));
            SysUtil.abort();
        }
        return companyOrgUnitInfo;
    }

    @Override
    public CtrlUnitInfo getCurrentCtrlUnit() {
        CtrlUnitInfo companyOrgUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)this.ctx);
        if (companyOrgUnitInfo == null) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"currenctCUNotEmpty"));
            SysUtil.abort();
        }
        return companyOrgUnitInfo;
    }

    @Override
    public CurrencyInfo getCompanyBaseCurrency(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CurrencyInfo currency = null;
        if (company == null) {
            return null;
        }
        if (company.getBaseCurrency() != null) {
            return company.getBaseCurrency();
        }
        ICompanyOrgUnit corgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("baseCurrency.*");
        CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selectors);
        currency = info.getBaseCurrency();
        return currency;
    }

    @Override
    public UserInfo getCurrentUser() {
        return ContextUtil.getCurrentUserInfo((Context)this.ctx);
    }

    @Override
    public String getSessionID() {
        return SysContext.getSysContext().getSessionID();
    }

    @Override
    public boolean isOnlyUnion(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (company.containsKey("isOnlyUnion")) {
            return GLUtil.isCompanyUnion((CompanyOrgUnitInfo)company);
        }
        ICompanyOrgUnit corgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("isOnlyUnion");
        CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selectors);
        return GLUtil.isCompanyUnion((CompanyOrgUnitInfo)info);
    }

    @Override
    public int getIntParam(String key, IObjectPK orgPK) {
        int rst = 0;
        String value = this.getStringParam(key, orgPK);
        if (EmptyUtil.isEmpty((String)value)) {
            return 0;
        }
        rst = Integer.parseInt(value);
        return rst;
    }

    @Override
    public String getStringParam(String key, IObjectPK orgPK) {
        HashMap<String, IObjectPK> map = new HashMap<String, IObjectPK>();
        map.put(key, orgPK);
        String value = null;
        try {
            IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
            HashMap param = iParamControl.getParamHashMap(map);
            value = (String)param.get(key);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return value;
    }

    @Override
    public boolean getBooleanParam(String key, IObjectPK orgPK) {
        String value = this.getStringParam(key, orgPK);
        boolean rst = Boolean.valueOf(value);
        return rst;
    }

    public Object[] getAllCompany() {
        try {
            return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection().toArray();
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public AdminOrgUnitInfo getCurrentAdmin() {
        AdminOrgUnitInfo orgInfo = ContextUtil.getCurrentAdminUnit((Context)this.ctx);
        if (orgInfo == null) {
            MsgBox.showWarning((String)"currenctAdminNotEmpty");
            SysUtil.abort();
        }
        return orgInfo;
    }

    @Override
    public QualityOrgUnitInfo getCurrentQuality() {
        QualityOrgUnitInfo companyOrgUnitInfo = ContextUtil.getCurrentQualityUnit((Context)this.ctx);
        if (companyOrgUnitInfo == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.qm.common.COMMONAutoGenerateResource", (String)"21_QMContextHelper"));
            SysUtil.abort();
        }
        return companyOrgUnitInfo;
    }
}

