/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.filter;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.qm.common.QMSysDefinedEnum;
import com.kingdee.eas.qm.common.filter.FilterElement;
import com.kingdee.eas.qm.common.filter.IDataCaster;
import com.kingdee.eas.qm.common.filter.QueryFilterManagerUtils;
import com.kingdee.eas.qm.common.util.QMConstant;
import com.kingdee.eas.qm.common.util.QMEqualsUtils;
import com.kingdee.eas.qm.common.util.backup.QMGroupClientUtils;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class SingleFilterElement
extends FilterElement {
    private static Logger logger = Logger.getLogger((String)SingleFilterElement.class.getName());
    private Component component = null;
    private CompareType compareType = CompareType.EQUALS;
    private String strSql = null;
    private boolean isExistQMark = false;

    public SingleFilterElement(String compareExp, Component component) {
        super(compareExp);
        this.component = component;
    }

    public SingleFilterElement(String compareExp, Component component, Object blankValue) {
        super(compareExp, blankValue);
        this.component = component;
    }

    public SingleFilterElement(String compareExp, Component component, String strSql, boolean isExistQMark) {
        super(compareExp);
        this.component = component;
        this.strSql = strSql;
        this.isExistQMark = isExistQMark;
    }

    @Override
    public void clear() {
        this.setCValue(this.getDefaultValue());
    }

    public CompareType getCompareType() {
        return this.compareType;
    }

    public void setCompareType(CompareType compareType) {
        this.compareType = compareType;
    }

    public String getCValue() {
        if (this.component instanceof KDBizPromptBox) {
            KDBizPromptBox comp = (KDBizPromptBox)this.component;
            if (comp.getValue() == this.getBlankValue()) {
                return null;
            }
            Object data = comp.getData();
            String result = this.getProperty(data, "id");
            return result;
        }
        if (this.component instanceof KDComboBox) {
            KDComboBox comp = (KDComboBox)this.component;
            Object selectedItem = comp.getSelectedItem();
            if (selectedItem == this.getBlankValue()) {
                return null;
            }
            if (selectedItem instanceof IntEnum) {
                if (selectedItem == QMSysDefinedEnum.ALL_ITEMS) {
                    return null;
                }
                IntEnum s = (IntEnum)selectedItem;
                return String.valueOf(s.getValue());
            }
        } else {
            if (this.component instanceof KDDatePicker) {
                KDDatePicker comp = (KDDatePicker)this.component;
                Object o = comp.getValue();
                if (o == null) {
                    return null;
                }
                String userInfo = this.getUserInfo("type");
                if (userInfo != null && userInfo.equals("end")) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime((Date)o);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    return QMConstant.getFormatTime().format(cal.getTime());
                }
                return QMConstant.getFormatDay().format(o);
            }
            if (this.component instanceof KDTextField) {
                KDTextField comp = (KDTextField)this.component;
                String o = comp.getText();
                if (o == null || o.trim().length() == 0) {
                    return null;
                }
                return o;
            }
            if (this.component instanceof KDCheckBox) {
                KDCheckBox comp = (KDCheckBox)this.component;
                String o = String.valueOf(comp.isSelected());
                return o;
            }
            if (this.component instanceof KDRadioButton) {
                KDRadioButton radioBtn = (KDRadioButton)this.component;
                String o = String.valueOf(radioBtn.isSelected());
                return o;
            }
        }
        return null;
    }

    @Override
    public String getValue() {
        if (this.component instanceof KDBizPromptBox) {
            KDBizPromptBox comp = (KDBizPromptBox)this.component;
            String key = this.getUserInfo("key");
            if (key == null) {
                key = "id";
            }
            if (comp.getValue() == this.getBlankValue()) {
                return null;
            }
            Object data = comp.getData();
            String result = this.getProperty(data, key);
            return result;
        }
        if (this.component instanceof KDComboBox) {
            KDComboBox comp = (KDComboBox)this.component;
            Object selectedItem = comp.getSelectedItem();
            if (selectedItem == this.getBlankValue()) {
                return null;
            }
            if (selectedItem instanceof IntEnum) {
                if (selectedItem == QMSysDefinedEnum.ALL_ITEMS) {
                    return null;
                }
                IntEnum s = (IntEnum)selectedItem;
                return String.valueOf(s.getValue());
            }
        } else {
            if (this.component instanceof KDDatePicker) {
                KDDatePicker comp = (KDDatePicker)this.component;
                Object o = comp.getValue();
                if (o == null) {
                    return null;
                }
                String userInfo = this.getUserInfo("type");
                if (userInfo != null && userInfo.equals("end")) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime((Date)o);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    return QMConstant.getFormatTime().format(cal.getTime());
                }
                return QMConstant.getFormatDay().format(o);
            }
            if (this.component instanceof KDTextField) {
                KDTextField comp = (KDTextField)this.component;
                String o = comp.getText();
                if (o == null || o.trim().length() == 0) {
                    return null;
                }
                return o;
            }
            if (this.component instanceof KDCheckBox) {
                KDCheckBox comp = (KDCheckBox)this.component;
                String trueValue = this.getUserInfo("trueValue");
                if (trueValue != null) {
                    if (comp.isSelected()) {
                        return trueValue;
                    }
                    return "0";
                }
                String falseequalall = this.getUserInfo("falseEqualAll");
                String o = this.getDefaultValue();
                if (falseequalall == null) {
                    o = String.valueOf(comp.isSelected());
                } else if (comp.isSelected()) {
                    o = String.valueOf(comp.isSelected());
                }
                return o;
            }
        }
        return null;
    }

    private String getProperty(Object data, String key) {
        StringBuffer result = new StringBuffer("");
        if (data instanceof CoreBaseInfo) {
            result.append("," + ((CoreBaseInfo)data).getString(key).toString());
        } else if (data instanceof Object[]) {
            Object[] o = (Object[])data;
            for (int i = 0; i < o.length; ++i) {
                result = result.append("," + this.getProperty(o[i], key));
            }
        } else if (data instanceof String) {
            result.append(data);
        }
        return result.toString().startsWith(",") ? result.toString().substring(1) : result.toString();
    }

    @Override
    public CustomerParams getElementValue() {
        String value = this.getCValue();
        CustomerParams cst = new CustomerParams();
        if (value == null) {
            return cst;
        }
        cst.addCustomerParam(this.getId(), value);
        return cst;
    }

    @Override
    public void setElementValue(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        String o = cp.getCustomerParam(this.getId());
        this.setCValue(o);
    }

    public void setCValue(String o) {
        if (this.component instanceof KDBizPromptBox) {
            KDBizPromptBox comp = (KDBizPromptBox)this.component;
            if (comp.getCommitParser() == null) {
                QueryFilterManagerUtils.setData(this.component, o);
                return;
            }
            if (comp.isEnabledMultiSelection()) {
                Object[] coll = QMGroupClientUtils.getObjectCollection(o);
                QueryFilterManagerUtils.setData(this.component, coll);
            } else {
                IObjectValue info = null;
                info = QMGroupClientUtils.getObjectValue(o);
                QueryFilterManagerUtils.setData(this.component, info);
            }
        } else if (this.component instanceof KDComboBox) {
            KDComboBox comp = (KDComboBox)this.component;
            for (int i = 0; i < comp.getItemCount(); ++i) {
                Object obj = comp.getItemAt(i);
                if (!(obj instanceof IntEnum)) continue;
                if (o == null) {
                    comp.setSelectedItem((Object)QMSysDefinedEnum.ALL_ITEMS);
                    return;
                }
                IntEnum intobj = (IntEnum)obj;
                if (!QMEqualsUtils.equals(String.valueOf(intobj.getValue()), o)) continue;
                comp.setSelectedItem(obj);
                return;
            }
        } else if (this.component instanceof KDDatePicker) {
            KDDatePicker comp = (KDDatePicker)this.component;
            if (o == null && comp.isSupportedEmpty()) {
                comp.setValue(null);
                return;
            }
            try {
                Date d = null;
                d = this.getUserInfo("type") != null && this.getUserInfo("type").equals("end") ? (o.length() == 10 ? QMConstant.getFormatDay().parse(o) : QMConstant.getFormatTime().parse(o)) : QMConstant.getFormatDay().parse(o);
                comp.setValue((Object)d);
            }
            catch (ParseException e) {
                logger.error((Object)e);
            }
        } else if (this.component instanceof KDTextField) {
            KDTextField comp = (KDTextField)this.component;
            comp.setText(o);
        } else if (this.component instanceof KDCheckBox) {
            KDCheckBox comp = (KDCheckBox)this.component;
            boolean isSel = Boolean.valueOf(o);
            comp.setSelected(isSel);
        } else if (this.component instanceof KDRadioButton) {
            KDRadioButton comp = (KDRadioButton)this.component;
            boolean isSel = Boolean.valueOf(o);
            comp.setSelected(isSel);
        }
    }

    @Override
    public FilterInfo getFilterInfo() {
        return this.doGetFilterInfo();
    }

    public FilterInfo doGetFilterInfo() {
        String value = this.getValue();
        if (value == null || value.length() == 0) {
            return null;
        }
        if ((value = this.getCustomerExtValue(value)) == null || value.length() == 0) {
            return null;
        }
        Object newValue = this.cast(value);
        FilterInfo filterInfo = new FilterInfo();
        String compareExp = this.getCompareExp();
        CompareType compareType2 = this.getCompareType();
        if (compareType2 == CompareType.INNER && this.strSql != null) {
            String strInSql = this.strSql;
            if (this.isExistQMark) {
                int index = strInSql.indexOf(63);
                String strF = strInSql.substring(0, index);
                String strE = strInSql.substring(index + 1, strInSql.length());
                strInSql = strF.concat(value).concat(strE);
            }
            FilterItemInfo itemInfo = new FilterItemInfo(compareExp, (Object)strInSql, compareType2);
            filterInfo.getFilterItems().add(itemInfo);
            return filterInfo;
        }
        if (this.component instanceof KDBizPromptBox) {
            KDBizPromptBox comp = (KDBizPromptBox)this.component;
            if (comp.isEnabledMultiSelection()) {
                FilterItemInfo itemInfo = new FilterItemInfo(compareExp, (Object)value, CompareType.INCLUDE);
                filterInfo.getFilterItems().add(itemInfo);
                return filterInfo;
            }
            FilterItemInfo itemInfo = new FilterItemInfo(compareExp, (Object)value, compareType2);
            filterInfo.getFilterItems().add(itemInfo);
            return filterInfo;
        }
        if (this.component instanceof KDComboBox) {
            FilterItemInfo itemInfo = new FilterItemInfo(compareExp, (Object)value, compareType2);
            filterInfo.getFilterItems().add(itemInfo);
            return filterInfo;
        }
        if (this.component instanceof KDCheckBox) {
            FilterItemInfo itemInfo = new FilterItemInfo(compareExp, newValue, compareType2);
            filterInfo.getFilterItems().add(itemInfo);
            return filterInfo;
        }
        if (this.component instanceof KDDatePicker) {
            FilterItemInfo itemInfo = new FilterItemInfo(compareExp, (Object)value, compareType2);
            filterInfo.getFilterItems().add(itemInfo);
            return filterInfo;
        }
        if (compareType2 == CompareType.LIKE && value != null) {
            FilterItemInfo itemInfo = new FilterItemInfo(compareExp, (Object)("%" + value + "%"), compareType2);
            filterInfo.getFilterItems().add(itemInfo);
            return filterInfo;
        }
        FilterItemInfo itemInfo = new FilterItemInfo(compareExp, (Object)value, compareType2);
        filterInfo.getFilterItems().add(itemInfo);
        return filterInfo;
    }

    private Object cast(String value) {
        IDataCaster dc = this.getDataCaster();
        if (dc != null) {
            return dc.cast(value);
        }
        return value;
    }

    public String getCustomerExtValue(String value) {
        return value;
    }
}

