/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.print;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.IPrintIntegration;
import com.kingdee.eas.basedata.assistant.PrintIntegrationFactory;
import com.kingdee.eas.basedata.assistant.PrintIntegrationInfo;
import com.kingdee.eas.common.client.SysContext;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class QMPrintIntegrationHelper {
    public static final String Key_PrintQuery = "PrintQuery";
    private static Logger logger = Logger.getLogger(QMPrintIntegrationHelper.class);
    private KDNoteHelper kdNotePrinter = null;
    private BOSObjectType bosType = null;
    private String tdPath = "";
    private List dataIdList = null;
    private Map printedErrorMap = new HashMap();
    private Map willPrintedErrorMap = new HashMap();

    public Map getPrintedErrorMap() {
        return this.printedErrorMap;
    }

    public Map getWillPrintedErrorMap() {
        return this.willPrintedErrorMap;
    }

    public QMPrintIntegrationHelper(KDNoteHelper kdNotePrinter, BOSObjectType bosType, List dataIdList, String tdPath) {
        this.kdNotePrinter = kdNotePrinter;
        this.bosType = bosType;
        this.tdPath = tdPath;
        this.dataIdList = dataIdList;
    }

    public void doInvokePrintIntegration() {
        try {
            String tempBillID;
            IPrintIntegration pinfo = PrintIntegrationFactory.getRemoteInstance();
            BOSObjectType bosType = this.getBosType();
            List printedInfoList = pinfo.getBillsPrintInfoByList(this.dataIdList, bosType.toString());
            Iterator<Object> it = this.dataIdList.iterator();
            ArrayList<PrintIntegrationInfo> updatePrintInfoList = new ArrayList<PrintIntegrationInfo>();
            while (it.hasNext()) {
                String string = it.next().toString();
                PrintIntegrationInfo printInfo = this.hasPrinted(string, bosType, printedInfoList);
                if (printInfo == null) {
                    printInfo = this.createNewPrintIntegrationInfo(string, this.getBosType());
                }
                if (!this.isPrintable(printInfo)) continue;
                int curNum = this.kdNotePrinter.getCopies();
                printInfo.setPrintedNumber(printInfo.getPrintedNumber() + curNum);
                printInfo.setLastPrintTime(new Timestamp(System.currentTimeMillis()));
                printInfo.setLastPrintUser(SysContext.getSysContext().getCurrentUserInfo());
                updatePrintInfoList.add(printInfo);
            }
            for (Map.Entry entry : this.printedErrorMap.entrySet()) {
                tempBillID = (String)entry.getKey();
                this.dataIdList.remove(tempBillID);
            }
            for (Map.Entry entry : this.willPrintedErrorMap.entrySet()) {
                tempBillID = (String)entry.getKey();
                this.dataIdList.remove(tempBillID);
            }
            if (this.dataIdList.size() == 0) {
                this.kdNotePrinter.diposePrint();
            }
            if (updatePrintInfoList.size() > 0) {
                pinfo.updateBillsPrintInfoByList(updatePrintInfoList);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.kdNotePrinter.diposePrint();
        }
    }

    public PrintIntegrationInfo hasPrinted(String billID, BOSObjectType bosType, List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        for (PrintIntegrationInfo info : list) {
            if (info == null || !billID.equals(info.getPrintBillID()) || !bosType.toString().equals(info.getPrintBosType())) continue;
            return info;
        }
        return null;
    }

    public PrintIntegrationInfo createNewPrintIntegrationInfo(String billID, BOSObjectType bosType) throws Exception {
        PrintIntegrationInfo tinfo = new PrintIntegrationInfo();
        tinfo.setPrintBillID(billID);
        tinfo.setPrintBosType(bosType.toString());
        tinfo.setPrintedNumber(0);
        tinfo.setLastPrintTime(new Timestamp(System.currentTimeMillis()));
        tinfo.setLastPrintUser(SysContext.getSysContext().getCurrentUserInfo());
        return tinfo;
    }

    public boolean isTDPathCtrl() throws KDRSException {
        return this.kdNotePrinter.isPrintTimesControllable2(this.tdPath);
    }

    public boolean isPrintable(PrintIntegrationInfo info) throws Exception {
        if (this.isTDPathCtrl()) {
            String billID = info.getPrintBillID();
            int pnum = info.getPrintedNumber();
            int maxNum = this.kdNotePrinter.getMaxPrintTimes2(this.tdPath);
            int curNum = this.kdNotePrinter.getCopies();
            String errorMsg = String.valueOf(pnum) + "#" + String.valueOf(maxNum) + "#" + String.valueOf(curNum);
            if (pnum >= maxNum) {
                this.printedErrorMap.put(billID, errorMsg);
                return false;
            }
            if (curNum + pnum > maxNum) {
                this.willPrintedErrorMap.put(billID, errorMsg);
                return false;
            }
        }
        return true;
    }

    public String getTDFileName() {
        return this.tdPath;
    }

    public BOSObjectType getBosType() {
        return this.bosType;
    }

    public static int getPrintNum(Context ctx, BOSObjectType bosType, String billID) throws Exception {
        IPrintIntegration ibiz = ctx == null ? PrintIntegrationFactory.getRemoteInstance() : PrintIntegrationFactory.getLocalInstance((Context)ctx);
        PrintIntegrationInfo printInfo = ibiz.getBillPrintInfo(bosType.toString(), billID);
        return printInfo != null ? printInfo.getPrintedNumber() : 0;
    }

    public static IMetaDataPK getPrintIntegrationQueryPK() {
        return new MetaDataPK("com.kingdee.eas.basedata.assistant", "CommonPrintQuery");
    }
}

