/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.print;

import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.qm.common.QMCommonFacadeFactory;
import com.kingdee.eas.qm.common.print.QMPrintActionAdapter;
import com.kingdee.eas.qm.common.print.QMPrintIntegrationHelper;
import java.util.List;
import java.util.Map;

public class QMTDPrintActionListener
extends QMPrintActionAdapter {
    private KDNoteHelper kdNotePrinter = null;
    private BOSObjectType bosType = null;
    private String tdPath = "";
    private List dataIdList = null;
    private boolean hasPrinted = false;
    private QMPrintIntegrationHelper printIntegrationHelper;
    private String printTDItemName = null;

    public QMTDPrintActionListener(KDNoteHelper kdNotePrinter, BOSObjectType bosType, List dataIdList, String tdPath, String printTDItemName) {
        this.kdNotePrinter = kdNotePrinter;
        this.bosType = bosType;
        this.tdPath = tdPath;
        this.dataIdList = dataIdList;
        this.printTDItemName = printTDItemName;
        this.printIntegrationHelper = new QMPrintIntegrationHelper(this.kdNotePrinter, this.bosType, this.dataIdList, this.tdPath);
    }

    @Override
    public void beforePrint() {
        this.hasPrinted = true;
        this.printIntegrationHelper.doInvokePrintIntegration();
        this.doLog();
    }

    public void doLog() {
        if (this.bosType == null || this.dataIdList == null || this.dataIdList.size() == 0) {
            return;
        }
        try {
            QMCommonFacadeFactory.getRemoteInstance().writeTDPrintLog(this.dataIdList, this.bosType, this.printTDItemName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Map getPrintedErrorMap() {
        return this.printIntegrationHelper.getPrintedErrorMap();
    }

    public Map getWillPrintedErrorMap() {
        return this.printIntegrationHelper.getWillPrintedErrorMap();
    }

    public boolean hasPrinted() {
        return this.hasPrinted;
    }
}

