/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.material.TimeUnitEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.QMCoreBillBaseInfo;
import com.kingdee.eas.qm.qc.QCRejectProcessException;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class QMUtils {
    public static BOSObjectType getSourceBillType(QMCoreBillBaseInfo model) {
        String srcbillid;
        if (model.getSourceBillType() == null) {
            return null;
        }
        BOSObjectType srcType = null;
        if (model != null && model.getSourceBillId() != null) {
            String src = model.getSourceBillId();
            BOSUuid id = BOSUuid.read((String)src);
            srcType = id.getType();
            return srcType;
        }
        if (model.getQMBillEntrys() != null && model.getQMBillEntrys().size() > 0 && (srcbillid = model.getQMBillEntrys().get(0).getSourceBillID()) != null) {
            BOSUuid id = BOSUuid.read((String)srcbillid);
            srcType = id.getType();
        }
        return srcType;
    }

    public static Integer getDayNumber(TimeUnitEnum unit, int unitValue) {
        if (unit == TimeUnitEnum.YEAR) {
            return new Integer(unitValue * 365);
        }
        if (unit == TimeUnitEnum.MONTH) {
            return new Integer(unitValue * 30);
        }
        if (unit == TimeUnitEnum.DAY) {
            return new Integer(unitValue);
        }
        return new Integer(0);
    }

    public static void setComponentEnable(Component[] comps, boolean isEnable) {
        if (null == comps || comps.length <= 0) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            if (null == comp) continue;
            comp.setEnabled(isEnable);
        }
    }

    public static void setComponentAccessAuthEnable(Component[] comps, boolean isEnable) {
        if (null == comps || comps.length <= 0) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            if (null == comp) continue;
            comp.setEnabled(isEnable);
            if (!(comp instanceof KDBizPromptBox)) continue;
            if (isEnable) {
                ((IKDTextComponent)((KDBizPromptBox)comp).getEditor()).setAccessAuthority(0);
                ((KDBizPromptBox)comp).setAccessAuthority(0);
                continue;
            }
            ((IKDTextComponent)((KDBizPromptBox)comp).getEditor()).setAccessAuthority(1);
            ((KDBizPromptBox)comp).setAccessAuthority(1);
        }
    }

    public static CurrencyInfo getBaseCurrency(Context ctx, String mainOrgID) throws BOSException, EASBizException {
        CurrencyInfo currencyInfo = null;
        if (StringUtils.isEmpty((String)mainOrgID)) {
            return null;
        }
        OrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrgID));
        CompanyOrgUnitInfo company = null;
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrgID));
        } else {
            Iterator iter;
            IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            company = (CompanyOrgUnitInfo)iOrgRelation.getDefaultToUnit(mainOrgID, 32, 1);
            OrgUnitCollection collection = iOrgRelation.getToUnit(mainOrgID, 32, 1);
            if (null != collection && collection.size() > 0 && (iter = collection.iterator()).hasNext()) {
                company = (CompanyOrgUnitInfo)iter.next();
            }
        }
        if (null == company) {
            throw new QCRejectProcessException(QCRejectProcessException.HASNOTDELECOMPANY);
        }
        currencyInfo = company.getBaseCurrency();
        if (null == currencyInfo) {
            throw new QCRejectProcessException(QCRejectProcessException.HASNOTBASECURRENCY);
        }
        return currencyInfo;
    }

    public static Map getDefaultSolutionAsMap(String queryUiName, String queryName) throws BOSException, EASBizException, Exception {
        QueryPanelInfo queryPanelInfo;
        String customerParams;
        QueryPanelCollection queryInfos;
        IQuerySolutionFacade iQuery;
        QuerySolutionInfo querySolution;
        HashMap parmaMap = new HashMap();
        if (queryUiName != null && (querySolution = (iQuery = QuerySolutionFacadeFactory.getRemoteInstance()).getDefaultSolution(queryUiName, queryName)) != null && (queryInfos = querySolution.getQueryPanelInfo()) != null && queryInfos.size() > 0 && (customerParams = (queryPanelInfo = queryInfos.get(0)).getCustomerParams()) != null) {
            CustomerParams cp = new CustomerParams();
            cp = XMLBean.transStrToCommonCustParams((String)customerParams);
            QMUtils.transCustParamsToMap(cp, parmaMap);
        }
        return parmaMap;
    }

    public static void transCustParamsToMap(CustomerParams cp, Map parmaMap) {
        if (cp != null && cp.getKeys() != null && cp.getKeys().size() > 0) {
            HashMap cpMap = cp.getCustomerParamsHashMap();
            Object[] keys = cpMap.keySet().toArray();
            int size = keys.length;
            for (int i = 0; i < size; ++i) {
                Object tempCP = cpMap.get(keys[i]);
                if (tempCP instanceof CustomerParams) {
                    QMUtils.transCustParamsToMap((CustomerParams)tempCP, parmaMap);
                    continue;
                }
                parmaMap.put(keys[i], tempCP);
            }
        }
    }
}

