/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.common.util.backup;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceManager;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.qm.common.QMBillBaseInfo;
import com.kingdee.eas.qm.common.QMBillException;
import com.kingdee.eas.qm.common.util.backup.QMCommonUtils;
import com.kingdee.eas.qm.common.util.backup.QMMetadataCommonUtils;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class QMBizServerUtils {
    private static Logger logger = Logger.getLogger((String)QMBizServerUtils.class.getName());

    protected OrgUnitCollection _getAuthOrgsByRelation(Context ctx, OrgType srcOrgType, OrgType destOrgType, String orgPK, IMetaDataPK queryPK) throws BOSException, EASBizException {
        OrgUnitCollection temp = null;
        String permItem = null;
        OrgUnitCollection result = QMBizServerUtils.getOrgsByRelation(ctx, srcOrgType, destOrgType, orgPK);
        if (result != null && result.size() > 0 && (permItem = QMBizServerUtils.getPermissionItem(ctx, queryPK)) != null && (temp = QMBizServerUtils.getAuthOrgByPermItem(ctx, srcOrgType, permItem)) != null) {
            int i;
            ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
            for (i = 0; i < temp.size(); ++i) {
                list.add(temp.get(i).getId());
            }
            for (i = 0; i < result.size(); ++i) {
                if (list.contains(result.get(i).getId())) continue;
                result.remove(result.get(i));
                --i;
            }
        }
        return result;
    }

    protected OrgUnitCollection _getAuthOrgsByType(Context ctx, OrgType orgType, IMetaDataPK queryPK) throws BOSException, EASBizException {
        String permItem = QMBizServerUtils.getPermissionItem(ctx, queryPK);
        OrgUnitCollection collection = QMBizServerUtils.getAuthOrgByPermItem(ctx, orgType, permItem);
        return null;
    }

    public static OrgUnitCollection getOrgsByRelation(Context ctx, OrgType srcOrgType, OrgType destOrgType, String orgPK) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        int iSrcOrg = srcOrgType.getValue();
        int iDestOrg = destOrgType.getValue();
        switch (iSrcOrg) {
            case 0: {
                return iDestOrg == 1 ? iOrgRelation.getToUnit(orgPK, iSrcOrg, iDestOrg) : iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 1: {
                return iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 2: {
                if (iDestOrg == 4) {
                    return iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
                }
                if (iDestOrg == 3) {
                    return null;
                }
                return iOrgRelation.getToUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 3: {
                if (iDestOrg == 1) {
                    return iOrgRelation.getToUnit(orgPK, iSrcOrg, iDestOrg);
                }
                if (iDestOrg == 2) {
                    return null;
                }
                return iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 4: {
                return iOrgRelation.getToUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 24: {
                if (iDestOrg != 4) break;
                return iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
            }
        }
        return null;
    }

    public static String getPermissionItem(Context context, IMetaDataPK pk) throws BOSException, EASBizException {
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(context);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.BASEQUERY, pk);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                String permItemName;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)(permItemName = bind[i].getName()))) continue;
                return permItemName;
            }
        }
        return null;
    }

    public static OrgUnitCollection getAuthOrgByPermItem(Context context, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = PermissionFactory.getLocalInstance((Context)context);
        FullOrgUnitCollection result = permission.getAuthorizedOrg(context.getCaller(), orgType, null, permItem);
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    public static CompanyOrgUnitCollection getUserOrgRanges(Context ctx) throws EASBizException, BOSException {
        UserInfo user;
        HashSet<String> idSet = new HashSet<String>();
        FullOrgUnitCollection coll = null;
        if (ctx == null) {
            user = SysContext.getSysContext().getCurrentUserInfo();
            coll = OrgSwitchFacadeFactory.getRemoteInstance().getOrgRanges((IObjectPK)new ObjectUuidPK(user.getId()));
        } else {
            user = SysContext.getSysContext().getCurrentUserInfo();
            coll = OrgSwitchFacadeFactory.getLocalInstance((Context)ctx).getOrgRanges((IObjectPK)new ObjectUuidPK(user.getId()));
        }
        for (int i = 0; i < coll.size(); ++i) {
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)coll.getObject(i);
            if (!orgUnit.isIsCompanyOrgUnit()) continue;
            idSet.add(orgUnit.getId().toString());
        }
        if (idSet.size() == 0) {
            return new CompanyOrgUnitCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        if (ctx == null) {
            return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        }
        return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
    }

    public static CompanyOrgUnitCollection getUserOrgRangesWithRange(Context ctx, String permissionItem) throws BOSException, EASBizException {
        IPermission permission;
        HashSet<String> idSet = new HashSet<String>();
        UserInfo userInfo = null;
        if (ctx == null) {
            userInfo = SysContext.getSysContext().getCurrentUserInfo();
            permission = PermissionFactory.getRemoteInstance();
        } else {
            userInfo = SysContext.getSysContext().getCurrentUserInfo();
            permission = PermissionFactory.getLocalInstance((Context)ctx);
        }
        FullOrgUnitCollection mainOrgs = permission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, null, permissionItem);
        for (int i = 0; i < mainOrgs.size(); ++i) {
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)mainOrgs.getObject(i);
            idSet.add(orgUnit.getId().toString());
        }
        if (idSet.size() == 0) {
            return new CompanyOrgUnitCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter2 = new FilterInfo();
        view.setFilter(filter2);
        filter2.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("isGroup");
        sic.add("baseCurrency.id");
        sic.add("baseCurrency.number");
        sic.add("baseCurrency.name");
        sic.add("accountTable.id");
        sic.add("accountTable.name");
        sic.add("isSealUp");
        sic.add("isBizUnit");
        if (ctx == null) {
            return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        }
        return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
    }

    public static boolean isAdmin(Context ctx, UserInfo user) throws EASBizException, BOSException {
        if (user == null) {
            return false;
        }
        return user != null && user.getId().equals((Object)QMBizServerUtils.getAdmin(ctx).getId());
    }

    public static UserInfo getAdmin(Context ctx) throws EASBizException, BOSException {
        UserInfo adminUser = null;
        if (adminUser == null) {
            adminUser = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000013B7DE7F"));
        }
        return adminUser;
    }

    public static PersonCollection getPersonColl(Context ctx, String adminOrgUnitId) throws BOSException, EASBizException {
        Set ids = QMBizServerUtils.getPersonIds(ctx, adminOrgUnitId);
        if (ids == null || ids.isEmpty()) {
            return new PersonCollection();
        }
        IPerson iPerson = null;
        iPerson = ctx == null ? PersonFactory.getRemoteInstance() : PersonFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return iPerson.getPersonCollection(evi);
    }

    public static String getCUId(Context ctx, String strCompanyId) throws BOSException, EASBizException {
        ICompanyOrgUnit company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo comInfo = company.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(strCompanyId));
        String strCUId = comInfo.getCU().getId().toString();
        return strCUId;
    }

    public static CompanyOrgUnitInfo getCompanyOrgByOrgUnit(OrgUnitInfo orgUnitInfo) throws EASBizException, BOSException {
        if (orgUnitInfo == null) {
            return null;
        }
        IOrgUnitCommon iOrgCommon = OrgUnitCommonFactory.getRemoteInstance();
        CompanyOrgUnitInfo companyInfo = iOrgCommon.getCompany(orgUnitInfo.getId());
        return companyInfo;
    }

    public static Set getPersonIds(Context ctx, String adminOrgUnitId) throws BOSException {
        HashSet<String> personIds = new HashSet<String>();
        if (QMCommonUtils.isEmpty(adminOrgUnitId)) {
            return personIds;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("position.adminOrgUnit.id", (Object)adminOrgUnitId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IPositionMember iPositionMember = null;
        iPositionMember = ctx == null ? PositionMemberFactory.getRemoteInstance() : PositionMemberFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection coll = iPositionMember.getPositionMemberCollection(evi);
        if (coll == null || coll.isEmpty()) {
            return personIds;
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            personIds.add(coll.get(i).getPerson().getId().toString());
        }
        return personIds;
    }

    public static void validateMaterialInfo(Context ctx, OrgType orgType, String orgId, String[] materialIds) throws Exception {
        IRowSet resultSet;
        block25: {
            FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
            resultSet = null;
            StringBuffer sqlParams = new StringBuffer();
            int c = materialIds.length;
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("'");
                sqlParams.append(materialIds[i]);
                sqlParams.append("'");
            }
            try {
                String materialName;
                IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
                ObjectUuidPK pk = new ObjectUuidPK(fullOrgUnitInfo.getCU().getId().toString());
                FilterInfo filterInfo = iMaterial.getDatabaseDFilter((IObjectPK)pk, "FID", "FAdminCUID");
                StringBuffer materialBuffer = new StringBuffer();
                materialBuffer.append(" select fid,fname_").append(SysContext.getSysContext().getLocale()).append(" from ").append(" T_BD_Material ").append(" where fid in(").append(sqlParams.toString()).append(")").append(" and ").append(filterInfo.toString());
                resultSet = DbUtil.executeQuery((Context)ctx, (String)materialBuffer.toString());
                StringBuffer noFitMaterialNameBuffer = new StringBuffer();
                while (resultSet.next()) {
                    String materialName2 = resultSet.getString(2);
                    String id = resultSet.getString(1);
                    if (sqlParams.indexOf(id) >= 0) continue;
                    if (noFitMaterialNameBuffer.length() > 0) {
                        noFitMaterialNameBuffer.append(",");
                    }
                    noFitMaterialNameBuffer.append(materialName2);
                }
                if (noFitMaterialNameBuffer.length() > 0) {
                    throw new MaterialBaseException(MaterialBaseException.ORGVIEWMATERIALFORBIDEN, (Object[])new String[]{noFitMaterialNameBuffer.toString()});
                }
                if (orgType.equals((Object)OrgType.Company)) {
                    StringBuffer companyBuffer = new StringBuffer();
                    companyBuffer.append(" select material.fid,material.fname_").append(SysContext.getSysContext().getLocale()).append(" from ").append(" T_BD_Material material").append(" inner join T_BD_MaterialCompanyInfo companyInfo on material.FID = companyInfo.FMaterial").append(" where material.FID in(").append(sqlParams.toString()).append(")").append(" and companyInfo.FCompanyID in ('").append(orgId).append("'").append(",'").append(fullOrgUnitInfo.getCU().getId().toString()).append("')");
                    resultSet = DbUtil.executeQuery((Context)ctx, (String)companyBuffer.toString());
                    noFitMaterialNameBuffer = new StringBuffer();
                    while (resultSet.next()) {
                        materialName = resultSet.getString(2);
                        String id = resultSet.getString(1);
                        if (sqlParams.indexOf(id) >= 0) continue;
                        if (noFitMaterialNameBuffer.length() > 0) {
                            noFitMaterialNameBuffer.append(",");
                        }
                        noFitMaterialNameBuffer.append(materialName);
                    }
                    if (noFitMaterialNameBuffer.length() > 0) {
                        throw new MaterialBaseException(MaterialBaseException.ORGNOTMAINTAINMATEIALCOMPANY, (Object[])new String[]{noFitMaterialNameBuffer.toString()});
                    }
                    break block25;
                }
                if (orgType.equals((Object)OrgType.Purchase)) {
                    StringBuffer purchaseBuffer = new StringBuffer();
                    purchaseBuffer.append(" select material.fid,material.fname_").append(SysContext.getSysContext().getLocale()).append(" from ").append(" T_BD_Material material").append(" inner join T_BD_MaterialPurchasing purchaseInfo on material.FID = purchaseInfo.FMaterialID").append(" where material.FID in(").append(sqlParams.toString()).append(")").append(" and purchaseInfo.FOrgUnit in ('").append(orgId).append("'").append(",'").append(fullOrgUnitInfo.getCU().getId().toString()).append("')");
                    resultSet = DbUtil.executeQuery((Context)ctx, (String)purchaseBuffer.toString());
                    noFitMaterialNameBuffer = new StringBuffer();
                    while (resultSet.next()) {
                        materialName = resultSet.getString(2);
                        String id = resultSet.getString(1);
                        if (sqlParams.indexOf(id) >= 0) continue;
                        if (noFitMaterialNameBuffer.length() > 0) {
                            noFitMaterialNameBuffer.append(",");
                        }
                        noFitMaterialNameBuffer.append(materialName);
                    }
                    if (noFitMaterialNameBuffer.length() > 0) {
                        throw new MaterialBaseException(MaterialBaseException.ORGNOTMAINTAINMATEIALPURCHASE, (Object[])new String[]{noFitMaterialNameBuffer.toString()});
                    }
                    break block25;
                }
                if (orgType.equals((Object)OrgType.Sale)) {
                    StringBuffer saleBuffer = new StringBuffer();
                    saleBuffer.append(" select material.fid,material.fname_").append(SysContext.getSysContext().getLocale()).append(" from ").append(" T_BD_Material material").append(" inner join T_BD_MaterialSales saleInfo on material.FID = saleInfo.FMaterialID").append(" where material.FID in(").append(sqlParams.toString()).append(")").append(" and saleInfo.FOrgUnit in ('").append(orgId).append("'").append(",'").append(fullOrgUnitInfo.getCU().getId().toString()).append("')");
                    resultSet = DbUtil.executeQuery((Context)ctx, (String)saleBuffer.toString());
                    noFitMaterialNameBuffer = new StringBuffer();
                    while (resultSet.next()) {
                        materialName = resultSet.getString(2);
                        String id = resultSet.getString(1);
                        if (sqlParams.indexOf(id) >= 0) continue;
                        if (noFitMaterialNameBuffer.length() > 0) {
                            noFitMaterialNameBuffer.append(",");
                        }
                        noFitMaterialNameBuffer.append(materialName);
                    }
                    if (noFitMaterialNameBuffer.length() > 0) {
                        throw new MaterialBaseException(MaterialBaseException.ORGNOTMAINTAINMATEIALSALE, (Object[])new String[]{noFitMaterialNameBuffer.toString()});
                    }
                    break block25;
                }
                if (orgType.equals((Object)OrgType.Storage)) {
                    StringBuffer inventoryBuffer = new StringBuffer();
                    inventoryBuffer.append(" select material.fid,material.fname_").append(SysContext.getSysContext().getLocale()).append(" from ").append(" T_BD_Material material").append(" inner join T_BD_MaterialInventory inventory on material.FID = inventory.FMaterialID").append(" where material.FID in(").append(sqlParams.toString()).append(")").append(" and inventory.FOrgUnit in ('").append(orgId).append("'").append(",'").append(fullOrgUnitInfo.getCU().getId().toString()).append("')");
                    resultSet = DbUtil.executeQuery((Context)ctx, (String)inventoryBuffer.toString());
                    noFitMaterialNameBuffer = new StringBuffer();
                    while (resultSet.next()) {
                        materialName = resultSet.getString(2);
                        String id = resultSet.getString(1);
                        if (sqlParams.indexOf(id) >= 0) continue;
                        if (noFitMaterialNameBuffer.length() > 0) {
                            noFitMaterialNameBuffer.append(",");
                        }
                        noFitMaterialNameBuffer.append(materialName);
                    }
                    if (noFitMaterialNameBuffer.length() > 0) {
                        throw new MaterialBaseException(MaterialBaseException.ORGNOTMAINTAINMATEIALINVENTARY, (Object[])new String[]{noFitMaterialNameBuffer.toString()});
                    }
                    break block25;
                }
                throw new SCMBillException(SCMBillException.ORGTYPEERROE);
            }
            catch (SQLException e) {
                try {
                    throw new Exception(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(resultSet);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet);
    }

    public void updateAuditStatus(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        String tableName = QMMetadataCommonUtils.getMainTableName(ctx, model);
        if (tableName == null) {
            throw new BOSException("table name is null!");
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            QMBillBaseInfo aQMBillBaseInfo = (QMBillBaseInfo)model;
            PreparedStatement preStmt = null;
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append("Update ");
            sqlBuff.append(tableName);
            sqlBuff.append(" SET FAuditTime = ?, FAuditorID = ? , FBaseStatus = ? ");
            sqlBuff.append(" WHERE FID = ? ");
            preStmt = conn.prepareStatement(sqlBuff.toString());
            Date now = new Date();
            preStmt.setTimestamp(1, new Timestamp(now.getTime()));
            UserInfo aUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            preStmt.setString(2, aUserInfo.getId().toString());
            preStmt.setString(4, aQMBillBaseInfo.getId().toString());
            preStmt.execute();
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public void updateUnAuditStatus(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        String tableName = QMMetadataCommonUtils.getMainTableName(ctx, model);
        if (tableName == null) {
            throw new BOSException("table name is null!");
        }
        QMBillBaseInfo aQMBillBaseInfo = (QMBillBaseInfo)model;
        Connection conn = null;
        PreparedStatement preStmt = null;
        Statement sm = null;
        try {
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append("Update ");
            sqlBuff.append(tableName);
            sqlBuff.append(" SET FAuditTime = ?, FAuditorID = ? , FBaseStatus = ? ");
            sqlBuff.append(" WHERE FID = ? ");
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement(sqlBuff.toString());
            preStmt.setTimestamp(1, null);
            preStmt.setString(2, null);
            preStmt.setString(4, aQMBillBaseInfo.getId().toString());
            preStmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preStmt, conn);
                SQLUtils.cleanup(sm, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preStmt, (Connection)conn);
        SQLUtils.cleanup(sm, (Connection)conn);
    }

    public static void updateUnAuditStatus(Context ctx, CoreBaseCollection coreBaseCollection) throws BOSException, EASBizException {
        if (coreBaseCollection == null || coreBaseCollection.size() <= 0) {
            return;
        }
        Connection conn = null;
        Statement preStmt = null;
        QMBillBaseInfo aQMBillBaseInfo = null;
        String tableName = null;
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append("Update ");
        sqlBuff.append(tableName);
        sqlBuff.append(" SET FAuditTime = ?, FAuditorID = ? , FBaseStatus = ? ");
        sqlBuff.append(" WHERE FID = ? ");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            for (int i = 0; i < coreBaseCollection.size(); ++i) {
                aQMBillBaseInfo = (QMBillBaseInfo)coreBaseCollection.get(i);
                tableName = QMMetadataCommonUtils.getMainTableName(ctx, aQMBillBaseInfo);
                if (tableName == null) {
                    throw new BOSException("table name is null!");
                }
                preStmt = conn.prepareStatement(sqlBuff.toString());
                Date now = new Date();
                preStmt.setTimestamp(1, new Timestamp(now.getTime()));
                UserInfo aUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                preStmt.setString(2, aUserInfo.getId().toString());
                preStmt.setString(4, aQMBillBaseInfo.getId().toString());
                preStmt.addBatch();
            }
            preStmt.executeBatch();
            preStmt.close();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preStmt, (Connection)conn);
    }

    public static void updateAuditStatus(Context ctx, CoreBaseCollection baseInfoCollection) throws BOSException, EASBizException {
        if (baseInfoCollection == null || baseInfoCollection.size() <= 0) {
            return;
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            Statement preStmt = null;
            QMBillBaseInfo aQMBillBaseInfo = null;
            String tableName = null;
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append("Update ");
            sqlBuff.append(tableName);
            sqlBuff.append(" SET FAuditTime = ?, FAuditorID = ? , FBaseStatus = ? ");
            sqlBuff.append(" WHERE FID = ? ");
            for (int i = 0; i < baseInfoCollection.size(); ++i) {
                aQMBillBaseInfo = (QMBillBaseInfo)baseInfoCollection.get(i);
                tableName = QMMetadataCommonUtils.getMainTableName(ctx, (IObjectValue)baseInfoCollection.get(i));
                if (tableName == null) {
                    throw new BOSException("table name is null!");
                }
                preStmt = conn.prepareStatement(sqlBuff.toString());
                Date now = new Date();
                preStmt.setTimestamp(1, new Timestamp(now.getTime()));
                UserInfo aUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                preStmt.setString(2, aUserInfo.getId().toString());
                preStmt.setString(4, aQMBillBaseInfo.getId().toString());
                preStmt.addBatch();
            }
            preStmt.executeBatch();
            preStmt.close();
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (EASBizException e) {
            throw e;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected boolean isAuditAfterSubmit(Context ctx, QMBillBaseInfo info, String orgUnitID, int orgType) throws BOSException, EASBizException {
        boolean isAutoAudit = false;
        if (info.getBillType() != null) {
            // empty if block
        }
        return isAutoAudit;
    }

    protected boolean isUnAudit(Context ctx, QMBillBaseInfo info, String orgUnitID, int orgType) throws BOSException, EASBizException {
        boolean isUnAudit = false;
        if (info.getBillType() != null) {
            // empty if block
        }
        return isUnAudit;
    }

    public static void saveBOTRelation(Context ctx, Map idMap) throws BOSException {
        if (idMap == null || idMap.isEmpty()) {
            return;
        }
        BOTRelationInfo relateInfo = null;
        String srcBillId = null;
        String destBillId = null;
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        for (Map.Entry entry : idMap.entrySet()) {
            srcBillId = (String)entry.getKey();
            destBillId = (String)entry.getValue();
            relateInfo = new BOTRelationInfo();
            relateInfo.setSrcEntityID(BOSUuid.read((String)srcBillId).getType().toString());
            relateInfo.setDestEntityID(BOSUuid.read((String)destBillId).getType().toString());
            relateInfo.setSrcObjectID(srcBillId);
            relateInfo.setDestObjectID(destBillId);
            relateInfo.setDate(new Date());
            relateInfo.setOperatorID("unknown");
            relateInfo.setIsEffected(true);
            relateInfo.setType(0);
            iBOTRelation.addnew(relateInfo);
        }
    }

    public static void saveBOTRelation(Context ctx, List srcIdList, String destBillId) throws BOSException {
        if (srcIdList == null || srcIdList.isEmpty() || destBillId == null || "".equals(destBillId.trim())) {
            return;
        }
        String srcBillId = null;
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        int size = srcIdList.size();
        for (int i = 0; i < size; ++i) {
            BOTRelationInfo relateInfo = new BOTRelationInfo();
            srcBillId = (String)srcIdList.get(i);
            relateInfo.setSrcEntityID(BOSUuid.read((String)srcBillId).getType().toString());
            relateInfo.setDestEntityID(BOSUuid.read((String)destBillId).getType().toString());
            relateInfo.setSrcObjectID(srcBillId);
            relateInfo.setDestObjectID(destBillId);
            relateInfo.setDate(new Date());
            relateInfo.setOperatorID("unknown");
            relateInfo.setIsEffected(true);
            relateInfo.setType(0);
            iBOTRelation.addnew(relateInfo);
        }
    }

    public static IObjectCollection botpTransfromSave(Context ctx, CoreBillBaseCollection srcBillColl, BOSObjectType destObjType) throws BOSException, EASBizException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = iBTPManager.transformMultiBill(srcBillColl, destObjType.toString());
        IObjectCollection destBillColl = result.getBills();
        BOTRelationCollection botRelateColl = result.getBOTRelationCollection();
        CoreBillBaseInfo destBillInfo = null;
        int size = destBillColl.size();
        for (int i = 0; i < size; ++i) {
            destBillInfo = (CoreBillBaseInfo)destBillColl.getObject(i);
            iBTPManager.saveRelations(destBillInfo, botRelateColl);
        }
        return destBillColl;
    }

    public static IObjectCollection botpTransfromSubmit(Context ctx, CoreBillBaseCollection srcBillColl, BOSObjectType destObjType) throws BOSException, EASBizException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = iBTPManager.transformMultiBill(srcBillColl, destObjType.toString());
        IObjectCollection destBillColl = result.getBills();
        BOTRelationCollection botRelateColl = result.getBOTRelationCollection();
        CoreBillBaseInfo destBillInfo = null;
        int size = destBillColl.size();
        for (int i = 0; i < size; ++i) {
            destBillInfo = (CoreBillBaseInfo)destBillColl.getObject(i);
            iBTPManager.submitRelations(destBillInfo, botRelateColl);
        }
        return destBillColl;
    }

    private static Set getSrcBillIdSet(Context ctx, Set destBillIdSet) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destBillIdSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        IBOTRelation iBOTRelation = null;
        iBOTRelation = ctx != null ? BOTRelationFactory.getLocalInstance((Context)ctx) : BOTRelationFactory.getRemoteInstance();
        BOTRelationCollection relateColl = iBOTRelation.getCollection(evi);
        HashSet<String> idSet = new HashSet<String>();
        int size = relateColl.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(relateColl.get(i).getSrcObjectID());
        }
        return idSet;
    }

    public static Set getDestBillIdSet(Context ctx, String srcBillId) throws BTPException, BOSException {
        IBTPManager iBTPManager = null;
        iBTPManager = ctx == null ? BTPManagerFactory.getRemoteInstance() : BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection relateColl = iBTPManager.getDestRelation(srcBillId);
        HashSet<String> idSet = new HashSet<String>();
        if (relateColl == null || relateColl.size() < 1) {
            return idSet;
        }
        int size = relateColl.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(relateColl.get(i).getDestObjectID());
        }
        return idSet;
    }

    public static Set getSrcBillIdCollBySrcId(Context ctx, String srcBillId) throws BTPException, BOSException {
        Set destBillIdSet = QMBizServerUtils.getDestBillIdSet(ctx, srcBillId);
        return QMBizServerUtils.getSrcBillIdSet(ctx, destBillIdSet);
    }

    public static Map getDestBillIDSet(Context ctx, Set srcBillIDSet) throws BTPException, BOSException {
        IBOTRelation iBTPRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("relationEntries.*"));
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)srcBillIDSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        BOTRelationCollection botRc = iBTPRelation.getCollection(viewInfo);
        int size = botRc.size();
        BOTRelationInfo botR = null;
        HashMap hm = new HashMap();
        for (int i = 0; i < size; ++i) {
            botR = botRc.get(i);
            if (hm.get(botR.getSrcObjectID()) == null) {
                HashSet<String> destIDSet = new HashSet<String>();
                destIDSet.add(botR.getDestObjectID());
                hm.put(botR.getSrcObjectID(), destIDSet);
                continue;
            }
            ((Set)hm.get(botR.getSrcObjectID())).add(botR.getDestObjectID());
        }
        return hm;
    }

    public static Set getSrcBillIdSet(Context ctx, String destBillId) throws BOSException {
        HashSet<String> destBillIdSet = new HashSet<String>();
        destBillIdSet.add(destBillId);
        return QMBizServerUtils.getSrcBillIdSet(ctx, destBillIdSet);
    }

    public static boolean hasWFInstance(Context ctx, String billId) throws BOSException {
        boolean hasWorkflow = false;
        if (billId != null) {
            IEnactmentService service2 = EnactmentServiceFactory.createRemoteEnactService();
            ProcessInstInfo instInfo = null;
            ProcessInstInfo[] procInsts = service2.getProcessInstanceByHoldedObjectId(billId);
            int n = procInsts.length;
            for (int i = 0; i < n; ++i) {
                if (!"open.running".equals(procInsts[i].getState())) continue;
                instInfo = procInsts[i];
            }
            hasWorkflow = instInfo != null;
        }
        return hasWorkflow;
    }

    public static boolean hasNumber(Context ctx, CoreBaseInfo info, String companyId) {
        if (info == null || companyId == null || companyId.equals("")) {
            return false;
        }
        boolean result = false;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            result = codingRuleManager.isExist((IObjectValue)info, companyId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void initNumber(Context ctx, BillBaseInfo info, AbstractCoreBaseControllerBean controller) throws BOSException, EASBizException {
        FilterInfo filter;
        if (!QMCommonUtils.isEmpty(info.getNumber())) {
            return;
        }
        int i = 0;
        do {
            String numberSilent;
            if (QMCommonUtils.isEmpty(numberSilent = QMBizServerUtils.getNumberSilent(ctx, (CoreBaseInfo)info, info.getCompany().getId().toString()))) {
                return;
            }
            info.setNumber(numberSilent);
        } while (controller.exists(ctx, filter = QMBizServerUtils.getCheckNumberDupFilter((IObjectValue)info, true)) && ++i < 10);
    }

    public static String getNumberSilent(Context ctx, CoreBaseInfo info, String companyId) throws BOSException, CodingRuleException, EASBizException {
        if (info == null || companyId == null || companyId.equals("")) {
            return null;
        }
        String result = null;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        result = codingRuleManager.getNumber((IObjectValue)info, companyId);
        return result;
    }

    public static void initNumber(Context ctx, DataBaseInfo info, String companyId, AbstractCoreBaseControllerBean controller) throws BOSException, EASBizException {
        FilterInfo filter;
        if (!QMCommonUtils.isEmpty(info.getNumber())) {
            return;
        }
        int i = 0;
        do {
            String numberSilent;
            if (QMCommonUtils.isEmpty(numberSilent = QMBizServerUtils.getNumberSilent(ctx, (CoreBaseInfo)info, companyId))) {
                return;
            }
            info.setNumber(numberSilent);
        } while (controller.exists(ctx, filter = QMBizServerUtils.getCheckNumberDupFilter((IObjectValue)info, true)) && ++i < 10);
    }

    public static FilterInfo getCheckNumberDupFilter(IObjectValue model, boolean isNeedComp) {
        FilterInfo filter = new FilterInfo();
        if (isNeedComp) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)model.getObjectValue("company").getBOSUuid("id")));
        }
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)model.getString("number")));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getBOSUuid("id"), CompareType.NOTEQUALS));
        return filter;
    }

    public static FilterInfo getCheckSeqDupFilter(IObjectValue model, boolean isNeedComp, String seqName) {
        FilterInfo filter = new FilterInfo();
        if (isNeedComp) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)model.getObjectValue("company").getBOSUuid("id")));
        }
        filter.getFilterItems().add(new FilterItemInfo(seqName, (Object)model.getString(seqName)));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getBOSUuid("id"), CompareType.NOTEQUALS));
        return filter;
    }

    public static void recycleNumber(Context ctx, CoreBaseInfo info, String companyId) {
        if (info == null || companyId == null || companyId.equals("")) {
            return;
        }
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (codingRuleManager.isExist((IObjectValue)info, companyId) && codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId)) {
                codingRuleManager.recycleNumber((IObjectValue)info, companyId, info.getString("number"));
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    public boolean isClosed(Context ctx, IObjectValue model, boolean isOk) throws EASBizException, BOSException {
        QMBillBaseInfo aQMBillBaseInfo = (QMBillBaseInfo)model;
        if (aQMBillBaseInfo.getBillStatus() != null) {
            if (isOk) {
                if (aQMBillBaseInfo.getBillStatus().getValue() == 7) {
                    throw new QMBillException(QMBillException.CHECKCLOSEDOK, new Object[]{aQMBillBaseInfo.getString("number"), ""});
                }
            } else if (aQMBillBaseInfo.getBillStatus().getValue() != 7) {
                throw new QMBillException(QMBillException.CHECKCLOSEDNOTOK, new Object[]{aQMBillBaseInfo.getString("number"), ""});
            }
        }
        return true;
    }
}

