/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.b2b.app.PurOrderB2BUtil;
import java.util.HashSet;

public class PurOrderUpLoadAndUpdateProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 1L;

    public PurOrderUpLoadAndUpdateProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurOrderUpLoadAndUpdateProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public PurOrderUpLoadAndUpdateProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection objCol = batchResults.getObjCollection();
        if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            this.uploadPurOrder2Cloud(objCol);
        } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            this.updateNetPurOrderStatus(objCol);
        }
    }

    private void uploadPurOrder2Cloud(IObjectCollection objCol) throws BOSException, EASBizException {
        PurOrderInfo purOrder = null;
        PurOrderCollection coll = this.getPurOrderCollection(objCol);
        int count = coll.size();
        for (int i = 0; i < count; ++i) {
            purOrder = coll.get(i);
            if (!purOrder.getBoolean("isNetOrder")) continue;
            PurOrderB2BUtil.uploadOrderInfo(this.ctx, purOrder);
        }
    }

    private void updateNetPurOrderStatus(IObjectCollection objCol) throws BOSException, EASBizException {
        PurOrderInfo purOrder = null;
        PurOrderCollection coll = this.getPurOrderCollection(objCol);
        int count = coll.size();
        for (int i = 0; i < count; ++i) {
            purOrder = coll.get(i);
            if (!purOrder.getBoolean("isNetOrder")) continue;
            PurOrderB2BUtil.updateOrderStatus(this.ctx, purOrder, PurOrderB2BUtil.OrderStatusEnum.disabled, "\u8ba2\u5355\u88ab\u53cd\u5ba1\u6838");
        }
    }

    private PurOrderCollection getPurOrderCollection(IObjectCollection objCol) throws BOSException {
        HashSet<String> idsSet = new HashSet<String>();
        PurOrderInfo info = null;
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            info = (PurOrderInfo)objCol.getObject(i);
            if (info == null) continue;
            idsSet.add(info.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idsSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selectColl = new SelectorItemCollection();
        selectColl.add(new SelectorItemInfo("id"));
        selectColl.add(new SelectorItemInfo("supplier.id"));
        selectColl.add(new SelectorItemInfo("supplier.number"));
        selectColl.add(new SelectorItemInfo("supplier.name"));
        selectColl.add(new SelectorItemInfo("totalAmount"));
        selectColl.add(new SelectorItemInfo("isNetOrder"));
        selectColl.add(new SelectorItemInfo("companyOrgUnit.id"));
        selectColl.add(new SelectorItemInfo("entries.id"));
        selectColl.add(new SelectorItemInfo("entries.netQuotationItemId"));
        selectColl.add(new SelectorItemInfo("entries.material.id"));
        selectColl.add(new SelectorItemInfo("entries.material.number"));
        selectColl.add(new SelectorItemInfo("entries.material.name"));
        selectColl.add(new SelectorItemInfo("entries.materialName"));
        selectColl.add(new SelectorItemInfo("entries.price"));
        selectColl.add(new SelectorItemInfo("entries.qty"));
        view.setSelector(selectColl);
        return PurOrderFactory.getLocalInstance((Context)this.ctx).getPurOrderCollection(view);
    }
}

