/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.sm.pur.b2b.BuyOfferStatusEnum;
import com.kingdee.eas.scm.sm.pur.b2b.QuotationStatusEnum;
import com.kingdee.eas.scm.sm.pur.b2b.app.AbstractBuyOfferManagerFacadeControllerBean;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class BuyOfferManagerFacadeControllerBean
extends AbstractBuyOfferManagerFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.b2b.app.BuyOfferManagerFacadeControllerBean");

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        if (tempTable != null) {
            this.dropTempTable(params.getString("tempTable"), ctx);
            logger.info((Object)("\u5220\u9664\u4e34\u65f6\u8868\uff1a" + tempTable));
        }
        tempTable = this.createTempTable(ctx, this.getCreateTable());
        logger.info((Object)("\u672c\u6b21\u521b\u5efa\u521b\u5efa\u4e34\u65f6\u8868\uff1a" + tempTable));
        HashSet<String> compOrgs = new HashSet<String>();
        Object obj = params.getObject("comOrg");
        if (obj != null) {
            if (obj instanceof Object[]) {
                Object[] objects;
                for (Object object : objects = (Object[])obj) {
                    if (object == null || !(object instanceof OrgUnitInfo)) continue;
                    OrgUnitInfo company = (OrgUnitInfo)object;
                    compOrgs.add(company.getId().toString());
                }
            } else if (obj instanceof OrgUnitInfo) {
                OrgUnitInfo company = (OrgUnitInfo)obj;
                compOrgs.add(company.getId().toString());
            }
        }
        this.updateBuyOfferStatus(compOrgs, ctx);
        FilterInfo filterInfo = new FilterInfo();
        if (!compOrgs.isEmpty()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("pur.FCompanyOrgUnitID", compOrgs, CompareType.INCLUDE));
        }
        String buyOfferId = params.getString("id");
        String buyTitle = params.getString("title");
        if (buyOfferId != null && buyOfferId.trim().length() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bu.Fpurchasenoteid", (Object)("%" + buyOfferId + "%"), CompareType.LIKE));
        }
        if (buyTitle != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bu.Ftitle", (Object)("%" + buyTitle + "%"), CompareType.LIKE));
        }
        Date gmtDateFrom = (Date)params.getObject("gmtDateFROM");
        Date gmtDateTo = (Date)params.getObject("gmtDateTo");
        if (gmtDateFrom != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bu.FGmtCreate", (Object)this.getStartTime(gmtDateFrom), CompareType.GREATER_EQUALS));
        }
        if (gmtDateTo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bu.FGmtCreate", (Object)this.getEndTime(gmtDateTo), CompareType.LESS_EQUALS));
        }
        BuyOfferStatusEnum bStatus = (BuyOfferStatusEnum)((Object)params.getObject("status"));
        String strStatus = null;
        if (bStatus != null && !BuyOfferStatusEnum.NONE.equals((Object)bStatus)) {
            strStatus = BuyOfferStatusEnum.END.equals((Object)bStatus) ? "end" : "sent";
        }
        String strQoStatus = null;
        QuotationStatusEnum quoStatus = (QuotationStatusEnum)((Object)params.getObject("quoStatus"));
        if (quoStatus != null) {
            strQoStatus = QuotationStatusEnum.NONE.equals((Object)quoStatus) ? null : (QuotationStatusEnum.NO.equals((Object)quoStatus) ? "no" : "yes");
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("insert into " + tempTable + "\t\n");
        sqlBuffer.append("(FId,FpurOrderId,FTitle,FGmtDate,FquotationExpire,Fstatus,FqtyQuotation,FCompanyId,FwebOrderId,FpurOrderNumber)\r\n");
        sqlBuffer.append("select distinct \r\n");
        sqlBuffer.append(" bu.Fpurchasenoteid as FId, \r\n");
        sqlBuffer.append(" purOrder.FId as FEasOrderId,\r\n");
        sqlBuffer.append(" bu.Ftitle as Ftitle,\r\n");
        sqlBuffer.append(" bu.FGmtcreate as FGmtDate,\r\n");
        sqlBuffer.append(" bu.FgmtquotationExpire as FQuotationExpire,\r\n");
        sqlBuffer.append(" case bu.fstatus when 'end' then '\u91c7\u8d2d\u7ed3\u675f' else '\u63a5\u53d7\u62a5\u4ef7\u4e2d' end as Fstatus,\r\n");
        sqlBuffer.append(" case tquoQty.count when  null then 0 else  tquoQty.count end as FqtyQuotation,\r\n");
        sqlBuffer.append(" pur.FCompanyOrgUnitID as FCompanyId, \r\n");
        sqlBuffer.append(" purOrder.FNetOrderId as FWebOrderId,\r\n");
        sqlBuffer.append(" purOrder.Fnumber as FEasOrder \r\n");
        sqlBuffer.append("  from t_sm_buyofferali as \"bu\" \r\n");
        sqlBuffer.append("  left outer join (select FBuyofferid,count(FBuyofferid) as count from t_sm_quotationali where Fquostatus='1' group by FBuyofferid) as \"tquoQty\" on\r\n");
        sqlBuffer.append("  bu.Fpurchasenoteid = tquoQty.FBuyofferid\r\n");
        sqlBuffer.append("  left outer join t_sm_buyofferitemali as \"buItem\" \r\n");
        sqlBuffer.append("  on buItem.FparentId = bu.Fpurchasenoteid \r\n");
        sqlBuffer.append("  LEFT OUTER JOIN T_SM_PurRequestEntry as \"purEntry\"\r\n");
        sqlBuffer.append("  on purEntry.FId = buItem.FPrItemId\r\n");
        sqlBuffer.append("  left outer join t_sm_purrequest as \"pur\"\r\n");
        sqlBuffer.append("  on purEntry.FparentId = pur.FID\r\n");
        sqlBuffer.append(" left outer join t_sm_purorderentry as \"purorderentry\" \r\n");
        sqlBuffer.append(" on bu.Fpurchasenoteid = purorderentry.fnetBuyOfferId");
        sqlBuffer.append("  left outer join t_sm_purorder as \"purOrder\"\r\n");
        sqlBuffer.append("  on  purorderentry.FparentId= purOrder.FId \r\n");
        sqlBuffer.append(" where ");
        sqlBuffer.append(filterInfo.toString() + "\r\n");
        if (strStatus != null && strStatus.trim().length() > 0) {
            if ("end".equals(strStatus)) {
                sqlBuffer.append(" and bu.fstatus ='end' \r\n");
            } else {
                sqlBuffer.append(" and bu.fstatus !='end' \r\n");
            }
        }
        sqlBuffer.append("and bu.fstatus != 'cancle' \r\n");
        if (strQoStatus != null && strQoStatus.trim().length() > 0) {
            if ("no".equals(strQoStatus)) {
                sqlBuffer.append(" and (tquoQty.count is null or tquoQty.count = 0) \r\n");
            } else {
                sqlBuffer.append(" and tquoQty.count > 0 \r\n");
            }
        }
        sqlBuffer.append("  order by FGmtDate desc\r\n");
        this.executeUpdate(sqlBuffer.toString(), null, ctx);
        this._extend(ctx, tempTable);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        RptRowSet rs = this.executeQuery("select count(*) as count from " + tempTable, null, ctx);
        if (rs.next()) {
            result.setInt("RowCount", rs.getInt("count"));
        }
        return result;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        RptParams rpt = new RptParams();
        StringBuffer sql = new StringBuffer();
        sql.append("select  \r\n");
        sql.append("FId as buyId,\r\n");
        sql.append("FTitle as title,\r\n");
        sql.append("Fstatus as status,\r\n");
        sql.append("FqtyQuotation as qtyQuotation, \r\n");
        sql.append("FGmtDate as gmtDate,\r\n");
        sql.append("FquotationExpire as quotationExpire,\r\n");
        sql.append("FwebOrderId as webOrderId,\r\n");
        sql.append("FpurOrderNumber as purOrderNumber,\r\n");
        sql.append("FCompanyId as companyId, \r\n");
        sql.append("FpurOrderId as purOrderId \r\n");
        sql.append("FROM " + params.getString("tempTable") + " as temp \r\n");
        sql.append("order by FGmtDate desc");
        RptRowSet rs = null;
        rs = null != params.getString("queryType") && params.getString("queryType").equalsIgnoreCase("web") ? this.executeQuery(ctx, sql.toString(), null, from, len) : this.executeQuery(sql.toString(), null, ctx);
        rpt.setObject("rowSet", (Object)rs);
        return rpt;
    }

    private String getCreateTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table TempTable \r\n");
        sql.append("( FId Varchar(44),\r\n");
        sql.append(" FTitle Varchar(250),\r\n");
        sql.append(" FGmtDate DateTime, \r\n");
        sql.append(" FquotationExpire DateTime,\r\n");
        sql.append(" Fstatus NVarchar(20),\r\n");
        sql.append(" FqtyQuotation int,\r\n");
        sql.append(" FcompanyId varchar(44), \r\n");
        sql.append(" FwebOrderId varchar(44), \r\n");
        sql.append(" FpurOrderId varchar(44), \r\n");
        sql.append(" FpurOrderNumber varchar(50))\r\n");
        return sql.toString();
    }

    private Timestamp getStartTime(Date dateStart) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateStart);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(calendar.getTime());
        Timestamp time = Timestamp.valueOf(dateString);
        return time;
    }

    private Timestamp getEndTime(Date dateEnd) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateEnd);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(calendar.getTime());
        Timestamp time = Timestamp.valueOf(dateString);
        return time;
    }

    private void updateBuyOfferStatus(Set compIds, Context ctx) throws BOSException {
        if (compIds.isEmpty()) {
            return;
        }
        Date curent = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(curent);
        Timestamp time = Timestamp.valueOf(dateString);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("FgmtquotationExpire", (Object)time, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("FcompanyId", (Object)compIds, CompareType.INCLUDE));
        StringBuffer sql = new StringBuffer("update t_sm_buyofferali set fstatus='end' where ");
        sql.append(filterInfo.toString());
        this.executeUpdate(sql.toString(), null, ctx);
    }

    protected void _extend(Context ctx, String tmpTable) throws BOSException, EASBizException {
    }
}

