/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.b2b.PurB2BException;
import com.kingdee.eas.scm.sm.pur.b2b.PurCloudConfigInfo;
import com.kingdee.eas.scm.sm.pur.b2b.app.PurCloudServiceHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public class PurCloudConfigHelper {
    private static final Logger logger = Logger.getLogger(PurCloudConfigHelper.class);
    public static final String CONFIG_FILE = "PurCloudConfig.properties";
    private static PurCloudConfigInfo configInfo = null;

    private PurCloudConfigHelper() {
    }

    public static PurCloudConfigInfo getInfo() throws BOSException {
        if (configInfo == null) {
            configInfo = PurCloudConfigHelper.loadPurCloudConfig();
        }
        return configInfo;
    }

    public static void reloadInfo() throws BOSException {
        configInfo = PurCloudConfigHelper.loadPurCloudConfig();
    }

    public static PurCloudConfigInfo getPurCloudConfig() throws BOSException {
        return PurCloudConfigHelper.loadPurCloudConfig();
    }

    public static PurCloudConfigInfo loadPurCloudConfig() throws BOSException {
        PurCloudConfigInfo config = new PurCloudConfigInfo();
        String path = System.getProperty("EAS_HOME");
        String slip = File.separator;
        path = path + slip + "server" + slip + "profiles" + slip + "server1" + slip + "config" + slip + CONFIG_FILE;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(path)));
            String text = null;
            while ((text = reader.readLine()) != null) {
                String[] namePair = text.split("=");
                if (namePair == null || namePair.length != 2) continue;
                config.setField(namePair[0], namePair[1]);
            }
            reader.close();
        }
        catch (IOException e) {
            logger.error((Object)("\u52a0\u8f7d\u7535\u5546\u914d\u7f6e\u6587\u4ef6\u51fa\u9519\uff1a" + e.getMessage()));
        }
        return config;
    }

    public static void savePurCloudConfig(String configContent) throws EASBizException {
        String path = System.getProperty("EAS_HOME");
        String slip = File.separator;
        File configFile = new File(path = path + slip + "server" + slip + "profiles" + slip + "server1" + slip + "config" + slip + CONFIG_FILE);
        if (configFile.exists()) {
            configFile.delete();
        }
        try {
            FileWriter writer = new FileWriter(configFile);
            writer.write(configContent.replaceAll("&", "/r/n"));
            writer.close();
            PurCloudServiceHelper.resetPolicy();
        }
        catch (IOException e) {
            throw new EASBizException(PurB2BException.SAVECONFIGFILEERROR, (Object[])new String[]{e.getMessage()});
        }
    }
}

