/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.openapi.APIId;
import com.kingdee.eas.scm.framework.openapi.PurCloudClient;
import com.kingdee.eas.scm.framework.openapi.Request;
import com.kingdee.eas.scm.framework.openapi.exception.PurCloudException;
import com.kingdee.eas.scm.framework.openapi.policy.ClientPolicy;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.b2b.PurB2BException;
import com.kingdee.eas.scm.sm.pur.b2b.PurCloudConfigInfo;
import com.kingdee.eas.scm.sm.pur.b2b.app.PurCloudConfigHelper;
import com.kingdee.eas.scm.sm.pur.b2b.app.PurExceptionDefine;
import com.kingdee.eas.scm.sm.pur.b2b.util.PurCloudHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.enterprisedt.util.debug.Logger;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class PurCloudServiceHelper {
    private static final Logger logger = Logger.getLogger(PurCloudServiceHelper.class);
    public static final int TIMEOUT = 30000;
    public static final String ENCODE = "UTF-8";
    public static final String NAMESPACE = "com.kingdee.purchase.openapi";
    public static final int DEFAULT_VERSION = 1;
    public static final String AUTOLOGIN = "autologin";
    private static volatile boolean isInit = false;
    private static ClientPolicy policy = null;

    private static PurCloudClient createClient() throws EASBizException {
        if (policy == null) {
            PurCloudConfigInfo config;
            try {
                config = PurCloudConfigHelper.getPurCloudConfig();
            }
            catch (BOSException e) {
                throw new PurB2BException(PurB2BException.PURCLOUDNOTCONFIGURED);
            }
            if (!config.isConfigured()) {
                throw new PurB2BException(PurB2BException.PURCLOUDNOTCONFIGURED);
            }
            policy = PurCloudServiceHelper.getClientPolicy(config);
        }
        PurCloudClient client = new PurCloudClient(policy);
        return client;
    }

    public static void resetPolicy() {
        policy = null;
    }

    public static String send(Context ctx, String companyId, String apiName, Map<String, Object> params) throws EASBizException {
        PurCloudClient client = PurCloudServiceHelper.createClient();
        String userId = PurCloudServiceHelper.getUserId(ctx);
        Request request = new Request(companyId, userId, new APIId(NAMESPACE, apiName, 1));
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                request.setParam(entry.getKey(), entry.getValue());
            }
        }
        request.setParam("name", PurCloudServiceHelper.getUserName(ctx));
        try {
            return client.send(request);
        }
        catch (PurCloudException e) {
            String errorAlias = PurExceptionDefine.getMessageAlias(Integer.valueOf(e.getErrorCode()));
            throw new PurB2BException(PurB2BException.INVOKEPURCLOUDERROR, new String[]{e.getErrorCode(), errorAlias == null ? e.getMessage() : errorAlias});
        }
    }

    public static String getAutoLoginWebContent(Context ctx, String companyId, PurCloudClient.TargetUrlEnum targetUrl, Map<String, Object> params) throws EASBizException {
        PurCloudClient client = PurCloudServiceHelper.createClient();
        String userId = PurCloudServiceHelper.getUserId(ctx);
        Request request = new Request(companyId, userId, new APIId(NAMESPACE, AUTOLOGIN, 1));
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                request.setParam(entry.getKey(), entry.getValue());
            }
        }
        return client.getAutoLoginWebContent(request, targetUrl);
    }

    public static String getAutoLoginUrl(Context ctx, String companyId, PurCloudClient.TargetUrlEnum targetUrl, String purReqBillId) throws EASBizException, BOSException {
        PurCloudClient client = PurCloudServiceHelper.createClient();
        String userId = PurCloudServiceHelper.getUserId(ctx);
        Request request = new Request(companyId, userId, new APIId(NAMESPACE, AUTOLOGIN, 1));
        if (PurCloudClient.TargetUrlEnum.POST_BUYOFFER.equals((Object)targetUrl)) {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            try {
                request.setParam("data", PurCloudHelper.buildRequestData(PurCloudServiceHelper.getPurRequestInfo(ctx, purReqBillId), userInfo));
            }
            catch (JSONException e) {
                throw new BOSException((Throwable)e);
            }
        }
        try {
            return client.getAutoLoginUrl(request, targetUrl);
        }
        catch (PurCloudException e) {
            String errorAlias = PurExceptionDefine.getMessageAlias(Integer.valueOf(e.getErrorCode()));
            throw new PurB2BException(PurB2BException.INVOKEPURCLOUDERROR, new String[]{e.getErrorCode(), errorAlias == null ? e.getMessage() : errorAlias});
        }
    }

    public static ClientPolicy getClientPolicy(PurCloudConfigInfo config) throws EASBizException {
        ClientPolicy policy = new ClientPolicy(config.getHost()).setHttpPort(config.getPort());
        if (config.isProxy()) {
            policy.setProxyHost(config.getProxyHost()).setProxyPort(config.getProxyPort());
        }
        policy.setEnterpriseId(config.getEnterpriseid());
        policy.setContentCharset(ENCODE).setTimeout(30000);
        return policy;
    }

    public static String getAutoLoginUrlPur(Context ctx, String companyId, PurCloudClient.TargetUrlEnum targetUrl, Map<String, Object> params) throws EASBizException, BOSException {
        PurCloudClient client = PurCloudServiceHelper.createClient();
        String userId = PurCloudServiceHelper.getUserId(ctx);
        Request request = new Request(companyId, userId, new APIId(NAMESPACE, AUTOLOGIN, 1));
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                request.setParam(entry.getKey(), entry.getValue());
            }
        }
        try {
            return client.getAutoLoginUrl(request, targetUrl);
        }
        catch (PurCloudException e) {
            String errorAlias = PurExceptionDefine.getMessageAlias(Integer.valueOf(e.getErrorCode()));
            throw new PurB2BException(PurB2BException.INVOKEPURCLOUDERROR, new String[]{e.getErrorCode(), errorAlias == null ? e.getMessage() : errorAlias});
        }
    }

    private static String getUserId(Context ctx) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String number = userInfo.getNumber();
        if (StringUtils.isEmpty((String)number)) {
            return number;
        }
        try {
            return URLEncoder.encode(number, ENCODE);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u83b7\u53d6\u4e0a\u4e0b\u6587\u7528\u6237\u4fe1\u606f\u51fa\u9519:" + e.getMessage());
            return null;
        }
    }

    private static String getUserName(Context ctx) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String name = userInfo.getName();
        if (StringUtils.isEmpty((String)name)) {
            return name;
        }
        try {
            return URLEncoder.encode(name, ENCODE);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u83b7\u53d6\u4e0a\u4e0b\u6587\u7528\u6237\u4fe1\u606f\u51fa\u9519:" + e.getMessage());
            return null;
        }
    }

    private static PurRequestInfo getPurRequestInfo(Context ctx, String purReqBillId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("netBuyOfferID"));
        selector.add(new SelectorItemInfo("description"));
        selector.add(new SelectorItemInfo("entries.id"));
        selector.add(new SelectorItemInfo("entries.materialName"));
        selector.add(new SelectorItemInfo("entries.qty"));
        selector.add(new SelectorItemInfo("entries.noNumMaterialModel"));
        selector.add(new SelectorItemInfo("entries.remark"));
        selector.add(new SelectorItemInfo("entries.unit.id"));
        selector.add(new SelectorItemInfo("entries.unit.name"));
        selector.add(new SelectorItemInfo("entries.unit.number"));
        selector.add(new SelectorItemInfo("entries.material.id"));
        selector.add(new SelectorItemInfo("entries.material.name"));
        selector.add(new SelectorItemInfo("entries.material.number"));
        selector.add(new SelectorItemInfo("entries.material.model"));
        selector.add(new SelectorItemInfo("entries.material.assistUnit.id"));
        selector.add(new SelectorItemInfo("entries.material.assistUnit.name"));
        selector.add(new SelectorItemInfo("entries.material.assistUnit.number"));
        return PurRequestFactory.getLocalInstance((Context)ctx).getPurRequestInfo((IObjectPK)new ObjectUuidPK(purReqBillId), selector);
    }
}

