/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.StringUtils;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.b2b.app.PurCloudServiceHelper;
import com.kingdee.eas.scm.sm.pur.b2b.app.SupplierHandlerUtil;
import com.kingdee.eas.scm.sm.pur.b2b.model.NetPurOrderItem;
import com.kingdee.eas.scm.sm.pur.b2b.model.ObjectCollection;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurOrderB2BUtil {
    private static final Logger logger = Logger.getLogger(PurOrderB2BUtil.class);
    private static final BigDecimal HUNDERD = new BigDecimal("100");

    public static void uploadOrderInfo(Context ctx, PurOrderInfo bill) {
        String companyId = bill.getCompanyOrgUnit().getId().toString();
        String apiName = "purorder.postOrderInfo";
        try {
            PurCloudServiceHelper.send(ctx, companyId, apiName, PurOrderB2BUtil.getSaveOrderParams(ctx, bill));
            logger.info((Object)"\u4e0a\u4f20\u8ba2\u5355\u6210\u529f");
        }
        catch (Exception e) {
            logger.error((Object)("\u4e0a\u4f20\u8ba2\u5355\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public static void closeNetBuyOffer(Context ctx, PurOrderInfo bill) {
        if (bill.getEntries().size() == 0) {
            return;
        }
        String purRequestId = bill.getEntries().get(0).getSourceBillId();
        String selectBuyOfferId = "select FNetBuyOfferId from T_SM_PurRequest where FID = '" + purRequestId + "'";
        try {
            String netBuyOfferId = null;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectBuyOfferId);
            if (rs.next()) {
                netBuyOfferId = rs.getString("FNetBuyOfferId");
            }
            String companyId = bill.getCompanyOrgUnit().getId().toString();
            String apiName = "buyoffer.closeBuyOffer";
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("buyOfferId", netBuyOfferId);
            params.put("closeReason", "\u5df2\u4e0b\u5355\uff0c\u62a5\u4ef7\u622a\u6b62");
            PurCloudServiceHelper.send(ctx, companyId, apiName, params);
            logger.info((Object)"\u8be2\u4ef7\u5173\u95ed\u6210\u529f!");
        }
        catch (Exception e) {
            logger.error((Object)("\u5173\u95ed\u8be2\u4ef7\u5931\u8d25\uff1a " + e.getMessage()));
        }
    }

    public static void updateOrderStatus(Context ctx, PurOrderInfo bill, OrderStatusEnum status, String reason) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", bill.getId().toString());
        params.put("orderStatus", status.toString());
        params.put("failReason", reason);
        String companyId = bill.getCompanyOrgUnit().getId().toString();
        String apiName = "purorder.updateOrderInfo";
        try {
            PurCloudServiceHelper.send(ctx, companyId, apiName, params);
            logger.info((Object)"\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u6210\u529f");
        }
        catch (Exception e) {
            logger.error((Object)("\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    private static Map<String, Object> getSaveOrderParams(Context ctx, PurOrderInfo bill) throws JSONException, EASBizException, BOSException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", bill.getId().toString());
        String supplierMemberId = SupplierHandlerUtil.getMappingSupplierMemberID(ctx, bill.getSupplier().getId().toString());
        params.put("supplierMemberId", supplierMemberId);
        params.put("supplierCode", bill.getSupplier().getNumber());
        params.put("supplierCompanyName", bill.getSupplier().getName());
        params.put("totalAmount", bill.getTotalAmount().multiply(HUNDERD).longValue());
        params.put("freightAmount", Long.valueOf("0"));
        params.put("orderAmount", bill.getTotalAmount().multiply(HUNDERD).longValue());
        params.put("sourceType", "BUYOFFER");
        params.put("orderStatus", "enabled");
        params.put("payType", "offline");
        params.put("orderItemList", PurOrderB2BUtil.getOrderItemList(bill.getEntries()));
        return params;
    }

    private static String getOrderItemList(PurOrderEntryCollection entryColl) throws JSONException {
        PurOrderEntryInfo entry = null;
        NetPurOrderItem item = null;
        ObjectCollection<NetPurOrderItem> itemColl = new ObjectCollection<NetPurOrderItem>();
        for (int i = 0; i < entryColl.size(); ++i) {
            entry = entryColl.get(i);
            item = new NetPurOrderItem();
            item.setOrderItemId(entry.getNetQuotationItemId());
            if (entry.getMaterial() != null) {
                item.setProductName(entry.getMaterial().getName());
            } else {
                item.setProductName(entry.getMaterialName());
            }
            item.setPrice(entry.getPrice().multiply(HUNDERD).longValue());
            item.setCount(entry.getQty().longValue());
            itemColl.addItem(item);
        }
        return itemColl.toJSONArray().toString();
    }

    public static void purOrderUnAudit(Context ctx, IObjectPK[] pks) throws BOSException {
        PurOrderCollection poCollection = PurOrderB2BUtil.getPurOrderCol(ctx, pks);
        PurOrderInfo purInfo = null;
        for (int i = 0; i < poCollection.size(); ++i) {
            purInfo = poCollection.get(i);
            if (purInfo.get("isNetOrder") == null || !purInfo.getBoolean("isNetOrder")) continue;
            PurOrderB2BUtil.updateOrderStatus(ctx, purInfo, OrderStatusEnum.disabled, "\u8ba2\u5355\u88ab\u53cd\u5ba1\u6838");
        }
    }

    public static void purOrderAudit(Context ctx, IObjectPK[] pks) throws BOSException {
        PurOrderCollection poCollection = PurOrderB2BUtil.getPurOrderCol(ctx, pks);
        PurOrderInfo updatePurOrderInfo = null;
        for (int i = 0; i < poCollection.size(); ++i) {
            updatePurOrderInfo = poCollection.get(i);
            if (updatePurOrderInfo.get("isNetOrder") == null || !updatePurOrderInfo.getBoolean("isNetOrder")) continue;
            PurOrderB2BUtil.uploadOrderInfo(ctx, updatePurOrderInfo);
            PurOrderB2BUtil.closeNetBuyOffer(ctx, updatePurOrderInfo);
        }
    }

    public static void purOrderRevoke(Context ctx, IObjectPK pk, IObjectValue reasonCode) throws BOSException, EASBizException {
        PurOrderInfo purOrderInfo = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderInfo(pk, PurOrderB2BUtil.getSelectors());
        if (purOrderInfo.get("isNetOrder") != null && purOrderInfo.getBoolean("isNetOrder")) {
            PurOrderB2BUtil.updateOrderStatus(ctx, purOrderInfo, OrderStatusEnum.disabled, reasonCode.toString());
        }
        PurOrderB2BUtil.cancelOrder(ctx, pk);
    }

    public static void purOrderRevoke(Context ctx, IObjectPK pk, String reasonCode) throws BOSException, EASBizException {
        PurOrderInfo purOrderInfo = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderInfo(pk, PurOrderB2BUtil.getSelectors());
        if (purOrderInfo.get("isNetOrder") != null && purOrderInfo.getBoolean("isNetOrder")) {
            PurOrderB2BUtil.updateOrderStatus(ctx, purOrderInfo, OrderStatusEnum.disabled, reasonCode);
        }
        PurOrderB2BUtil.cancelOrder(ctx, pk);
    }

    private static void cancelOrder(Context ctx, IObjectPK pk) throws BOSException {
        if (pk == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct t2.fJdOrderId from t_sm_purorder t1 inner join t_sm_purorderentry t2 on t1.fid = t2.fparentid ");
        sql.append(" where t1.fid ='").append(pk.toString()).append("'");
        HashMap<String, Object> params = new HashMap<String, Object>();
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), null);
        String jdOrderID = null;
        JSONArray jsonArray = new JSONArray();
        try {
            while (rs.next()) {
                jdOrderID = rs.getString("fJdOrderId");
                if (StringUtils.isEmpty((String)jdOrderID)) continue;
                jsonArray.put((Object)jdOrderID);
            }
            if (jsonArray.length() == 0) {
                return;
            }
            params.put("jdOrderIds", jsonArray.toString());
            PurCloudServiceHelper.send(ctx, "00000000-0000-0000-0000-000000000000CCE7AED4", "jd.order.cancel", params);
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    private static PurOrderCollection getPurOrderCol(Context ctx, IObjectPK[] pks) throws BOSException {
        HashSet<String> ids = new HashSet<String>();
        int size = pks.length;
        for (int j = 0; j < size; ++j) {
            ids.add(pks[j].toString());
        }
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        entityView.setFilter(filterInfo);
        entityView.setSelector(PurOrderB2BUtil.getSelectors());
        PurOrderCollection poCollection = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderCollection(entityView);
        return poCollection;
    }

    private static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("billType"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("entries.baseStatus"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("cu.id"));
        sic.add(new SelectorItemInfo("sourceBillType"));
        sic.add(new SelectorItemInfo("entries.sourceBillEntryId"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("isNetOrder"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.reason"));
        return sic;
    }

    public static void entryUpdateSatus(Context ctx, IObjectPK[] entryPks, BillBaseStatusEnum newStatus) throws EASBizException, BOSException {
        IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance((Context)ctx);
        IPurOrder iPurOrder = PurOrderFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK oldOrderpk = null;
        PurOrderEntryInfo purOrderEntryInfo = null;
        ObjectUuidPK orderPK = null;
        PurOrderInfo purOrderInfo = null;
        BillBaseStatusEnum orderStatus = null;
        int size = entryPks.length;
        for (int i = 0; i < size; ++i) {
            purOrderEntryInfo = iPurOrderEntry.getPurOrderEntryInfo(entryPks[i]);
            orderPK = new ObjectUuidPK(purOrderEntryInfo.getParent().getId());
            if (!orderPK.equals(oldOrderpk) && oldOrderpk != null) {
                purOrderInfo = iPurOrder.getPurOrderInfo((IObjectPK)oldOrderpk);
                orderStatus = purOrderInfo.getBaseStatus();
                if (purOrderInfo.isIsNetOrder() && !BillBaseStatusEnum.AUDITED.equals((Object)newStatus) && orderStatus.equals((Object)newStatus)) {
                    PurOrderB2BUtil.updateOrderStatus(ctx, purOrderInfo, OrderStatusEnum.disabled, "\u8ba2\u5355\u72b6\u6001\u88ab\u4fee\u6539\u4e3a:" + newStatus.getAlias());
                }
            }
            oldOrderpk = orderPK;
        }
        purOrderInfo = iPurOrder.getPurOrderInfo(oldOrderpk);
        orderStatus = purOrderInfo.getBaseStatus();
        if (purOrderInfo.isIsNetOrder() && !BillBaseStatusEnum.AUDITED.equals((Object)newStatus) && orderStatus.equals((Object)newStatus)) {
            PurOrderB2BUtil.updateOrderStatus(ctx, purOrderInfo, OrderStatusEnum.disabled, "\u8ba2\u5355\u72b6\u6001\u88ab\u4fee\u6539\u4e3a:" + newStatus.getAlias());
        }
    }

    public static enum OrderStatusEnum {
        enabled,
        disabled;

    }
}

