/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.PurRequestCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.b2b.PurB2BException;
import com.kingdee.eas.scm.sm.pur.b2b.app.PurCloudServiceHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class PurReqB2BUtils {
    private static final Logger logger = Logger.getLogger(PurReqB2BUtils.class);

    public static void closeNetBuyOffer(Context ctx, PurRequestInfo info) {
        if (PurReqB2BUtils.isUnPostNetBuyOffer(info)) {
            return;
        }
        String apiName = "buyoffer.closeBuyOffer";
        String companyId = info.getCompanyOrgUnit().getId().toString();
        ArrayList<String> list = new ArrayList<String>();
        PurRequestEntryCollection entries = info.getEntries();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            String buyOfferId;
            if (StringUtil.isEmptyString((String)entries.get(i).getString("netBuyOfferItemId")) || list.contains(buyOfferId = entries.get(i).getString("netBuyOfferItemId"))) continue;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("closeReason", "\u5916\u90e8\u91c7\u8d2d\u7cfb\u7edf\u5df2\u5173\u95ed\u91c7\u8d2d\u7533\u8bf7\u5355");
            params.put("buyOfferId", buyOfferId);
            list.add(buyOfferId);
            try {
                PurCloudServiceHelper.send(ctx, companyId, apiName, params);
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)("\u5173\u95ed\u7f51\u7edc\u8be2\u4ef7\u5355\u5931\u8d25\uff1a" + e.getMessage()));
            }
        }
    }

    public static boolean isUnPostNetBuyOffer(PurRequestInfo purInfo) {
        PurRequestEntryCollection entries = purInfo.getEntries();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            if (StringUtil.isEmptyString((String)entries.get(i).getString("netBuyOfferItemId"))) continue;
            return false;
        }
        return true;
    }

    public static void checkUnAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        if (pks.length == 0) {
            return;
        }
        HashSet<IObjectPK> idsSet = new HashSet<IObjectPK>();
        for (int i = 0; i < pks.length; ++i) {
            idsSet.add(pks[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idsSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("netBuyOfferId"));
        sic.add(new SelectorItemInfo("entries.netBuyOfferItemId"));
        view.setSelector(sic);
        PurRequestCollection coll = PurRequestFactory.getLocalInstance((Context)ctx).getPurRequestCollection(view);
        PurRequestInfo purInfo = null;
        if (coll != null && coll.size() > 0) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                purInfo = coll.get(i);
                if (PurReqB2BUtils.isUnPostNetBuyOffer(purInfo)) continue;
                throw new EASBizException(PurB2BException.BILLHASPOSTBUYOFFER, (Object[])new String[]{purInfo.getNumber()});
            }
        }
    }

    public static void check4Delete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("netBuyOfferId"));
        sic.add(new SelectorItemInfo("entries.netBuyOfferItemId"));
        PurRequestInfo model = (PurRequestInfo)PurRequestFactory.getLocalInstance((Context)ctx).getValue(pk, sic);
        String buyOfferId = null;
        for (int i = 0; i < model.getEntries().size(); ++i) {
            buyOfferId = model.getEntries().get(i).getString("netBuyOfferItemId");
            if (buyOfferId == null || buyOfferId.trim().length() <= 0) continue;
            throw new PurB2BException(PurB2BException.DELETE_BUYOFFER);
        }
    }
}

