/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierLinkManInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoInfo;
import com.kingdee.eas.basedata.master.cssp.UsingStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.util.TimeStampUtility;
import com.kingdee.eas.scm.sm.pur.b2b.PurB2BException;
import com.kingdee.eas.scm.sm.pur.b2b.app.AbstractSupplier4AliFacadeControllerBean;
import com.kingdee.eas.scm.sm.pur.b2b.app.SupplierHandlerUtil;
import com.kingdee.eas.scm.sm.pur.b2b.model.SupplierMapTypeEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Supplier4AliFacadeControllerBean
extends AbstractSupplier4AliFacadeControllerBean {
    private static final long serialVersionUID = 1L;

    @Override
    protected List _getMappingSupplierListById(Context ctx, List idList) throws BOSException, EASBizException {
        return SupplierHandlerUtil.getMappingSupplierListByID(ctx, idList);
    }

    @Override
    protected boolean _isMapped(Context ctx, String supplierMemberId) throws BOSException, EASBizException {
        return SupplierHandlerUtil.hasMapped(ctx, supplierMemberId);
    }

    @Override
    protected Map _getMappingSupplierByMemberId(Context ctx, List memberIdList) throws BOSException, EASBizException {
        return SupplierHandlerUtil.getMappingSupplierByMemberID(ctx, memberIdList);
    }

    @Override
    protected SupplierMapTypeEnum _handleMapping(Context ctx, SupplierInfo supplierInfo, Map paramMap) throws BOSException, EASBizException {
        List purchaseIDList = (List)paramMap.get("purchaseOrgUnitIdList");
        String supplierMemberId = (String)paramMap.get("supplierMemberId");
        boolean isMapped = SupplierHandlerUtil.hasMapped(ctx, supplierMemberId);
        if (isMapped) {
            return SupplierMapTypeEnum.SUPPLIER_MAPPING;
        }
        String supplierId = supplierInfo.getId().toString();
        String companyID = (String)paramMap.get("companyOrgUnitId");
        ObjectUuidPK supplierPK = new ObjectUuidPK(supplierId);
        ObjectUuidPK companyPK = new ObjectUuidPK(companyID);
        SupplierMapTypeEnum valueEnum = null;
        valueEnum = SupplierHandlerUtil.hasSupplierCompanyInfo(ctx, (IObjectPK)supplierPK, (IObjectPK)companyPK);
        if (SupplierMapTypeEnum.SUPPLIER_NOCOMPANYDATA.equals((Object)valueEnum)) {
            this.savaSupplierCompanyInfo(ctx, supplierInfo, companyID);
        }
        if (purchaseIDList != null && purchaseIDList.size() > 0) {
            SupplierLinkManInfo linkInfo = (SupplierLinkManInfo)paramMap.get("contactorInfo");
            ObjectUuidPK purchaseOrgPK = null;
            CoreBaseCollection colls = new CoreBaseCollection();
            int size = purchaseIDList.size();
            for (int i = 0; i < size; ++i) {
                purchaseOrgPK = new ObjectUuidPK((String)purchaseIDList.get(i));
                valueEnum = SupplierHandlerUtil.hasSupplierPurchaseInfo(ctx, (IObjectPK)supplierPK, (IObjectPK)purchaseOrgPK);
                if (!SupplierMapTypeEnum.SUPPLIER_NOPURCHASEDATA.equals((Object)valueEnum)) continue;
                colls.add((CoreBaseInfo)this.savaSupplierPurchaseInfo(ctx, supplierInfo, (String)purchaseIDList.get(i), linkInfo));
            }
            if (colls.size() > 0) {
                SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx).addnewBatchData(colls);
            }
        }
        SupplierHandlerUtil.dealWithMapping(ctx, supplierMemberId, supplierId);
        return SupplierMapTypeEnum.SUPPLIER_SUCCESS;
    }

    private IObjectPK saveSupplierBaseInfo(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        SupplierInfo supplierInfo = (SupplierInfo)model;
        CSSPGroupStandardInfo stdInfo = SupplierHandlerUtil.getGroupStandardInfo(ctx);
        if (stdInfo == null) {
            throw new EASBizException(PurB2BException.COMPANYIDISNULL);
        }
        CSSPGroupInfo groupInfo = SupplierHandlerUtil.getCSSPGroupInfo(ctx, stdInfo);
        supplierInfo.setBrowseGroup(groupInfo);
        supplierInfo.getSupplierGroupDetails().add(SupplierHandlerUtil.getSupplierGroupDetailInfo(stdInfo, groupInfo));
        ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
        IObjectPK pk = iSupplier.addnew((CoreBaseInfo)supplierInfo);
        return pk;
    }

    public CompanyOrgUnitInfo getCompanyOrgUnitInfo(Context ctx, String companyID) throws EASBizException, BOSException {
        CompanyOrgUnitInfo org = null;
        if (companyID != null) {
            org = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), Supplier4AliFacadeControllerBean.getSelectorByCompanyOrg());
        }
        return org;
    }

    private static SelectorItemCollection getSelectorByCompanyOrg() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        return sic;
    }

    private SupplierCompanyInfoInfo createSupplierCompanyData(Context ctx, SupplierInfo supplierInfo, String companyID) throws EASBizException, BOSException {
        SupplierCompanyInfoInfo supCompanyInfo = new SupplierCompanyInfoInfo();
        supCompanyInfo.setSupplier(supplierInfo);
        CompanyOrgUnitInfo companyInfo = this.getCompanyOrgUnitInfo(ctx, companyID);
        supCompanyInfo.setCompanyOrgUnit(companyInfo);
        supCompanyInfo.setSettlementCurrency(companyInfo.getBaseCurrency());
        String accountTableId = null;
        if (companyInfo.getAccountTable() != null) {
            accountTableId = companyInfo.getAccountTable().getId().toString();
        }
        if (accountTableId != null && companyID != null) {
            KAClassficationInfo defKA = SupplierHandlerUtil.getDefaultAccountClass(ctx, "supplier", companyID, accountTableId);
            supCompanyInfo.setAccountingClassification(defKA);
        }
        supCompanyInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        supCompanyInfo.setCreateTime(TimeStampUtility.getTime());
        supCompanyInfo.setIsFreezePayment(false);
        supCompanyInfo.setUsingStatus(UsingStatusEnum.USING);
        CtrlUnitInfo curCtrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        supCompanyInfo.setCU(curCtrlUnitInfo);
        return supCompanyInfo;
    }

    private IObjectPK savaSupplierCompanyInfo(Context ctx, SupplierInfo supplierInfo, String companyID) throws EASBizException, BOSException {
        SupplierCompanyInfoInfo supCompanyInfo = this.createSupplierCompanyData(ctx, supplierInfo, companyID);
        IObjectPK pk = SupplierCompanyInfoFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)supCompanyInfo);
        return pk;
    }

    public PurchaseOrgUnitInfo getPurchaseOrgUnitInfo(Context ctx, String purchaseID) throws EASBizException, BOSException {
        PurchaseOrgUnitInfo orgUnitInfo = null;
        if (purchaseID != null) {
            orgUnitInfo = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(purchaseID), Supplier4AliFacadeControllerBean.getSelectorByPurchseOrg());
        }
        return orgUnitInfo;
    }

    private static SelectorItemCollection getSelectorByPurchseOrg() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        return sic;
    }

    private SupplierPurchaseInfoInfo createSupplierPurchaseData(Context ctx, SupplierInfo supplierInfo, String purchaseID, SupplierLinkManInfo linkInfo) throws EASBizException, BOSException {
        SupplierPurchaseInfoInfo info = new SupplierPurchaseInfoInfo();
        info.setId(BOSUuid.create((String)"9920F4D3"));
        info.setSupplier(supplierInfo);
        PurchaseOrgUnitInfo purchaseOrgInfo = this.getPurchaseOrgUnitInfo(ctx, purchaseID);
        info.setPurchaseOrgUnit(purchaseOrgInfo);
        info.setBillingOrgUnit(supplierInfo);
        info.setDeliverOrgUnit(supplierInfo);
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setCreateTime(TimeStampUtility.getTime());
        info.setGrade("0");
        info.setNoteAdvance(0);
        info.setIsCPartial(true);
        info.setIsDPlanColl(true);
        info.setIsSDirect(true);
        info.setIsFreezeMakeOrder(false);
        info.setUsingStatus(UsingStatusEnum.USING);
        CtrlUnitInfo curCtrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        info.setCU(curCtrlUnitInfo);
        SupplierLinkManInfo cloneInfo = (SupplierLinkManInfo)linkInfo.clone();
        cloneInfo.setId(BOSUuid.create((String)"3FD16964"));
        info.getSupplierLinkMan().add(cloneInfo);
        return info;
    }

    private SupplierPurchaseInfoInfo savaSupplierPurchaseInfo(Context ctx, SupplierInfo supplierInfo, String purchaseID, SupplierLinkManInfo linkInfo) throws BOSException, EASBizException {
        return this.createSupplierPurchaseData(ctx, supplierInfo, purchaseID, linkInfo);
    }

    private IObjectPK saveSupplier(Context ctx, SupplierInfo supplierInfo, Map paramMap) throws EASBizException, BOSException {
        IObjectPK pk = this.saveSupplierBaseInfo(ctx, (CoreBaseInfo)supplierInfo);
        String companyID = (String)paramMap.get("companyOrgUnitId");
        this.savaSupplierCompanyInfo(ctx, supplierInfo, companyID);
        List purchaseIDList = (List)paramMap.get("purchaseOrgUnitIdList");
        if (purchaseIDList != null && purchaseIDList.size() > 0) {
            SupplierLinkManInfo linkInfo = (SupplierLinkManInfo)paramMap.get("contactorInfo");
            CoreBaseCollection colls = new CoreBaseCollection();
            int size = purchaseIDList.size();
            for (int i = 0; i < size; ++i) {
                colls.add((CoreBaseInfo)this.savaSupplierPurchaseInfo(ctx, supplierInfo, (String)purchaseIDList.get(i), linkInfo));
            }
            SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx).addnewBatchData(colls);
        }
        String supplierMemberId = (String)paramMap.get("supplierMemberId");
        SupplierHandlerUtil.dealWithMapping(ctx, supplierMemberId, pk.toString());
        return pk;
    }

    @Override
    protected IObjectPK _addNewSupplier(Context ctx, SupplierInfo supplierInfo, Map paramMap) throws BOSException, EASBizException {
        String supplierMemberId = (String)paramMap.get("supplierMemberId");
        boolean isMapped = SupplierHandlerUtil.hasMapped(ctx, supplierMemberId);
        if (isMapped) {
            throw new EASBizException(new NumericExceptionSubItem("7777", "\u4f9b\u5e94\u5546\u5df2\u5173\u8054EAS\u4f9b\u5e94\u5546"));
        }
        return this.saveSupplier(ctx, supplierInfo, paramMap);
    }

    private SupplierMapTypeEnum dealSupplierData(Context ctx, Map paramMap) throws BOSException, EASBizException {
        String supplierMemberId = (String)paramMap.get("supplierMemberId");
        String companyID = (String)paramMap.get("companyOrgUnitId");
        List purchaseIdList = (List)paramMap.get("purchaseOrgUnitIdList");
        StringBuilder error = new StringBuilder();
        SupplierMapTypeEnum value = SupplierHandlerUtil.hasMapping(ctx, supplierMemberId);
        if (SupplierMapTypeEnum.SUPPLIER_NOTMAPPING.equals((Object)value)) {
            return SupplierMapTypeEnum.SUPPLIER_NOTMAPPING;
        }
        ArrayList<String> memberIdList = new ArrayList<String>();
        memberIdList.add(supplierMemberId);
        Map<String, String> map = SupplierHandlerUtil.getMappingSupplierByMemberID(ctx, memberIdList);
        String supplierId = map.get(supplierMemberId);
        String oql = "SELECT id,name WHERE id = '" + supplierId + "' AND usedStatus = 1 ";
        SupplierCollection supplierColls = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(oql);
        if (supplierColls == null || supplierColls.size() == 0) {
            return SupplierMapTypeEnum.SUPPLIER_BASEDATANOAUDIT;
        }
        ObjectUuidPK supplierPK = new ObjectUuidPK(supplierId);
        ObjectUuidPK companyPK = new ObjectUuidPK(companyID);
        value = SupplierHandlerUtil.hasSupplierCompanyInfo(ctx, (IObjectPK)supplierPK, (IObjectPK)companyPK);
        if (!SupplierMapTypeEnum.SUPPLIER_COMPANYDATACOMPLETE.equals((Object)value)) {
            return value;
        }
        if (purchaseIdList != null && purchaseIdList.size() > 0) {
            ObjectUuidPK purchaseOrgPK = null;
            int size = purchaseIdList.size();
            for (int i = 0; i < size; ++i) {
                purchaseOrgPK = new ObjectUuidPK((String)purchaseIdList.get(i));
                value = SupplierHandlerUtil.hasSupplierPurchaseInfo(ctx, (IObjectPK)supplierPK, (IObjectPK)purchaseOrgPK);
                if (SupplierMapTypeEnum.SUPPLIER_PURCHASEDATACOMPLETE.equals((Object)value)) continue;
                return value;
            }
        }
        return SupplierMapTypeEnum.SUPPLIER_CANBUILDORDER;
    }

    @Override
    protected SupplierMapTypeEnum _checkSupplierData(Context ctx, Map paramMap) throws BOSException, EASBizException {
        return this.dealSupplierData(ctx, paramMap);
    }

    @Override
    protected SupplierInfo _getEasSupplierByMemberId(Context ctx, String memberId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)memberId)) {
            return null;
        }
        String supplierId = SupplierHandlerUtil.getSupplierIDByMemberID(ctx, memberId);
        if (StringUtils.isEmpty((String)supplierId)) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(supplierId);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        SupplierInfo supplierInfo = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)pk, sic);
        return supplierInfo;
    }

    @Override
    protected String _getMemberIdBySupplierId(Context ctx, String supplierId) throws BOSException, EASBizException {
        if (supplierId == null) {
            return null;
        }
        return SupplierHandlerUtil.getMappingSupplierMemberID(ctx, supplierId);
    }
}

