/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.b2b.WebOrderPayTypeEnum;
import com.kingdee.eas.scm.sm.pur.b2b.WebOrderPostEnum;
import com.kingdee.eas.scm.sm.pur.b2b.WebOrderStatus;
import com.kingdee.eas.scm.sm.pur.b2b.app.AbstractWebPurOrderFacadeControllerBean;
import com.kingdee.eas.scm.sm.pur.util.DateHelper;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class WebPurOrderFacadeControllerBean
extends AbstractWebPurOrderFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.b2b.app.WebPurOrderFacadeControllerBean");

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String matName;
        WebOrderStatus webOrder;
        String tempTable = params.getString("tempTable");
        if (tempTable != null) {
            this.dropTempTable(params.getString("tempTable"), ctx);
            logger.info((Object)("\u5220\u9664\u4e34\u65f6\u8868\uff1a" + tempTable));
        }
        tempTable = this.createTempTable(ctx, this.getCreateTable());
        logger.info((Object)("\u672c\u6b21\u521b\u5efa\u521b\u5efa\u4e34\u65f6\u8868\uff1a" + tempTable));
        Object obj = null;
        HashSet<String> comOrgs = new HashSet<String>();
        obj = params.getObject("compOrg");
        if (obj != null) {
            if (obj instanceof Object[]) {
                Object[] objects;
                for (Object object : objects = (Object[])obj) {
                    if (object == null || !(object instanceof OrgUnitInfo)) continue;
                    OrgUnitInfo comOrgInfo = (OrgUnitInfo)object;
                    comOrgs.add(comOrgInfo.getId().toString());
                }
            } else if (obj instanceof OrgUnitInfo) {
                OrgUnitInfo comOrgInfo = (OrgUnitInfo)obj;
                comOrgs.add(comOrgInfo.getId().toString());
            }
        }
        HashSet<String> purOrgUnitIds = new HashSet<String>();
        obj = params.getObject("purOrg");
        if (obj != null) {
            if (obj instanceof Object[]) {
                Object[] objects;
                for (Object object : objects = (Object[])obj) {
                    if (object == null || !(object instanceof OrgUnitInfo)) continue;
                    OrgUnitInfo purOrgInfo = (OrgUnitInfo)object;
                    purOrgUnitIds.add(purOrgInfo.getId().toString());
                }
            } else if (obj instanceof OrgUnitInfo) {
                OrgUnitInfo purOrgInfo = (OrgUnitInfo)obj;
                purOrgUnitIds.add(purOrgInfo.getId().toString());
            }
        }
        String matIdStart = null;
        obj = params.getObject("matNumFrom");
        if (obj != null && obj instanceof MaterialInfo) {
            matIdStart = ((MaterialInfo)obj).getNumber();
        }
        String matIdEnd = null;
        obj = params.getObject("matNumTo");
        if (obj != null && obj instanceof MaterialInfo) {
            matIdEnd = ((MaterialInfo)obj).getNumber();
        }
        String supplierName = params.getString("supplierName");
        String easOrderNum = null;
        obj = params.getObject("esaOrderNum");
        if (obj != null && obj instanceof PurOrderInfo) {
            PurOrderInfo orderInfo = (PurOrderInfo)obj;
            easOrderNum = orderInfo.getNumber();
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItem = filter.getFilterItems();
        if (!comOrgs.isEmpty()) {
            filterItem.add(new FilterItemInfo("easOrder.FCompanyOrgUnitID", comOrgs, CompareType.INCLUDE));
        }
        if (!purOrgUnitIds.isEmpty()) {
            filterItem.add(new FilterItemInfo("easOrder.FPurchaseOrgUnitID", purOrgUnitIds, CompareType.INCLUDE));
        }
        if (matIdStart != null) {
            filterItem.add(new FilterItemInfo("material.Fnumber", (Object)matIdStart, CompareType.GREATER_EQUALS));
        }
        if (matIdEnd != null) {
            filterItem.add(new FilterItemInfo("material.Fnumber", (Object)matIdEnd, CompareType.LESS_EQUALS));
        }
        if (supplierName != null && supplierName.trim().length() > 0) {
            filterItem.add(new FilterItemInfo("supplier.fname_l2", (Object)("%" + supplierName + "%"), CompareType.LIKE));
        }
        if (easOrderNum != null) {
            filterItem.add(new FilterItemInfo("easOrder.Fnumber", (Object)easOrderNum, CompareType.EQUALS));
        }
        if (params.getObject("easOrderBizDateFrom") != null) {
            filterItem.add(new FilterItemInfo("easOrder.FbizDate", (Object)DateHelper.getFilterDate((Date)((Date)params.getObject("easOrderBizDateFrom")), (String)"startDate"), CompareType.GREATER_EQUALS));
        }
        if (params.getObject("easOrderBizDateTo") != null) {
            filterItem.add(new FilterItemInfo("easOrder.FbizDate", (Object)DateHelper.getFilterDate((Date)((Date)params.getObject("easOrderBizDateTo")), (String)"endDate"), CompareType.LESS_EQUALS));
        }
        if ((webOrder = (WebOrderStatus)((Object)params.getObject("webOrderStatus"))) != null) {
            if (!WebOrderStatus.NONE.equals((Object)webOrder)) {
                filterItem.add(new FilterItemInfo("webOrder.FStatus", (Object)webOrder.getName(), CompareType.EQUALS));
            }
        }
        if (params.getObject("isWeb") != null && Boolean.valueOf(params.getObject("isWeb").toString()).booleanValue()) {
            if (params.getString("payType") != null && !"0".equals(params.getString("payType"))) {
                filterItem.add(new FilterItemInfo("webOrder.FtradeTypeStr", (Object)params.getString("payType"), CompareType.EQUALS));
            }
        } else {
            WebOrderPayTypeEnum payType = (WebOrderPayTypeEnum)((Object)params.getObject("payType"));
            if (payType != null) {
                if (!WebOrderPayTypeEnum.NONE.equals((Object)payType)) {
                    filterItem.add(new FilterItemInfo("webOrder.FtradeTypeStr", (Object)payType.getValue(), CompareType.EQUALS));
                }
            }
        }
        if ((matName = params.getString("matName")) != null && matName.trim().length() > 0) {
            filterItem.add(new FilterItemInfo("material.fname_l2", (Object)("%" + matName + "%"), CompareType.LIKE));
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("insert into " + tempTable + "\t\n");
        sqlBuffer.append(" (FwebOrderId,FwebOrderStatus,FwebTradeType,FsureDays,FeasOrderNumber,FsuppNumber,FSuppName,FMatNumber,FMatName,Fmodel,Funit,Fqty,FTaxPrice,FSumPrice,FsumAmounts,FTotalReceiptQty,FtotalInvAmount,FTotalInvoicedQty,FTotalInvoicedAmount,FComOrgName,FpurOrgName,FPurId,FeasOrderId,FnetBuyofferId,FCompanyId,FPurOrderEntryId,FGmtCreate,FOtherNumber,FPaymentNumber,fpurreqid,fOtherid,FPaymentid)\r\n");
        sqlBuffer.append("select distinct \r\n");
        sqlBuffer.append(" webOrder.Fid as FwebOrderId,  \r\n");
        sqlBuffer.append(" case webOrder.FStatus \r\n");
        sqlBuffer.append("\twhen 'CANCEL' then '\u8ba2\u5355\u5173\u95ed'\r\n");
        sqlBuffer.append("\twhen 'SUCCESS' then '\u4ea4\u6613\u6210\u529f'\r\n");
        sqlBuffer.append("\twhen 'WAIT_BUYER_PAY' then '\u5f85\u4ed8\u6b3e'\r\n");
        sqlBuffer.append("\twhen 'WAIT_SELLER_SEND' then '\u5f85\u5356\u5bb6\u53d1\u8d27'\r\n");
        sqlBuffer.append("\twhen 'WAIT_BUYER_RECEIVE' then '\u5f85\u786e\u8ba4\u6536\u8d27'\r\n");
        sqlBuffer.append("\twhen 'WAIT_SELLER_ACT' then '\u5206\u9636\u6bb5\u7b49\u5f85\u5356\u5bb6\u64cd\u4f5c'\r\n");
        sqlBuffer.append("\twhen 'WAIT_BUYER_CONFIRM_ACTION' then '\u5206\u9636\u6bb5\u5f85\u786e\u8ba4\u5356\u5bb6\u64cd\u4f5c'\r\n");
        sqlBuffer.append("\twhen 'WAIT_SELLER_PUSH' then '\u5206\u9636\u6bb5\u7b49\u5f85\u5356\u5bb6\u63a8\u8fdb'\r\n");
        sqlBuffer.append("\twhen 'WAIT_LOGISTICS_TAKE_INv' then '\u7b49\u5f85\u7269\u6d41\u516c\u53f8\u63fd\u4ef6'\r\n");
        sqlBuffer.append("\twhen 'WAIT_BUYER_SIGN' then '\u5f85\u7b7e\u6536'\r\n");
        sqlBuffer.append("\twhen 'SIGN_IN_SUCCESS' then '\u5df2\u7b7e\u6536'\r\n");
        sqlBuffer.append("\tend\r\n");
        sqlBuffer.append("as FwebOrderStatus, \r\n");
        sqlBuffer.append("case webOrder.FtradeTypeStr \r\n");
        sqlBuffer.append("\twhen '1' then '\u62c5\u4fdd\u4ea4\u6613' \r\n");
        sqlBuffer.append("\twhen '2' then '\u9884\u5b58\u6b3e\u4ea4\u6613' \r\n");
        sqlBuffer.append("\twhen '3' then 'ETC\u5883\u5916\u6536\u5355\u4ea4' \r\n");
        sqlBuffer.append("\twhen '4' then '\u53ca\u65f6\u5230\u8d26\u4ea4\u6613' \r\n");
        sqlBuffer.append("\twhen '5' then '\u4fdd\u969c\u91d1\u5b89\u5168\u4ea4\u6613' \r\n");
        sqlBuffer.append("\twhen '6' then '\u7edf\u4e00\u4ea4\u6613\u6d41\u7a0b' \r\n");
        sqlBuffer.append("\twhen '7' then '\u5206\u9636\u6bb5\u4ea4\u6613' \r\n");
        sqlBuffer.append("\twhen '8' then '\u8d27\u5230\u4ed8\u6b3e\u4ea4\u6613' \r\n");
        sqlBuffer.append("\twhen '9' then '\u4fe1\u7528\u51ed\u8bc1\u652f\u4ed8\u4ea4\u6613' \r\n");
        sqlBuffer.append("\twhen '10' then '\u8d26\u671f\u652f\u4ed8' \r\n");
        sqlBuffer.append(" end  as FwebTradeType, \r\n");
        sqlBuffer.append(" case when easOrderEntry.FTotalReceiptQty > 0 then 0else datediff(day,weborder.FGmtCreate,getdate())+1 end as FsureDays, \r\n");
        sqlBuffer.append(" easOrder.Fnumber as FeasOrderNumber, \r\n");
        sqlBuffer.append(" supplier.fnumber as FsuppNumber, \r\n");
        sqlBuffer.append(" supplier.fname_l2 as FSuppName, \r\n");
        sqlBuffer.append(" material.fnumber as FMatNumber, \r\n");
        sqlBuffer.append(" easOrderEntry.FmaterialName as FMatName, \r\n");
        sqlBuffer.append(" material.FModel as Fmodel,\r\n");
        sqlBuffer.append(" unit.fname_l2 as Funit,  \r\n");
        sqlBuffer.append(" easOrderEntry.Fqty as Fqty, \r\n");
        sqlBuffer.append(" easOrderEntry.FtaxPrice as FTaxPrice, \r\n");
        sqlBuffer.append(" easOrderEntry.FtaxAmount as FSumPrice, \r\n");
        sqlBuffer.append(" easOrder.FtotalTaxAmount as FsumAmount, \r\n");
        sqlBuffer.append(" easOrderEntry.FTotalReceiptQty as FTotalReceiptQty, \r\n");
        sqlBuffer.append(" case webOrder.FStatus \r\n");
        sqlBuffer.append(" when 'WAIT_BUYER_RECEIVE'  then webOrder.FSumparyment/100\r\n");
        sqlBuffer.append(" when 'SUCCESS' then  webOrder.FSumparyment/100\r\n");
        sqlBuffer.append(" else 0.00 end as FtotalInvAmount,\r\n");
        sqlBuffer.append("easOrderEntry.FTotalInvoicedQty as FTotalInvoicedQty,\r\n");
        sqlBuffer.append("easOrderEntry.FTotalInvoicedAmount as FTotalInvoicedAmount,\r\n");
        sqlBuffer.append(" comOrg.fname_l2 as FComOrgName, \r\n");
        sqlBuffer.append(" purOrg.Fname_l2 as FpurOrgName, \r\n");
        sqlBuffer.append(" pureqentry.fid as FPurId, \r\n");
        sqlBuffer.append(" easOrder.fid as FeasOrderId, \r\n");
        sqlBuffer.append(" easOrderEntry.fnetBuyofferId as FnetBuyofferId ,\r\n");
        sqlBuffer.append(" easOrder.FCompanyOrgUnitID as FcompanyId, \r\n");
        sqlBuffer.append(" easOrderEntry.FID as FPurOrderEntryId, \r\n");
        sqlBuffer.append(" easOrder.FbizDate as FGmtCreate, \r\n");
        sqlBuffer.append("  other.Fnumber as FOtherNumber,\r\n");
        sqlBuffer.append(" payment.Fnumber as FPaymentNumber,\r\n");
        sqlBuffer.append("  pureqentry.FPARENTID  as fpurreqid,\r\n");
        sqlBuffer.append("  other.fid as fOtherid,\r\n");
        sqlBuffer.append(" payment.fid as FPaymentid\r\n");
        sqlBuffer.append(" from t_sm_purorder  as \"easOrder\" \r\n");
        sqlBuffer.append(" left outer join  t_sm_webOrdermodelali as \"webOrder\"\r\n");
        sqlBuffer.append(" on easOrder.Fnetorderid = webOrder.Fid \r\n");
        sqlBuffer.append(" left outer join t_sm_purorderentry as \"easOrderEntry\" \r\n");
        sqlBuffer.append(" on easOrderEntry.Fparentid = easOrder.Fid \r\n");
        sqlBuffer.append(" LEFT OUTER JOIN T_BD_Supplier AS \"supplier\" \r\n");
        sqlBuffer.append(" ON easOrder.fsupplierid = supplier.fid \r\n");
        sqlBuffer.append(" left outer join t_bd_material as \"material\" \r\n");
        sqlBuffer.append(" on easOrderEntry.FmaterialId = material.fid \r\n");
        sqlBuffer.append(" left outer join t_sm_quotationitemali as \"quoItem\" \r\n");
        sqlBuffer.append(" on easOrderEntry.fnetquotationitemid = quoItem.FID \r\n");
        sqlBuffer.append(" left outer join t_sm_purrequestentry as \"pureqentry\" \r\n");
        sqlBuffer.append(" on easOrderEntry.fsourcebillEntryid = pureqentry.fid \r\n");
        sqlBuffer.append(" left outer join T_ORG_Purchase as \"purOrg\"");
        sqlBuffer.append(" on easOrder.FPurchaseOrgUnitID = purOrg.Fid\r\n");
        sqlBuffer.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS \"UNIT\" \r\n");
        sqlBuffer.append(" ON easOrderEntry.FUnitID = unit.FID\r\n");
        sqlBuffer.append("LEFT OUTER JOIN T_ORG_Company AS \"comOrg\" \r\n");
        sqlBuffer.append("ON easOrder.FCompanyOrgUnitID = comOrg.FID\r\n");
        sqlBuffer.append(" left outer join t_ap_otherbillEntry as \"otherEntry\" \r\n");
        sqlBuffer.append(" on otherEntry.FCoreBillEntryId = easOrderEntry.Fid\r\n");
        sqlBuffer.append(" left outer join t_ap_otherbill as \"other\" \r\n");
        sqlBuffer.append(" on other.Fid = otherEntry.FParentId\r\n");
        sqlBuffer.append(" left outer join t_cas_paymentBillEntry as \"paymentEntry\"\r\n");
        sqlBuffer.append(" on paymentEntry.FCoreBillEntryId = easOrderEntry.Fid\r\n");
        sqlBuffer.append(" left outer join t_cas_paymentBill as \"payment\"\r\n");
        sqlBuffer.append("on payment.Fid = paymentEntry.FPaymentBillID\r\n");
        sqlBuffer.append(" where \r\n");
        sqlBuffer.append(filter.toString() + "\r\n");
        sqlBuffer.append("and easOrder.FIsNetOrder = 1\r\n");
        sqlBuffer.append(" and easOrderEntry.fjdorderid is null ");
        WebOrderPostEnum webOrderPost = (WebOrderPostEnum)((Object)params.getObject("webOrderPost"));
        if (webOrderPost != null && !WebOrderPostEnum.NONE.equals((Object)webOrderPost)) {
            if (WebOrderPostEnum.YES.equals((Object)webOrderPost)) {
                sqlBuffer.append("and webOrder.FId is not null \r\n");
            } else if (WebOrderPostEnum.NO.equals((Object)webOrderPost)) {
                sqlBuffer.append(" and webOrder.FId is null\r\n");
            }
        }
        this.executeUpdate(sqlBuffer.toString(), null, ctx);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        RptRowSet rs = this.executeQuery("select count(*) as count from " + tempTable, null, ctx);
        if (rs.next()) {
            result.setInt("RowCount", rs.getInt("count"));
        }
        return result;
    }

    private String getCreateTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table TempTable \r\n");
        sql.append("( FwebOrderId Varchar(44),\r\n");
        sql.append(" FwebOrderStatus varchar(50), \r\n");
        sql.append(" FwebTradeType varchar(50), \r\n");
        sql.append(" FsureDays int, \r\n");
        sql.append(" FeasOrderNumber  nvarchar(80), \r\n");
        sql.append(" FsuppNumber  nvarchar(80), \r\n");
        sql.append(" FSuppName  nvarchar(255), \r\n");
        sql.append(" FMatNumber  nvarchar(80), \r\n");
        sql.append(" FMatName  nvarchar(255), \r\n");
        sql.append(" Fmodel  nvarchar(255), \r\n");
        sql.append(" Funit  varchar(20), \r\n");
        sql.append(" Fqty NUMERIC(19,2), \r\n");
        sql.append(" FTaxPrice NUMERIC(19,2), \r\n");
        sql.append(" FSumPrice NUMERIC(19,2), \r\n");
        sql.append(" FsumAmounts NUMERIC(19,2), \r\n");
        sql.append(" FTotalReceiptQty NUMERIC(19,2), \r\n");
        sql.append(" FtotalInvAmount NUMERIC(19,2), \r\n");
        sql.append(" FTotalInvoicedQty NUMERIC(19,2), \r\n");
        sql.append(" FTotalInvoicedAmount NUMERIC(19,2), \r\n");
        sql.append(" FOtherNumber  nvarchar(80), \r\n");
        sql.append(" FPaymentNumber  nvarchar(80), \r\n");
        sql.append(" FComOrgName nvarchar(255), \r\n");
        sql.append(" FpurOrgName nvarchar(255), \r\n");
        sql.append(" FGmtCreate datetime, \r\n");
        sql.append(" FPurId varchar(44), \r\n");
        sql.append(" FeasOrderId varchar(44), \r\n");
        sql.append(" FPurOrderEntryId varchar(44), \r\n");
        sql.append(" FcompanyId varchar(44), \r\n");
        sql.append(" FnetBuyofferId varchar(44), \r\n");
        sql.append(" fpurreqid varchar(44), \r\n");
        sql.append(" fOtherid varchar(44), \r\n");
        sql.append(" FPaymentid varchar(44))\r\n");
        return sql.toString();
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        RptParams rpt = new RptParams();
        StringBuffer sql = new StringBuffer();
        sql.append("select  \r\n");
        sql.append("FeasOrderId as Id ,\r\n");
        sql.append("0, \r\n");
        sql.append(" FeasOrderNumber,\r\n");
        sql.append(" FComOrgName, \r\n");
        sql.append(" FpurOrgName, \r\n");
        sql.append(" FwebOrderId,\r\n");
        sql.append(" FwebOrderStatus,\r\n");
        sql.append(" FwebTradeType,\r\n");
        sql.append(" FGmtCreate ,\r\n");
        sql.append(" FsureDays,\r\n");
        sql.append(" FsuppNumber,\r\n");
        sql.append(" FSuppName,\r\n");
        sql.append(" FMatNumber,\r\n");
        sql.append(" FMatName,\r\n");
        sql.append(" Fmodel,\r\n");
        sql.append(" Funit,\r\n");
        sql.append(" Fqty,\r\n");
        sql.append(" FTaxPrice,\r\n");
        sql.append(" FSumPrice, \r\n");
        sql.append(" FTotalReceiptQty,\r\n");
        sql.append(" FTotalInvoicedQty,\r\n");
        sql.append(" FsumAmounts, \r\n");
        sql.append(" FTotalInvoicedAmount ,\r\n");
        sql.append(" FtotalInvAmount,\r\n");
        sql.append(" FPurId,\r\n");
        sql.append(" FeasOrderId,\r\n");
        sql.append(" FnetBuyofferId,\r\n");
        sql.append(" FcompanyId, \r\n");
        sql.append(" FPurOrderEntryId, \r\n");
        sql.append(" FOtherNumber, \r\n");
        if (params.getBoolean("isPage")) {
            sql.append(" FPaymentNumber, \r\n");
            sql.append(" fpurreqid, \r\n");
            sql.append(" fOtherid, \r\n");
            sql.append(" FPaymentid \r\n");
        } else {
            sql.append(" FPaymentNumber \r\n");
        }
        sql.append("FROM " + params.getString("tempTable") + " as temp \r\n");
        sql.append("order by FeasOrderNumber desc \r\n");
        RptRowSet rs = null;
        rs = params.getBoolean("isPage") ? this.executeQuery(sql.toString(), null, from, len, ctx) : this.executeQuery(sql.toString(), null, ctx);
        rpt.setObject("rowSet", (Object)rs);
        String sumSql = "select sum(Fqty),sum(FSumPrice),sum(FTotalReceiptQty),sum(FTotalInvoicedQty),sum(FTotalInvoicedAmount) from " + params.getString("tempTable");
        RptRowSet sumRs = null;
        sumRs = params.getBoolean("isPage") ? this.executeQuery(sumSql, null, from, len, ctx) : this.executeQuery(sumSql, null, ctx);
        while (sumRs.next()) {
            rpt.setBigDecimal("sumQty", sumRs.getBigDecimal(0));
            rpt.setBigDecimal("sumTaxAmounts", sumRs.getBigDecimal(1));
            rpt.setBigDecimal("totalReceiptQty", sumRs.getBigDecimal(2));
            rpt.setBigDecimal("totalInvoicedQty", sumRs.getBigDecimal(3));
            rpt.setBigDecimal("totalInvoicedAmount", sumRs.getBigDecimal(4));
        }
        String sumSql2 = "select sum(FtotalInvAmount) from (select distinct FwebOrderId,FtotalInvAmount from " + params.getString("tempTable") + ") as \"temp\"";
        sumRs = this.executeQuery(sumSql2, null, ctx);
        while (sumRs.next()) {
            rpt.setBigDecimal("totalInvAmount", sumRs.getBigDecimal(0));
        }
        return rpt;
    }
}

