/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app.message;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.json.JSONException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.b2b.app.info.BuyerCloseOrderMsg;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.IMessageService;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.pushletClient.EASWorker;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class BuyerCloseOrderMsgService
extends EASWorker
implements IMessageService<BuyerCloseOrderMsg> {
    private static Logger logger = Logger.getLogger(BuyerCloseOrderMsgService.class);

    @Override
    public boolean process(Context ctx, BuyerCloseOrderMsg msgInfo) throws Exception {
        boolean bl;
        if (msgInfo == null) {
            return false;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        String webOrderId = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            webOrderId = msgInfo.getData().get("orderId");
            String sql = "update T_SM_WebOrderModelali set FStatus='CANCEL' where FId=?";
            ps = conn.prepareStatement(sql);
            ps.setString(1, webOrderId);
            this.updatePurOrderHeader(conn, msgInfo);
            this.updatePurOrderEntry(conn, msgInfo);
            bl = ps.executeUpdate() > 0;
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return bl;
    }

    private void updatePurOrderHeader(Connection conn, BuyerCloseOrderMsg msgInfo) throws SQLException {
        String sql = "update t_sm_purorder set FnetOrderId= null where FnetOrderId=? ";
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setString(1, msgInfo.getData().get("orderId"));
        ps.close();
    }

    private void updatePurOrderEntry(Connection conn, BuyerCloseOrderMsg msgInfo) throws SQLException, JSONException {
        String sql = "update t_sm_purorderentry set FnetOrderEntryId=null where FnetQuotationId=?";
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setString(1, msgInfo.getData().get("quotationId"));
        ps.close();
    }

    @Override
    public Message runInEAS(Context ctx, Message message) throws EASBizException, BOSException {
        BuyerCloseOrderMsg msg = new BuyerCloseOrderMsg();
        msg.copyMessage(message);
        try {
            this.process(ctx, msg);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }
}

