/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app.message;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.permission.UserFacadeFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.b2b.PurB2BFacadeFactory;
import com.kingdee.eas.scm.sm.pur.b2b.app.info.BuyerPaySuccessMsg;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.IMessageService;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.pushletClient.EASWorker;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class BuyerPayedMsgService
extends EASWorker
implements IMessageService<BuyerPaySuccessMsg> {
    private static Logger logger = Logger.getLogger(BuyerPayedMsgService.class);

    @Override
    public Message runInEAS(Context ctx, Message message) throws EASBizException, BOSException {
        BuyerPaySuccessMsg msg = new BuyerPaySuccessMsg();
        msg.copyMessage(message);
        try {
            this.process(ctx, msg);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    public boolean process(Context ctx, BuyerPaySuccessMsg msgInfo) throws Exception {
        if (msgInfo == null) {
            return false;
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String webOrderId = msgInfo.getData().get("orderId");
            this.updateWebOrder(conn, webOrderId);
            String erpUserId = msgInfo.getData().get("erpUserId");
            if (erpUserId == null) {
                throw new EASBizException(new NumericExceptionSubItem("10000", "\u751f\u6210\u5e94\u4ed8\u5355\u5931\u8d25\uff0ceprUerId\u4e3a\u7a7a"));
            }
            if (erpUserId != null && erpUserId.trim().length() > 0) {
                UserInfo userInfo = UserFacadeFactory.getLocalInstance((Context)ctx).getUserInfo4LoinModule(erpUserId);
                ctx.put((Object)"UserInfo", (Object)userInfo);
                ctx.setUserName(userInfo.getName());
                ctx.setCaller((IObjectPK)new ObjectUuidPK(userInfo.getId().toString()));
                PurB2BFacadeFactory.getLocalInstance(ctx).addPaymentBillByOrder(webOrderId);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private boolean updateWebOrder(Connection conn, String webOrderId) throws SQLException {
        String sql = "update T_SM_WebOrderModelali set FStatus='WAIT_BUYER_RECEIVE' where FId=?";
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setString(1, webOrderId);
        boolean b = ps.executeUpdate() > 0;
        ps.close();
        return b;
    }
}

