/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app.message;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.b2b.PurB2BFacadeFactory;
import com.kingdee.eas.scm.sm.pur.b2b.app.info.BuyerPublishBuyofferMsg;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.IMessageService;
import com.kingdee.eas.scm.sm.pur.b2b.model.BuyOfferInfo;
import com.kingdee.eas.scm.sm.pur.b2b.model.BuyOfferItem;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.pushletClient.EASWorker;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.log4j.Logger;

public class PublishBuyOfferMsgService
extends EASWorker
implements IMessageService<BuyerPublishBuyofferMsg> {
    private static Logger logger = Logger.getLogger(PublishBuyOfferMsgService.class);

    @Override
    public Message runInEAS(Context ctx, Message message) throws EASBizException, BOSException {
        BuyerPublishBuyofferMsg msg = new BuyerPublishBuyofferMsg();
        msg.copyMessage(message);
        try {
            this.process(ctx, msg);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    public boolean process(Context ctx, BuyerPublishBuyofferMsg msgInfo) throws BOSException {
        String buyOfferid = msgInfo.getData().get("buyOfferId");
        String companyId = msgInfo.getCompanyId();
        Connection conn = null;
        try {
            BuyOfferInfo buyInfo = PurB2BFacadeFactory.getLocalInstance(ctx).getBuyOfferByPrId(buyOfferid, companyId);
            conn = EJBFactory.getConnection((Context)ctx);
            this.updatePurReqEntry(conn, buyInfo);
            this.saveBuyOffer(conn, buyInfo, companyId, buyOfferid);
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        return false;
    }

    private boolean updatePurReqEntry(Connection conn, BuyOfferInfo buyInfo) throws EASBizException, BOSException, SQLException {
        String updateSQL = "update T_SM_PurRequestEntry set FnetBuyOfferItemId = ? where FID = ?";
        PreparedStatement ps = conn.prepareStatement("update T_SM_PurRequestEntry set FnetBuyOfferItemId = ? where FID = ?");
        BuyOfferItem item = null;
        for (int i = 0; i < buyInfo.getPurchaseNoteItems().size(); ++i) {
            item = buyInfo.getPurchaseNoteItems().getItem(i);
            ps.setString(1, buyInfo.getPurchaseNoteId());
            ps.setString(2, item.getPrItemId());
            ps.addBatch();
        }
        int[] count = ps.executeBatch();
        int sum = 0;
        for (int i = 0; i < count.length; ++i) {
            sum += count[i];
        }
        ps.close();
        return sum > 0;
    }

    private boolean saveBuyOffer(Connection conn, BuyOfferInfo buyInfo, String companyId, String buyOfferid) throws SQLException {
        if (this.isBuyOfferSaved(conn, buyOfferid)) {
            return false;
        }
        int result = 0;
        result += this.saveBuyOfferHead(conn, buyInfo, companyId);
        return (result += this.saveBuyOfferItem(conn, buyInfo.getPurchaseNoteItems().getItemsList(), buyOfferid)) > 0;
    }

    private int saveBuyOfferHead(Connection conn, BuyOfferInfo buyInfo, String companyId) throws SQLException {
        int result = 0;
        String sql = "insert into T_SM_BuyOfferAli (FPurchaseNoteId,FTitle,FStatus,FSubUserId,FBuyerMemberId,FGmtCreate,FGmtQuotationExpire,FPrId,FDescription,FContactName,FMobile,FPhone,FEmail,FIncludeTax,FProvince,FCity,FDistrict,FIsVisibleAfterEndQuote,FCompanyId) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setString(1, buyInfo.getPurchaseNoteId());
        ps.setString(2, buyInfo.getTitle());
        ps.setString(3, buyInfo.getStatus());
        ps.setString(4, buyInfo.getSubUserId());
        ps.setString(5, buyInfo.getBuyerMemberId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (buyInfo.getGmtCreate() != null) {
            ps.setTimestamp(6, Timestamp.valueOf(sdf.format(buyInfo.getGmtCreate().getTime())));
        } else {
            ps.setTimestamp(6, null);
        }
        if (buyInfo.getGmtQuotationExpire() != null) {
            ps.setTimestamp(7, Timestamp.valueOf(sdf.format(buyInfo.getGmtQuotationExpire().getTime())));
        } else {
            ps.setTimestamp(7, null);
        }
        ps.setString(8, buyInfo.getPrId());
        ps.setString(9, buyInfo.getDescription());
        if (buyInfo.getContactInfo() != null) {
            ps.setString(10, buyInfo.getContactInfo().getContact());
            ps.setString(11, buyInfo.getContactInfo().getMobile());
            ps.setString(12, buyInfo.getContactInfo().getPhone());
            ps.setString(13, buyInfo.getContactInfo().getEmail());
        } else {
            ps.setString(10, null);
            ps.setString(11, null);
            ps.setString(12, null);
            ps.setString(13, null);
        }
        ps.setString(14, String.valueOf(buyInfo.isIncludeTax()));
        if (buyInfo.getReceiptAddress() != null) {
            ps.setString(15, buyInfo.getReceiptAddress().getProvince());
            ps.setString(16, buyInfo.getReceiptAddress().getCity());
            ps.setString(17, buyInfo.getReceiptAddress().getDistrict());
        } else {
            ps.setString(15, null);
            ps.setString(16, null);
            ps.setString(17, null);
        }
        ps.setString(18, String.valueOf(buyInfo.isVisibleAfterEndQuote()));
        ps.setString(19, companyId);
        result = ps.executeUpdate();
        ps.close();
        return result;
    }

    private int saveBuyOfferItem(Connection conn, List<BuyOfferItem> buyItems, String buyOfferid) throws SQLException {
        int result = 0;
        String sql = "insert into T_SM_BuyOfferItemAli (FPurchaseNoteItemId, FSubject, FUnit, FPurchaseAmount, FProductCode,FDesc,FPrItemId,FParentId) values(?,?,?,?,?,?,?,?)";
        PreparedStatement ps = conn.prepareStatement(sql);
        for (BuyOfferItem buyItem : buyItems) {
            ps.setString(1, buyItem.getPurchaseNoteItemId());
            ps.setString(2, buyItem.getSubject());
            ps.setString(3, buyItem.getUnit());
            ps.setLong(4, buyItem.getPurchaseAmount());
            ps.setString(5, buyItem.getProductCode());
            ps.setString(6, buyItem.getDesc());
            ps.setString(7, buyItem.getPrItemId());
            ps.setString(8, buyOfferid);
            ps.addBatch();
        }
        int[] results = ps.executeBatch();
        for (int i = 0; i < results.length; ++i) {
            result += results[i];
        }
        ps.close();
        return result;
    }

    private boolean isBuyOfferSaved(Connection conn, String buyOfferId) throws SQLException {
        String sql = "select count(*) as count from T_SM_BuyOfferAli where FPurchaseNoteId=?";
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setString(1, buyOfferId);
        ResultSet rs = ps.executeQuery();
        int result = 0;
        while (rs.next()) {
            result = rs.getInt("count");
        }
        ps.close();
        return result > 0;
    }
}

