/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app.message;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.b2b.PurB2BFacadeFactory;
import com.kingdee.eas.scm.sm.pur.b2b.app.info.SupplierQuotationMsg;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.IMessageService;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.PublishBuyOfferMsgService;
import com.kingdee.eas.scm.sm.pur.b2b.model.QuotationInfo;
import com.kingdee.eas.scm.sm.pur.b2b.model.QuotationItem;
import com.kingdee.eas.scm.sm.pur.b2b.model.SupplierInfo;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.pushletClient.EASWorker;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.log4j.Logger;

public class SupplierQuotationMsgService
extends EASWorker
implements IMessageService<SupplierQuotationMsg> {
    private static Logger logger = Logger.getLogger(PublishBuyOfferMsgService.class);

    @Override
    public boolean process(Context ctx, SupplierQuotationMsg msgInfo) throws SQLException, BOSException {
        if (msgInfo == null) {
            return false;
        }
        String quotationId = msgInfo.getQuotationId();
        String companyId = msgInfo.getCompanyId();
        QuotationInfo quoInfo = null;
        try {
            quoInfo = PurB2BFacadeFactory.getLocalInstance(ctx).getQuotationInfoById(quotationId, companyId);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            quoInfo.getSupplier().setDestId(msgInfo.getSupplierMemberId());
            if (!this.isQuotationSaved(conn, msgInfo.getQuotationId())) {
                this.saveQuotation(conn, quoInfo, msgInfo.getQuotationId());
            }
            this.saveSupplier(conn, quoInfo.getSupplier());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private int saveQuotation(Connection conn, QuotationInfo quoInfo, String quotationId) throws SQLException {
        int result = 0;
        result += this.saveQuotationHead(conn, quoInfo, quotationId);
        return result += this.saveQuotationItem(conn, quoInfo.getSupplyNoteItems().getItemsList(), quotationId);
    }

    private int saveQuotationHead(Connection conn, QuotationInfo quoInfo, String quotationId) throws SQLException {
        String sql = "insert into T_SM_QuotationAli (FId,FExpireDate,FBuyOfferId,FSupplierMemberId,FContactName,FMobile,FPhone,FEmail,FInvoiceType,FFreight,FTotalPrice,FSpecifications,FPayType,FPaySpecification,FGmtCreate,FPrId,FQuoStatus)  values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement ps = conn.prepareStatement(sql);
        long id = Long.parseLong(quotationId);
        ps.setLong(1, id);
        if (quoInfo.getExpireDate() != null) {
            ps.setTimestamp(2, new Timestamp(quoInfo.getExpireDate().getTime()));
        } else {
            ps.setTimestamp(2, null);
        }
        ps.setString(3, quoInfo.getBuyOfferId());
        ps.setString(4, quoInfo.getSupplierMemberId());
        if (quoInfo.getContactInfo() != null) {
            ps.setString(5, quoInfo.getContactInfo().getContact());
            ps.setString(6, quoInfo.getContactInfo().getMobile());
            ps.setString(7, quoInfo.getContactInfo().getPhone());
            ps.setString(8, quoInfo.getContactInfo().getEmail());
        } else {
            ps.setString(5, null);
            ps.setString(6, null);
            ps.setString(7, null);
            ps.setString(8, null);
        }
        if (quoInfo.getInvoiceType() != null) {
            ps.setString(9, quoInfo.getInvoiceType().name());
        } else {
            ps.setString(9, null);
        }
        ps.setLong(10, quoInfo.getFreight());
        ps.setLong(11, quoInfo.getTotalPrice());
        ps.setString(12, quoInfo.getSpecifications());
        if (quoInfo.getPayType() != null) {
            ps.setString(13, quoInfo.getPayType().name());
        } else {
            ps.setString(13, null);
        }
        ps.setString(14, quoInfo.getPaySpecification());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (quoInfo.getGmtCreate() != null) {
            ps.setTimestamp(15, Timestamp.valueOf(sdf.format(quoInfo.getGmtCreate().getTime())));
        } else {
            ps.setDate(15, null);
        }
        ps.setString(16, quoInfo.getPrId());
        ps.setString(17, "1");
        int result = ps.executeUpdate();
        ps.close();
        return result;
    }

    private int saveQuotationItem(Connection conn, List<QuotationItem> quoItems, String quotationId) throws SQLException {
        String sql = "insert into T_SM_QuotationItemAli (FId,FSubject,FProductId,FParentId,FAmount,FUnit,FPrice,FPrItemId,FTaxRate) values(?,?,?,?,?,?,?,?,?)";
        PreparedStatement ps = conn.prepareStatement(sql);
        for (QuotationItem item : quoItems) {
            ps.setLong(1, item.getId());
            ps.setString(2, item.getSubject());
            ps.setLong(3, item.getProductId());
            ps.setString(4, quotationId);
            ps.setInt(5, item.getAmount());
            ps.setString(6, item.getUnit());
            ps.setLong(7, item.getPrice());
            ps.setString(8, item.getPrItemId());
            ps.setString(9, item.getTaxRate());
            ps.addBatch();
        }
        int[] results = ps.executeBatch();
        int result = 0;
        for (int i = 0; i < results.length; ++i) {
            result += results[i];
        }
        ps.close();
        return result;
    }

    private int saveSupplier(Connection conn, SupplierInfo supplierInfo) throws SQLException {
        if (this.isSupplierSaved(conn, supplierInfo.getDestId())) {
            return 0;
        }
        String sql = "insert into T_SM_SupplierAli (FSupplierMemberId,FCompanyName,FPrincipal,FCompanyAddress,FRegistrationId,FEnterpriseType,FDateOfEstablishment,FRegisteredCapital,FContactName,FMobile,FGender,FPhone,FFax,FZipCode,FContactAddress) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setString(1, supplierInfo.getDestId());
        ps.setString(2, supplierInfo.getCompanyInfo().getName());
        ps.setString(3, supplierInfo.getCompanyInfo().getPrincipal());
        ps.setString(4, supplierInfo.getCompanyInfo().getCompanyAddress());
        ps.setString(5, supplierInfo.getCompanyInfo().getRegistrationId());
        ps.setString(6, supplierInfo.getCompanyInfo().getEnterpriseType());
        ps.setString(7, supplierInfo.getCompanyInfo().getDateOfEstablishment());
        ps.setString(8, supplierInfo.getCompanyInfo().getRegisteredCapital());
        ps.setString(9, supplierInfo.getContactInfo().getName());
        ps.setString(10, supplierInfo.getContactInfo().getMobile());
        ps.setString(11, supplierInfo.getContactInfo().getGender());
        ps.setString(12, supplierInfo.getContactInfo().getPhone());
        ps.setString(13, supplierInfo.getContactInfo().getFax());
        ps.setString(14, supplierInfo.getContactInfo().getZipCode());
        ps.setString(15, supplierInfo.getContactInfo().getContactAddress());
        int result = ps.executeUpdate();
        ps.close();
        return result;
    }

    private boolean isQuotationSaved(Connection conn, String quoId) throws SQLException {
        String sql = "select count(*) as count from T_SM_QuotationAli where FId=?";
        PreparedStatement ps = conn.prepareStatement(sql);
        long id = Long.parseLong(quoId);
        ps.setLong(1, id);
        ResultSet rs = ps.executeQuery();
        int result = 0;
        while (rs.next()) {
            result = rs.getInt("count");
        }
        ps.close();
        return result > 0;
    }

    private boolean isSupplierSaved(Connection conn, String destId) throws SQLException {
        String sql = "select count(*) as count from T_SM_SupplierAli where FSupplierMemberId=?";
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setString(1, destId);
        ResultSet rs = ps.executeQuery();
        int result = 0;
        while (rs.next()) {
            result = rs.getInt("count");
        }
        ps.close();
        return result > 0;
    }

    @Override
    public Message runInEAS(Context ctx, Message message) throws EASBizException, BOSException {
        SupplierQuotationMsg msg = new SupplierQuotationMsg();
        msg.copyMessage(message);
        try {
            this.process(ctx, msg);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }
}

