/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app.message.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AmountControlTypeEnum;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillEntryInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillFactory;
import com.kingdee.eas.cp.bc.OtherExpenseBillInfo;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.sm.pur.b2b.PurB2BFacadeFactory;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.model.NetPurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.model.NetPurOrderInfo;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.pushletClient.EASWorker;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class OtherExpenseRequestCreateMessageHandler
extends EASWorker {
    private static Logger logger = Logger.getLogger(OtherExpenseRequestCreateMessageHandler.class);

    @Override
    public Message runInEAS(Context ctx, Message message) throws EASBizException, BOSException {
        this.process(ctx, message);
        return null;
    }

    public void process(Context ctx, Message message) throws BOSException, EASBizException {
        logger.info((Object)"\u5f00\u59cb\u5904\u7406\u8ba2\u5355\u6d88\u606f");
        String orderId = message.getField("orderid");
        logger.info((Object)("\u5f00\u59cb\u5904\u7406\u8ba2\u5355\u6d88\u606f\uff0c\u4eac\u4e1c\u5355\u53f7\uff1a" + orderId));
        if (orderId == null || orderId.length() == 0) {
            throw new BOSException("\u91c7\u8d2d100JD\u521b\u5efa\u8d39\u7528\u7533\u8bf7\u5355\u6d88\u606f\u6570\u636e\u4e2d\u7f3a\u5c11\u8ba2\u5355ID");
        }
        String orderJson = null;
        NetPurOrderInfo netInfo = null;
        try {
            orderJson = PurB2BFacadeFactory.getLocalInstance(ctx).getPurpOrderInfo(orderId);
            netInfo = NetPurOrderInfo.create(new JSONObject(orderJson));
        }
        catch (JSONException e) {
            throw new BOSException("\u6d88\u606f\u6570\u636e\u4e0d\u5408\u6cd5\uff1a" + e.getMessage());
        }
        NetPurOrderEntryInfo netEntryInfo = null;
        ArrayList<String> purReqIds = new ArrayList<String>();
        ArrayList<String> purReqEntryIds = new ArrayList<String>();
        String purReqEntryId = null;
        String purReqId = null;
        for (int i = 0; i < netInfo.getEntrys().size(); ++i) {
            netEntryInfo = netInfo.getEntrys().get(i);
            purReqId = netEntryInfo.getErpBillId();
            purReqEntryId = netEntryInfo.getErpBillEntryId();
            if (!StringUtils.isEmpty((String)purReqEntryId)) {
                purReqEntryIds.add(purReqEntryId);
            }
            if (StringUtils.isEmpty((String)purReqId)) continue;
            purReqIds.add(purReqId);
        }
        String billNumber = this.createEasOtherExpenseRequestBill(ctx, netInfo);
        PurB2BFacadeFactory.getLocalInstance(ctx).writeBackERPBillNumber(orderId, billNumber);
    }

    private String createEasOtherExpenseRequestBill(Context ctx, NetPurOrderInfo netInfo) throws BOSException, EASBizException {
        logger.error((Object)"### cpbc createEasOtherExpenseRequestBill ");
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(netInfo.getCreatorID()));
        ctx.put((Object)"UserInfo", (Object)userInfo);
        ctx.setCaller((IObjectPK)new ObjectUuidPK(userInfo.getId().toString()));
        ctx.setUserName(userInfo.getName());
        OtherExpenseBillInfo info = new OtherExpenseBillInfo();
        logger.error((Object)("### cpbc createEasOtherExpenseRequestBill userInfo=" + userInfo));
        info.setCreator(userInfo);
        info.setBiller(userInfo);
        info.setName("\u8d39\u7528\u7533\u8bf7\u5355");
        logger.error((Object)("### cpbc createEasOtherExpenseRequestBill userInfo.getPerson()=" + userInfo.getPerson()));
        info.setApplier(userInfo.getPerson());
        info.setBizDate(new Date());
        info.setBizReqDate(new Date());
        info.setTel(netInfo.getPhone());
        info.setAmountControlType(AmountControlTypeEnum.oneTOone);
        info.setAmountApproved(netInfo.getTotalAmount());
        info.setDescription(netInfo.getRemark());
        this.setHeadDefaultValue(ctx, info, netInfo);
        List<NetPurOrderEntryInfo> entrys = netInfo.getEntrys();
        OtherExpenseBillEntryInfo entry = null;
        NetPurOrderEntryInfo netEntry = null;
        BigDecimal totalAmount = new BigDecimal("0.0");
        for (int i = 0; i < entrys.size(); ++i) {
            netEntry = entrys.get(i);
            entry = new OtherExpenseBillEntryInfo();
            BigDecimal mount = new BigDecimal("0.0");
            mount = netEntry.getPrice().multiply(new BigDecimal(netEntry.getQty()));
            totalAmount = totalAmount.add(mount);
            entry.setAmount(mount);
            entry.setAmountOri(mount);
            entry.setAmountApproved(mount);
            entry.setAmountApprovedOri(mount);
            entry.setCurrencyType(this.setCurrencyType());
            entry.setExchangeRate(new BigDecimal(1));
            String expenseTypeId = netEntry.getExpenseTypeId();
            ExpenseTypeInfo expenseType = null;
            if (expenseTypeId != null && expenseTypeId.trim().length() > 0) {
                expenseType = ExpenseTypeFactory.getLocalInstance((Context)ctx).getExpenseTypeInfo((IObjectPK)new ObjectUuidPK(expenseTypeId));
                entry.setExpenseType(expenseType);
            }
            entry.setPurpose(netEntry.getPurpose());
            entry.put("jdOrderId", (Object)netInfo.getJdOrderID());
            info.getEntries().add(entry);
        }
        info.setAmount(totalAmount);
        IObjectPK billID = null;
        String number = netInfo.getNumber();
        if (info.getApplierCompany() == null) {
            throw new BOSException("CompanyOrgUnit is null ,userID =" + info.getCreator().getId());
        }
        info.setNumber(number);
        info.setState(StateEnum.DRAFT);
        try {
            logger.error((Object)("##  cpbc OtherExpenseBill info =" + info));
            billID = OtherExpenseBillFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)info);
            logger.error((Object)("### cpbc OtherExpenseBill billID =" + billID));
        }
        catch (EASBizException e) {
            this.printExcetpion((Exception)((Object)e));
            throw new BOSException("save bill error " + e.getMessage() + e.getStackTrace());
        }
        catch (BOSException e) {
            this.printExcetpion((Exception)((Object)e));
            throw new BOSException("save bill error " + e.getMessage() + e.getStackTrace());
        }
        OtherExpenseBillInfo newInfo = OtherExpenseBillFactory.getLocalInstance((Context)ctx).getOtherExpenseBillInfo(billID);
        logger.error((Object)("### cpbc OtherExpenseBill newInfo =" + newInfo.getNumber()));
        return newInfo.getNumber();
    }

    private void setHeadDefaultValue(Context ctx, OtherExpenseBillInfo info, NetPurOrderInfo netInfo) throws BOSException, EASBizException {
        UserInfo user = info.getCreator();
        PersonInfo personInfo = user.getPerson();
        if (personInfo == null) {
            return;
        }
        IPerson iperson = PersonFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitInfo adminInfo = iperson.getPrimaryAdminOrgUnit(personInfo.getId());
        PositionInfo position = iperson.getPrimaryPosition(personInfo.getId());
        info.setOrgUnit(adminInfo);
        info.setCostedDept(this.getCostCenterByAdmin(ctx, adminInfo));
        info.setPosition(position);
        if (adminInfo == null) {
            return;
        }
        CompanyOrgUnitInfo companyInfo = this.getHasPermissionOrg(ctx, user, netInfo.getCompanyID());
        info.setApplierCompany(companyInfo);
        info.setCompany(companyInfo);
        info.setCurrencyType(this.setCurrencyType());
        info.setPayMode(this.setPayMode(ctx, info));
        info.setCreateTime(new Timestamp(new Date().getTime()));
        info.setBizDate(new Date());
        info.setBizReqDate(new Date());
        info.setCU(companyInfo.getCU());
    }

    private CompanyOrgUnitInfo getHasPermissionOrg(Context ctx, UserInfo user, String companyId) throws EASBizException, BOSException {
        Set orgsID = this.getAuthorizedCompanyOrgIds(ctx, user.getId().toString(), "cp_bc_Expense_Update");
        CompanyOrgUnitInfo company = null;
        if (orgsID == null || orgsID.size() == 0) {
            logger.error((Object)("### cpbc OtherExpenseBill no permission =" + user.getId().toString()));
            return null;
        }
        if (companyId != null && orgsID.contains(companyId)) {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)));
            logger.error((Object)("### cpbc OtherExpenseBill netPurOrderInfoCompany =" + company.getNumber()));
        }
        if (company == null && orgsID.contains(companyId) && user.getDefOrgUnit() != null) {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(user.getDefOrgUnit().getId()));
            logger.error((Object)("### cpbc OtherExpenseBill userCompany =" + company.getNumber()));
        }
        if (company == null) {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgsID.toArray()[0].toString()));
            logger.error((Object)("### cpbc OtherExpenseBill the first Company =" + company.getId().toString()));
        }
        return company;
    }

    private AdminOrgUnitInfo getAdminOrgBy(Context ctx, AdminOrgUnitInfo adminOrg, CompanyOrgUnitInfo companyOrgInfo) throws BOSException, EASBizException {
        if (companyOrgInfo == null) {
            return adminOrg;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getFromUnit(companyOrgInfo.getId().toString(), 1, 0);
        if (adminOrg == null) {
            return (AdminOrgUnitInfo)orgCol.get(0);
        }
        int size = orgCol.size();
        OrgUnitInfo org = null;
        HashMap<String, OrgUnitInfo> orgMap = new HashMap<String, OrgUnitInfo>();
        for (int i = 0; i < size; ++i) {
            org = orgCol.get(i);
            orgMap.put(org.getId().toString(), org);
        }
        String adminId = adminOrg.getId().toString();
        if (orgMap.get(adminId) == null) {
            return (AdminOrgUnitInfo)orgCol.get(0);
        }
        return adminOrg;
    }

    public CompanyOrgUnitInfo getCompanyInfo(Context ctx, AdminOrgUnitInfo adminOrg) throws BOSException, EASBizException {
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getToUnit(adminOrg.getId().toString(), 0, 1);
        return (CompanyOrgUnitInfo)orgCol.get(0);
    }

    public static String getInStringFromList(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            in.append("'").append(iter.next().toString()).append("'");
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    private Set getAuthorizedCompanyOrgIds(Context ctx, String userId, String permissionItem) throws BOSException {
        HashSet<String> authorizedOrgIds = null;
        if (!StringUtil.isEmpty((String)userId) && !StringUtil.isEmpty((String)permissionItem)) {
            try {
                FullOrgUnitCollection orgUnitCol = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userId), OrgType.Company, null, permissionItem);
                authorizedOrgIds = new HashSet<String>(orgUnitCol.size());
                int size = orgUnitCol.size();
                for (int i = 0; i < size; ++i) {
                    authorizedOrgIds.add(orgUnitCol.get(i).getId().toString());
                }
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return authorizedOrgIds;
    }

    private void printExcetpion(Exception e) {
        StackTraceElement[] stack = e.getStackTrace();
        logger.error((Object)e.getMessage());
        for (int i = 0; i < stack.length; ++i) {
            logger.error((Object)stack[i].toString());
        }
    }

    private CostCenterOrgUnitInfo getCostCenterOrgUnit(Context ctx, AdminOrgUnitInfo adminOrgUnitInfo) throws BOSException, EASBizException {
        CostCenterOrgUnitInfo retInfo = null;
        CostCenterOrgUnitInfo tmpInfo = this.getCostCenterByAdmin(ctx, adminOrgUnitInfo);
        if (tmpInfo == null) {
            return null;
        }
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add(new SelectorItemInfo("*"));
        CostCenterOrgUnitInfo costCenterOrgUnitInfo = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(tmpInfo.getId().toString()), selectorColl);
        boolean isEntity = BizCollUtil.isBizUnitCostCenter((Context)ctx, (CostCenterOrgUnitInfo)costCenterOrgUnitInfo);
        boolean isSealUp = BizCollUtil.isSealUpCostCenter((Context)ctx, (CostCenterOrgUnitInfo)costCenterOrgUnitInfo);
        if (isEntity && !isSealUp) {
            retInfo = tmpInfo;
        } else {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            OrgUnitCollection tmpColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(adminOrgUnitInfo.getId().toString(), 0, 5);
            HashSet<BOSUuid> idSet = new HashSet<BOSUuid>();
            if (tmpColl != null && tmpColl.size() > 0) {
                for (int i = 0; i < tmpColl.size(); ++i) {
                    idSet.add(tmpColl.get(i).getId());
                }
            }
            EntityViewInfo envi = new EntityViewInfo();
            FilterInfo fiter = new FilterInfo();
            fiter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            envi.setFilter(fiter);
            CostCenterOrgUnitCollection costCenterCol = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitCollection(envi);
            if (costCenterCol != null) {
                for (int i = 0; i < costCenterCol.size(); ++i) {
                    if (!BizCollUtil.isBizUnitCostCenter((Context)ctx, (CostCenterOrgUnitInfo)costCenterCol.get(i)) || BizCollUtil.isSealUpCostCenter((Context)ctx, (CostCenterOrgUnitInfo)costCenterCol.get(i))) continue;
                    retInfo = costCenterCol.get(i);
                    break;
                }
            }
        }
        return retInfo;
    }

    private CurrencyInfo setCurrencyType() {
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(BOSUuid.read((String)"dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC"));
        currency.setIsoCode("RMB");
        return currency;
    }

    private SettlementTypeInfo setPayMode(Context ctx, OtherExpenseBillInfo oInfo) throws BOSException, EASBizException {
        ISettlementType iSettle = SettlementTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)true));
        viewInfo.setFilter(filter);
        SettlementTypeCollection collPay = iSettle.getSettlementTypeCollection(viewInfo);
        SettlementTypeInfo settle = null;
        if (collPay != null && collPay.size() > 0) {
            settle = collPay.get(0);
        }
        return settle;
    }

    public CostCenterOrgUnitInfo getCostCenterByAdmin(Context ctx, AdminOrgUnitInfo adminOrgUnitInfo) throws BOSException, EASBizException {
        CostCenterOrgUnitInfo costCenterOrgUnitInfo = null;
        AdminOrgUnitInfo parentCost = null;
        parentCost = adminOrgUnitInfo;
        while (parentCost != null) {
            String id;
            if (parentCost.isIsCostOrgUnit()) {
                id = parentCost.getId().toString();
                if (id == null) continue;
                ICostCenterOrgUnit iCostCenterOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
                costCenterOrgUnitInfo = (CostCenterOrgUnitInfo)iCostCenterOrgUnit.getValue((IObjectPK)new ObjectUuidPK(id));
                break;
            }
            if ((parentCost = parentCost.getParent()) == null || (id = parentCost.getId().toString()) == null) continue;
            IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            parentCost = (AdminOrgUnitInfo)iAdmin.getValue((IObjectPK)new ObjectUuidPK(id));
        }
        return costCenterOrgUnitInfo;
    }
}

