/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app.message.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.messageCenter.IMessage;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.MessageException;
import com.kingdee.messageCenter.common.ObjectFactory;
import com.kingdee.messageCenter.pushletClient.EASWorker;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class PURPGetErpOrderStatusHandler
extends EASWorker {
    private static Logger logger = Logger.getLogger(PURPGetErpOrderStatusHandler.class);

    @Override
    public Message runInEAS(Context ctx, Message message) throws EASBizException, BOSException {
        String sourceBillType = message.getField("sourceBillType");
        String jdOrderId = message.getField("jdOrderId");
        logger.info((Object)("eas\u72b6\u6001\u66f4\u65b0\uff0c\u4eac\u4e1c\u5355\u53f7\uff1a" + jdOrderId));
        this.pushStatusMessage(ctx, sourceBillType, jdOrderId, message.getId());
        return null;
    }

    public void pushStatusMessage(Context ctx, String sourceBillType, String jdOrderId, String messageid) throws EASBizException, BOSException {
        String data = this.getBillMsgForSourceBillType(ctx, sourceBillType, jdOrderId);
        if (data != null) {
            Message retMsg = new Message();
            if (messageid != null) {
                retMsg.setField("SOURCEID", messageid);
            }
            retMsg.setSubject("/EAS/ERP_ORDER_STATUS");
            retMsg.setField("DATA", data);
            IMessage messageServer = ObjectFactory.getInstance().getMessageServer();
            try {
                messageServer.pushMessage(retMsg);
            }
            catch (MessageException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private String getBillMsgForSourceBillType(Context ctx, String sourceBillType, String jdOrderId) throws BOSException, EASBizException {
        String msg = null;
        if (sourceBillType.equals("PUR_ORDER")) {
            msg = this.sourceBillTypeForOrder(ctx, jdOrderId);
        } else if (sourceBillType.equals("PUR_REQ")) {
            msg = this.sourceBillTypeForReq(ctx, jdOrderId);
        } else if (sourceBillType.equals("OTHER_EXPENSE")) {
            msg = this.sourceBillTypeForOtherReq(ctx, jdOrderId);
        }
        return msg;
    }

    private String sourceBillTypeForOrder(Context ctx, String jdorderId) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct t1.fnumber as orderNumber,t1.fbaseStatus as orderStatus  from t_sm_purorder t1\r\n");
        sql.append(" inner join t_sm_purorderentry t2\r\n");
        sql.append(" on t1.fid=t2.fparentid\r\n");
        sql.append(" where t2.fjdorderid='" + jdorderId + "'\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String orderNumber = "";
        int orderStatus = -10;
        String orderStatusName = "";
        StringBuffer msg = new StringBuffer();
        msg.append(" { \"result\" :[ ");
        int count = 0;
        try {
            while (rs.next()) {
                if (count != 0) {
                    msg.append(",");
                }
                orderNumber = rs.getString("orderNumber");
                orderStatus = rs.getInt("orderStatus");
                orderStatusName = this.getBillStatusName(orderStatus);
                ++count;
                if (orderNumber == null || "".equals(orderNumber)) continue;
                msg.append("{\"billtype\":\"").append("\u91c7\u8d2d\u8ba2\u5355").append("\"");
                msg.append(" ,").append("\"msg\":").append("{\"number\":\"").append(orderNumber);
                msg.append("\",\"jdorderid\":\"").append(jdorderId);
                msg.append("\",\"status\":\"").append(orderStatusName).append("\"}}");
            }
            msg.append("]}");
        }
        catch (SQLException e) {
            logger.error((Object)("\u53d6\u8ba2\u5355\u72b6\u6001\u5931\u8d25:" + e.getMessage()), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return msg.toString();
    }

    private String sourceBillTypeForOtherReq(Context ctx, String jdorderId) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct t1.fnumber as number, t1.fstate as state from t_bc_otherexpensebill t1\r\n");
        sql.append(" inner join t_bc_otherexpensebillentry t2\r\n");
        sql.append(" on t1.fid=t2.fbillid\r\n");
        sql.append(" where t2.fjdorderid='" + jdorderId + "'\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String number = "";
        int status = -10;
        String statusName = "";
        StringBuffer msg = new StringBuffer();
        msg.append(" { \"result\" :[ ");
        int count = 0;
        try {
            while (rs.next()) {
                if (count != 0) {
                    msg.append(",");
                }
                number = rs.getString("number");
                status = rs.getInt("state");
                statusName = StateEnum.getEnum((int)status).getAlias();
                ++count;
                if (number == null || "".equals(number)) continue;
                msg.append("{\"billtype\":\"").append("\u8d39\u7528\u7533\u8bf7\u5355").append("\"");
                msg.append(" ,").append("\"msg\":").append("{\"number\":\"").append(number);
                msg.append("\",\"jdorderid\":\"").append(jdorderId);
                msg.append("\",\"status\":\"").append(statusName).append("\"}}");
            }
            msg.append("]}");
        }
        catch (SQLException e) {
            logger.error((Object)("\u53d6\u8d39\u7528\u5355\u636e\u72b6\u6001\u5931\u8d25:" + e.getMessage()), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return msg.toString();
    }

    private String sourceBillTypeForReq(Context ctx, String jdorderID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct t1.fnumber as reqNumber,t1.fbaseStatus as reqStatus ,t.fnumber as orderNumber,");
        sql.append(" t.fbaseStatus as orderStatus from t_sm_purrequest t1  ");
        sql.append("  inner join t_sm_purrequestentry t4 on t1.fid = t4.fparentid ");
        sql.append("  left join  (select t2.fnumber, t2.FBaseStatus, t3.fsourcebillid from t_sm_purorder t2 ");
        sql.append(" inner join t_sm_purorderentry t3 on t2.fid = t3.fparentid ) t ");
        sql.append(" on t1.fid = t.fsourcebillid ").append(" where t4.fjdorderid  = '" + jdorderID + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String reqNumber = "";
        String orderNumber = "";
        int reqStatus = -10;
        int orderStatus = -10;
        String reqStatusName = "";
        String orderStatusName = "";
        StringBuffer msg = new StringBuffer();
        msg.append(" { \"result\" :[ ");
        int count = 0;
        try {
            while (rs.next()) {
                if (count != 0) {
                    msg.append(",");
                }
                reqNumber = rs.getString("reqNumber");
                reqStatus = rs.getInt("reqStatus");
                orderNumber = rs.getString("orderNumber");
                orderStatus = rs.getInt("orderStatus");
                reqStatusName = this.getBillStatusName(reqStatus);
                orderStatusName = this.getBillStatusName(orderStatus);
                ++count;
                msg.append("{\"billtype\":\"").append("\u91c7\u8d2d\u7533\u8bf7\u5355").append("\"");
                msg.append(" ,").append("\"msg\":").append("{\"number\":\"").append(reqNumber);
                msg.append("\",\"jdorderid\":\"").append(jdorderID);
                msg.append("\",\"status\":\"").append(reqStatusName).append("\"}}");
                if (orderNumber == null || "".equals(orderNumber)) continue;
                msg.append(",{\"billtype\":\"").append("\u91c7\u8d2d\u8ba2\u5355").append("\"");
                msg.append(" ,").append("\"msg\":").append("{\"number\":\"").append(orderNumber);
                msg.append("\",\"status\":\"").append(orderStatusName).append("\"}}");
            }
            msg.append("]}");
        }
        catch (SQLException e) {
            logger.error((Object)("\u53d6\u7533\u8bf7\u5355\u72b6\u6001\u5931\u8d25:" + e.getMessage()), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return msg.toString();
    }

    private String getBillStatusName(int statusValue) {
        return BillBaseStatusEnum.getEnum((int)statusValue).getAlias();
    }
}

