/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app.message.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.b2b.PurB2BFacadeFactory;
import com.kingdee.eas.scm.sm.pur.b2b.Purb2bExtendFacadeFactory;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.handler.MessageUtils;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.handler.PURPGetErpOrderStatusHandler;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.model.NetPurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.model.NetPurOrderInfo;
import com.kingdee.eas.scm.sm.pur.b2b.util.PurCloudHelper;
import com.kingdee.eas.scm.sm.pur.b2b.util.SCMSelectorFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.messageCenter.IMessage;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.MessageException;
import com.kingdee.messageCenter.common.ObjectFactory;
import com.kingdee.messageCenter.pushletClient.EASWorker;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PURPOrderCreateMessageHandler
extends EASWorker {
    private static Logger logger = Logger.getLogger(PURPOrderCreateMessageHandler.class);

    @Override
    public Message runInEAS(Context ctx, Message message) throws EASBizException, BOSException {
        Uuid mutexID;
        String messageid = message.getId();
        if (this.checkMutex(ctx, messageid, mutexID = Uuid.create())) {
            this.process(ctx, message);
        }
        PURPOrderCreateMessageHandler.releaseMutex(ctx, mutexID);
        return null;
    }

    private boolean checkMutex(Context ctx, String messageid, Uuid uuid) throws BOSException {
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        MutexParameter param = new MutexParameter();
        param.setRequestId(uuid);
        param.setMutexName("createOrder" + messageid);
        param.setActionName("createOrder");
        param.setUserID(user.getId());
        param.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        param.setDcName(ctx.getAIS());
        param.setSessionID(ctx.getContextID());
        boolean isMutex = PURPOrderCreateMessageHandler.requestMutex(ctx, param);
        return isMutex;
    }

    public static boolean requestMutex(Context ctx, MutexParameter param) throws BOSException {
        if (param != null) {
            IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            return mutexService.requestMutex(param);
        }
        return false;
    }

    public static void releaseMutex(Context ctx, Uuid id) throws BOSException {
        if (id != null) {
            IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            mutexService.releaseMutex(id);
        }
    }

    public void process(Context ctx, Message message) throws BOSException, EASBizException {
        logger.info((Object)"\u5f00\u59cb\u5904\u7406\u8ba2\u5355\u6d88\u606f");
        String orderId = message.getField("orderid");
        logger.error((Object)("\u5f00\u59cb\u5904\u7406\u8ba2\u5355\u6d88\u606f\uff0c\u4eac\u4e1c\u5355\u53f7\uff1a" + orderId));
        if (orderId == null || orderId.length() == 0) {
            throw new BOSException("\u91c7\u8d2d100JD\u521b\u5efa\u91c7\u8d2d\u8ba2\u5355\u6d88\u606f\u6570\u636e\u4e2d\u7f3a\u5c11\u8ba2\u5355ID");
        }
        String orderJson = null;
        NetPurOrderInfo netInfo = null;
        try {
            orderJson = PurB2BFacadeFactory.getLocalInstance(ctx).getPurpOrderInfo(orderId);
            netInfo = NetPurOrderInfo.create(new JSONObject(orderJson));
        }
        catch (JSONException e) {
            logger.error((Object)("\u6d88\u606f\u6570\u636e\u4e0d\u5408\u6cd5\uff1a" + e.getMessage()));
            return;
        }
        String jdorderid = netInfo.getJdOrderID();
        String sql = " select fid from T_sm_purorderentry where fjdorderid ='" + jdorderid + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                return;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        NetPurOrderEntryInfo netEntryInfo = null;
        ArrayList<String> purReqIds = new ArrayList<String>();
        ArrayList<String> purReqEntryIds = new ArrayList<String>();
        String purReqEntryId = null;
        String purReqId = null;
        for (int i = 0; i < netInfo.getEntrys().size(); ++i) {
            netEntryInfo = netInfo.getEntrys().get(i);
            purReqId = netEntryInfo.getErpBillId();
            purReqEntryId = netEntryInfo.getErpBillEntryId();
            if (!StringUtils.isEmpty((String)purReqEntryId)) {
                purReqEntryIds.add(purReqEntryId);
            }
            if (StringUtils.isEmpty((String)purReqId)) continue;
            purReqIds.add(purReqId);
        }
        if (!purReqIds.isEmpty()) {
            this.createEasPurOrderByPurReqeust(ctx, netInfo, purReqIds, purReqEntryIds);
        } else {
            this.createEasPurOrder(ctx, netInfo);
        }
        PURPGetErpOrderStatusHandler statusHandler = new PURPGetErpOrderStatusHandler();
        statusHandler.pushStatusMessage(ctx, "PUR_ORDER", netInfo.getJdOrderID(), null);
    }

    private void createEasPurOrderByPurReqeust(Context ctx, NetPurOrderInfo netInfo, List<String> purReqIds, List<String> purReqEntryIds) throws EASBizException, BOSException {
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(netInfo.getCreatorID()));
        ctx.put((Object)"UserInfo", (Object)userInfo);
        ctx.setCaller((IObjectPK)new ObjectUuidPK(userInfo.getId().toString()));
        ctx.setUserName(userInfo.getName());
        HashMap<String, NetPurOrderEntryInfo> prItemId2PriceMap = new HashMap<String, NetPurOrderEntryInfo>();
        NetPurOrderEntryInfo netEntryInfo = null;
        int size = netInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            netEntryInfo = netInfo.getEntrys().get(i);
            prItemId2PriceMap.put(netEntryInfo.getErpBillEntryId(), netEntryInfo);
        }
        String botpName = "PUR001";
        BOTMappingInfo botMappingInfo = null;
        try {
            botMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo("where name='" + botpName + "'");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("1000003", "\u4e0b\u5355\u5931\u8d25\uff0c\u4e0d\u7b26\u5408\u5355\u636e\u8f6c\u6362\u89c4\u5219\u8bbe\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        if (!botMappingInfo.getExtRule().isIsEffected()) {
            throw new EASBizException(new NumericExceptionSubItem("1000004", "\u4e0b\u5355\u5931\u8d25\uff0c\u5355\u636e\u8f6c\u6362\u89c4\u5219\u672a\u542f\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        SelectorItemCollection botpSelectors = SCMSelectorFactory.getPurRequestSelector(true);
        BTPTransformResult transformResult = BTPManagerFactory.getLocalInstance((Context)ctx).transformForBotp(purReqIds.toArray(new String[0]), new String[]{"entries"}, purReqEntryIds, botpSelectors, "3171BFAD", (IObjectPK)new ObjectUuidPK(botMappingInfo.getId()), "25428F2E");
        IObjectCollection bills = transformResult.getBills();
        if (bills.size() <= 0) {
            throw new EASBizException(new NumericExceptionSubItem("1000000", "\u4e0b\u5355\u5931\u8d25\uff0cbotp\u8f6c\u6362\u540e\u8ba2\u5355\u6570\u636e\u4f4d\u7a7a"));
        }
        SupplierInfo supplier = new SupplierInfo();
        supplier.setId(BOSUuid.read((String)"8r0AAAAF0G03xn38"));
        IPurOrder iPurOrder = PurOrderFactory.getLocalInstance((Context)ctx);
        BigDecimal amount = null;
        int size2 = bills.size();
        for (int i = 0; i < size2; ++i) {
            PurOrderInfo order = (PurOrderInfo)bills.getObject(i);
            PurOrderEntryCollection entrys = order.getEntries();
            boolean isInTax = false;
            int len = entrys.size();
            for (int j = 0; j < len; ++j) {
                PurOrderEntryInfo entry = entrys.get(j);
                String prItemId = entry.getSourceBillEntryId();
                netEntryInfo = (NetPurOrderEntryInfo)prItemId2PriceMap.get(prItemId);
                entry.put("jdOrderId", (Object)netInfo.getJdOrderID());
                isInTax = true;
                entry.setQty(new BigDecimal(netEntryInfo.getQty()));
                entry.setTaxPrice(netEntryInfo.getPrice());
                entry.setTaxRate(new BigDecimal(netEntryInfo.getFtaxRate()));
                entry.setPrice(netEntryInfo.getFnakedPrice());
                amount = netEntryInfo.getPrice().multiply(entry.getQty()).setScale(2);
                entry.setAmount(amount);
                this.setEntryDefaultValue(ctx, entry, netEntryInfo);
            }
            order.setIsInTax(isInTax);
            order.setSupplier(supplier);
            order.setBoolean("isNetOrder", true);
            order.setIsSysBill(false);
            order.setCU(order.getCompanyOrgUnit().getCU());
            iPurOrder.handleAfterTransform("SAVE", (IObjectValue)order);
            order = (PurOrderInfo)Purb2bExtendFacadeFactory.getLocalInstance(ctx).extendPurorder((IObjectValue)order);
            iPurOrder.save((CoreBaseInfo)order);
            iPurOrder.saveRelations((CoreBillBaseInfo)order, transformResult.getBOTRelationCollection());
        }
    }

    private String createEasPurOrder(Context ctx, NetPurOrderInfo netInfo) throws BOSException, EASBizException {
        PurOrderInfo info = new PurOrderInfo();
        info.setNumber(netInfo.getNumber());
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(netInfo.getCreatorID()));
        ctx.put((Object)"UserInfo", (Object)userInfo);
        ctx.setCaller((IObjectPK)new ObjectUuidPK(userInfo.getId().toString()));
        ctx.setUserName(userInfo.getName());
        info.setCreator(userInfo);
        this.setHeadDefaultValue(ctx, info, netInfo);
        info.setIsPriceInTax(true);
        info.setIsInTax(true);
        info.setBoolean("isNetOrder", true);
        List<NetPurOrderEntryInfo> entrys = netInfo.getEntrys();
        PurOrderEntryInfo entry = null;
        NetPurOrderEntryInfo netEntry = null;
        Map<String, MaterialInfo> materialIDMap = this.getMaterialIDByNumber(ctx, netInfo);
        MaterialInfo materialInfo = null;
        PersonInfo personInfo = userInfo.getPerson();
        if (personInfo == null) {
            return null;
        }
        MeasureUnitInfo unit = new MeasureUnitInfo();
        unit.setId(BOSUuid.read((String)"gw5fUwEOEADgAArZwKgSOFuCXFc="));
        PurchaseOrgUnitInfo purchaseOrg = info.getPurchaseOrgUnit();
        AdminOrgUnitInfo adminInfo = this.getAdminOrgUnitInfo(ctx, purchaseOrg);
        StorageOrgUnitInfo storageInfo = this.getStorageOrgUnitInfo(ctx, purchaseOrg);
        BigDecimal amount = null;
        for (int i = 0; i < entrys.size(); ++i) {
            entry = new PurOrderEntryInfo();
            netEntry = entrys.get(i);
            entry.setMaterialName(netEntry.getMatName());
            if (materialIDMap.get(netEntry.getMaterialNumber()) != null) {
                materialInfo = materialIDMap.get(netEntry.getMaterialNumber());
                entry.setMaterial(materialInfo);
                entry.setBaseUnit(materialInfo.getBaseUnit());
                entry.setUnit(materialInfo.getBaseUnit());
                entry.setNoNumMaterialModel(materialInfo.getModel());
                entry.setRequestOrgUnit(storageInfo);
            } else {
                entry.setBaseUnit(unit);
                entry.setUnit(unit);
                entry.setAdminOrgUnit(adminInfo);
                if (adminInfo == null) {
                    logger.error((Object)("\u91c7\u8d2d\u7ec4\u7ec7\uff1a" + purchaseOrg.getName()));
                    logger.error((Object)("\u65b0\u589e\u7ec4\u7ec7\u6ca1\u6709\u53d6\u5230\uff1a" + netInfo.getJdOrderID()));
                } else {
                    logger.error((Object)("\u8bbe\u7f6e\u884c\u653f\u7ec4\u7ec7" + adminInfo.getName()));
                }
            }
            entry.setQty(new BigDecimal(netEntry.getQty()));
            entry.setBaseQty(entry.getQty());
            entry.setTaxPrice(netEntry.getPrice());
            if (netEntry.getFtaxRate() != null) {
                entry.setTaxRate(new BigDecimal(netEntry.getFtaxRate()));
            }
            entry.setPrice(netEntry.getFnakedPrice());
            entry.setStorageOrgUnit(storageInfo);
            entry.setDeliveryDate(new Date());
            amount = entry.getPrice().multiply(entry.getQty()).setScale(4);
            entry.setAmount(amount);
            entry.setTaxAmount(entry.getTaxPrice().multiply(entry.getQty()).setScale(4));
            this.setEntryDefaultValue(ctx, entry, netEntry);
            entry.put("jdOrderId", (Object)netInfo.getJdOrderID());
            entry.setBizDate(new Date());
            entry.setQuantityUnCtrl(true);
            entry.setTimeUnCtrl(true);
            info.getEntries().add(entry);
        }
        if (BigDecimal.ZERO.compareTo(netInfo.getfFreight()) < 0) {
            entry = new PurOrderEntryInfo();
            netEntry = entrys.get(0);
            entry.setMaterialName("\u8fd0\u8d39");
            entry.setBaseUnit(unit);
            entry.setUnit(unit);
            entry.setAdminOrgUnit(adminInfo);
            entry.setQty(new BigDecimal("1.00"));
            entry.setBaseQty(new BigDecimal("1.00"));
            BigDecimal freight = netInfo.getfFreight();
            entry.setTaxPrice(freight);
            entry.setTaxAmount(freight);
            if (netEntry.getFtaxRate() != null) {
                entry.setTaxRate(new BigDecimal(netEntry.getFtaxRate()));
            } else {
                entry.setTaxRate(new BigDecimal("0.0"));
            }
            entry.setTax(freight.multiply(entry.getTaxRate()).movePointLeft(2).setScale(2));
            entry.setPrice(freight.subtract(entry.getTax()));
            entry.setStorageOrgUnit(storageInfo);
            entry.setDeliveryDate(new Date());
            entry.setAmount(entry.getPrice());
            this.setEntryDefaultValue(ctx, entry, netEntry);
            entry.put("jdOrderId", (Object)netInfo.getJdOrderID());
            entry.setBizDate(new Date());
            entry.setQuantityUnCtrl(true);
            entry.setTimeUnCtrl(true);
            info.getEntries().add(entry);
        }
        try {
            info.setPrepaymentRate(new BigDecimal("100.00"));
            IObjectValue purinfo = Purb2bExtendFacadeFactory.getLocalInstance(ctx).extendPurorder((IObjectValue)info);
            PurCloudHelper.saveForNet(ctx, purinfo);
        }
        catch (EASBizException e) {
            throw new BOSException("\u4fdd\u5b58\u5355\u636e\u5931\u8d25\uff1a" + e.getMessage() + info.getPurchaseOrgUnit() + info.getCompanyOrgUnit());
        }
        catch (BOSException e) {
            throw new BOSException("\u4fdd\u5b58\u5355\u636e\u5931\u8d25\uff1a" + e.getMessage() + info.getPurchaseOrgUnit() + info.getCompanyOrgUnit());
        }
        return info.getNumber();
    }

    public Map<String, MaterialInfo> getMaterialIDByNumber(Context ctx, NetPurOrderInfo netInfo) throws BOSException, EASBizException {
        String numbers = this.getNumbers(netInfo);
        String sql = "select fid,fnumber,fbaseUnit,fmodel from t_bd_material where fnumber in " + numbers;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, MaterialInfo> retMap = new HashMap<String, MaterialInfo>();
        MaterialInfo materialInfo = null;
        MeasureUnitInfo baseUnitInfo = null;
        try {
            while (rs.next()) {
                String number = rs.getString("fnumber");
                String id = rs.getString("fid");
                materialInfo = new MaterialInfo();
                materialInfo.setNumber(number);
                materialInfo.setModel(rs.getString("fmodel"));
                materialInfo.setId(BOSUuid.read((String)id));
                String baseUnitId = rs.getString("fbaseUnit");
                baseUnitInfo = new MeasureUnitInfo();
                baseUnitInfo.setId(BOSUuid.read((String)baseUnitId));
                materialInfo.setBaseUnit(baseUnitInfo);
                retMap.put(number, materialInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return retMap;
    }

    private void setHeadDefaultValue(Context ctx, PurOrderInfo info, NetPurOrderInfo netInfo) throws BOSException, EASBizException {
        String companyid;
        ObjectUuidPK pk = new ObjectUuidPK("dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC");
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)pk);
        info.setCurrency(currency);
        info.setExchangeRate(new BigDecimal("1.00"));
        BizTypeInfo bizType = new BizTypeInfo();
        bizType.setId(BOSUuid.read((String)"d8e80652-0106-1000-e000-04c5c0a812202407435C"));
        bizType.setNumber("110");
        bizType.setName("\u666e\u901a\u91c7\u8d2d");
        info.setBizType(bizType);
        BillTypeInfo billType = new BillTypeInfo();
        billType.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-010bc0a812fd463ED552"));
        info.setBillType(billType);
        PaymentTypeInfo paymentType = new PaymentTypeInfo();
        paymentType.setId(BOSUuid.read((String)"40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5"));
        paymentType.setNumber("003");
        paymentType.setName("\u73b0\u8d2d");
        info.setPaymentType(paymentType);
        info.setBizDate(new Date());
        SupplierInfo supplier = new SupplierInfo();
        supplier.setId(BOSUuid.read((String)"8r0AAAAF0G03xn38"));
        info.setSupplier(supplier);
        UserInfo user = info.getCreator();
        PersonInfo personInfo = user.getPerson();
        if (personInfo == null) {
            return;
        }
        FullOrgUnitInfo defOrg = user.getDefOrgUnit();
        String curCompnayId = null;
        if (defOrg != null) {
            curCompnayId = defOrg.getId().toString();
        }
        if ((companyid = netInfo.getCompanyID()) == null || companyid.length() < 1) {
            return;
        }
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo.setId(BOSUuid.read((String)companyid));
        PurchaseOrgUnitInfo purchaseOrg = this.getPurchaseOrgInfo(ctx, user.getId().toString(), companyid);
        if (purchaseOrg == null) {
            purchaseOrg = this.getPurchaseOrgInfo(ctx, user.getId().toString(), curCompnayId);
            companyInfo.setId(BOSUuid.read((String)curCompnayId));
        }
        info.setPurchaseOrgUnit(purchaseOrg);
        companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        info.setCompanyOrgUnit(companyInfo);
        info.setCU(companyInfo.getCU());
        AdminOrgUnitInfo adminInfo = this.getAdminOrgUnitInfoByPurchase(ctx, purchaseOrg);
        if (adminInfo == null) {
            IPerson iperson = PersonFactory.getLocalInstance((Context)ctx);
            adminInfo = iperson.getPrimaryAdminOrgUnit(personInfo.getId());
        }
        info.setAdminOrgUnit(adminInfo);
        if (adminInfo == null) {
            return;
        }
    }

    private void setEntryDefaultValue(Context ctx, PurOrderEntryInfo entry, NetPurOrderEntryInfo netEntry) throws EASBizException, BOSException {
        RowTypeInfo rowType = RowTypeFactory.getLocalInstance((Context)ctx).getRowTypeInfo((IObjectPK)new ObjectUuidPK(netEntry.getPurhcaseType()));
        entry.setRowType(rowType);
    }

    private PurchaseOrgUnitInfo getPurchaseOrgInfo(Context ctx, String userId, String companyid) throws BOSException {
        try {
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgCol = iUnitRel.getFromUnit(companyid, 1, 3);
            Set set = MessageUtils.getAuthorizedCompanyOrgIds(ctx, userId, "purorder_addnew", OrgType.Purchase, true);
            String purchaseOrgUnitid = null;
            OrgUnitInfo orgInfo = null;
            int size = orgCol.size();
            for (int i = 0; i < size; ++i) {
                orgInfo = orgCol.get(i);
                if (!set.contains(orgInfo.getId().toString())) continue;
                purchaseOrgUnitid = orgInfo.getId().toString();
            }
            PurchaseOrgUnitInfo purchaseOrg = null;
            if (purchaseOrgUnitid != null && purchaseOrgUnitid.length() > 1) {
                purchaseOrg = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(purchaseOrgUnitid));
            }
            return purchaseOrg;
        }
        catch (EASBizException e) {
            throw new BOSException("\u6839\u636e\u8d22\u52a1\u7ec4\u7ec7\u83b7\u53d6\u91c7\u8d2d\u7ec4\u7ec7\u5931\u8d25\uff1a" + e.getMessage());
        }
        catch (BOSException e) {
            throw new BOSException("\u6839\u636e\u8d22\u52a1\u7ec4\u7ec7\u83b7\u53d6\u91c7\u8d2d\u7ec4\u7ec7\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private CompanyOrgUnitInfo getCompanyInfo(Context ctx, AdminOrgUnitInfo adminOrg) throws BOSException {
        try {
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgCol = iUnitRel.getToUnit(adminOrg.getId().toString(), 0, 1);
            return (CompanyOrgUnitInfo)orgCol.get(0);
        }
        catch (EASBizException e) {
            throw new BOSException("\u6839\u636e\u884c\u653f\u7ec4\u7ec7\u83b7\u53d6\u8d22\u52a1\u7ec4\u7ec7\u5931\u8d25\uff1a" + e.getMessage());
        }
        catch (BOSException e) {
            throw new BOSException("\u6839\u636e\u884c\u653f\u7ec4\u7ec7\u83b7\u53d6\u8d22\u52a1\u7ec4\u7ec7\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private AdminOrgUnitInfo getAdminOrgUnitInfo(Context ctx, PurchaseOrgUnitInfo purOrg) throws BOSException {
        try {
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgCol = iUnitRel.getFromUnit(purOrg.getId().toString(), 3, 0);
            return (AdminOrgUnitInfo)orgCol.get(0);
        }
        catch (EASBizException e) {
            throw new BOSException("\u6839\u636e\u884c\u653f\u7ec4\u7ec7\u83b7\u53d6\u8d22\u52a1\u7ec4\u7ec7\u5931\u8d25\uff1a" + e.getMessage());
        }
        catch (BOSException e) {
            throw new BOSException("\u6839\u636e\u884c\u653f\u7ec4\u7ec7\u83b7\u53d6\u8d22\u52a1\u7ec4\u7ec7\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private AdminOrgUnitInfo getAdminOrgUnitInfoByPurchase(Context ctx, PurchaseOrgUnitInfo purOrg) throws BOSException {
        try {
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitInfo orginfo = null;
            Object curorginfo = null;
            OrgUnitCollection orgCol = iUnitRel.getToUnit(purOrg.getId().toString(), 3, 0);
            if (orginfo == null) {
                orginfo = orgCol.get(0);
            }
            return (AdminOrgUnitInfo)orginfo;
        }
        catch (EASBizException e) {
            throw new BOSException("\u6839\u636e\u91c7\u8d2d\u7ec4\u7ec7\u83b7\u53d6\u884c\u653f\u7ec4\u7ec7\u5931\u8d25\uff1a" + e.getMessage());
        }
        catch (BOSException e) {
            throw new BOSException("\u6839\u636e\u884c\u653f\u7ec4\u7ec7\u83b7\u53d6\u8d22\u52a1\u7ec4\u7ec7\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private StorageOrgUnitInfo getStorageOrgUnitInfo(Context ctx, PurchaseOrgUnitInfo purOrg) throws BOSException {
        try {
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgCol = iUnitRel.getFromUnit(purOrg.getId().toString(), 3, 4);
            return (StorageOrgUnitInfo)orgCol.get(0);
        }
        catch (EASBizException e) {
            throw new BOSException("\u6839\u636e\u91c7\u8d2d\u7ec4\u7ec7\u83b7\u53d6\u5e93\u5b58\u7ec4\u7ec7\u5931\u8d25\uff1a" + e.getMessage());
        }
        catch (BOSException e) {
            throw new BOSException("\u6839\u636e\u91c7\u8d2d\u7ec4\u7ec7\u83b7\u53d6\u5e93\u5b58\u7ec4\u7ec7\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public String getNumbers(NetPurOrderInfo netInfo) {
        ArrayList<String> materiaNum = new ArrayList<String>();
        List<NetPurOrderEntryInfo> entrys = netInfo.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            NetPurOrderEntryInfo entry = entrys.get(i);
            materiaNum.add(entry.getMaterialNumber());
        }
        String numbers = this.getInStringFromList(materiaNum);
        return numbers;
    }

    public String getInStringFromList(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            in.append("'").append(iter.next().toString()).append("'");
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    @Override
    public void dealException(Context ctx, Message message, Exception e) throws MessageException {
        Message retMsg = new Message();
        if (message != null) {
            retMsg.setField("SOURCEID", message.getId());
            retMsg.setSubject("/EAS/ERP_ORDER_ERROR");
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                retMsg.setField("DATA", e.getMessage());
            } else {
                retMsg.setField("DATA", e.toString().substring(500));
            }
            IMessage messageServer = ObjectFactory.getInstance().getMessageServer();
            messageServer.pushMessage(retMsg);
        }
    }
}

