/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.app.message.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.b2b.PurB2BFacadeFactory;
import com.kingdee.eas.scm.sm.pur.b2b.Purb2bExtendFacadeFactory;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.handler.MessageUtils;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.handler.PURPGetErpOrderStatusHandler;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.model.NetPurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.b2b.app.message.model.NetPurOrderInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.pushletClient.EASWorker;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PURPurRequestCreateMessageHandler
extends EASWorker {
    private static Logger logger = Logger.getLogger(PURPurRequestCreateMessageHandler.class);

    @Override
    public Message runInEAS(Context ctx, Message message) throws EASBizException, BOSException {
        this.process(ctx, message);
        return null;
    }

    public void process(Context ctx, Message message) throws BOSException, EASBizException {
        String orderId = message.getField("orderid");
        if (orderId == null || orderId.length() == 0) {
            throw new BOSException("\u91c7\u8d2d100JD\u521b\u5efa\u91c7\u8d2d\u7533\u8bf7\u5355\u6d88\u606f\u6570\u636e\u4e2d\u7f3a\u5c11\u8ba2\u5355ID");
        }
        String orderJson = null;
        NetPurOrderInfo netInfo = null;
        try {
            orderJson = PurB2BFacadeFactory.getLocalInstance(ctx).getPurpOrderInfo(orderId);
            netInfo = NetPurOrderInfo.create(new JSONObject(orderJson));
        }
        catch (JSONException e) {
            this.printExcetpion((Exception)((Object)e));
            throw new BOSException("\u6d88\u606f\u6570\u636e\u4e0d\u5408\u6cd5\uff1a" + e.getStackTrace());
        }
        String billNumber = this.createEasPurRequestBill(ctx, netInfo);
        PurB2BFacadeFactory.getLocalInstance(ctx).writeBackERPBillNumber(orderId, billNumber);
        PURPGetErpOrderStatusHandler statusHandler = new PURPGetErpOrderStatusHandler();
        statusHandler.pushStatusMessage(ctx, "PUR_REQ", netInfo.getJdOrderID(), null);
    }

    private String createEasPurRequestBill(Context ctx, NetPurOrderInfo netInfo) throws BOSException, EASBizException {
        PurRequestInfo info = new PurRequestInfo();
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(netInfo.getCreatorID()));
        info.setCreator(userInfo);
        ctx.put((Object)"UserInfo", (Object)userInfo);
        ctx.setCaller((IObjectPK)new ObjectUuidPK(userInfo.getId().toString()));
        ctx.setUserName(userInfo.getName());
        info.setPerson(userInfo.getPerson());
        info.put("jdOrderID", (Object)netInfo.getJdOrderID());
        String purpCompanyID = netInfo.getCompanyID();
        this.setHeadDefaultValue(ctx, info, netInfo);
        StorageOrgUnitInfo entryStorageInfo = this.getStorageOrgUnitInfo(ctx, info.getCompanyOrgUnit());
        List<NetPurOrderEntryInfo> entrys = netInfo.getEntrys();
        PurRequestEntryInfo entry = null;
        NetPurOrderEntryInfo netEntry = null;
        Map materialIDMap = MessageUtils.getMaterialIDByNumber(ctx, netInfo);
        Calendar calender = Calendar.getInstance();
        calender.add(5, -1);
        Date purchaseDate = calender.getTime();
        calender.add(5, 2);
        Date deliveryDate = calender.getTime();
        MaterialInfo materialInfo = null;
        String mid = null;
        AdminOrgUnitInfo entryAdmin = this.getAdminOrgBy(ctx, info.getAdminOrg(), info.getCompanyOrgUnit());
        PurchaseOrgUnitInfo entryPurOrg = null;
        BigDecimal totalLocAmount = new BigDecimal("0.0");
        for (int i = 0; i < entrys.size(); ++i) {
            entry = new PurRequestEntryInfo();
            netEntry = entrys.get(i);
            this.setEntryDefaultValue(info, entry, netEntry);
            entry.setMaterialName(netEntry.getMatName());
            if (materialIDMap.get(netEntry.getMaterialNumber()) != null) {
                mid = materialIDMap.get(netEntry.getMaterialNumber()).toString();
                materialInfo = new MaterialInfo();
                materialInfo.setId(BOSUuid.read((String)mid));
                entry.setMaterial(materialInfo);
            }
            entry.setQty(new BigDecimal(netEntry.getQty()));
            entry.setBaseQty(entry.getQty());
            entry.setRequestQty(entry.getQty());
            entry.setPrice(netEntry.getPrice());
            entry.setAmount(entry.getQty().multiply(netEntry.getPrice()));
            entry.setLocalAmount(entry.getAmount());
            totalLocAmount = totalLocAmount.add(entry.getLocalAmount());
            if (entry.getRowType() != null && "00000000-0000-0000-0000-0000000000017C7DC4A3".equals(entry.getRowType().getId().toString())) {
                entry.setStorageOrgUnit(entryStorageInfo);
            } else {
                entry.setAdminOrgUnit(entryAdmin);
            }
            entry.setExchangeRate(new BigDecimal("1"));
            entry.setRequirementDate(Calendar.getInstance().getTime());
            entry.setProposePurchaseDate(purchaseDate);
            entry.setProposeDeliveryDate(deliveryDate);
            if (entryPurOrg == null) {
                entryPurOrg = this.getEntryPurchaseOrgInfo(ctx, purpCompanyID, entryPurOrg, entry);
            }
            entry.setPurchaseOrgUnit(entryPurOrg);
            entry.put("jdOrderId", (Object)netInfo.getJdOrderID());
            info.getEntries().add(entry);
        }
        IObjectPK billID = null;
        String number = netInfo.getNumber();
        if (info.getCompanyOrgUnit() == null) {
            throw new BOSException("CompanyOrgUnit is null ,userID =" + info.getCreator().getId());
        }
        info.setTotalAmount(totalLocAmount);
        info.setLocalTotalAmount(totalLocAmount);
        try {
            number = PurRequestFactory.getLocalInstance((Context)ctx).getNewNumber((IObjectValue)info, info.getCompanyOrgUnit().getId().toString(), "");
        }
        catch (EASBizException e) {
        }
        catch (BOSException e) {
            // empty catch block
        }
        info.setNumber(number);
        try {
            info = (PurRequestInfo)Purb2bExtendFacadeFactory.getLocalInstance(ctx).extendPurRequest((IObjectValue)info);
            billID = PurRequestFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)info);
        }
        catch (EASBizException e) {
            this.printExcetpion((Exception)((Object)e));
            throw new BOSException("save bill error " + e.getMessage() + e.getStackTrace());
        }
        catch (BOSException e) {
            this.printExcetpion((Exception)((Object)e));
            throw new BOSException("save bill error " + e.getMessage() + e.getStackTrace());
        }
        this.setEntryUnit(ctx, billID.toString());
        this.setHeadDemandType(ctx, billID.toString(), netEntry);
        PurRequestInfo newInfo = PurRequestFactory.getLocalInstance((Context)ctx).getPurRequestInfo(billID);
        return newInfo.getNumber();
    }

    public void init(Map<String, String> initParams) {
    }

    private PurchaseOrgUnitInfo getEntryPurchaseOrgInfo(Context ctx, String purpCompanyID, PurchaseOrgUnitInfo purchaseOrg, PurRequestEntryInfo entry) throws BOSException, EASBizException {
        purchaseOrg = entry.getRowType() != null && "00000000-0000-0000-0000-0000000000017C7DC4A3".equals(entry.getRowType().getId().toString()) ? this.getPurchaseOrgInfoByStorage(ctx, purpCompanyID, entry.getStorageOrgUnit()) : PURPurRequestCreateMessageHandler.getPurchaseOrgInfoByAdminOrg(ctx, purpCompanyID, entry.getAdminOrgUnit());
        return purchaseOrg;
    }

    private void setHeadDefaultValue(Context ctx, PurRequestInfo info, NetPurOrderInfo netInfo) throws BOSException, EASBizException {
        BizTypeInfo bizType = new BizTypeInfo();
        bizType.setId(BOSUuid.read((String)"d8e80652-0106-1000-e000-04c5c0a812202407435C"));
        bizType.setNumber("110");
        info.setBizType(bizType);
        UserInfo user = info.getCreator();
        PersonInfo personInfo = user.getPerson();
        if (personInfo == null) {
            return;
        }
        IPerson iperson = PersonFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitInfo adminInfo = iperson.getPrimaryAdminOrgUnit(personInfo.getId());
        info.setAdminOrg(adminInfo);
        if (adminInfo == null) {
            return;
        }
        CompanyOrgUnitInfo companyInfo = null;
        FullOrgUnitInfo defOrg = user.getDefOrgUnit();
        String curCompanyId = null;
        if (defOrg != null) {
            curCompanyId = defOrg.getId().toString();
        }
        companyInfo = MessageUtils.getHasPermissionOrg(ctx, user.getId().toString(), curCompanyId, netInfo.getCompanyID(), "purreq_addnew", OrgType.Company);
        info.setCompanyOrgUnit(companyInfo);
        info.setCreateTime(new Timestamp(new Date().getTime()));
        info.setBizDate(new Date());
    }

    private AdminOrgUnitInfo getAdminOrgBy(Context ctx, AdminOrgUnitInfo adminOrg, CompanyOrgUnitInfo companyOrgInfo) throws BOSException, EASBizException {
        if (companyOrgInfo == null) {
            return adminOrg;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getFromUnit(companyOrgInfo.getId().toString(), 1, 0);
        if (adminOrg == null) {
            return (AdminOrgUnitInfo)orgCol.get(0);
        }
        int size = orgCol.size();
        OrgUnitInfo org = null;
        HashMap<String, OrgUnitInfo> orgMap = new HashMap<String, OrgUnitInfo>();
        for (int i = 0; i < size; ++i) {
            org = orgCol.get(i);
            orgMap.put(org.getId().toString(), org);
        }
        String adminId = adminOrg.getId().toString();
        if (orgMap.get(adminId) == null) {
            return (AdminOrgUnitInfo)orgCol.get(0);
        }
        return adminOrg;
    }

    private void setEntryDefaultValue(PurRequestInfo info, PurRequestEntryInfo entry, NetPurOrderEntryInfo netEntry) throws BOSException {
        RowTypeInfo rowType = new RowTypeInfo();
        rowType.setId(BOSUuid.read((String)netEntry.getPurhcaseType()));
        entry.setRowType(rowType);
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(BOSUuid.read((String)"dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC"));
        currency.setIsoCode("RMB");
        entry.setCurrency(currency);
        SupplierInfo supplier = new SupplierInfo();
        supplier.setId(BOSUuid.read((String)"8r0AAAAF0G03xn38"));
        entry.setSupplier(supplier);
    }

    public static PurchaseOrgUnitInfo getPurchaseOrgInfoByAdminOrg(Context ctx, String purpCompanyID, AdminOrgUnitInfo admin) throws BOSException, EASBizException {
        int i;
        if (admin == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection storageAdmin = iUnitRel.getToUnit(admin.getId().toString(), 0, 3);
        OrgUnitCollection storageComp = iUnitRel.getFromUnit(purpCompanyID, 1, 3);
        PurchaseOrgUnitInfo retOrg = (PurchaseOrgUnitInfo)storageAdmin.get(0);
        int size = storageComp.size();
        HashMap<String, OrgUnitInfo> orgMap = new HashMap<String, OrgUnitInfo>();
        OrgUnitInfo org = null;
        for (i = 0; i < size; ++i) {
            org = storageComp.get(i);
            orgMap.put(org.getId().toString(), org);
        }
        size = storageAdmin.size();
        for (i = 0; i < size; ++i) {
            org = storageAdmin.get(i);
            if (orgMap.get(org.getId().toString()) == null) continue;
            retOrg = (PurchaseOrgUnitInfo)org;
            break;
        }
        return retOrg;
    }

    public PurchaseOrgUnitInfo getPurchaseOrgInfoByStorage(Context ctx, String purpCompanyID, StorageOrgUnitInfo storage) throws BOSException, EASBizException {
        int i;
        if (storage == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection storagePur = iUnitRel.getToUnit(storage.getId().toString(), 4, 3);
        OrgUnitCollection storageComp = iUnitRel.getFromUnit(purpCompanyID, 1, 3);
        PurchaseOrgUnitInfo retOrg = (PurchaseOrgUnitInfo)storagePur.get(0);
        int size = storageComp.size();
        HashMap<String, OrgUnitInfo> orgMap = new HashMap<String, OrgUnitInfo>();
        OrgUnitInfo org = null;
        for (i = 0; i < size; ++i) {
            org = storageComp.get(i);
            orgMap.put(org.getId().toString(), org);
        }
        size = storagePur.size();
        for (i = 0; i < size; ++i) {
            org = storagePur.get(i);
            if (orgMap.get(org.getId().toString()) == null) continue;
            retOrg = (PurchaseOrgUnitInfo)org;
            break;
        }
        return retOrg;
    }

    public StorageOrgUnitInfo getStorageOrgUnitInfo(Context ctx, CompanyOrgUnitInfo companyOrg) throws BOSException, EASBizException {
        if (companyOrg == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getFromUnit(companyOrg.getId().toString(), 1, 4);
        HashSet<String> iSet = new HashSet<String>();
        for (int i = 0; i < orgCol.size(); ++i) {
            iSet.add(orgCol.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", iSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isSealup", (Object)new Boolean(false), CompareType.EQUALS));
        view.setFilter(filter);
        StorageOrgUnitCollection stoOrgColl = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(view);
        return stoOrgColl.get(0);
    }

    public CompanyOrgUnitInfo getCompanyInfo(Context ctx, AdminOrgUnitInfo adminOrg) throws BOSException, EASBizException {
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getToUnit(adminOrg.getId().toString(), 0, 1);
        return (CompanyOrgUnitInfo)orgCol.get(0);
    }

    public static String getInStringFromList(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            in.append("'").append(iter.next().toString()).append("'");
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    private Map getMaterialIDByNumber(Context ctx, String numbers) throws BOSException, EASBizException {
        String sql = "select fid,fnumber from t_bd_material where fnumber in " + numbers;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, String> retMap = new HashMap<String, String>();
        try {
            while (rs.next()) {
                String number = rs.getString("fnumber");
                String id = rs.getString("fid");
                retMap.put(number, id);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return retMap;
    }

    private void setEntryUnit(Context ctx, String billID) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update t_sm_purrequestentry t10 set (funitid,fbaseunitid) = ");
        sql.append(" (select t2.fbaseunit,t2.fbaseunit from t_sm_purrequestentry t1 ");
        sql.append(" inner join t_bd_material t2 on t1.fmaterialid = t2.fid  ");
        sql.append(" where t10.fid = t1.fid and t1.fparentid = '" + billID + "' )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void setHeadDemandType(Context ctx, String billID, NetPurOrderEntryInfo netEntry) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(" update t_sm_purrequest t1 set (fDemandTypeid) = ( ");
        sb.append(" select top 1 t2.fid as id from T_SM_DemandType t2 where t2.frowtypeid = '" + netEntry.getPurhcaseType() + "' ");
        sb.append(" ) where t1.fid = '" + billID + "' ");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private void printExcetpion(Exception e) {
        StackTraceElement[] stack = e.getStackTrace();
        logger.error((Object)e.getMessage());
        for (int i = 0; i < stack.length; ++i) {
            logger.error((Object)stack[i].toString());
        }
    }
}

