/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.common.core.filter;

import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.barcode.common.core.filter.FilterElement;
import com.kingdee.eas.barcode.common.core.filter.SingleFilterElement;
import com.kingdee.eas.base.commonquery.CustomerParams;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class RangeFilterElement
extends FilterElement {
    private static final Logger logger = Logger.getLogger(RangeFilterElement.class);
    private Component fromComp = null;
    private Component toComp = null;
    SingleFilterElement from;
    SingleFilterElement to;

    public RangeFilterElement(String compareExp, Component fromComp, Component toComp) {
        super(compareExp);
        this.fromComp = fromComp;
        this.toComp = toComp;
        this.from = new SingleFilterElement(compareExp, fromComp);
        this.to = new SingleFilterElement(compareExp, toComp);
        this.to.putUserInfo("type", "end");
        this.from.setId(compareExp + "from");
        this.to.setId(compareExp + "to");
        this.from.setCompareType(CompareType.GREATER_EQUALS);
        this.to.setCompareType(CompareType.LESS_EQUALS);
    }

    public SingleFilterElement getFrom() {
        return this.from;
    }

    public void setFrom(SingleFilterElement from) {
        this.from = from;
    }

    public SingleFilterElement getTo() {
        return this.to;
    }

    public void setTo(SingleFilterElement to) {
        this.to = to;
    }

    public RangeFilterElement(String compareExp, Component fromComp, Component toComp, Object[] blankValue) {
        super(compareExp, blankValue);
        Object blankValuefrom = null;
        Object blankValueto = null;
        if (blankValue != null && blankValue.length == 2) {
            blankValuefrom = blankValue[0];
            blankValueto = blankValue[0];
        }
        this.from = new SingleFilterElement(compareExp, fromComp, blankValuefrom);
        this.to = new SingleFilterElement(compareExp, toComp, blankValueto);
        this.to.putUserInfo("type", "end");
        this.from.setId(compareExp + "from");
        this.to.setId(compareExp + "id");
        this.from.setCompareType(CompareType.GREATER_EQUALS);
        this.to.setCompareType(CompareType.LESS_EQUALS);
    }

    @Override
    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo item1 = null;
        FilterItemInfo item2 = null;
        if (this.from.getFilterInfo() != null && this.from.getFilterInfo().getFilterItems().size() > 0) {
            item1 = this.from.getFilterInfo().getFilterItems().get(0);
        }
        if (this.to.getFilterInfo() != null && this.to.getFilterInfo().getFilterItems().size() > 0) {
            item2 = this.to.getFilterInfo().getFilterItems().get(0);
        }
        if (item1 != null) {
            if (this.fromComp instanceof KDDatePicker) {
                item1.setCompareValue((Object)this.getTimestamp(Timestamp.valueOf((String)item1.getCompareValue()), 0));
            }
            filterInfo.getFilterItems().add(item1);
        }
        if (item2 != null) {
            if (this.toComp instanceof KDDatePicker) {
                item2.setCompareValue((Object)this.getTimestamp(Timestamp.valueOf((String)item2.getCompareValue()), 1));
            }
            filterInfo.getFilterItems().add(item2);
        }
        if (filterInfo.getFilterItems().size() > 1) {
            filterInfo.setMaskString("(#0 and #1)");
        }
        return filterInfo.getFilterItems().size() > 0 ? filterInfo : null;
    }

    @Override
    public void clear() {
        this.from.clear();
        this.to.clear();
    }

    @Override
    public void setElementValue(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        CustomerParams me = cp.getMe(this.from.getId());
        this.from.setElementValue(me);
        CustomerParams me2 = cp.getMe(this.to.getId());
        this.to.setElementValue(me2);
    }

    public void setDefaultValue(Object value) {
        if (value instanceof String[]) {
            String[] values = (String[])value;
            if (values.length > 0) {
                this.from.setDefaultValue(values[0]);
            }
            if (values.length > 1) {
                this.to.setDefaultValue(values[1]);
            }
        }
    }

    @Override
    public CustomerParams getElementValue() {
        CustomerParams cst = new CustomerParams();
        CustomerParams elementValue = this.from.getElementValue();
        CustomerParams elementValue2 = this.to.getElementValue();
        if (elementValue == null && elementValue2 == null) {
            return cst;
        }
        if (elementValue != null) {
            cst.putMe(this.from.getId(), elementValue);
        }
        if (elementValue2 != null) {
            cst.putMe(this.to.getId(), elementValue2);
        }
        return cst;
    }

    @Override
    public String getValue() {
        return this.from.getValue() + " to " + this.from.getValue();
    }

    public Timestamp getTimestamp(Timestamp value, int dateType) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        if (dateType == 0) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            calendar.set(14, 0);
        } else {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            calendar.set(14, 995);
        }
        return new Timestamp(calendar.getTimeInMillis());
    }
}

