/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.barcode.common.util.GenePrecisionUtil;
import com.kingdee.eas.barcode.common.util.GeneStringUtils;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JScrollBar;
import javax.swing.JTextField;

public abstract class KDTableUtils {
    private static final String TABLENULLEXCEPTION = "\u4f20\u5165\u7684\u660e\u7ec6\u8868\u4e0d\u5b58\u5728";
    private static final BigDecimal MAXVALUE = new BigDecimal("9999999999999.99999999");
    private static final BigDecimal MINVALUE = new BigDecimal(1.0E-8);

    public static void setMergeColumn(KDTable table, String[] columns) {
        table.checkParsed();
        table.getGroupManager().setGroup(true);
        for (int i = 0; i < columns.length; ++i) {
            table.getColumn(columns[i]).setGroup(true);
            table.getColumn(columns[i]).setMergeable(true);
        }
    }

    public static void setHideColumn(KDTable table, String[] columns) {
        int i;
        for (i = 0; i < table.getColumnCount(); ++i) {
            table.getColumn(i).getStyleAttributes().setHided(false);
        }
        for (i = 0; i < columns.length; ++i) {
            table.getColumn(columns[i]).getStyleAttributes().setHided(true);
        }
    }

    public static void setShowColumn(KDTable table, String[] columns) {
        int i;
        for (i = 0; i < table.getColumnCount(); ++i) {
            table.getColumn(i).getStyleAttributes().setHided(true);
        }
        for (i = 0; i < columns.length; ++i) {
            table.getColumn(columns[i]).getStyleAttributes().setHided(false);
        }
    }

    public static void setLockColumn(KDTable table, String[] columns) {
        int i;
        for (i = 0; i < table.getColumnCount(); ++i) {
            table.getColumn(i).getStyleAttributes().setLocked(false);
        }
        for (i = 0; i < columns.length; ++i) {
            table.getColumn(columns[i]).getStyleAttributes().setLocked(true);
        }
    }

    public static void setLockColumn(KDTable table, int rowIndex, String[] columns) {
        int i;
        for (i = 0; i < table.getColumnCount(); ++i) {
            table.getCell(rowIndex, i).getStyleAttributes().setLocked(false);
        }
        for (i = 0; i < columns.length; ++i) {
            table.getCell(rowIndex, columns[i]).getStyleAttributes().setLocked(true);
        }
    }

    public static void setUnLockColumn(KDTable table, String[] columns) {
        int i;
        for (i = 0; i < table.getColumnCount(); ++i) {
            table.getColumn(i).getStyleAttributes().setLocked(true);
        }
        for (i = 0; i < columns.length; ++i) {
            table.getColumn(columns[i]).getStyleAttributes().setLocked(false);
        }
    }

    public static void setUnLockColumn(KDTable table, int rowIndex, String[] columns) {
        int i;
        for (i = 0; i < table.getColumnCount(); ++i) {
            table.getCell(rowIndex, i).getStyleAttributes().setLocked(true);
        }
        for (i = 0; i < columns.length; ++i) {
            table.getCell(rowIndex, columns[i]).getStyleAttributes().setLocked(false);
        }
    }

    public static String getFieldName(KDTable table, int columnIndex) {
        String fieldName = null;
        if (table != null && columnIndex > -1) {
            fieldName = table.getColumnKey(columnIndex);
        }
        return fieldName;
    }

    public static Object getFieldValue(KDTable table, int rowIndex, String fieldName) {
        Object result = null;
        ICell cell = KDTableUtils.getCell(table, rowIndex, fieldName);
        if (cell != null) {
            result = cell.getValue();
        }
        return result;
    }

    public static Object getFieldValue(KDTable table, int rowIndex, int columnIndex) {
        Object result = null;
        ICell cell = KDTableUtils.getCell(table, rowIndex, columnIndex);
        if (cell != null) {
            result = cell.getValue();
        }
        return result;
    }

    public static List getFieldValues(KDTable table, int rowIndex, String[] fieldNames) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (table != null && rowIndex > -1 && fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                values.add(i, KDTableUtils.getFieldValue(table, rowIndex, fieldNames[i]));
            }
        }
        return values;
    }

    public static List getMapFieldValues(KDTable table, String[] fieldNames) {
        ArrayList<Map> allList = new ArrayList<Map>();
        if (table != null && fieldNames != null) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                Map map = KDTableUtils.getMapFieldValues(table, i, fieldNames);
                allList.add(map);
            }
        }
        return allList;
    }

    public static Map getMapFieldValues(KDTable table, int rowIndex, String[] fieldNames) {
        HashMap map = new HashMap();
        List list = KDTableUtils.getFieldValues(table, rowIndex, fieldNames);
        for (int j = 0; j < fieldNames.length; ++j) {
            map.put(fieldNames[j], list.get(j));
        }
        return map;
    }

    public static List getColumnValues(KDTable table, String fieldName) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (table != null && fieldName != null) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                Object val = KDTableUtils.getFieldValue(table, i, fieldName);
                list.add(val);
            }
        }
        return list;
    }

    public static List getFieldValues(KDTable table, int rowIndex, int[] columnIndexes) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (table != null && rowIndex > -1 && columnIndexes != null) {
            int size = columnIndexes.length;
            for (int i = 0; i < size; ++i) {
                values.add(i, KDTableUtils.getFieldValue(table, rowIndex, columnIndexes[i]));
            }
        }
        return values;
    }

    public static void setFieldValues(KDTable table, int rowIndex, String[] fieldNames, Object[] values) {
        if (fieldNames != null) {
            int vSize = values.length;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                if (i > -1 && i < vSize) {
                    KDTableUtils.setFieldValue(table, rowIndex, fieldNames[i], values[i]);
                    continue;
                }
                KDTableUtils.setFieldValue(table, rowIndex, fieldNames[i], null);
            }
        }
    }

    public static void setFieldValues(KDTable table, int rowIndex, int[] columnIndexes, Object[] values) {
        if (columnIndexes != null) {
            int vSize = values.length;
            int size = columnIndexes.length;
            for (int i = 0; i < size; ++i) {
                if (i > -1 && i < vSize) {
                    KDTableUtils.setFieldValue(table, rowIndex, columnIndexes[i], values[i]);
                    continue;
                }
                KDTableUtils.setFieldValue(table, rowIndex, columnIndexes[i], null);
            }
        }
    }

    public static void setFieldValue(KDTable table, int rowIndex, String fieldName, Object value) {
        ICell cell = KDTableUtils.getCell(table, rowIndex, fieldName);
        if (cell != null) {
            cell.setValue(value);
        }
    }

    public static void setFieldValue(KDTable table, int rowIndex, int columnIndex, Object value) {
        ICell cell = KDTableUtils.getCell(table, rowIndex, columnIndex);
        if (cell != null) {
            cell.setValue(value);
        }
    }

    public static ICell getCell(KDTable table, int rowIndex, String fieldName) {
        IRow row;
        ICell cell = null;
        if (table != null && rowIndex > -1 && fieldName != null && fieldName.trim().length() != 0 && (row = table.getRow2(rowIndex)) != null) {
            cell = row.getCell(fieldName);
        }
        return cell;
    }

    public static ICell getCell(KDTable table, int rowIndex, int columnIndex) {
        ICell cell = null;
        if (table != null && rowIndex > -1 && columnIndex > -1) {
            cell = table.getRow(rowIndex).getCell(columnIndex);
        }
        return cell;
    }

    public static int getColumnIndex(KDTable table, String fieldName) {
        IColumn column = KDTableUtils.getColumn(table, fieldName);
        int columnIndex = -1;
        if (column != null) {
            columnIndex = column.getColumnIndex();
        }
        return columnIndex;
    }

    public static IColumn getColumn(KDTable table, String fieldName) {
        IColumn column = null;
        if (table != null && fieldName != null && fieldName.trim().length() != 0) {
            column = table.getColumn(fieldName);
        }
        return column;
    }

    public static IColumn getColumn(KDTable table, int columnIndex) {
        IColumn column = null;
        if (table != null && columnIndex > -1) {
            column = table.getColumn(columnIndex);
        }
        return column;
    }

    public static void setHideFields(KDTable table, String[] fieldNames, boolean isHide) {
        if (fieldNames != null) {
            IColumn column = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                column = KDTableUtils.getColumn(table, fieldNames[i]);
                if (column == null) continue;
                column.getStyleAttributes().setHided(isHide);
                if (!isHide) continue;
                column.setWidth(-1);
            }
        }
    }

    public static void setLockCells(KDTable table, int rowIndex, String[] fieldNames, boolean isLock) {
        if (fieldNames != null) {
            ICell cell = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                cell = KDTableUtils.getCell(table, rowIndex, fieldNames[i]);
                if (cell == null) continue;
                cell.getStyleAttributes().setLocked(isLock);
            }
        }
    }

    public static void setLockFields(KDTable table, String[] fieldNames, boolean isLock) {
        if (fieldNames != null) {
            IColumn column = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                column = KDTableUtils.getColumn(table, fieldNames[i]);
                if (column == null) continue;
                column.getStyleAttributes().setLocked(isLock);
            }
        }
    }

    public static void setLockFields(KDTable table, boolean isLock) {
        int size = table.getColumnCount();
        for (int i = 0; i < size; ++i) {
            IColumn column = KDTableUtils.getColumn(table, i);
            if (column == null) continue;
            column.getStyleAttributes().setLocked(isLock);
        }
    }

    public static void setBigDecimalFieldsPrecision(int precision, KDTable table, String[] fieldNames) {
        if (fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                KDTableUtils.setBigDecimalFieldsPrecisionByColumn(KDTableUtils.getColumn(table, fieldNames[i]), precision);
            }
        }
    }

    public static void setBigDecimalFieldsPrecision(int precision, KDTable table, String[] fieldNames, BigDecimal maxValue) {
        if (fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                KDTableUtils.setBigDecimalFieldsPrecisionByColumn(KDTableUtils.getColumn(table, fieldNames[i]), precision, maxValue);
            }
        }
    }

    public static void setBigDecimalFieldsPrecision(int precision, KDTable table, int rowIndex, String[] fieldNames) {
        if (fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                KDTableUtils.setBigDecimalFieldsPrecisionByCell(KDTableUtils.getCell(table, rowIndex, fieldNames[i]), precision);
            }
        }
    }

    public static void setBigDecimalFieldsPrecision(int precision, KDTable table, int rowIndex, String[] fieldNames, BigDecimal maxValue) {
        if (fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                KDTableUtils.setBigDecimalFieldsPrecisionByCell(KDTableUtils.getCell(table, rowIndex, fieldNames[i]), precision, maxValue);
            }
        }
    }

    public static void setBigDecimalFieldsPrecisionByColumn(IColumn column, int precision) {
        if (column != null) {
            column.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)KDTableUtils.getBigDecimalTextField(precision, null)));
            column.getStyleAttributes().setNumberFormat(GenePrecisionUtil.getFormatString(precision));
        }
    }

    public static void setBigDecimalFieldsPrecisionByColumn(IColumn column, int precision, BigDecimal maxValue) {
        if (column != null) {
            column.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)KDTableUtils.getBigDecimalTextField(precision, maxValue)));
            column.getStyleAttributes().setNumberFormat(GenePrecisionUtil.getFormatString(precision));
        }
    }

    public static void setBigDecimalFieldsPrecisionByCell(ICell cell, int precision) {
        if (cell != null) {
            cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)KDTableUtils.getBigDecimalTextField(precision, null)));
            cell.getStyleAttributes().setNumberFormat(GenePrecisionUtil.getFormatString(precision));
        }
    }

    public static void setBigDecimalFieldsPrecisionByCell(ICell cell, int precision, BigDecimal maxValue) {
        if (cell != null) {
            cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)KDTableUtils.getBigDecimalTextField(precision, maxValue)));
            cell.getStyleAttributes().setNumberFormat(GenePrecisionUtil.getFormatString(precision));
            cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    public static KDFormattedTextField getBigDecimalTextField(int precision, BigDecimal maxValue) {
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(precision);
        colTxtField.setHorizontalAlignment(4);
        colTxtField.setSupportedEmpty(true);
        colTxtField.setRemoveingZeroInDispaly(false);
        colTxtField.setMinimumValue((Comparable)new BigDecimal("0"));
        if (maxValue != null) {
            colTxtField.setMaximumValue((Comparable)maxValue);
        } else {
            colTxtField.setMaximumValue((Comparable)MAXVALUE);
        }
        return colTxtField;
    }

    public static void changeScrollBar(KDTable table) {
        table.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        table.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
    }

    public static void setFieldsHorizontalAlignment(Styles.HorizontalAlignment hAlign, KDTable table, String[] fieldNames) {
        if (fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                KDTableUtils.getColumn(table, fieldNames[i]).getStyleAttributes().setHorizontalAlign(hAlign);
            }
        }
    }

    public static void setFreezeColumn(KDTable table, int[] columnIndexes) {
        if (table != null && columnIndexes != null) {
            int size = columnIndexes.length;
            for (int i = 0; i < size; ++i) {
                table.getViewManager().freeze(-1, columnIndexes[i]);
            }
        }
    }

    public static void setFreezeColumn(KDTable table, String[] fieldNames) {
        if (table != null && fieldNames != null) {
            IColumn column = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                column = KDTableUtils.getColumn(table, fieldNames[i]);
                if (column == null) continue;
                table.getViewManager().freeze(-1, column.getColumnIndex() + 1);
            }
        }
    }

    public static void setFreezeRow(KDTable table, int[] rowIndex) {
        if (table != null && rowIndex != null) {
            int size = rowIndex.length;
            for (int i = 0; i < size; ++i) {
                table.getViewManager().freeze(-1, rowIndex[i]);
            }
        }
    }

    public static void setFreezeCell(KDTable table, int rowIndex, int colIndex, boolean isFreeze) {
        ICell cell = KDTableUtils.getCell(table, rowIndex, colIndex);
        if (cell != null) {
            cell.getStyleAttributes().setLocked(isFreeze);
        }
    }

    public static void setFreezeCell(KDTable table, int rowIndex, String colName, boolean isFreeze) {
        ICell cell = KDTableUtils.getCell(table, rowIndex, colName);
        if (cell != null) {
            cell.getStyleAttributes().setLocked(isFreeze);
        }
    }

    public static void lockColumnNotMoveable(KDTable table) {
        if (table != null) {
            int size = table.getColumnCount();
            for (int i = 0; i < size; ++i) {
                table.getColumn(i).setMoveable(false);
            }
        }
    }

    public static void addCellF7NewFilter(KDTable table, int rowIndex, String fieldName, FilterInfo filter) throws BOSException {
        KDTableUtils.addCellF7Filter(table, rowIndex, fieldName, filter, false, null);
    }

    public static void addCellF7Filter(KDTable table, int rowIndex, String fieldName, FilterInfo filter) throws BOSException {
        KDTableUtils.addCellF7Filter(table, rowIndex, fieldName, filter, true, "AND");
    }

    public static void addCellF7Filter(KDTable table, int rowIndex, String fieldName, FilterInfo filter, boolean isRequireMerge) throws BOSException {
        KDTableUtils.addCellF7Filter(table, rowIndex, fieldName, filter, isRequireMerge, "AND");
    }

    public static void addCellF7Filter(KDTable table, int rowIndex, String fieldName, FilterInfo filter, boolean isRequireMerge, String logic) throws BOSException {
        if (table != null && !StringUtils.isEmpty((String)fieldName)) {
            ICellEditor[] editor = KDTableUtils.getCellEditor(table, rowIndex, new String[]{fieldName});
            KDBizPromptBox f7 = null;
            if (editor == null) {
                f7 = new KDBizPromptBox();
                KDTableUtils.getCell(table, rowIndex, fieldName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7));
            } else if (editor[0].getComponent() instanceof KDBizPromptBox) {
                f7 = (KDBizPromptBox)editor[0].getComponent();
            }
            KDTableUtils.addF7Filter(f7, filter, isRequireMerge, logic);
        }
    }

    public static void addColF7NewFilter(KDTable table, String fieldName, FilterInfo filter) throws BOSException {
        KDTableUtils.addColF7Filter(table, fieldName, filter, false, null);
    }

    public static void addColF7Filter(KDTable table, String fieldName, FilterInfo filter) throws BOSException {
        KDTableUtils.addColF7Filter(table, fieldName, filter, true, "AND");
    }

    public static void addColF7Filter(KDTable table, String fieldName, FilterInfo filter, boolean isRequireMerge) throws BOSException {
        KDTableUtils.addColF7Filter(table, fieldName, filter, isRequireMerge, "AND");
    }

    public static void addColF7Filter(KDTable table, String fieldName, FilterInfo filter, boolean isRequireMerge, String logic) throws BOSException {
        if (table != null && !StringUtils.isEmpty((String)fieldName)) {
            ICellEditor[] editor = KDTableUtils.getColEditor(table, new String[]{fieldName});
            KDBizPromptBox f7 = null;
            if (editor == null) {
                f7 = new KDBizPromptBox();
                KDTableUtils.getColumn(table, fieldName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7));
            } else if (editor[0].getComponent() instanceof KDBizPromptBox) {
                f7 = (KDBizPromptBox)editor[0].getComponent();
            }
            KDTableUtils.addF7Filter(f7, filter, isRequireMerge, logic);
        }
    }

    private static void addF7Filter(KDBizPromptBox f7, FilterInfo filter, boolean isRequireMerge, String logic) throws BOSException {
        if (f7 != null) {
            EntityViewInfo v = f7.getEntityViewInfo();
            if (v == null) {
                v = new EntityViewInfo();
            }
            FilterInfo flt = v.getFilter();
            if (isRequireMerge && !StringUtils.isEmpty((String)logic) && flt != null && filter != null) {
                flt.mergeFilter(filter, logic);
            } else if (!isRequireMerge && filter != null) {
                v.setFilter(filter);
            }
            f7.setEntityViewInfo(v);
        }
    }

    public static ICellEditor[] getCellEditor(KDTable table, int rowIndex, String[] fieldNames) {
        KDTDefaultCellEditor[] editors = null;
        if (table != null && fieldNames != null) {
            ICell cell = null;
            editors = new KDTDefaultCellEditor[fieldNames.length];
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                cell = KDTableUtils.getCell(table, rowIndex, fieldNames[i]);
                if (cell == null) continue;
                editors[i] = cell.getEditor();
            }
        }
        return editors;
    }

    public static ICellEditor[] getColEditor(KDTable table, String[] fieldNames) {
        KDTDefaultCellEditor[] editors = null;
        if (table != null && fieldNames != null) {
            IColumn column = null;
            editors = new KDTDefaultCellEditor[fieldNames.length];
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                column = KDTableUtils.getColumn(table, fieldNames[i]);
                if (column == null) continue;
                editors[i] = column.getEditor();
            }
        }
        return editors;
    }

    public static void setCellEditor(KDTable table, int rowIndex, Map cellEditors) {
        if (table != null && cellEditors != null) {
            Iterator itor = cellEditors.keySet().iterator();
            Object key = null;
            Object editor = null;
            ICell cell = null;
            while (itor.hasNext()) {
                key = itor.next();
                if (key instanceof String) {
                    cell = KDTableUtils.getCell(table, rowIndex, key.toString());
                } else if (key instanceof Integer) {
                    cell = KDTableUtils.getCell(table, rowIndex, Integer.parseInt(key.toString()));
                }
                editor = cellEditors.get(key);
                if (cell == null || !(editor instanceof IKDEditor)) continue;
                cell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)editor));
            }
        }
    }

    public static void setColEditor(KDTable table, Map columnEditors) {
        if (table != null && columnEditors != null) {
            Iterator itor = columnEditors.keySet().iterator();
            Object key = null;
            Object editor = null;
            IColumn column = null;
            while (itor.hasNext()) {
                key = itor.next();
                if (key instanceof String) {
                    column = KDTableUtils.getColumn(table, key.toString());
                } else if (key instanceof Integer) {
                    column = KDTableUtils.getColumn(table, Integer.parseInt(key.toString()));
                }
                editor = columnEditors.get(key);
                if (column == null || !(editor instanceof IKDEditor)) continue;
                column.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)editor));
            }
        }
    }

    public static IObjectValue[] selectedInfosForTable(KDTable table, DataBinder dataBinder) {
        ArrayList arrayList;
        KDTSelectManager kdtSelectManager;
        IObjectValue[] infos = null;
        IObjectValue info = null;
        if (table != null && (kdtSelectManager = table.getSelectManager()) != null && (arrayList = kdtSelectManager.getBlocks()) != null && arrayList.size() > 0) {
            int entryCount = 0;
            int blockEntryCount = 0;
            for (int arrayListIndex = 0; arrayListIndex < arrayList.size(); ++arrayListIndex) {
                KDTSelectBlock kdtSelectBlock = (KDTSelectBlock)arrayList.get(arrayListIndex);
                blockEntryCount = Math.abs(kdtSelectBlock.getEndRow() - kdtSelectBlock.getBeginRow()) + 1;
                entryCount += blockEntryCount;
            }
            infos = new IObjectValue[entryCount];
            int arrayIndex = 0;
            for (int arrayListIndex = 0; arrayListIndex < arrayList.size(); ++arrayListIndex) {
                int endRow;
                KDTSelectBlock kdtSelectBlock = (KDTSelectBlock)arrayList.get(arrayListIndex);
                int beginRow = kdtSelectBlock.getBeginRow();
                if (beginRow > (endRow = kdtSelectBlock.getEndRow())) {
                    beginRow = endRow;
                    endRow = kdtSelectBlock.getBeginRow();
                }
                for (int rowIndex = beginRow; rowIndex <= endRow; ++rowIndex) {
                    if (table.getRow(rowIndex) == null) continue;
                    dataBinder.storeLineFields(table, table.getRow(rowIndex), null);
                    Object o = table.getRow(rowIndex).getUserObject();
                    if (!(o instanceof AbstractObjectValue)) continue;
                    info = (IObjectValue)((AbstractObjectValue)o).clone();
                    infos[arrayIndex++] = info;
                }
            }
        }
        return infos;
    }

    public static void selectFirstRow(KDTable table) {
        if (table != null && table.getRow(0) != null) {
            table.getSelectManager().select(0, 0);
        }
    }

    public static void setAutoAddRow(KDTable table, boolean isAuto) {
        KDTableHelper.updateEnterWithTab((KDTable)table, (boolean)isAuto, null);
        KDTableHelper.downArrowAutoAddRow((KDTable)table, (boolean)isAuto, null);
    }

    public static boolean isRowBlankOnTable(KDTable detailTable, int row, String[] cols) throws Exception {
        if (detailTable == null) {
            throw new Exception(TABLENULLEXCEPTION);
        }
        if (cols == null) {
            return false;
        }
        for (int i = 0; i < cols.length; ++i) {
            if (detailTable.getCell(row, cols[i]).getValue() == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isRowBlank(IRow row, String key) {
        return row.getCell(key).getValue() == null;
    }

    public static void removeLine(KDTable table, int rowIndex) {
        if (table == null) {
            return;
        }
        if (table.getRow(rowIndex) != null) {
            table.getSelectManager().select(rowIndex, 0, rowIndex, 0, 2);
            IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
            table.removeRow(rowIndex);
            IObjectCollection collection = (IObjectCollection)table.getUserObject();
            if (collection != null && detailData != null) {
                collection.removeObject(detailData);
            }
        }
    }

    public static IRow addLine(KDTable table) {
        if (table == null) {
            return null;
        }
        IRow row = table.addRow();
        return row;
    }

    public static void setKDTableColumnsMaxLength(KDTable table, HashMap columnNames) {
        if (table == null || columnNames == null) {
            return;
        }
        for (Object o : columnNames.keySet()) {
            String columnName = o.toString();
            KDTextField txtInput = new KDTextField();
            txtInput.setMaxLength(new BigDecimal(columnNames.get(columnName).toString()).intValue());
            table.getColumn(columnName).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtInput));
        }
    }

    public static void setKDTableColumnsMaxLength(KDTable table, String[] columnNames, int maxLength) {
        if (table == null || columnNames == null || maxLength <= 0) {
            return;
        }
        for (int i = 0; i < columnNames.length; ++i) {
            KDTextField txtInput = new KDTextField();
            txtInput.setMaxLength(maxLength);
            table.getColumn(columnNames[i]).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtInput));
        }
    }

    public static void setKDTableColumnsMaxValue(KDTable table, String[] columnNames, BigDecimal maxValue) {
        if (table == null || columnNames == null) {
            return;
        }
        for (int i = 0; i < columnNames.length; ++i) {
            KDFormattedTextField colTxtField = new KDFormattedTextField();
            colTxtField.setDataType(1);
            if (maxValue != null) {
                colTxtField.setMaximumValue((Comparable)maxValue);
            } else {
                colTxtField.setMaximumValue((Comparable)MAXVALUE);
            }
            IColumn column = KDTableUtils.getColumn(table, columnNames[i]);
            if (column == null) continue;
            column.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)colTxtField));
        }
    }

    public static void setKDTableColumnsMinValue(KDTable table, String[] columnNames, BigDecimal minValue) {
        if (table == null || columnNames == null) {
            return;
        }
        for (int i = 0; i < columnNames.length; ++i) {
            IColumn column = KDTableUtils.getColumn(table, columnNames[i]);
            KDFormattedTextField colTxtField = null;
            colTxtField = column.getEditor().getComponent() instanceof KDFormattedTextField ? (KDFormattedTextField)column.getEditor().getComponent() : new KDFormattedTextField();
            colTxtField.setDataType(1);
            if (minValue != null) {
                colTxtField.setMinimumValue((Comparable)minValue);
            } else {
                colTxtField.setMinimumValue((Comparable)MINVALUE);
            }
            if (column == null) continue;
            column.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)colTxtField));
        }
    }

    public static int[] getSelectedRows(KDTable table) {
        if (table.getSelectManager().size() == 0) {
            return new int[0];
        }
        int count = KDTableUtils.getSelectedRowCount(table);
        int[] rows = new int[count];
        int k = 0;
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            int j;
            KDTSelectBlock block = table.getSelectManager().get(i);
            if (block.getMode() == 8) {
                for (j = 0; j < count; ++j) {
                    rows[j] = j;
                }
                continue;
            }
            for (j = block.getTop(); j <= block.getBottom(); ++j) {
                if (j == -1 || table.getRow(j) == null || table.getRow(j).getStyleAttributes().isHided()) continue;
                rows[k] = j;
                ++k;
            }
        }
        return rows;
    }

    public static int getSelectedRowCount(KDTable table) {
        int count = 0;
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            KDTSelectBlock block = table.getSelectManager().get(i);
            count = block.getMode() == 8 ? (count += table.getRowCount()) : (count += block.getBottom() - block.getTop() + 1);
            for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                IRow row = table.getRow(j);
                if (row == null || !row.getStyleAttributes().isHided()) continue;
                --count;
            }
        }
        return count;
    }

    public static void setColumnDisplayFormat(KDTable table, String columnName, String formatString) {
        if (table == null || StringUtils.isEmpty((String)columnName) || table.getColumnIndex(columnName) < 0) {
            return;
        }
        KDTableUtils.setColumnDisplayFormat(table, table.getColumnIndex(columnName), formatString);
    }

    public static void setColumnDisplayFormat(KDTable table, String[] cols, String formatString) {
        for (int i = 0; i < cols.length; ++i) {
            KDTableUtils.setColumnDisplayFormat(table, cols[i], formatString);
        }
    }

    public static void setColumnDisplayFormat(KDTable table, int columnIndex, String formatString) {
        if (table == null || StringUtils.isEmpty((String)formatString) || table.getColumn(columnIndex) == null) {
            return;
        }
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat(formatString));
        table.getColumn(columnIndex).setRenderer((IBasicRender)avr);
    }

    public static void setColumnDisplayFormat(KDTable table, int[] cols, String formatString) {
        for (int i = 0; i < cols.length; ++i) {
            KDTableUtils.setColumnDisplayFormat(table, cols[i], formatString);
        }
    }

    public static void setKDTableFunction(KDTable[] tables, boolean enabled) {
        if (tables == null) {
            return;
        }
        int count = tables.length;
        for (int i = 0; i < count; ++i) {
            KDTableHelper.updateEnterWithTab((KDTable)tables[i], (boolean)enabled);
            KDTableHelper.downArrowAutoAddRow((KDTable)tables[i], (boolean)enabled, null);
            tables[i].getEditHelper().setCoypMode(2);
        }
    }

    public static void unSelectUnVisableRow(KDTable table) {
        if (table != null && table.getRowCount() > 0) {
            table.getSelectManager().setSelectMode(10);
            int[] rows = KDTableUtils.getSelectedRows(table);
            if (rows.length > 0) {
                int i;
                ArrayList<Integer> list = new ArrayList<Integer>();
                int size = rows.length;
                for (i = 0; i < size; ++i) {
                    list.add(new Integer(rows[i]));
                }
                size = rows.length;
                for (i = 0; i < size; ++i) {
                    if (!table.getRow(rows[i]).getStyleAttributes().isHided()) continue;
                    list.remove(new Integer(rows[i]));
                }
                table.getSelectManager().unselect(new KDTSelectBlock(rows[0], 0, rows[0], 1), false);
                size = list.size();
                for (i = 0; i < size; ++i) {
                    table.getSelectManager().add(((Integer)list.get(i)).intValue(), 0, ((Integer)list.get(i)).intValue(), 1);
                }
            }
        }
    }

    public void setValueByFirstRow(KDTable table, String[] columnNames) {
        if (table == null || columnNames == null || columnNames.length == 0) {
            return;
        }
        Object[] values = new Object[columnNames.length];
        int size = columnNames.length;
        for (int columnIndex = 0; columnIndex < size; ++columnIndex) {
            values[columnIndex] = KDTableUtils.getFieldValue(table, 0, columnNames[columnIndex]);
        }
        size = table.getRowCount();
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            KDTableUtils.setFieldValues(table, rowIndex, columnNames, values);
        }
    }

    public static void printTableAttributes(KDTable[] tables, PrintStream out) {
        if (out == null) {
            out = System.out;
        }
        if (tables != null) {
            for (int i = 0; i < tables.length; ++i) {
                KDTable table = tables[i];
                out.println("\u8868\u540d\uff1a" + table.getName());
                out.println("\u5b57\u6bb5\u540d\t\t\u6807\u9898\t\t\u9501\u5b9a\t\t\u53ef\u89c1\t\t\u5fc5\u5f55");
                if (table == null) continue;
                int size = table.getColumnCount();
                for (int colIndex = 0; colIndex < size; ++colIndex) {
                    IColumn column = table.getColumn(colIndex);
                    out.print(column.getFieldName() + "\t\t");
                    out.print(table.getHead().getRow(0).getCell(colIndex).getValue() + "\t\t");
                    out.print(column.getStyleAttributes().isLocked() + "\t\t");
                    out.print(!column.getStyleAttributes().isHided() + "\t\t");
                    out.print(column.isRequired());
                    out.println("");
                }
            }
        }
    }

    public static void addSelectedRow(KDTable table, int row) {
        table.getSelectManager().setActiveRowIndex(row);
        KDTSelectBlock block = new KDTSelectBlock();
        block.setTop(row);
        block.setBottom(row);
        block.setLeft(0);
        block.setRight(table.getColumnCount());
        block.setTable(table);
        table.getSelectManager().add(block);
    }

    public static void setFieldsDate(KDTable table, String[] fieldName, boolean required, boolean timeEnabled) {
        IColumn column = null;
        KDDatePicker date = null;
        int length = fieldName.length;
        for (int i = 0; i < length; ++i) {
            column = KDTableUtils.getColumn(table, fieldName[i]);
            if (column == null) continue;
            date = new KDDatePicker();
            date.setRequired(required);
            date.setTimeEnabled(timeEnabled);
            column.setEditor((ICellEditor)new KDTDefaultCellEditor(date));
        }
    }

    public static void moveRowsFromTableToTable(int[] rowIndex, KDTable fromTable, KDTable toTable) {
        if (rowIndex == null || fromTable == null || toTable == null) {
            return;
        }
        Arrays.sort(rowIndex);
        int sumDelIndex = 0;
        for (int i = 0; i < rowIndex.length; ++i) {
            int index = rowIndex[i];
            IRow row = fromTable.getRow(index -= ++sumDelIndex);
            toTable.addRow(toTable.getRowCount(), row);
            fromTable.removeRow(index);
        }
    }

    public static void fillDataOnTable(KDTable table, IRowSet rs) throws Exception {
        int rsColSize = rs.getMetaData().getColumnCount();
        int tableColSize = table.getColumnCount();
        while (rs.next()) {
            IRow row = table.addRow();
            for (int i = 0; i < rsColSize && i < tableColSize; ++i) {
                row.getCell(i).setValue(rs.getObject(i + 1));
            }
        }
    }

    public static void fillDataOnTableByColName(KDTable table, IRowSet rs, String[] colNames) throws Exception {
        int rsColSize = rs.getMetaData().getColumnCount();
        int tableColSize = table.getColumnCount();
        while (rs.next()) {
            IRow row = table.addRow();
            for (int i = 0; i < rsColSize && i < tableColSize; ++i) {
                row.getCell(colNames[i]).setValue(rs.getObject(i + 1));
            }
        }
    }

    public static void autoChangeTableColWidth(KDTable table) {
        KDTableUtils.autoChangeTableColWidth(table, null);
    }

    public static void autoChangeTableColWidth(KDTable table, int maxWidth) {
        KDTableUtils.autoChangeTableColWidth(table, null, maxWidth);
    }

    public static void autoChangeTableColWidth(KDTable table, List unChangeCols) {
        KDTableUtils.autoChangeTableColWidth(table, unChangeCols, -1);
    }

    public static void autoChangeTableColWidth(KDTable table, List unChangeCols, int maxWidth) {
        int headBase = 8;
        int dataBase = 7;
        int numberAppend = 5;
        int sortBase = 4;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            int curWidth;
            IColumn curColumn = table.getColumn(i);
            if (curColumn.getStyleAttributes().isHided() || unChangeCols != null && unChangeCols.contains(curColumn.getKey())) continue;
            int headColWidth = 0;
            int dataColWidth = 0;
            if (table.getHeadRowCount() > 0) {
                String colValue = (String)table.getHeadRow(table.getHeadRowCount() - 1).getCell(i).getValue();
                headColWidth = (GeneStringUtils.getStringLength(colValue) + sortBase) * headBase;
            }
            for (int j = 0; j < table.getRowCount(); ++j) {
                int tempWidth;
                String tempStr = "";
                if (table.getCell(j, i).getValue() != null) {
                    tempStr = table.getCell(j, i).getValue().toString();
                }
                int strLength = GeneStringUtils.getStringLength(tempStr);
                if (GeneStringUtils.isNumber(tempStr)) {
                    strLength += numberAppend;
                }
                if ((tempWidth = strLength * dataBase) <= dataColWidth) continue;
                dataColWidth = tempWidth;
            }
            int n = curWidth = headColWidth > dataColWidth ? headColWidth : dataColWidth;
            if (maxWidth <= 0) {
                maxWidth = 250;
            }
            if (curWidth > maxWidth) {
                curWidth = maxWidth;
            }
            curColumn.setWidth(curWidth);
        }
    }

    public static void setEntryTitleVisible(DetailPanel detailPanel, boolean visible) {
        KDPanel controlPanel = (KDPanel)detailPanel.getComponent(0);
        KDContainer conTitle = (KDContainer)controlPanel.getComponent(0);
        conTitle.setVisible(visible);
        conTitle.setTitleStyle(2);
    }

    public static void printKDTableDefinition(KDTable table, String prefix) {
        if (table == null) {
            return;
        }
        int columns = table.getColumnCount();
        for (int i = 0; i < columns; ++i) {
            IColumn iColumn = table.getColumn(i);
        }
    }

    public static void resetDetailPanelActions(DetailPanel detailPanel, ActionListener addAction, ActionListener insertAction, ActionListener removeAction) {
        int i;
        ActionListener[] oldListeners = detailPanel.getAddNewLineButton().getActionListeners();
        for (i = 0; i < oldListeners.length; ++i) {
            detailPanel.getAddNewLineButton().removeActionListener(oldListeners[i]);
        }
        detailPanel.getAddNewLineButton().addActionListener(addAction);
        oldListeners = detailPanel.getInsertLineButton().getActionListeners();
        for (i = 0; i < oldListeners.length; ++i) {
            detailPanel.getInsertLineButton().removeActionListener(oldListeners[i]);
        }
        detailPanel.getInsertLineButton().addActionListener(insertAction);
        oldListeners = detailPanel.getRemoveLinesButton().getActionListeners();
        for (i = 0; i < oldListeners.length; ++i) {
            detailPanel.getRemoveLinesButton().removeActionListener(oldListeners[i]);
        }
        detailPanel.getRemoveLinesButton().addActionListener(removeAction);
    }

    public static KDFormattedTextField getBigDecimalTextField(int precision) {
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(precision);
        colTxtField.setHorizontalAlignment(4);
        colTxtField.setSupportedEmpty(true);
        colTxtField.setRemoveingZeroInDispaly(false);
        return colTxtField;
    }

    public static void registerBigDecimalTextToColumn(KDTable table, String colName, int precision) {
        KDFormattedTextField text = KDTableUtils.getBigDecimalTextField(precision);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)text);
        table.getColumn(colName).setEditor((ICellEditor)editor);
        String colFormat = "%{0.##########}f";
        table.getColumn(colName).getStyleAttributes().setNumberFormat(colFormat);
    }
}

