/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.barcode.fa.manage.FAExBaseStatusEnum;
import com.kingdee.eas.barcode.fa.manage.FaStockTakingInfoBillCollection;
import com.kingdee.eas.barcode.fa.manage.FaStockTakingInfoBillFactory;
import com.kingdee.eas.barcode.fa.manage.FaStockTakingInfoBillInfo;
import com.kingdee.eas.barcode.fa.manage.FaStockTakingInfoEntryInfo;
import com.kingdee.eas.barcode.fa.manage.RepairBillCollection;
import com.kingdee.eas.barcode.fa.manage.RepairBillEntryInfo;
import com.kingdee.eas.barcode.fa.manage.RepairBillFactory;
import com.kingdee.eas.barcode.fa.manage.RepairBillInfo;
import com.kingdee.eas.barcode.fa.manage.ScrappedBillCollection;
import com.kingdee.eas.barcode.fa.manage.ScrappedBillEntryInfo;
import com.kingdee.eas.barcode.fa.manage.ScrappedBillFactory;
import com.kingdee.eas.barcode.fa.manage.ScrappedBillInfo;
import com.kingdee.eas.barcode.fa.manage.app.AbstractFaRepairInterfaceFacadeControllerBean;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.BASE64Decoder;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class FaRepairInterfaceFacadeControllerBean
extends AbstractFaRepairInterfaceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.fa.manage.app.FaRepairInterfaceFacadeControllerBean");

    @Override
    protected String _getRepairInfo(Context ctx, String arg) throws BOSException, EASBizException {
        JSONObject json = JSONObject.fromObject((Object)arg);
        String number = json.get("number").toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        RepairBillCollection coll = RepairBillFactory.getLocalInstance(ctx).getRepairBillCollection(view);
        RepairBillInfo info = null;
        if (coll.size() > 0) {
            info = coll.get(0);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("number", info.getNumber());
            map.put("assetname", info.getAssetName());
            map.put("assetnum", info.getAssetNum());
            map.put("description", info.getDescription());
            ArrayList list = new ArrayList();
            for (int i = 0; i < info.getEntries().size(); ++i) {
                HashMap<String, String> entrymap = new HashMap<String, String>();
                if (info.getEntries().get(i).getFile() != null) {
                    entrymap.put("file", new String(info.getEntries().get(i).getFile()));
                }
                entrymap.put("name", info.getEntries().get(i).getName());
                entrymap.put("fileName", info.getEntries().get(i).getFileName());
                list.add(entrymap);
            }
            map.put("pics", list);
            String value = JSONObject.fromObject(map).toString();
            return value;
        }
        return null;
    }

    @Override
    protected String _getScrappedInfo(Context ctx, String arg) throws BOSException, EASBizException {
        JSONObject json = JSONObject.fromObject((Object)arg);
        String number = json.get("number").toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        ScrappedBillCollection coll = ScrappedBillFactory.getLocalInstance(ctx).getScrappedBillCollection(view);
        ScrappedBillInfo info = null;
        if (coll.size() > 0) {
            info = coll.get(0);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("number", info.getNumber());
            map.put("assetname", info.getAssetName());
            map.put("assetnum", info.getAssetNum());
            map.put("description", info.getDescription());
            ArrayList list = new ArrayList();
            for (int i = 0; i < info.getEntries().size(); ++i) {
                HashMap<String, String> entrymap = new HashMap<String, String>();
                if (info.getEntries().get(i).getFile() != null) {
                    entrymap.put("file", new String(info.getEntries().get(i).getFile()));
                }
                entrymap.put("name", info.getEntries().get(i).getName());
                entrymap.put("fileName", info.getEntries().get(i).getFileName());
                list.add(entrymap);
            }
            map.put("pics", list);
            String value = JSONObject.fromObject(map).toString();
            return value;
        }
        return null;
    }

    @Override
    protected String _addFaStockTakingInfo(Context ctx, String arg) throws BOSException, EASBizException {
        try {
            JSONObject json = JSONObject.fromObject((Object)arg);
            FaStockTakingInfoBillInfo info = new FaStockTakingInfoBillInfo();
            String number = json.get("number") == null ? null : json.get("number").toString();
            String assetNum = json.get("assetnum") == null ? null : json.get("assetnum").toString();
            String assetName = json.get("assetname") == null ? null : json.get("assetname").toString();
            String barCode = json.get("barcode") == null ? null : json.get("barcode").toString();
            String description = json.get("description") == null ? null : json.get("description").toString();
            String operator = json.get("operator") == null ? null : json.get("operator").toString();
            String openid = json.get("openid") == null ? null : json.get("openid").toString();
            String qtyStr = json.get("qty") == null ? null : json.get("qty").toString();
            JSONArray pics = json.get("pics") == null ? null : (JSONArray)json.get("pics");
            info.setNumber(number);
            info.setAssetName(assetName);
            info.setAssetNum(assetNum);
            info.setBarCode(barCode);
            info.setDescription(description);
            if (operator != null) {
                UserInfo user;
                if (!operator.startsWith("YZJ")) {
                    try {
                        user = UserFactory.getLocalInstance((Context)ctx).getUserInfoByNumber(operator);
                        if (user == null) {
                            return "{\"msg\":\"ERP:\u64cd\u4f5c\u7528\u6237" + operator + "\u4e0d\u5b58\u5728\u4e8eEAS\u4e2d\"}";
                        }
                        info.setOperator(user);
                    }
                    catch (Exception e) {
                        if (openid != null) {
                            UserInfo user2 = this.getUsByOpenId(ctx, openid);
                            info.setOperator(user2);
                        }
                    }
                } else if (openid != null) {
                    user = this.getUsByOpenId(ctx, openid);
                    info.setOperator(user);
                } else {
                    return "{\"msg\":\"ERP:\u670d\u52a1\u5668\u9519\u8bef,\u672a\u4f20\u5165OPENID\u4fe1\u606f\"}";
                }
            }
            info.setStocktakingAmt(new BigDecimal(qtyStr));
            info.setBizDate(new Date());
            if (assetName == null) {
                try {
                    BarcodeDossierInfo barInfo = this.getFaCardByAssetNum(ctx, barCode);
                    if (barInfo != null) {
                        if (barInfo.getFaCurCard() == null) {
                            return "{\"msg\":\"ERP:\u6761\u7801\u503c" + barCode + "\u975e\u56fa\u5b9a\u8d44\u4ea7\u6761\u7801,\u65e0\u6cd5\u4fdd\u5b58\"}";
                        }
                    } else {
                        return "{\"msg\":\"ERP:\u6761\u7801\u503c" + barCode + "\u65e0\u6cd5\u5728\u6761\u7801\u6863\u6848\u4e2d\u627e\u5230\"}";
                    }
                    info.setAssetNum(barInfo.getFaCurCard().getNumber());
                    info.setAssetName(barInfo.getFaCurCard().getAssetName());
                    info.setSpecs(barInfo.getFaCurCard().getSpecs());
                    info.setAssetCat(barInfo.getFaCurCard().getAssetCat());
                    info.setBarCode(barInfo.getFaCurCard().getBarCode());
                    info.setMeasureUnit(barInfo.getFaCurCard().getMeasureUnit());
                    info.setAssetAmt(barInfo.getFaCurCard().getAssetAmt());
                    info.setAssetAmt(barInfo.getQty());
                }
                catch (BOSException e) {
                    logger.error((Object)"\u751f\u6210\u62a5\u5907\u5355\u9519\u8bef=EAS\u67e5\u8be2\u6761\u7801\u51fa\u9519", (Throwable)e);
                    return "{\"msg\":\"ERP:EAS\u67e5\u8be2\u6761\u7801\u51fa\u9519" + e.getMessage() + "\"}";
                }
            }
            if (pics != null) {
                for (int i = 0; i < pics.size(); ++i) {
                    FaStockTakingInfoEntryInfo entry = new FaStockTakingInfoEntryInfo();
                    Map map = (Map)pics.get(i);
                    entry.setFileName(map.get("fileName") == null ? null : map.get("fileName").toString());
                    entry.setName(map.get("name") == null ? null : map.get("name").toString());
                    Object picObj = map.get("pic");
                    if (picObj != null) {
                        byte[] buffer = new BASE64Decoder().decodeBuffer(picObj.toString());
                        entry.setFile(buffer);
                    }
                    info.getEntries().add(entry);
                }
            }
            info.setBaseStatus(FAExBaseStatusEnum.SUBMIT);
            FaStockTakingInfoBillFactory.getLocalInstance(ctx).addnew(info);
            return "{\"msg\":\"SUCCESS\"}";
        }
        catch (Exception e) {
            logger.error((Object)"\u751f\u6210\u62a5\u5907\u5355\u9519\u8bef", (Throwable)e);
            return "{\"msg\":\"ERP:" + e.getMessage() + "\"}";
        }
    }

    private UserInfo getUsByOpenId(Context ctx, String openid) throws Exception {
        IRowSet users = DbUtil.executeQuery((Context)ctx, (String)"select FUserId from T_PM_easxtusermap where  Fxtid=?", (Object[])new String[]{openid});
        String userId = null;
        if (!users.next()) {
            throw new Exception("\u64cd\u4f5c\u7528\u6237\u65e0\u6cd5\u5728EAS\u4e0e\u4e91\u4e4b\u5bb6\u5173\u7cfb\u4e2d\u627e\u5230");
        }
        userId = users.getString(1);
        return UserFactory.getLocalInstance((Context)ctx).getUserByID((IObjectPK)new ObjectUuidPK(userId));
    }

    @Override
    protected String _addRepairInfo(Context ctx, String arg) throws BOSException, EASBizException {
        try {
            String openid;
            JSONObject json = JSONObject.fromObject((Object)arg);
            RepairBillInfo info = new RepairBillInfo();
            String number = json.get("number") == null ? null : json.get("number").toString();
            String assetNum = json.get("assetnum") == null ? null : json.get("assetnum").toString();
            String assetName = json.get("assetname") == null ? null : json.get("assetname").toString();
            String barCode = json.get("barcode") == null ? null : json.get("barcode").toString();
            String description = json.get("description") == null ? null : json.get("description").toString();
            JSONArray pics = json.get("pics") == null ? null : (JSONArray)json.get("pics");
            String operator = json.get("operator") == null ? null : json.get("operator").toString();
            String string = openid = json.get("openid") == null ? null : json.get("openid").toString();
            if (operator != null) {
                UserInfo user;
                if (!operator.startsWith("YZJ")) {
                    try {
                        user = UserFactory.getLocalInstance((Context)ctx).getUserInfoByNumber(operator);
                        if (user == null) {
                            return "{\"msg\":\"ERP:\u64cd\u4f5c\u7528\u6237" + operator + "\u4e0d\u5b58\u5728\u4e8eEAS\u4e2d\"}";
                        }
                        info.setOperator(user);
                    }
                    catch (Exception e) {
                        if (openid != null) {
                            UserInfo user2 = this.getUsByOpenId(ctx, openid);
                            info.setOperator(user2);
                        }
                    }
                } else if (openid != null) {
                    user = this.getUsByOpenId(ctx, openid);
                    info.setOperator(user);
                } else {
                    return "{\"msg\":\"ERP:\u670d\u52a1\u5668\u9519\u8bef,\u672a\u4f20\u5165OPENID\u4fe1\u606f\"}";
                }
            }
            info.setNumber(number);
            info.setAssetName(assetName);
            info.setAssetNum(assetNum);
            info.setBarCode(barCode);
            info.setDescription(description);
            try {
                BarcodeDossierInfo barInfo = this.getFaCardByAssetNum(ctx, barCode);
                if (barInfo == null) {
                    return "{\"msg\":\"FAIL\"}";
                }
                info.setAssetNum(barInfo.getFaCurCard().getNumber());
                info.setAssetName(barInfo.getFaCurCard().getAssetName());
                info.setFaCurCard(barInfo.getFaCurCard());
            }
            catch (BOSException e) {
                e.printStackTrace();
                return "{\"msg\":\"FAIL\"}";
            }
            if (pics != null) {
                for (int i = 0; i < pics.size(); ++i) {
                    RepairBillEntryInfo entry = new RepairBillEntryInfo();
                    Map map = (Map)pics.get(i);
                    entry.setFileName(map.get("fileName") == null ? null : map.get("fileName").toString());
                    entry.setName(map.get("name") == null ? null : map.get("name").toString());
                    Object picObj = map.get("pic");
                    if (picObj != null) {
                        byte[] buffer = new BASE64Decoder().decodeBuffer(picObj.toString());
                        entry.setFile(buffer);
                    }
                    info.getEntries().add(entry);
                }
            }
            info.setBaseStatus(FAExBaseStatusEnum.SUBMIT);
            RepairBillFactory.getLocalInstance(ctx).addnew(info);
            return "{\"msg\":\"SUCCESS\"}";
        }
        catch (Exception e) {
            return "{\"msg\":\"FAIL\"}";
        }
    }

    @Override
    protected String _addScrappedInfo(Context ctx, String arg) throws BOSException, EASBizException {
        try {
            JSONObject json = JSONObject.fromObject((Object)arg);
            ScrappedBillInfo info = new ScrappedBillInfo();
            String number = json.get("number") == null ? null : json.get("number").toString();
            String assetNum = json.get("assetnum") == null ? null : json.get("assetnum").toString();
            String assetName = json.get("assetname") == null ? null : json.get("assetname").toString();
            String barCode = json.get("barcode") == null ? null : json.get("barcode").toString();
            String description = json.get("description") == null ? null : json.get("description").toString();
            JSONArray pics = json.get("pics") == null ? null : (JSONArray)json.get("pics");
            String operator = json.get("operator") == null ? null : json.get("operator").toString();
            String openid = json.get("openid") == null ? null : json.get("openid").toString();
            info.setNumber(number);
            info.setAssetName(assetName);
            info.setAssetNum(assetNum);
            info.setBarCode(barCode);
            info.setDescription(description);
            if (operator != null) {
                UserInfo user;
                if (!operator.startsWith("YZJ")) {
                    try {
                        user = UserFactory.getLocalInstance((Context)ctx).getUserInfoByNumber(operator);
                        if (user == null) {
                            return "{\"msg\":\"ERP:\u64cd\u4f5c\u7528\u6237" + operator + "\u4e0d\u5b58\u5728\u4e8eEAS\u4e2d\"}";
                        }
                        info.setOperator(user);
                    }
                    catch (Exception e) {
                        if (openid != null) {
                            UserInfo user2 = this.getUsByOpenId(ctx, openid);
                            info.setOperator(user2);
                        }
                    }
                } else if (openid != null) {
                    user = this.getUsByOpenId(ctx, openid);
                    info.setOperator(user);
                } else {
                    return "{\"msg\":\"ERP:\u670d\u52a1\u5668\u9519\u8bef,\u672a\u4f20\u5165OPENID\u4fe1\u606f\"}";
                }
            }
            try {
                BarcodeDossierInfo barInfo = this.getFaCardByAssetNum(ctx, barCode);
                if (barInfo == null) {
                    return "{\"msg\":\"FAIL\"}";
                }
                info.setAssetNum(barInfo.getFaCurCard().getNumber());
                info.setAssetName(barInfo.getFaCurCard().getAssetName());
                info.setFaCurCard(barInfo.getFaCurCard());
            }
            catch (BOSException e) {
                e.printStackTrace();
                return "{\"msg\":\"FAIL\"}";
            }
            if (pics != null) {
                for (int i = 0; i < pics.size(); ++i) {
                    ScrappedBillEntryInfo entry = new ScrappedBillEntryInfo();
                    Map map = (Map)pics.get(i);
                    entry.setFileName(map.get("fileName") == null ? null : map.get("fileName").toString());
                    entry.setName(map.get("name") == null ? null : map.get("name").toString());
                    Object picObj = map.get("pic");
                    if (picObj != null) {
                        byte[] buffer = new BASE64Decoder().decodeBuffer(picObj.toString());
                        entry.setFile(buffer);
                    }
                    info.getEntries().add(entry);
                }
            }
            info.setBaseStatus(FAExBaseStatusEnum.SUBMIT);
            ScrappedBillFactory.getLocalInstance(ctx).addnew(info);
            return "{\"msg\":\"SUCCESS\"}";
        }
        catch (Exception e) {
            return "{\"msg\":\"FAIL\"}";
        }
    }

    @Override
    protected String _delFaStockTakingInfo(Context ctx, String arg) throws BOSException, EASBizException {
        try {
            JSONObject json = JSONObject.fromObject((Object)arg);
            String number = json.get("number").toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            FaStockTakingInfoBillFactory.getLocalInstance(ctx).delete(filter);
            return "{\"msg\":\"SUCCESS\"}";
        }
        catch (Exception e) {
            return "{\"msg\":\"FAIL\"}";
        }
    }

    @Override
    protected String _delRepairInfo(Context ctx, String arg) throws BOSException, EASBizException {
        try {
            JSONObject json = JSONObject.fromObject((Object)arg);
            String number = json.get("number").toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            RepairBillFactory.getLocalInstance(ctx).delete(filter);
            return "{\"msg\":\"SUCCESS\"}";
        }
        catch (Exception e) {
            return "{\"msg\":\"FAIL\"}";
        }
    }

    @Override
    protected String _delScrappedInfo(Context ctx, String arg) throws BOSException, EASBizException {
        try {
            JSONObject json = JSONObject.fromObject((Object)arg);
            String number = json.get("number").toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            ScrappedBillFactory.getLocalInstance(ctx).delete(filter);
            return "{\"msg\":\"SUCCESS\"}";
        }
        catch (Exception e) {
            return "{\"msg\":\"FAIL\"}";
        }
    }

    @Override
    protected String _getFaStockTakingInfo(Context ctx, String arg) throws BOSException, EASBizException {
        JSONObject json = JSONObject.fromObject((Object)arg);
        String number = json.get("number").toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        FaStockTakingInfoBillCollection coll = FaStockTakingInfoBillFactory.getLocalInstance(ctx).getFaStockTakingInfoBillCollection(view);
        FaStockTakingInfoBillInfo info = null;
        if (coll.size() > 0) {
            info = coll.get(0);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", info.getNumber());
            map.put("assetname", info.getAssetName());
            map.put("assetnum", info.getAssetNum());
            map.put("description", info.getDescription());
            map.put("operator", (String)info.getOperator());
            String value = JSONObject.fromObject(map).toString();
            return value;
        }
        return null;
    }

    @Override
    protected String _updateFaStockTakingInfo(Context ctx, String arg) throws BOSException, EASBizException {
        try {
            JSONObject json = JSONObject.fromObject((Object)arg);
            String number = json.get("number") == null ? null : json.get("number").toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            FaStockTakingInfoBillCollection coll = FaStockTakingInfoBillFactory.getLocalInstance(ctx).getFaStockTakingInfoBillCollection(view);
            FaStockTakingInfoBillInfo info = null;
            if (coll.size() <= 0) {
                return "{\"msg\":\"\u8be5\u7f16\u7801\u4e0d\u5b58\u5728\"}";
            }
            info = coll.get(0);
            String assetNum = json.get("assetnum") == null ? null : json.get("assetnum").toString();
            String assetName = json.get("assetname") == null ? null : json.get("assetname").toString();
            String barCode = json.get("barcode") == null ? null : json.get("barcode").toString();
            String description = json.get("description") == null ? null : json.get("description").toString();
            JSONArray pics = json.get("pics") == null ? null : (JSONArray)json.get("pics");
            info.setNumber(number);
            info.setAssetName(assetName);
            info.setAssetNum(assetNum);
            info.setBarCode(barCode);
            info.setDescription(description);
            FaStockTakingInfoBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId().toString()), info);
            return "{\"msg\":\"SUCCESS\"}";
        }
        catch (Exception e) {
            return "{\"msg\":\"FAIL\"}";
        }
    }

    @Override
    protected String _updateRepairInfo(Context ctx, String arg) throws BOSException, EASBizException {
        try {
            JSONObject json = JSONObject.fromObject((Object)arg);
            String number = json.get("number") == null ? null : json.get("number").toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            RepairBillCollection coll = RepairBillFactory.getLocalInstance(ctx).getRepairBillCollection(view);
            RepairBillInfo info = null;
            if (coll.size() <= 0) {
                return "{\"msg\":\"\u8be5\u7f16\u7801\u4e0d\u5b58\u5728\"}";
            }
            info = coll.get(0);
            String assetNum = json.get("assetnum") == null ? null : json.get("assetnum").toString();
            String assetName = json.get("assetname") == null ? null : json.get("assetname").toString();
            String barCode = json.get("barcode") == null ? null : json.get("barcode").toString();
            String description = json.get("description") == null ? null : json.get("description").toString();
            JSONArray pics = json.get("pics") == null ? null : (JSONArray)json.get("pics");
            info.setNumber(number);
            info.setAssetName(assetName);
            info.setAssetNum(assetNum);
            info.setBarCode(barCode);
            info.setDescription(description);
            info.getEntries().clear();
            if (pics != null) {
                for (int i = 0; i < pics.size(); ++i) {
                    RepairBillEntryInfo entry = new RepairBillEntryInfo();
                    Map map = (Map)pics.get(i);
                    entry.setFileName(map.get("fileName") == null ? null : map.get("fileName").toString());
                    entry.setName(map.get("name") == null ? null : map.get("name").toString());
                    Object picObj = map.get("pic");
                    byte[] buffer = new BASE64Decoder().decodeBuffer(picObj.toString());
                    entry.setFile(buffer);
                    info.getEntries().add(entry);
                }
            }
            RepairBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId().toString()), info);
            return "{\"msg\":\"SUCCESS\"}";
        }
        catch (Exception e) {
            return "{\"msg\":\"FAIL\"}";
        }
    }

    @Override
    protected String _updateScrappedInfo(Context ctx, String arg) throws BOSException, EASBizException {
        try {
            JSONObject json = JSONObject.fromObject((Object)arg);
            String number = json.get("number") == null ? null : json.get("number").toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            ScrappedBillCollection coll = ScrappedBillFactory.getLocalInstance(ctx).getScrappedBillCollection(view);
            ScrappedBillInfo info = null;
            if (coll.size() <= 0) {
                return "{\"msg\":\"\u8be5\u7f16\u7801\u4e0d\u5b58\u5728\"}";
            }
            info = coll.get(0);
            String assetNum = json.get("assetnum") == null ? null : json.get("assetnum").toString();
            String assetName = json.get("assetname") == null ? null : json.get("assetname").toString();
            String barCode = json.get("barcode") == null ? null : json.get("barcode").toString();
            String description = json.get("description") == null ? null : json.get("description").toString();
            JSONArray pics = json.get("pics") == null ? null : (JSONArray)json.get("pics");
            info.setNumber(number);
            info.setAssetName(assetName);
            info.setAssetNum(assetNum);
            info.setBarCode(barCode);
            info.setDescription(description);
            info.getEntries().clear();
            if (pics != null) {
                for (int i = 0; i < pics.size(); ++i) {
                    ScrappedBillEntryInfo entry = new ScrappedBillEntryInfo();
                    Map map = (Map)pics.get(i);
                    entry.setFileName(map.get("fileName") == null ? null : map.get("fileName").toString());
                    entry.setName(map.get("name") == null ? null : map.get("name").toString());
                    Object picObj = map.get("pic");
                    byte[] buffer = new BASE64Decoder().decodeBuffer(picObj.toString());
                    entry.setFile(buffer);
                    info.getEntries().add(entry);
                }
            }
            ScrappedBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId().toString()), info);
            return "{\"msg\":\"SUCCESS\"}";
        }
        catch (Exception e) {
            return "{\"msg\":\"FAIL\"}";
        }
    }

    private BarcodeDossierInfo getFaCardByAssetNum(Context ctx, String assetNum) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("faCurCard.id"));
        sic.add(new SelectorItemInfo("faCurCard.number"));
        sic.add(new SelectorItemInfo("faCurCard.assetName"));
        sic.add(new SelectorItemInfo("faCurCard.specs"));
        sic.add(new SelectorItemInfo("faCurCard.assetCat.id"));
        sic.add(new SelectorItemInfo("faCurCard.barCode"));
        sic.add(new SelectorItemInfo("faCurCard.measureUnit.id"));
        sic.add(new SelectorItemInfo("faCurCard.assetAmt"));
        sic.add(new SelectorItemInfo("qty"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)assetNum, CompareType.EQUALS));
        view.setFilter(filter);
        BarcodeDossierCollection barcodeCol = BarcodeDossierFactory.getLocalInstance(ctx).getBarcodeDossierCollection(view);
        if (barcodeCol.size() > 0) {
            return barcodeCol.get(0);
        }
        return null;
    }
}

